/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.configsections;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.TrackersUtil;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.config.ConfigSectionImpl;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.systray.SystemTraySWT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConfigSectionInterfaceSWT
extends ConfigSectionImpl {
    public static final String REFID_INTERFACE_SYSTRAY = "interface-systyray";
    private ParameterListener decisions_parameter_listener;

    public ConfigSectionInterfaceSWT() {
        super("style", "root");
    }

    @Override
    public void deleteConfigSection() {
        super.deleteConfigSection();
        if (this.decisions_parameter_listener != null) {
            COConfigurationManager.removeParameterListener("MessageBoxWindow.decisions", this.decisions_parameter_listener);
        }
    }

    @Override
    public void build() {
        this.setDefaultUITypesForAdd("swt");
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        ArrayList listAutoOpen = new ArrayList();
        this.add(new LabelParameterImpl("ConfigView.label.autoopen.detailstab"), listAutoOpen);
        this.add(new BooleanParameterImpl("Open Details", "ConfigView.label.autoopen.dl"), listAutoOpen);
        this.add(new BooleanParameterImpl("Open Seeding Details", "ConfigView.label.autoopen.cd"), listAutoOpen);
        this.add(new LabelParameterImpl("ConfigView.label.autoopen.downloadbars"), listAutoOpen);
        this.add(new BooleanParameterImpl("Open Bar Incomplete", "ConfigView.label.autoopen.dl"), listAutoOpen);
        this.add(new BooleanParameterImpl("Open Bar Complete", "ConfigView.label.autoopen.cd"), listAutoOpen);
        this.add("if.pgAutoOpen", new ParameterGroupImpl("ConfigView.label.autoopen", listAutoOpen).setNumberOfColumns2(3), new List[0]);
        if (!Constants.isOSX) {
            BooleanParameterImpl paramShowTitleStatus = new BooleanParameterImpl("Show Status In Window Title", "ConfigView.label.info.in.window.title");
            this.add(paramShowTitleStatus, new List[0]);
            this.add("if.pgTitle", new ParameterGroupImpl("ConfigView.label.titlebar", paramShowTitleStatus), new List[0]);
        }
        ArrayList listTransferBar = new ArrayList();
        this.add(new BooleanParameterImpl("Remember transfer bar location", "ConfigView.label.transferbar.remember_location"), listTransferBar);
        this.add(new IntParameterImpl("Bar Transparency", "label.bar.trans", 0, 100), listTransferBar);
        this.add(new BooleanParameterImpl("Transfer Bar Show Icon Area", "label.show.icon.area"), listTransferBar);
        this.add("if.TransferBar", new ParameterGroupImpl("MainWindow.menu.view.open_global_transfer_bar", listTransferBar), new List[0]);
        ArrayList listSysTray = new ArrayList();
        BooleanParameterImpl est = new BooleanParameterImpl("Enable System Tray", "ConfigView.section.interface.enabletray");
        this.add(est, listSysTray);
        est.addListener(p -> {
            boolean bl = Utils.execSWTThread(() -> {
                boolean hasTray = SystemTraySWT.hasTray();
                boolean enable = est.getValue();
                if (enable && !hasTray) {
                    SystemTraySWT.getTray();
                } else if (!enable && hasTray) {
                    SystemTraySWT.getTray().dispose();
                }
            });
        });
        BooleanParameterImpl stdo = new BooleanParameterImpl("System Tray Disabled Override", "ConfigView.label.closetotrayoverride");
        this.add(stdo, listSysTray);
        BooleanParameterImpl ctt = new BooleanParameterImpl("Close To Tray", "ConfigView.label.closetotray");
        this.add(ctt, listSysTray);
        BooleanParameterImpl mtt = new BooleanParameterImpl("Minimize To Tray", "ConfigView.label.minimizetotray");
        this.add(mtt, listSysTray);
        BooleanParameterImpl esttt = new BooleanParameterImpl("ui.systray.tooltip.enable", "ConfigView.label.enableSystrayToolTip");
        this.add(esttt, listSysTray);
        BooleanParameterImpl estttd = new BooleanParameterImpl("ui.systray.tooltip.next.eta.enable", "ConfigView.label.enableSystrayToolTipNextETA");
        this.add(estttd, listSysTray);
        estttd.setIndent(1, true);
        est.addDisabledOnSelection((Parameter)stdo);
        com.biglybt.pif.ui.config.ParameterListener st_enabler = param -> {
            boolean st_enabled = est.getValue();
            boolean override = stdo.getValue();
            boolean dl_stats = esttt.getValue();
            ctt.setEnabled(st_enabled || override);
            mtt.setEnabled(st_enabled || override);
            esttt.setEnabled(st_enabled);
            estttd.setEnabled(st_enabled && dl_stats);
        };
        est.addListener(st_enabler);
        stdo.addListener(st_enabler);
        esttt.addListener(st_enabler);
        st_enabler.parameterChanged(null);
        ParameterGroupImpl sysTrayPG = new ParameterGroupImpl("ConfigView.label.systray", listSysTray);
        this.add("if.SysTray", sysTrayPG, new List[0]);
        sysTrayPG.setReferenceID(REFID_INTERFACE_SYSTRAY);
        LabelParameterImpl paramSpeedOptionsLabel = new LabelParameterImpl("ConfigView.label.set_ui_transfer_speeds.description");
        this.add(paramSpeedOptionsLabel, new List[0]);
        ArrayList listSpeedOptions = new ArrayList();
        String[] limit_types = new String[]{"download", "upload"};
        String limit_type_prefix = "config.ui.speed.partitions.manual.";
        String[] stringArray = limit_types;
        int n = limit_types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            BooleanParameterImpl bp = new BooleanParameterImpl(String.valueOf(limit_type_prefix) + type + ".enabled", "ConfigView.label.set_ui_transfer_speeds.description." + type);
            this.add(bp, listSpeedOptions);
            StringParameterImpl sp = new StringParameterImpl(String.valueOf(limit_type_prefix) + type + ".values", null);
            this.add(sp, listSpeedOptions);
            bp.addEnabledOnSelection((Parameter)sp);
            ++n2;
        }
        ParameterGroupImpl pgSpeedOptions2Col = new ParameterGroupImpl(null, listSpeedOptions).setNumberOfColumns2(2);
        this.add("if.pgSpeedOptions2Col", pgSpeedOptions2Col, new List[0]);
        ParameterGroupImpl pgSpeedOptions = new ParameterGroupImpl("ConfigView.label.set_ui_transfer_speeds", paramSpeedOptionsLabel, pgSpeedOptions2Col);
        this.add("if.pgSpeedOptions", pgSpeedOptions, new List[0]);
        this.add(new BooleanParameterImpl("Send Version Info", "ConfigView.label.allowSendVersion"), new List[0]);
        this.add(new HyperlinkParameterImpl("ConfigView.label.version.info.link", "https://wiki.biglybt.com/w/Version.azureusplatform.com"), new List[0]);
        if (!Constants.isOSX) {
            this.add(new BooleanParameterImpl("confirmationOnExit", "ConfigView.section.style.confirmationOnExit"), new List[0]);
        }
        ActionParameterImpl clear_decisions = new ActionParameterImpl("ConfigView.section.interface.cleardecisions", "ConfigView.section.interface.cleardecisionsbutton");
        this.add(clear_decisions, new List[0]);
        clear_decisions.addListener(param -> RememberedDecisionsManager.clearAll());
        ActionParameterImpl clear_tracker_button = new ActionParameterImpl("ConfigView.section.interface.cleartrackers", "ConfigView.section.interface.cleartrackersbutton");
        this.add(clear_tracker_button, new List[0]);
        clear_tracker_button.addListener(param -> TrackersUtil.getInstance().clearAllTrackers(true));
        ActionParameterImpl clear_save_path_button = new ActionParameterImpl("ConfigView.section.interface.clearsavepaths", "ConfigView.section.interface.clearsavepathsbutton");
        this.add(clear_save_path_button, new List[0]);
        clear_save_path_button.addListener(param -> {
            COConfigurationManager.setParameter("saveTo_list", new ArrayList());
            COConfigurationManager.setParameter("open.torrent.window.moc.history", new ArrayList());
        });
        this.decisions_parameter_listener = parameterName -> {
            boolean enabled = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap()).size() > 0;
            clear_decisions.setEnabled(enabled);
        };
        COConfigurationManager.addAndFireParameterListener("MessageBoxWindow.decisions", this.decisions_parameter_listener);
        ActionParameterImpl clear_tables_button = new ActionParameterImpl("ConfigView.section.interface.cleartables", "ConfigView.section.interface.resetassocbutton");
        this.add(clear_tables_button, new List[0]);
        clear_tables_button.addListener(param -> TableColumnManager.getInstance().resetAllTables());
        if (platform.hasCapability(PlatformManagerCapabilities.RegisterFileAssociations)) {
            ActionParameterImpl reset_associations = new ActionParameterImpl("ConfigView.section.interface.resetassoc", "ConfigView.section.interface.resetassocbutton");
            this.add(reset_associations, new List[0]);
            reset_associations.addListener(param -> {
                try {
                    platform.registerApplication();
                }
                catch (PlatformManagerException e) {
                    Logger.log(new LogAlert(false, "Failed to register application", e));
                }
            });
            this.add(new BooleanParameterImpl("config.interface.checkassoc", "ConfigView.section.interface.checkassoc"), new List[0]);
        }
    }
}

