/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.configsections;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.FileParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import com.biglybt.ui.swt.ConfigKeysSWT;
import com.biglybt.ui.swt.Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ConfigSectionInterfaceTablesSWT
extends ConfigSectionImpl {
    public static final String REFID_SECTION_LIBRARY = "section-library";
    public static final String SECTION_ID = "tables";

    public ConfigSectionInterfaceTablesSWT() {
        super(SECTION_ID, "style");
    }

    @Override
    public void deleteConfigSection() {
        super.deleteConfigSection();
    }

    @Override
    public void build() {
        this.setDefaultUITypesForAdd("swt");
        boolean isAZ3 = Utils.isAZ3UI();
        ArrayList listGeneral = new ArrayList();
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] sortOrderValues = nArray;
        String[] sortOrderLabels = new String[]{MessageText.getString("ConfigView.section.style.defaultSortOrder.asc"), MessageText.getString("ConfigView.section.style.defaultSortOrder.desc"), MessageText.getString("ConfigView.section.style.defaultSortOrder.flip"), MessageText.getString("ConfigView.section.style.defaultSortOrder.same")};
        this.add(new IntListParameterImpl("config.style.table.defaultSortOrder", "ConfigView.section.style.defaultSortOrder", sortOrderValues, sortOrderLabels), listGeneral);
        this.add(new BooleanParameterImpl("Table.sort.intuitive", "ConfigView.section.table.sort.intuitive"), listGeneral);
        this.add(new BooleanParameterImpl("Table.filter.confusable", "ConfigView.section.table.filter.confusable"), listGeneral);
        int[] values = new int[]{10, 25, 50, 100, 250, 500, 1000, 2000, 5000, 10000, 15000};
        String ms = TimeFormatter.MS_SUFFIX;
        String secs = " " + TimeFormatter.getShortSuffix(0);
        String[] labels = new String[]{"10" + ms, "25" + ms, "50" + ms, "100" + ms, "250" + ms, "500" + ms, "1" + secs, "2" + secs, "5" + secs, "10" + secs, "15" + secs};
        this.add(new IntListParameterImpl("GUI Refresh", "ConfigView.section.style.guiUpdate", values, labels), 1, listGeneral);
        this.add(new IntParameterImpl("Graphics Update", "ConfigView.section.style.graphicsUpdate", 1, Integer.MAX_VALUE), 1, listGeneral);
        this.add(new IntParameterImpl("ReOrder Delay", "ConfigView.section.style.reOrderDelay"), 1, listGeneral);
        this.add(new BooleanParameterImpl("Table.extendedErase", "ConfigView.section.style.extendedErase"), 1, listGeneral);
        this.add(new BooleanParameterImpl("Table Header Gradient Fill", "ConfigView.section.style.header.gradient"), 1, listGeneral);
        boolean hhEnabled = COConfigurationManager.getIntParameter("Table.headerHeight") > 0;
        BooleanParameterImpl chkHeaderHeight = new BooleanParameterImpl("Table.useHeaderHeight", "ConfigView.section.style.enableHeaderHeight");
        this.add(chkHeaderHeight, 1, new List[0]);
        chkHeaderHeight.setValue(hhEnabled);
        IntParameterImpl paramHH = new IntParameterImpl("Table.headerHeight", null, 0, 100);
        this.add(paramHH, 1, new List[0]);
        chkHeaderHeight.addEnabledOnSelection((Parameter)paramHH);
        chkHeaderHeight.addListener(param -> {
            if (chkHeaderHeight.getValue()) {
                COConfigurationManager.setParameter("Table.headerHeight", 16);
                paramHH.setEnabled(true);
            } else {
                COConfigurationManager.setParameter("Table.headerHeight", 0);
                paramHH.setEnabled(false);
            }
        });
        boolean cdEnabled = COConfigurationManager.getStringParameter("Table.column.dateformat", "").length() > 0;
        BooleanParameterImpl chkCustomDate = new BooleanParameterImpl("Table.useCustomDateFormat", "ConfigView.section.style.customDateFormat");
        this.add(chkCustomDate, 1, new List[0]);
        chkCustomDate.setValue(cdEnabled);
        StringParameterImpl paramCustomDate = new StringParameterImpl("Table.column.dateformat", null);
        this.add(paramCustomDate, new List[0]);
        chkCustomDate.addEnabledOnSelection((Parameter)paramCustomDate);
        paramCustomDate.addStringValidator((p, toValue) -> {
            try {
                SimpleDateFormat temp = new SimpleDateFormat((String)toValue);
                temp.format(new Date());
                return new ParameterValidator.ValidationInfo(true);
            }
            catch (Exception e) {
                return new ParameterValidator.ValidationInfo(false, e.getMessage());
            }
        });
        chkCustomDate.addListener(param -> {
            if (chkCustomDate.getValue()) {
                COConfigurationManager.setParameter("Table.column.dateformat", "yyyy/MM/dd");
                paramCustomDate.setEnabled(true);
            } else {
                COConfigurationManager.setParameter("Table.column.dateformat", "");
                paramCustomDate.setEnabled(false);
            }
        });
        this.add("ifT.pgGeneral2Col", new ParameterGroupImpl(null, chkHeaderHeight, paramHH, chkCustomDate, paramCustomDate).setNumberOfColumns2(2), 1, listGeneral);
        BooleanParameterImpl disableTT = this.add(new BooleanParameterImpl("Table.tooltip.disable", "ConfigView.section.table.disable.tooltips"), 1, listGeneral);
        BooleanParameterImpl truncTT = this.add(new BooleanParameterImpl("Table.tooltip.truncate", "ConfigView.section.table.truncate.tooltips"), 1, listGeneral);
        disableTT.addDisabledOnSelection((Parameter)truncTT);
        this.add(new ParameterGroupImpl("ConfigView.section.global", listGeneral), new List[0]);
        ArrayList listLibrary = new ArrayList();
        this.add(new BooleanParameterImpl("Library.ShowTitle", "menu.show.title"), listLibrary);
        this.add(new BooleanParameterImpl("Table.useTree", "ConfigView.section.style.useTree"), listLibrary);
        this.add(new BooleanParameterImpl("DND Always In Incomplete", "ConfigView.section.style.DNDalwaysInIncomplete"), 2, listLibrary);
        if (isAZ3) {
            this.add(new BooleanParameterImpl("Library.EnableSimpleView", "ConfigView.section.style.EnableSimpleView"), listLibrary);
        }
        this.add(new BooleanParameterImpl("Library.ShowTabsInTorrentView", "ConfigView.section.style.ShowTabsInTorrentView"), listLibrary);
        String[] spltLabels = new String[5];
        int[] splitValues = new int[spltLabels.length];
        int i = 0;
        while (i < spltLabels.length) {
            spltLabels[i] = MessageText.getString("ConfigView.library.split." + i);
            splitValues[i] = i;
            ++i;
        }
        this.add(new IntListParameterImpl("Library.TorrentViewSplitMode", "ConfigView.library.split.mode", splitValues, spltLabels), listLibrary);
        this.add(new BooleanParameterImpl("Library.showFancyMenu", "ConfigView.section.style.ShowFancyMenu"), listLibrary);
        String[][] dblclickOptions = new String[][]{{"ConfigView.option.dm.dblclick.play", "0"}, {"ConfigView.option.dm.dblclick.show", "2"}, {"ConfigView.option.dm.dblclick.launch", "3"}, {"ConfigView.option.dm.dblclick.launch.content", "7"}, {"ConfigView.option.dm.dblclick.launch.qv", "4"}, {"ConfigView.option.dm.dblclick.open.browser", "5"}, {"ConfigView.option.dm.dblclick.details", "1"}, {"ConfigView.option.dm.dblclick.details.pop", "6"}};
        String[] dblclickLabels = new String[dblclickOptions.length];
        String[] dblclickValues = new String[dblclickOptions.length];
        int i2 = 0;
        while (i2 < dblclickOptions.length) {
            dblclickLabels[i2] = MessageText.getString(dblclickOptions[i2][0]);
            dblclickValues[i2] = dblclickOptions[i2][1];
            ++i2;
        }
        this.add(new StringListParameterImpl("list.dm.dblclick", "ConfigView.label.dm.dblclick", dblclickValues, dblclickLabels), listLibrary);
        BooleanParameterImpl web_in_browser = new BooleanParameterImpl("Library.LaunchWebsiteInBrowser", "library.launch.web.in.browser");
        this.add(web_in_browser, listLibrary);
        web_in_browser.setIndent(1, true);
        BooleanParameterImpl web_in_browser_anon = new BooleanParameterImpl("Library.LaunchWebsiteInBrowserAnon", "library.launch.web.in.browser.anon");
        this.add(web_in_browser_anon, listLibrary);
        web_in_browser_anon.setIndent(2, false);
        web_in_browser.addEnabledOnSelection((Parameter)web_in_browser_anon);
        String[][] enterOptions = new String[][]{{"ConfigView.option.dm.enter.sameasdblclick", "-1"}, {"ConfigView.option.dm.dblclick.play", "0"}, {"ConfigView.option.dm.dblclick.show", "2"}, {"ConfigView.option.dm.dblclick.launch", "3"}, {"ConfigView.option.dm.dblclick.launch.content", "7"}, {"ConfigView.option.dm.dblclick.launch.qv", "4"}, {"ConfigView.option.dm.dblclick.open.browser", "5"}, {"ConfigView.option.dm.dblclick.details", "1"}, {"ConfigView.option.dm.dblclick.details.pop", "6"}};
        String[] enterLabels = new String[enterOptions.length];
        String[] enterValues = new String[enterOptions.length];
        int i3 = 0;
        while (i3 < enterOptions.length) {
            enterLabels[i3] = MessageText.getString(enterOptions[i3][0]);
            enterValues[i3] = enterOptions[i3][1];
            ++i3;
        }
        this.add(new StringListParameterImpl("list.dm.enteraction", "ConfigView.label.dm.enteraction", enterValues, enterLabels), listLibrary);
        ArrayList listLaunchGroup = new ArrayList();
        this.add(new LabelParameterImpl("ConfigView.label.lh.info"), listLaunchGroup);
        if (Constants.isUnix) {
            String sf = MessageText.getString("explicit.helper.showfile", new String[]{"<showfile>"});
            String info3 = MessageText.getString("ConfigView.label.lh.info3", new String[]{sf});
            this.add(new LabelParameterImpl("!" + info3 + "!"), listLaunchGroup);
        }
        this.add(new LabelParameterImpl("ConfigView.label.lh.info2"), listLaunchGroup);
        ArrayList<Parameter> listLaunchHelpers = new ArrayList<Parameter>();
        int i4 = 0;
        while (i4 < ConfigKeysSWT.getLaunchHelperEntryCount()) {
            this.addLaunchHelperLine(listLaunchHelpers, i4);
            ++i4;
        }
        ActionParameterImpl addButton = new ActionParameterImpl("label.add.another", "Button.add");
        this.add("addAnother", addButton, listLaunchHelpers);
        addButton.addListener(param -> {
            int num = ConfigKeysSWT.getLaunchHelperEntryCount();
            ConfigKeysSWT.setLaunchHelperEntryCount(num + 1);
            this.requestRebuild();
        });
        this.add("pgLaunchHelpersInt", new ParameterGroupImpl(null, listLaunchHelpers).setNumberOfColumns2(3), listLaunchGroup);
        this.add(new ParameterGroupImpl("ConfigView.section.style.launch", listLaunchGroup), new List[0]);
        ParameterGroupImpl pgLibrary = this.add(new ParameterGroupImpl("ConfigView.section.style.library", listLibrary), new List[0]);
        pgLibrary.setReferenceID(REFID_SECTION_LIBRARY);
        ArrayList listSearchSubs = new ArrayList();
        this.add(new BooleanParameterImpl("Search View Is Web View", "ConfigView.section.style.search.is.web.view"), listSearchSubs);
        this.add(new BooleanParameterImpl("Search View Switch Hidden", "ConfigView.section.style.search.hide.view.switch"), listSearchSubs);
        this.add(new IntParameterImpl("Search Subs Row Height", "ConfigView.section.style.searchsubs.row.height", 16, 64), listSearchSubs);
        this.add(new ParameterGroupImpl("ConfigView.section.style.searchsubs", listSearchSubs), new List[0]);
    }

    protected void addLaunchHelperLine(List<Parameter> listLaunchHelpers, int index) {
        StringParameterImpl extsParam = new StringParameterImpl(ConfigKeysSWT.getLaunchHelperExtConfig(index), "ConfigView.label.lh.ext");
        this.add(extsParam, listLaunchHelpers);
        extsParam.setWidthInCharacters(15);
        FileParameterImpl progParam = new FileParameterImpl(ConfigKeysSWT.getLaunchHelperProgConfig(index), "ConfigView.label.lh.prog", new String[0]);
        this.add(progParam, listLaunchHelpers);
        ActionParameterImpl deleteRow = new ActionParameterImpl("", "");
        deleteRow.setImageID("smallx-c");
        this.add(deleteRow, listLaunchHelpers);
        deleteRow.addListener(param -> Utils.execSWTThread(() -> {
            int num_lines = ConfigKeysSWT.getLaunchHelperEntryCount();
            ConfigKeysSWT.setLaunchHelpersExts(index, "");
            ConfigKeysSWT.setLaunchHelpersProg(index, "");
            if (index == num_lines - 1) {
                if (index > 0) {
                    COConfigurationManager.setParameter("Table.lh.line.count", num_lines - 1);
                }
            } else {
                int i = index + 1;
                while (i <= num_lines) {
                    String exts = ConfigKeysSWT.getLaunchHelpersExts(i);
                    String prog = ConfigKeysSWT.getLaunchHelpersProg(i);
                    ConfigKeysSWT.setLaunchHelpersExts(i - 1, exts);
                    ConfigKeysSWT.setLaunchHelpersProg(i - 1, prog);
                    ++i;
                }
                COConfigurationManager.setParameter("Table.lh.line.count", num_lines - 1);
            }
            this.requestRebuild();
        }));
    }
}

