/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.peer;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.HSLColor;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.piece.PieceMapView;
import com.biglybt.util.MapUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class PeerPieceMapView
implements UISWTViewCoreEventListener {
    public static final String VIEW_ID = "PeerPieceMapView";
    private static final int BLOCK_FILLSIZE = 14;
    private static final int BLOCK_SPACING = 2;
    private static final int BLOCK_SIZE = 16;
    private static final int BLOCKCOLOR_AVAIL_HAVE = 0;
    private static final int BLOCKCOLOR_AVAIL_NOHAVE = 1;
    private static final int BLOCKCOLOR_NOAVAIL_HAVE = 2;
    private static final int BLOCKCOLOR_NOAVAIL_NOHAVE = 3;
    private static final int BLOCKCOLOR_TRANSFER = 4;
    private static final int BLOCKCOLOR_NEXT = 5;
    private static final byte SHOW_BIG = 2;
    private static final byte SHOW_SMALL = 1;
    private static final boolean DEBUG = false;
    private Composite peerInfoComposite;
    private ScrolledComposite sc;
    protected Canvas peerInfoCanvas;
    private Color[] blockColors;
    private Label topLabel;
    private Label imageLabel;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update") * 2;
    private int loopFactor = 0;
    private PEPeer peer;
    private Plugin countryLocator = null;
    private String sCountryImagesDir;
    private Font font = null;
    Image img = null;
    protected boolean alreadyFilling;
    private UISWTView swtView;
    private int currentNumColumns;
    private int currentNumPieces;
    BlockInfo[] oldBlockInfo;
    private final List<Integer> distinctPieceCache = new ArrayList<Integer>();

    public PeerPieceMapView() {
        this.blockColors = new Color[]{Colors.blues[9], Colors.blues[2], Colors.fadedGreen, Colors.white, Colors.red, Colors.fadedRed};
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                PeerPieceMapView.this.initCountryPlugin();
            }
        });
    }

    private void initCountryPlugin() {
        try {
            PluginInterface pi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID("CountryLocator");
            if (pi != null) {
                this.countryLocator = pi.getPlugin();
                if (!pi.getPluginState().isOperational() || pi.getUtilities().compareVersions(pi.getPluginVersion(), "1.6") < 0) {
                    this.countryLocator = null;
                }
                if (this.countryLocator != null) {
                    this.sCountryImagesDir = (String)this.countryLocator.getClass().getMethod("getImageLocation", Integer.TYPE).invoke((Object)this.countryLocator, new Integer(0));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof Object[] && ((Object[])newDataSource).length > 0) {
            newDataSource = ((Object[])newDataSource)[0];
        }
        this.peer = newDataSource instanceof PEPeer ? (PEPeer)newDataSource : null;
        this.oldBlockInfo = null;
        Utils.execSWTThreadLater(0, () -> this.swt_fillPeerInfoSection());
    }

    private String getFullTitle() {
        return MessageText.getString("PeersView.BlockView.title");
    }

    private void initialize(Composite composite) {
        if (this.peerInfoComposite != null && !this.peerInfoComposite.isDisposed()) {
            Logger.log(new LogEvent(LogIDs.GUI, 3, "PeerPieceMapView already initialized! Stack: " + Debug.getStackTrace(true, false)));
            this.delete();
        }
        this.createPeerInfoPanel(composite);
    }

    private Composite createPeerInfoPanel(Composite parent) {
        this.peerInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.peerInfoComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.peerInfoComposite.setLayoutData((Object)gridData);
        this.imageLabel = new Label(this.peerInfoComposite, 0);
        gridData = new GridData();
        if (ImageRepository.hasCountryFlags(false) || this.countryLocator != null) {
            gridData.widthHint = 28;
        }
        this.imageLabel.setLayoutData((Object)gridData);
        this.topLabel = new Label(this.peerInfoComposite, 0);
        gridData = new GridData(4, -1, false, false);
        this.topLabel.setLayoutData((Object)gridData);
        this.sc = new ScrolledComposite(this.peerInfoComposite, 512);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.sc.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true, 2, 1);
        this.sc.setLayoutData((Object)gridData);
        this.sc.getVerticalBar().setIncrement(16);
        this.peerInfoCanvas = new Canvas((Composite)this.sc, 0x140000);
        gridData = new GridData(4, -1, true, false);
        this.peerInfoCanvas.setLayoutData((Object)gridData);
        this.peerInfoCanvas.addPaintListener(e -> {
            if (e.width <= 0 || e.height <= 0) {
                return;
            }
            try {
                Rectangle bounds;
                Rectangle rectangle = bounds = this.img == null ? null : this.img.getBounds();
                if (bounds == null) {
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                } else {
                    int visibleImageWidth = bounds.width - e.x;
                    int visibleImageHeight = bounds.height - e.y;
                    if (e.width > visibleImageWidth) {
                        e.gc.fillRectangle(bounds.width, e.y, e.width - visibleImageWidth + 1, e.height);
                    }
                    if (e.height > visibleImageHeight) {
                        e.gc.fillRectangle(e.x, bounds.height, e.width, e.height - visibleImageHeight + 1);
                    }
                    int width = Math.min(e.width, visibleImageWidth);
                    int height = Math.min(e.height, visibleImageHeight);
                    e.gc.drawImage(this.img, e.x, e.y, width, height, e.x, e.y, width, height);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Listener doNothingListener = new Listener(){

            public void handleEvent(Event event2) {
            }
        };
        this.peerInfoCanvas.addListener(1, doNothingListener);
        this.peerInfoCanvas.addListener(11, e -> {
            if (!this.peerInfoCanvas.isVisible()) {
                return;
            }
            PeerPieceMapView peerPieceMapView = this;
            synchronized (peerPieceMapView) {
                if (this.alreadyFilling) {
                    return;
                }
                this.alreadyFilling = true;
            }
            Utils.execSWTThreadLater(0, () -> {
                int iNewColCount;
                int iOldColCount;
                if (this.img != null && (iOldColCount = this.img.getBounds().width / 16) != (iNewColCount = this.peerInfoCanvas.getClientArea().width / 16)) {
                    this.refreshInfoCanvas();
                }
                PeerPieceMapView peerPieceMapView = this;
                synchronized (peerPieceMapView) {
                    this.alreadyFilling = false;
                }
            });
        });
        this.sc.setContent((Control)this.peerInfoCanvas);
        this.peerInfoCanvas.addListener(10, event2 -> this.swt_fillPeerInfoSection());
        this.sc.addListener(11, event2 -> this.swt_fillPeerInfoSection());
        Legend.createLegendComposite(this.peerInfoComposite, this.blockColors, new String[]{"PeersView.BlockView.Avail.Have", "PeersView.BlockView.Avail.NoHave", "PeersView.BlockView.NoAvail.Have", "PeersView.BlockView.NoAvail.NoHave", "PeersView.BlockView.Transfer", "PeersView.BlockView.NextRequest"}, null, new GridData(4, -1, true, false, 2, 1), true, new Legend.LegendListener(){

            @Override
            public void hoverChange(boolean entry, int index) {
            }

            @Override
            public void visibilityChange(boolean visible, int index) {
            }

            @Override
            public void colorChange(int index) {
                PeerPieceMapView.this.oldBlockInfo = null;
                PeerPieceMapView.this.distinctPieceCache.clear();
                PeerPieceMapView.this.refreshInfoCanvas();
            }
        });
        this.font = FontUtils.getFontPercentOf(this.peerInfoCanvas.getFont(), 0.7f);
        return this.peerInfoComposite;
    }

    private void swt_fillPeerInfoSection() {
        block18: {
            if (this.peerInfoComposite == null || this.peerInfoComposite.isDisposed()) {
                return;
            }
            if (this.imageLabel.getImage() != null) {
                Image image = this.imageLabel.getImage();
                this.imageLabel.setImage(null);
                image.dispose();
            }
            if (this.peer == null) {
                this.topLabel.setText("");
            } else {
                String s = this.peer.getClient();
                if (s == null) {
                    s = "";
                } else if (s.length() > 0) {
                    s = String.valueOf(s) + "; ";
                }
                s = String.valueOf(s) + this.peer.getIp() + "; " + DisplayFormatters.formatPercentFromThousands(this.peer.getPercentDoneInThousandNotation());
                this.topLabel.setText(s);
                Image flag = ImageRepository.getCountryFlag(this.peer, false);
                if (flag != null) {
                    flag = new Image(flag.getDevice(), flag.getImageData());
                    flag.setBackground(this.imageLabel.getBackground());
                    this.imageLabel.setImage(flag);
                    String[] country_details = PeerUtils.getCountryDetails(this.peer);
                    if (country_details != null && country_details.length == 2) {
                        Utils.setTT((Control)this.imageLabel, String.valueOf(country_details[0]) + "- " + country_details[1]);
                    } else {
                        Utils.setTT((Control)this.imageLabel, "");
                    }
                } else if (this.countryLocator != null) {
                    try {
                        String sCountry = (String)this.countryLocator.getClass().getMethod("getIPCountry", String.class, Locale.class).invoke((Object)this.countryLocator, this.peer.getIp(), Locale.getDefault());
                        String sCode = (String)this.countryLocator.getClass().getMethod("getIPISO3166", String.class).invoke((Object)this.countryLocator, this.peer.getIp());
                        Utils.setTT((Control)this.imageLabel, String.valueOf(sCode) + "- " + sCountry);
                        InputStream is = this.countryLocator.getClass().getClassLoader().getResourceAsStream(String.valueOf(this.sCountryImagesDir) + "/" + sCode.toLowerCase() + ".png");
                        if (is == null) break block18;
                        try {
                            Image img = new Image((Device)this.imageLabel.getDisplay(), is);
                            img.setBackground(this.imageLabel.getBackground());
                            this.imageLabel.setImage(img);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    Utils.setTT((Control)this.imageLabel, "");
                }
            }
        }
        this.refreshInfoCanvas();
    }

    private void refresh() {
        if (this.loopFactor++ % this.graphicsUpdate == 0) {
            this.refreshInfoCanvas();
        }
    }

    private void refreshInfoCanvas() {
        boolean needsMore;
        int numChanged;
        Rectangle dirtyBounds;
        block62: {
            GC gcImg;
            block61: {
                this.alreadyFilling = false;
                if (this.peerInfoComposite == null || this.peerInfoComposite.isDisposed() || !this.peerInfoComposite.isVisible()) {
                    return;
                }
                this.peerInfoCanvas.layout(true);
                Rectangle bounds = this.peerInfoCanvas.getClientArea();
                if (bounds.width <= 0 || bounds.height <= 0) {
                    return;
                }
                if (this.peer == null || this.peer.getPeerState() != 30) {
                    GC gc = new GC((Drawable)this.peerInfoCanvas);
                    gc.fillRectangle(bounds);
                    gc.dispose();
                    return;
                }
                PEPeerManager pm = this.peer.getManager();
                DiskManager dm = pm == null ? null : pm.getDiskManager();
                BitFlags peerHavePieces = this.peer.getAvailable();
                if (dm == null || peerHavePieces == null) {
                    GC gc = new GC((Drawable)this.peerInfoCanvas);
                    gc.fillRectangle(bounds);
                    gc.dispose();
                    return;
                }
                int iNumCols = bounds.width / 16;
                if (this.currentNumColumns != iNumCols) {
                    this.currentNumColumns = iNumCols;
                    this.oldBlockInfo = null;
                    if (this.img != null) {
                        this.img.dispose();
                        this.img = null;
                    }
                    this.distinctPieceCache.clear();
                }
                int numPieces = dm.getNbPieces();
                int iNeededHeight = ((numPieces - 1) / iNumCols + 1) * 16;
                if (this.img != null && !this.img.isDisposed()) {
                    Rectangle imgBounds = this.img.getBounds();
                    if (numPieces != this.currentNumPieces || imgBounds.width != bounds.width || imgBounds.height != iNeededHeight) {
                        this.oldBlockInfo = null;
                        this.img.dispose();
                        this.img = null;
                        this.distinctPieceCache.clear();
                    }
                }
                if (this.sc.getMinHeight() != iNeededHeight) {
                    boolean scrollVisible = this.sc.getVerticalBar() != null && this.sc.getVerticalBar().getVisible();
                    this.sc.setMinHeight(iNeededHeight);
                    this.sc.layout(true, true);
                    if (!scrollVisible && iNeededHeight > this.sc.getClientArea().height) {
                        return;
                    }
                    bounds = this.peerInfoCanvas.getClientArea();
                }
                this.currentNumPieces = numPieces;
                DiskManagerPiece[] dm_pieces = dm.getPieces();
                dirtyBounds = null;
                if (this.img == null) {
                    this.img = new Image((Device)this.peerInfoCanvas.getDisplay(), bounds.width, iNeededHeight);
                    this.oldBlockInfo = null;
                    dirtyBounds = this.peerInfoCanvas.getBounds();
                }
                gcImg = new GC((Drawable)this.img);
                gcImg.setFont(this.font);
                numChanged = 0;
                int numCopyArea = 0;
                needsMore = false;
                long startTime = SystemTime.getMonotonousTime();
                try {
                    try {
                        int[] peerRequestedPieces;
                        gcImg.setAdvanced(true);
                        Color canvasBG = this.peerInfoCanvas.getBackground();
                        if (this.oldBlockInfo == null) {
                            gcImg.setBackground(canvasBG);
                            gcImg.fillRectangle(0, 0, bounds.width, iNeededHeight);
                            this.oldBlockInfo = new BlockInfo[numPieces];
                            this.distinctPieceCache.clear();
                        }
                        int[] availability = pm.getAvailability();
                        int minAvailability = Integer.MAX_VALUE;
                        int minAvailability2 = Integer.MAX_VALUE;
                        int maxAvailability = 0;
                        if (availability != null && availability.length > 0) {
                            int[] nArray = availability;
                            int n = availability.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int anAvailability = nArray[n2];
                                if (anAvailability > maxAvailability) {
                                    maxAvailability = anAvailability;
                                }
                                if (anAvailability != 0 && anAvailability < minAvailability) {
                                    minAvailability2 = minAvailability;
                                    minAvailability = anAvailability;
                                    if (minAvailability == 1) break;
                                }
                                ++n2;
                            }
                        }
                        int iNextDLPieceID = -1;
                        int iDLPieceID = -1;
                        int[] ourRequestedPieces = this.peer.getOutgoingRequestedPieceNumbers();
                        if (ourRequestedPieces != null) {
                            if (!this.peer.isChokingMe()) {
                                if (ourRequestedPieces.length > 0) {
                                    iDLPieceID = ourRequestedPieces[0];
                                    if (ourRequestedPieces.length > 1) {
                                        iNextDLPieceID = ourRequestedPieces[1];
                                    }
                                }
                            } else if (ourRequestedPieces.length > 0) {
                                iNextDLPieceID = ourRequestedPieces[0];
                            }
                        }
                        if ((peerRequestedPieces = this.peer.getIncomingRequestedPieceNumbers()) == null) {
                            peerRequestedPieces = new int[]{};
                        }
                        int peerNextRequestedPiece = -1;
                        if (peerRequestedPieces.length > 0) {
                            peerNextRequestedPiece = peerRequestedPieces[0];
                        }
                        Arrays.sort(peerRequestedPieces);
                        int iRow = 0;
                        int iCol = 0;
                        Rectangle canvasBounds = this.peerInfoCanvas.getBounds();
                        if (canvasBounds.y < 0) {
                            iRow = -canvasBounds.y / 16;
                        }
                        int startPieceNo = iRow * iNumCols;
                        int drawHeight = this.sc.getClientArea().height;
                        int endPieceNo = Math.min(numPieces - 1, (int)((double)startPieceNo + (Math.ceil((float)drawHeight / 16.0f) + 1.0) * (double)iNumCols) - 1);
                        boolean needGCrecycle = false;
                        int i = startPieceNo;
                        while (i <= endPieceNo) {
                            block60: {
                                BlockInfo oldInfo;
                                DiskManagerPiece dm_piece;
                                DiskManagerPiece diskManagerPiece = dm_piece = dm_pieces == null ? null : dm_pieces[i];
                                if (iCol >= iNumCols) {
                                    iCol = 0;
                                    ++iRow;
                                }
                                boolean done = dm_piece != null && dm_piece.isDone();
                                int iXPos = iCol * 16;
                                int iYPos = iRow * 16;
                                BlockInfo newInfo = new BlockInfo();
                                newInfo.peerHas = peerHavePieces.flags[i];
                                newInfo.showDown = (byte)(i == iDLPieceID ? 2 : (i == iNextDLPieceID ? 1 : 0));
                                newInfo.showUp = (byte)(i == peerNextRequestedPiece ? 2 : (Arrays.binarySearch(peerRequestedPieces, i) >= 0 ? 1 : 0));
                                int n = newInfo.availNum = availability == null ? -1 : availability[i];
                                if (done) {
                                    newInfo.haveWidth = 14;
                                } else if (dm_piece != null) {
                                    boolean partiallyDone = dm_piece.getNbWritten() > 0;
                                    int width = 14;
                                    if (partiallyDone) {
                                        int iNewWidth = (int)((float)dm_piece.getNbWritten() / (float)dm_piece.getNbBlocks() * (float)width);
                                        if (iNewWidth >= width) {
                                            iNewWidth = width - 1;
                                        } else if (iNewWidth <= 0) {
                                            iNewWidth = 1;
                                        }
                                        newInfo.haveWidth = iNewWidth;
                                    }
                                }
                                newInfo.bounds = new Rectangle(iXPos - 1, iYPos - 1, 16, 16);
                                BlockInfo blockInfo = oldInfo = this.oldBlockInfo != null ? this.oldBlockInfo[i] : null;
                                if (newInfo.sameAs(oldInfo)) {
                                    ++iCol;
                                } else {
                                    long diff;
                                    HSLColor hslColor;
                                    if (needGCrecycle) {
                                        gcImg.dispose();
                                        gcImg = new GC((Drawable)this.img);
                                        gcImg.setFont(this.font);
                                        gcImg.setAdvanced(true);
                                        needGCrecycle = false;
                                    }
                                    if (this.oldBlockInfo != null) {
                                        for (Integer cachePieceNo : this.distinctPieceCache) {
                                            BlockInfo cacheInfo;
                                            if (cachePieceNo == i || (cacheInfo = this.oldBlockInfo[cachePieceNo]) == null || !cacheInfo.sameAs(newInfo)) continue;
                                            Rectangle cacheBounds = cacheInfo.bounds;
                                            gcImg.copyArea(cacheBounds.x, cacheBounds.y, cacheBounds.width, cacheBounds.height, iXPos - 1, iYPos - 1, false);
                                            Rectangle rect = new Rectangle(iXPos - 1, iYPos - 1, 16, 16);
                                            if (dirtyBounds == null) {
                                                dirtyBounds = rect;
                                            } else {
                                                dirtyBounds.add(rect);
                                            }
                                            ++iCol;
                                            ++numCopyArea;
                                            this.oldBlockInfo[i] = newInfo;
                                            this.distinctPieceCache.remove((Object)i);
                                            if (SystemTime.getMonotonousTime() - startTime <= 200L) break block60;
                                            needsMore = true;
                                            break block61;
                                        }
                                    }
                                    Colors colorsInstance = Colors.getInstance();
                                    if (newInfo.haveWidth > 0) {
                                        Color bg = this.blockColors[newInfo.peerHas ? 0 : 2];
                                        if (newInfo.availNum >= 0 && newInfo.availNum < maxAvailability) {
                                            hslColor = new HSLColor();
                                            hslColor.initHSLbyRGB(bg.getRed(), bg.getGreen(), bg.getBlue());
                                            float pct = (1.0f - (float)newInfo.availNum / (float)maxAvailability) / 2.0f;
                                            hslColor.blend(canvasBG.getRed(), canvasBG.getGreen(), canvasBG.getBlue(), pct);
                                            bg = ColorCache.getColor(gcImg.getDevice(), hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                                        }
                                        gcImg.setBackground(bg);
                                        gcImg.fillRectangle(iXPos, iYPos, newInfo.haveWidth, 14);
                                    }
                                    int colorIndex = done ? (newInfo.peerHas ? 0 : 2) : (newInfo.peerHas ? 1 : 3);
                                    Color bg = this.blockColors[colorIndex];
                                    if (newInfo.availNum >= 0 && newInfo.availNum < maxAvailability) {
                                        hslColor = new HSLColor();
                                        hslColor.initHSLbyRGB(bg.getRed(), bg.getGreen(), bg.getBlue());
                                        float pct = (1.0f - (float)newInfo.availNum / (float)maxAvailability) / 2.0f;
                                        hslColor.blend(canvasBG.getRed(), canvasBG.getGreen(), canvasBG.getBlue(), pct);
                                        bg = ColorCache.getColor(gcImg.getDevice(), hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                                    }
                                    gcImg.setBackground(bg);
                                    gcImg.fillRectangle(iXPos + newInfo.haveWidth, iYPos, 14 - newInfo.haveWidth, 14);
                                    if (newInfo.showDown > 0) {
                                        boolean isSmall = newInfo.showDown == 1;
                                        bg = this.blockColors[isSmall ? 5 : 4];
                                        gcImg.setBackground(bg);
                                        PieceMapView.drawDownloadIndicator(gcImg, iXPos, iYPos, isSmall, 14);
                                    }
                                    if (newInfo.showUp > 0) {
                                        boolean isSmall = newInfo.showUp == 1;
                                        bg = this.blockColors[isSmall ? 5 : 4];
                                        gcImg.setBackground(bg);
                                        PieceMapView.drawUploadIndicator(gcImg, iXPos, iYPos, isSmall, 14);
                                    }
                                    if (newInfo.availNum != -1) {
                                        String availText = newInfo.availNum < 100 ? String.valueOf(newInfo.availNum) : "+";
                                        Point size = gcImg.stringExtent(availText);
                                        int x = iXPos + 7 - size.x / 2;
                                        int y = iYPos + 7 - size.y / 2;
                                        Color availCol = colorsInstance.getReadableColor(bg);
                                        gcImg.setForeground(availCol);
                                        gcImg.drawText(availText, x, y, 1);
                                    }
                                    Rectangle dirtyBlockBounds = new Rectangle(iXPos - 1, iYPos - 1, 16, 16);
                                    if (dirtyBounds == null) {
                                        dirtyBounds = new Rectangle(iXPos - 1, iYPos - 1, 16, 16);
                                    } else {
                                        dirtyBounds.add(dirtyBlockBounds);
                                    }
                                    ++iCol;
                                    ++numChanged;
                                    this.oldBlockInfo[i] = newInfo;
                                    this.distinctPieceCache.remove((Object)i);
                                    if (newInfo.showDown == 0 && newInfo.showUp == 0 && (newInfo.haveWidth == 0 || newInfo.haveWidth == 14)) {
                                        boolean haveSimilar = false;
                                        for (Integer cachePieceNo : this.distinctPieceCache) {
                                            if (!newInfo.sameAs(this.oldBlockInfo[cachePieceNo])) continue;
                                            haveSimilar = true;
                                            break;
                                        }
                                        if (!haveSimilar) {
                                            this.distinctPieceCache.add(i);
                                            needGCrecycle = Constants.isOSX;
                                            if (this.distinctPieceCache.size() > 15) {
                                                this.distinctPieceCache.remove(0);
                                            }
                                        }
                                    }
                                    if ((diff = SystemTime.getMonotonousTime() - startTime) > 200L) {
                                        needsMore = true;
                                        break;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        Logger.log(new LogEvent(LogIDs.GUI, "drawing piece map", e));
                        gcImg.dispose();
                        break block62;
                    }
                }
                catch (Throwable throwable) {
                    gcImg.dispose();
                    throw throwable;
                }
            }
            gcImg.dispose();
        }
        if (numChanged > 0) {
            this.peerInfoCanvas.redraw(dirtyBounds.x, dirtyBounds.y, dirtyBounds.width, dirtyBounds.height, false);
        }
        if (needsMore) {
            Utils.execSWTThreadLater(0, this::refreshInfoCanvas);
        }
    }

    private Composite getComposite() {
        return this.peerInfoComposite;
    }

    private void delete() {
        if (this.imageLabel != null && !this.imageLabel.isDisposed() && this.imageLabel.getImage() != null) {
            Image image = this.imageLabel.getImage();
            this.imageLabel.setImage(null);
            image.dispose();
        }
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
            this.img = null;
        }
        this.oldBlockInfo = null;
        this.distinctPieceCache.clear();
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
            this.font = null;
        }
    }

    private Image obfuscatedImage(Image image) {
        UIDebugGenerator.obfuscateArea(image, (Control)this.topLabel, "");
        return image;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.refreshInfoCanvas();
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfuscatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        }
        return true;
    }

    private static void log(String s) {
        System.out.println(String.valueOf(SystemTime.getCurrentTime()) + " PIV] " + s);
    }

    private static class BlockInfo {
        public int haveWidth;
        public boolean peerHas;
        int availNum;
        byte showUp;
        byte showDown;
        Rectangle bounds;

        private BlockInfo() {
        }

        public boolean sameAs(BlockInfo otherBlockInfo) {
            if (otherBlockInfo == null) {
                return false;
            }
            return this.haveWidth == otherBlockInfo.haveWidth && this.peerHas == otherBlockInfo.peerHas && this.availNum == otherBlockInfo.availNum && this.showDown == otherBlockInfo.showDown && this.showUp == otherBlockInfo.showUp;
        }

        public String toString() {
            return "BlockInfo@" + Integer.toHexString(this.hashCode()) + "{" + "haveWidth=" + this.haveWidth + ", availNum=" + this.availNum + ", showUp=" + this.showUp + ", showDown=" + this.showDown + '}';
        }
    }
}

