/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.piece;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.DownloadManagerPieceListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.peermanager.piecepicker.PiecePickerListener;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.HSLColor;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class PieceMapView
implements DownloadManagerPieceListener,
DownloadManagerPeerListener,
PiecePickerListener,
UISWTViewCoreEventListener {
    public static final boolean DEBUG = false;
    public static final String KEY_INSTANCE = "PieceMapView::instance";
    private static final int BLOCK_FILLSIZE = 14;
    private static final int BLOCK_SPACING = 3;
    private static final int BLOCK_SIZE = 17;
    private static final int BLOCKCOLOR_HAVE = 0;
    private static final int BLOCKCOLOR_NOHAVE = 1;
    private static final int BLOCKCOLOR_TRANSFER = 2;
    private static final int BLOCKCOLOR_NEXT = 3;
    private static final int BLOCKCOLOR_SHOWFILE = 4;
    private static final int BLOCKCOLOR_MERGE_READ = 5;
    private static final int BLOCKCOLOR_MERGE_WRITE = 6;
    private static final int BLOCKCOLOR_FORCED = 7;
    public static final String MSGID_PREFIX = "PieceMapView";
    private static final byte SHOW_BIG = 2;
    private static final byte SHOW_SMALL = 1;
    private Composite pieceInfoComposite;
    private ScrolledComposite sc;
    private Canvas pieceInfoCanvas;
    private int currentNumColumns;
    private int currentNumPieces;
    private static final Color[] blockColors = new Color[]{Colors.blues[9], Colors.white, Colors.red, Colors.fadedRed, Colors.fadedGreen, Colors.yellow, Colors.grey, Colors.cyan};
    private static final String[] legendKeys = new String[]{"PiecesView.BlockView.Have", "PiecesView.BlockView.NoHave", "PeersView.BlockView.Transfer", "PeersView.BlockView.NextRequest", "PeersView.BlockView.ShowFile", "PeersView.BlockView.MergeRead", "PeersView.BlockView.MergeWrite", "PeersView.BlockView.ForcePiece"};
    private BufferedLabel topLabel;
    private String topLabelLHS = "";
    private String topLabelRHS = "";
    private List<Integer> selectedPieceExplicit = null;
    private int selectedPiece = -1;
    private int selectedPieceShowFilePending = -1;
    private boolean selectedPieceShowFile;
    private boolean scrollPending = false;
    private Color file_color;
    private Color file_color_faded;
    private Label imageLabel;
    private final int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    private int loopFactor = 0;
    private Font font = null;
    Image img = null;
    private DownloadManager dlm;
    private PiecePicker current_pp;
    BlockInfo[] oldBlockInfo;
    private Map<String, Point> textExtents;
    private final List<Integer> distinctPieceCache = new ArrayList<Integer>();
    private boolean alreadyFilling = false;
    private UISWTView swtView;

    public static Color getLegendColor(String key) {
        return Legend.getLegendColor(key, legendKeys, blockColors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object newDataSource) {
        Object parentView;
        DownloadManager[] newManager = DataSourceUtils.getDMs(newDataSource);
        if (newManager.length == 0 && this.swtView != null && (parentView = this.swtView.getParentView()) != null) {
            newManager = DataSourceUtils.getDMs(parentView.getDataSource());
        }
        if (newManager.length != 1) {
            this.oldBlockInfo = null;
            this.distinctPieceCache.clear();
            if (this.img != null) {
                this.img.dispose();
                this.img = null;
            }
            if (this.pieceInfoCanvas != null && !this.pieceInfoCanvas.isDisposed()) {
                this.pieceInfoCanvas.redraw();
            }
        }
        this.topLabelRHS = "";
        parentView = this;
        synchronized (parentView) {
            if (this.dlm != null) {
                this.dlm.removePieceListener(this);
                this.dlm.removePeerListener(this);
                if (this.current_pp != null) {
                    this.current_pp.removeListener(this);
                }
            }
            DownloadManager downloadManager = this.dlm = newManager.length == 1 ? newManager[0] : null;
            if (this.dlm != null) {
                this.dlm.addPieceListener(this, false);
                this.dlm.addPeerListener(this, true);
            }
        }
        PEPiece[] pieces = DataSourceUtils.getPieces(newDataSource);
        if (this.dlm != null && pieces.length > 0) {
            this.selectPieces(pieces);
        }
        if (this.dlm != null) {
            this.fillPieceInfoSection();
        }
        Utils.execSWTThread(() -> this.updateTopLabel());
    }

    private static String getFullTitle() {
        return MessageText.getString("PeersView.BlockView.title");
    }

    private void initialize(Composite composite) {
        if (this.pieceInfoComposite != null && !this.pieceInfoComposite.isDisposed()) {
            Logger.log(new LogEvent(LogIDs.GUI, 3, "PieceMapView already initialized! Stack: " + Debug.getStackTrace(true, false)));
            this.delete();
        }
        this.createPeerInfoPanel(composite);
        this.fillPieceInfoSection();
        Composite c = composite;
        while (c != null) {
            c.setData(KEY_INSTANCE, (Object)composite);
            c = c.getParent();
        }
    }

    public void selectPieces(PEPiece ... pieces) {
        if (pieces.length > 0) {
            this.selectedPieceExplicit = new ArrayList<Integer>();
            PEPiece[] pEPieceArray = pieces;
            int n = pieces.length;
            int n2 = 0;
            while (n2 < n) {
                PEPiece piece = pEPieceArray[n2];
                this.selectedPieceExplicit.add(piece.getPieceNumber());
                ++n2;
            }
        } else {
            this.selectedPieceExplicit = null;
        }
        Utils.execSWTThread(() -> {
            this.scrollPending = true;
            this.refreshInfoCanvas();
        });
    }

    private void createPeerInfoPanel(Composite parent) {
        this.pieceInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.pieceInfoComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.pieceInfoComposite.setLayoutData((Object)gridData);
        this.imageLabel = new Label(this.pieceInfoComposite, 0);
        gridData = new GridData();
        this.imageLabel.setLayoutData((Object)gridData);
        this.topLabel = new BufferedLabel(this.pieceInfoComposite, 0x20000000);
        if (!Utils.isDarkAppearanceNative()) {
            this.topLabel.getControl().setBackground(Colors.white);
        }
        gridData = new GridData(4, -1, true, false);
        this.topLabel.setLayoutData(gridData);
        this.sc = new ScrolledComposite(this.pieceInfoComposite, 512);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.sc.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true, 2, 1);
        this.sc.setLayoutData((Object)gridData);
        this.sc.getVerticalBar().setIncrement(17);
        this.pieceInfoCanvas = new Canvas((Composite)this.sc, 0x140000);
        gridData = new GridData(4, -1, true, false);
        this.pieceInfoCanvas.setLayoutData((Object)gridData);
        this.pieceInfoCanvas.addPaintListener(e -> {
            if (e.width <= 0 || e.height <= 0) {
                return;
            }
            try {
                Rectangle bounds;
                Rectangle rectangle = bounds = this.img == null ? null : this.img.getBounds();
                if (bounds == null || this.dlm == null) {
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                } else {
                    int visibleImageWidth = bounds.width - e.x;
                    int visibleImageHeight = bounds.height - e.y;
                    if (e.width > visibleImageWidth) {
                        e.gc.fillRectangle(bounds.width, e.y, e.width - visibleImageWidth + 1, e.height);
                    }
                    if (e.height > visibleImageHeight) {
                        e.gc.fillRectangle(e.x, bounds.height, e.width, e.height - visibleImageHeight + 1);
                    }
                    if (visibleImageWidth < 0 || visibleImageHeight < 0) {
                        return;
                    }
                    this.refreshInfoCanvas();
                    int width = Math.min(e.width, visibleImageWidth);
                    int height = Math.min(e.height, visibleImageHeight);
                    e.gc.drawImage(this.img, e.x, e.y, width, height, e.x, e.y, width, height);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        this.pieceInfoCanvas.addListener(1, (Listener)new DoNothingListener());
        this.pieceInfoCanvas.addListener(11, e -> {
            PieceMapView pieceMapView = this;
            synchronized (pieceMapView) {
                if (this.alreadyFilling) {
                    return;
                }
                this.alreadyFilling = true;
            }
            Utils.execSWTThreadLater(0, () -> {
                int iNewColCount;
                int iOldColCount;
                if (this.img != null && (iOldColCount = this.img.getBounds().width / 17) != (iNewColCount = this.pieceInfoCanvas.getClientArea().width / 17)) {
                    this.refreshInfoCanvas();
                }
                PieceMapView pieceMapView = this;
                synchronized (pieceMapView) {
                    this.alreadyFilling = false;
                }
            });
        });
        this.sc.setContent((Control)this.pieceInfoCanvas);
        this.pieceInfoCanvas.addMouseMoveListener(event2 -> {
            int piece_number = this.getPieceNumber(event2.x, event2.y);
            if (piece_number != this.selectedPiece) {
                this.selectedPieceShowFilePending = -1;
            }
        });
        this.pieceInfoCanvas.addListener(10, event2 -> this.fillPieceInfoSection());
        this.sc.addListener(11, event2 -> this.fillPieceInfoSection());
        this.pieceInfoCanvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event2) {
                boolean pieceChanged;
                int piece_number = PieceMapView.this.getPieceNumber(event2.x, event2.y);
                boolean bl = pieceChanged = piece_number != PieceMapView.this.selectedPiece;
                if (piece_number >= 0) {
                    PieceMapView.this.selectedPieceExplicit = null;
                    PieceMapView.this.selectedPiece = piece_number;
                    PieceMapView.this.selectedPieceShowFilePending = piece_number;
                    SimpleTimer.addEvent("ShowFile", SystemTime.getOffsetTime(1000L), event1 -> {
                        boolean bl = Utils.execSWTThread(() -> {
                            if (PieceMapView.this.selectedPieceShowFilePending == piece_number) {
                                PieceMapView.this.selectedPieceShowFile = true;
                                PieceMapView.this.refreshInfoCanvas();
                            }
                        });
                    });
                    PieceMapView.this.refreshInfoCanvas();
                    PieceMapView.this.setTopLableRHS(new Integer[]{piece_number});
                } else {
                    PieceMapView.this.topLabelRHS = "";
                }
                PieceMapView.this.updateTopLabel();
                if (pieceChanged) {
                    PieceMapView.this.refreshInfoCanvas();
                }
            }

            public void mouseExit(MouseEvent e) {
                PieceMapView.this.selectedPiece = -1;
                PieceMapView.this.selectedPieceShowFile = false;
                Utils.setTT((Control)PieceMapView.this.pieceInfoCanvas, null);
                PieceMapView.this.refreshInfoCanvas();
            }
        });
        Menu menu = new Menu((Decorations)this.pieceInfoCanvas.getShell(), 8);
        this.pieceInfoCanvas.setMenu(menu);
        this.pieceInfoCanvas.addListener(35, event2 -> {
            Point pt = this.pieceInfoCanvas.toControl(event2.x, event2.y);
            int piece_number = this.getPieceNumber(pt.x, pt.y);
            menu.setData("pieceNumber", (Object)piece_number);
        });
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, (menu1, event2) -> {
            Integer pn = (Integer)menu1.getData("pieceNumber");
            if (pn != null && pn != -1) {
                final DownloadManager download_manager = this.dlm;
                if (download_manager == null) {
                    return;
                }
                DiskManager disk_manager = download_manager.getDiskManager();
                PEPeerManager peer_manager = download_manager.getPeerManager();
                if (disk_manager == null || peer_manager == null) {
                    return;
                }
                final PiecePicker picker = peer_manager.getPiecePicker();
                DiskManagerPiece[] dm_pieces = disk_manager.getPieces();
                PEPiece[] pe_pieces = peer_manager.getPieces();
                final int piece_number = pn;
                DiskManagerPiece dm_piece = dm_pieces[piece_number];
                PEPiece pm_piece = pe_pieces[piece_number];
                MenuItem force_piece = new MenuItem(menu1, 32);
                Messages.setLanguageText((Widget)force_piece, "label.force.piece");
                boolean done = dm_piece.isDone();
                force_piece.setEnabled(!done);
                if (!done) {
                    force_piece.setSelection(picker.isForcePiece(piece_number));
                    force_piece.addSelectionListener((SelectionListener)new SelectionListenerForcePiece(picker, piece_number, force_piece));
                }
                MenuItem reset_piece = new MenuItem(menu1, 8);
                Messages.setLanguageText((Widget)reset_piece, "label.reset.piece");
                boolean can_reset = dm_piece.isDone() || dm_piece.getNbWritten() > 0;
                reset_piece.setEnabled(can_reset);
                reset_piece.addSelectionListener((SelectionListener)new SelectionListenerResetPiece(dm_piece, pm_piece));
                new MenuItem(menu1, 2);
                MenuItem seq_asc = new MenuItem(menu1, 8);
                Messages.setLanguageText((Widget)seq_asc, "label.seq.asc.from", String.valueOf(piece_number));
                seq_asc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        download_manager.getDownloadState().setFlag(8192L, false);
                        picker.setReverseBlockOrder(false);
                        picker.setSequentialAscendingFrom(piece_number);
                    }
                });
                MenuItem seq_desc = new MenuItem(menu1, 8);
                Messages.setLanguageText((Widget)seq_desc, "label.seq.desc.from", String.valueOf(piece_number));
                seq_desc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        download_manager.getDownloadState().setFlag(8192L, false);
                        picker.setReverseBlockOrder(true);
                        picker.setSequentialDescendingFrom(piece_number);
                    }
                });
                MenuItem seq_clear = new MenuItem(menu1, 8);
                Messages.setLanguageText((Widget)seq_clear, "label.seq.clear", String.valueOf(piece_number));
                seq_clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        download_manager.getDownloadState().setFlag(8192L, false);
                        picker.setReverseBlockOrder(false);
                        picker.clearSequential();
                    }
                });
            }
        });
        Legend.createLegendComposite(this.pieceInfoComposite, blockColors, legendKeys, null, new GridData(4, -1, true, false, 2, 1), true, new Legend.LegendListener(){

            @Override
            public void hoverChange(boolean entry, int index) {
            }

            @Override
            public void visibilityChange(boolean visible, int index) {
            }

            @Override
            public void colorChange(int index) {
                PieceMapView.this.oldBlockInfo = null;
                PieceMapView.this.distinctPieceCache.clear();
                PieceMapView.this.refreshInfoCanvas();
            }
        });
        this.font = FontUtils.getFontPercentOf(this.pieceInfoCanvas.getFont(), 0.7f);
        this.textExtents = new HashMap<String, Point>();
    }

    private int getPieceNumber(int x, int y) {
        DownloadManager manager = this.dlm;
        if (manager == null) {
            return -1;
        }
        Rectangle bounds = this.pieceInfoCanvas.getClientArea();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return -1;
        }
        int y_block = y / 17;
        int iNumCols = bounds.width / 17;
        int x_block = x / 17;
        int piece_number = y_block * iNumCols + x_block;
        if (piece_number >= this.dlm.getNbPieces()) {
            return -1;
        }
        return piece_number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPieceInfoSection() {
        PieceMapView pieceMapView = this;
        synchronized (pieceMapView) {
            if (this.alreadyFilling) {
                return;
            }
            this.alreadyFilling = true;
        }
        Utils.execSWTThreadLater(0, () -> {
            block17: {
                PieceMapView pieceMapView;
                PieceMapView pieceMapView2 = this;
                synchronized (pieceMapView2) {
                    if (!this.alreadyFilling) {
                        return;
                    }
                }
                try {
                    if (this.imageLabel != null && !this.imageLabel.isDisposed()) break block17;
                    pieceMapView = this;
                }
                catch (Throwable throwable) {
                    PieceMapView pieceMapView3 = this;
                    synchronized (pieceMapView3) {
                        this.alreadyFilling = false;
                    }
                    throw throwable;
                }
                synchronized (pieceMapView) {
                    this.alreadyFilling = false;
                }
                return;
            }
            if (this.imageLabel.getImage() != null) {
                Image image = this.imageLabel.getImage();
                this.imageLabel.setImage(null);
                image.dispose();
            }
            this.refreshInfoCanvas();
            PieceMapView pieceMapView = this;
            synchronized (pieceMapView) {
                this.alreadyFilling = false;
            }
        });
    }

    private void refresh() {
        if (this.loopFactor++ % this.graphicsUpdate == 0) {
            this.refreshInfoCanvas();
        }
    }

    private void setTopLableRHS(Integer ... piece_numbers) {
        DiskManager disk_manager = this.dlm.getDiskManager();
        PEPeerManager pm = this.dlm.getPeerManager();
        DiskManagerPiece[] dm_pieces = disk_manager == null ? this.dlm.getDiskManagerPiecesSnapshot() : disk_manager.getPieces();
        StringBuilder text = new StringBuilder();
        if (dm_pieces != null) {
            StringBuilder files_str = new StringBuilder();
            int file_count = 0;
            Integer[] integerArray = piece_numbers;
            int n = piece_numbers.length;
            int n2 = 0;
            while (n2 < n) {
                int piece_number = integerArray[n2];
                if (text.length() > 0) {
                    text.append("\n");
                }
                DiskManagerPiece dm_piece = dm_pieces[piece_number];
                PEPiece pm_piece = pm == null ? null : pm.getPiece(piece_number);
                text.append("Piece ").append(piece_number);
                text.append(": ").append(dm_piece.getString());
                if (pm_piece != null) {
                    text.append(", active: ").append(pm_piece.getString());
                } else if (dm_piece.isNeeded() && !dm_piece.isDone() && pm != null) {
                    text.append(", inactive: ");
                    text.append(pm.getPiecePicker().getPieceString(piece_number));
                }
                text.append(" - ");
                DMPieceList l = dm_piece.getPieceList();
                int i = 0;
                while (i < l.size()) {
                    DMPieceMapEntry entry = l.get(i);
                    DiskManagerFileInfo info = entry.getFile();
                    if (i > 0) {
                        text.append("; ");
                    }
                    text.append(info.getFile(true).getName());
                    text.append(", ");
                    text.append(MessageText.getString("label.offset"));
                    text.append(" ");
                    text.append(entry.getOffset());
                    if (file_count < 20) {
                        if (files_str.length() > 0) {
                            files_str.append('\n');
                        }
                        files_str.append(info.getTorrentFile().getRelativePath());
                        files_str.append(", ");
                        files_str.append(MessageText.getString("label.offset"));
                        files_str.append(" ");
                        files_str.append(entry.getOffset());
                    } else if (file_count == 20) {
                        files_str.append("\n...");
                    }
                    ++file_count;
                    ++i;
                }
                ++n2;
            }
            Utils.setTT((Control)this.pieceInfoCanvas, files_str.toString());
        } else {
            Utils.setTT((Control)this.pieceInfoCanvas, null);
        }
        this.topLabelRHS = text.toString();
    }

    private void updateTopLabel() {
        if (this.topLabel == null || this.topLabel.isDisposed()) {
            return;
        }
        String text = this.topLabelLHS;
        if (this.selectedPieceExplicit != null) {
            this.setTopLableRHS(this.selectedPieceExplicit.toArray(new Integer[0]));
        }
        if (text.length() > 0 && this.topLabelRHS.length() > 0) {
            text = String.valueOf(text) + "; " + this.topLabelRHS;
        }
        this.topLabel.setText(text);
    }

    protected void refreshInfoCanvas() {
        int pos = this.refreshInfoCanvasSupport();
        if (this.scrollPending && pos != -1) {
            this.scrollPending = false;
            this.sc.setOrigin(0, pos);
            this.refreshInfoCanvasSupport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int refreshInfoCanvasSupport() {
        boolean needsMore;
        Rectangle dirtyBounds;
        int numPieces;
        int iNumCols;
        PEPeerManager pm;
        int result;
        block99: {
            GC gcImg;
            block98: {
                int n;
                DiskManagerPiece[] dm_pieces;
                result = -1;
                PieceMapView pieceMapView = this;
                synchronized (pieceMapView) {
                    this.alreadyFilling = false;
                }
                if (this.pieceInfoCanvas == null || this.pieceInfoCanvas.isDisposed() || !this.pieceInfoCanvas.isVisible()) {
                    return result;
                }
                this.pieceInfoCanvas.layout(true);
                Rectangle bounds = this.pieceInfoCanvas.getClientArea();
                if (bounds.width <= 0 || bounds.height <= 0) {
                    this.topLabelLHS = "";
                    this.updateTopLabel();
                    return result;
                }
                if (this.dlm == null) {
                    GC gc = new GC((Drawable)this.pieceInfoCanvas);
                    gc.fillRectangle(bounds);
                    gc.dispose();
                    this.topLabelLHS = MessageText.getString("view.one.download.only");
                    this.topLabelRHS = "";
                    this.updateTopLabel();
                    return result;
                }
                pm = this.dlm.getPeerManager();
                PiecePicker piecePicker = pm == null ? null : pm.getPiecePicker();
                DiskManager dm = this.dlm.getDiskManager();
                DiskManagerPiece[] diskManagerPieceArray = dm_pieces = dm == null ? this.dlm.getDiskManagerPiecesSnapshot() : dm.getPieces();
                if (dm_pieces == null) {
                    GC gc = new GC((Drawable)this.pieceInfoCanvas);
                    gc.fillRectangle(bounds);
                    gc.dispose();
                    this.topLabelLHS = "";
                    this.updateTopLabel();
                    return result;
                }
                iNumCols = bounds.width / 17;
                if (this.currentNumColumns != iNumCols) {
                    this.currentNumColumns = iNumCols;
                    this.oldBlockInfo = null;
                    if (this.img != null) {
                        this.img.dispose();
                        this.img = null;
                    }
                    this.distinctPieceCache.clear();
                }
                numPieces = dm_pieces.length;
                int iNeededHeight = ((numPieces - 1) / iNumCols + 1) * 17;
                if (this.img != null && !this.img.isDisposed()) {
                    Rectangle imgBounds = this.img.getBounds();
                    if (numPieces != this.currentNumPieces || imgBounds.width != bounds.width || imgBounds.height != iNeededHeight) {
                        this.oldBlockInfo = null;
                        this.img.dispose();
                        this.img = null;
                        this.distinctPieceCache.clear();
                    }
                }
                if (this.sc.getMinHeight() != iNeededHeight) {
                    boolean scrollVisible = this.sc.getVerticalBar() != null && this.sc.getVerticalBar().getVisible();
                    this.sc.setMinHeight(iNeededHeight);
                    this.sc.layout(true, true);
                    if (!scrollVisible && iNeededHeight > this.sc.getClientArea().height) {
                        return this.refreshInfoCanvasSupport();
                    }
                    bounds = this.pieceInfoCanvas.getClientArea();
                }
                this.currentNumPieces = numPieces;
                PEPiece[] currentDLPieces = pm == null ? null : pm.getPieces();
                byte[] uploadingPieces = new byte[numPieces];
                long now = SystemTime.getMonotonousTime();
                if (pm != null) {
                    for (PEPeer peer : pm.getPeers()) {
                        DiskManagerReadRequest[] pieces;
                        DiskManagerReadRequest[] diskManagerReadRequestArray = pieces = peer.getRecentPiecesSent();
                        n = pieces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int pieceNum;
                            DiskManagerReadRequest piece = diskManagerReadRequestArray[n2];
                            long sent = piece.getTimeSent();
                            if (sent >= 0L && (sent <= 0L || now - sent <= 10000L) && (pieceNum = piece.getPieceNumber()) < uploadingPieces.length && pieceNum >= 0) {
                                uploadingPieces[pieceNum] = 2;
                            }
                            ++n2;
                        }
                        int[] peerRequestedPieces = peer.getIncomingRequestedPieceNumbers();
                        if (peerRequestedPieces == null || peerRequestedPieces.length == 0) continue;
                        int[] sent = peerRequestedPieces;
                        int n3 = peerRequestedPieces.length;
                        n = 0;
                        while (n < n3) {
                            int pieceNum = sent[n];
                            if (pieceNum < uploadingPieces.length && uploadingPieces[pieceNum] < 1) {
                                uploadingPieces[pieceNum] = 1;
                            }
                            ++n;
                        }
                    }
                }
                int[] availability = pm == null ? null : pm.getAvailability();
                int minAvailability = Integer.MAX_VALUE;
                int minAvailability2 = Integer.MAX_VALUE;
                int maxAvailability = 0;
                if (availability != null && availability.length > 0) {
                    int[] sent = availability;
                    int n4 = availability.length;
                    n = 0;
                    while (n < n4) {
                        int anAvailability = sent[n];
                        if (anAvailability > maxAvailability) {
                            maxAvailability = anAvailability;
                        }
                        if (anAvailability != 0 && anAvailability < minAvailability) {
                            minAvailability2 = minAvailability;
                            minAvailability = anAvailability;
                            if (minAvailability == 1) break;
                        }
                        ++n;
                    }
                }
                int selectionStart = Integer.MAX_VALUE;
                int selectionEnd = Integer.MIN_VALUE;
                if (this.selectedPiece != -1 && this.selectedPieceShowFile) {
                    DMPieceList l = dm_pieces[this.selectedPiece].getPieceList();
                    int i = 0;
                    while (i < l.size()) {
                        DMPieceMapEntry entry = l.get(i);
                        DiskManagerFileInfo info = entry.getFile();
                        int first = info.getFirstPieceNumber();
                        int last = info.getLastPieceNumber();
                        if (first < selectionStart) {
                            selectionStart = first;
                        }
                        if (last > selectionEnd) {
                            selectionEnd = last;
                        }
                        ++i;
                    }
                }
                dirtyBounds = null;
                if (this.img == null) {
                    this.img = new Image((Device)this.pieceInfoCanvas.getDisplay(), bounds.width, iNeededHeight);
                    this.oldBlockInfo = null;
                    this.distinctPieceCache.clear();
                    dirtyBounds = this.pieceInfoCanvas.getBounds();
                }
                gcImg = new GC((Drawable)this.img);
                try {
                    gcImg.setTextAntialias(1);
                }
                catch (Throwable entry) {
                    // empty catch block
                }
                gcImg.setFont(this.font);
                int numChanged = 0;
                int numCopyArea = 0;
                needsMore = false;
                long startTime = SystemTime.getMonotonousTime();
                try {
                    try {
                        gcImg.setAdvanced(true);
                        Color canvasBG = this.pieceInfoCanvas.getBackground();
                        if (this.oldBlockInfo == null) {
                            gcImg.setBackground(canvasBG);
                            gcImg.fillRectangle(0, 0, bounds.width, iNeededHeight);
                            this.oldBlockInfo = new BlockInfo[numPieces];
                            this.distinctPieceCache.clear();
                        }
                        int iCol = 0;
                        int iRow = 0;
                        Rectangle canvasBounds = this.pieceInfoCanvas.getBounds();
                        if (canvasBounds.y < 0) {
                            iRow = -canvasBounds.y / 17;
                        }
                        int startPieceNo = iRow * iNumCols;
                        int drawHeight = this.sc.getClientArea().height;
                        int endPieceNo = Math.min(numPieces - 1, (int)((double)startPieceNo + (Math.ceil((float)drawHeight / 17.0f) + 1.0) * (double)iNumCols) - 1);
                        boolean needGCrecycle = false;
                        int i = startPieceNo;
                        while (i <= endPieceNo) {
                            block97: {
                                BlockInfo oldInfo;
                                boolean isSel;
                                DiskManagerPiece dm_piece = dm_pieces[i];
                                if (iCol >= iNumCols) {
                                    iCol = 0;
                                    ++iRow;
                                }
                                BlockInfo newInfo = new BlockInfo();
                                newInfo.needed = dm_piece.isNeeded();
                                if (i >= selectionStart && i <= selectionEnd) {
                                    newInfo.selectedRange = true;
                                }
                                boolean done = dm_piece.isDone();
                                int iXPos = iCol * 17 + 1;
                                int iYPos = iRow * 17 + 1;
                                if (done) {
                                    newInfo.haveWidth = 14;
                                } else {
                                    boolean partiallyDone = dm_piece.getNbWritten() > 0;
                                    int width = 14;
                                    if (partiallyDone) {
                                        int iNewWidth = (int)((float)dm_piece.getNbWritten() / (float)dm_piece.getNbBlocks() * (float)width);
                                        if (iNewWidth >= width) {
                                            iNewWidth = width - 1;
                                        } else if (iNewWidth <= 0) {
                                            iNewWidth = 1;
                                        }
                                        newInfo.haveWidth = iNewWidth;
                                    }
                                }
                                PEPiece pe_piece = currentDLPieces != null ? currentDLPieces[i] : null;
                                boolean bl = newInfo.forced = piecePicker != null && piecePicker.isForcePiece(i);
                                if (pe_piece != null && pe_piece.hasUndownloadedBlock()) {
                                    newInfo.showDown = (byte)(pe_piece.getNbRequests() == 0 ? 1 : 2);
                                }
                                if (uploadingPieces[i] > 0) {
                                    newInfo.showUp = (byte)(uploadingPieces[i] < 2 ? 1 : 2);
                                }
                                if (availability != null) {
                                    newInfo.availNum = availability[i];
                                    if (minAvailability2 == availability[i]) {
                                        newInfo.availDotted = true;
                                    }
                                } else {
                                    newInfo.availNum = -1;
                                }
                                boolean bl2 = isSel = i == this.selectedPiece || this.selectedPieceExplicit != null && this.selectedPieceExplicit.contains(i);
                                if (isSel) {
                                    newInfo.selected = true;
                                    result = iYPos - 14;
                                }
                                newInfo.bounds = new Rectangle(iXPos - 1, iYPos - 1, 17, 17);
                                BlockInfo blockInfo = oldInfo = this.oldBlockInfo != null ? this.oldBlockInfo[i] : null;
                                if (newInfo.sameAs(oldInfo)) {
                                    ++iCol;
                                } else {
                                    long diff;
                                    Color bg;
                                    Rectangle rectWithBorder = new Rectangle(iXPos - 1, iYPos - 1, 15, 15);
                                    if (needGCrecycle) {
                                        gcImg.dispose();
                                        gcImg = new GC((Drawable)this.img);
                                        gcImg.setFont(this.font);
                                        gcImg.setAdvanced(true);
                                        needGCrecycle = false;
                                    }
                                    if (this.oldBlockInfo != null) {
                                        for (Integer cachePieceNo : this.distinctPieceCache) {
                                            BlockInfo cacheInfo;
                                            if (cachePieceNo == i || (cacheInfo = this.oldBlockInfo[cachePieceNo]) == null || !cacheInfo.sameAs(newInfo)) continue;
                                            Rectangle cacheBounds = cacheInfo.bounds;
                                            gcImg.copyArea(cacheBounds.x, cacheBounds.y, cacheBounds.width, cacheBounds.height, iXPos - 1, iYPos - 1, false);
                                            Rectangle rect = new Rectangle(iXPos - 1, iYPos - 1, 17, 17);
                                            if (dirtyBounds == null) {
                                                dirtyBounds = rect;
                                            } else {
                                                dirtyBounds.add(rect);
                                            }
                                            ++iCol;
                                            ++numCopyArea;
                                            this.oldBlockInfo[i] = newInfo;
                                            this.distinctPieceCache.remove((Object)i);
                                            if (SystemTime.getMonotonousTime() - startTime <= 200L) break block97;
                                            needsMore = true;
                                            break block98;
                                        }
                                    }
                                    Color bgMain = null;
                                    Colors colorsInstance = Colors.getInstance();
                                    if (newInfo.selectedRange) {
                                        Color fc = blockColors[4];
                                        if (oldInfo == null || !oldInfo.selectedRange) {
                                            gcImg.setBackground(fc);
                                            gcImg.fillRectangle(iXPos - 1, iYPos - 1, 17, 17);
                                        }
                                        if (fc != this.file_color) {
                                            this.file_color = fc;
                                            this.file_color_faded = colorsInstance.getLighterColor(fc, 75);
                                        }
                                        bgMain = bg = this.file_color_faded;
                                    } else {
                                        HSLColor hslColor;
                                        bg = canvasBG;
                                        if (oldInfo == null || oldInfo.selectedRange) {
                                            gcImg.setBackground(bg);
                                            gcImg.fillRectangle(iXPos - 1, iYPos - 1, 17, 17);
                                        }
                                        if (newInfo.haveWidth > 0) {
                                            bg = dm_piece.isMergeRead() ? blockColors[5] : (dm_piece.isMergeWrite() ? blockColors[6] : blockColors[0]);
                                            if (newInfo.availNum >= 0 && newInfo.availNum < maxAvailability) {
                                                hslColor = new HSLColor();
                                                hslColor.initHSLbyRGB(bg.getRed(), bg.getGreen(), bg.getBlue());
                                                float pct = (1.0f - (float)newInfo.availNum / (float)maxAvailability) / 2.0f;
                                                hslColor.blend(canvasBG.getRed(), canvasBG.getGreen(), canvasBG.getBlue(), pct);
                                                bg = ColorCache.getColor(gcImg.getDevice(), hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                                            }
                                            gcImg.setBackground(bg);
                                            gcImg.fillRectangle(iXPos, iYPos, newInfo.haveWidth, 14);
                                            if (newInfo.haveWidth * 2 > 14) {
                                                bgMain = bg;
                                            }
                                        }
                                        Color color = bg = newInfo.needed ? blockColors[1] : canvasBG;
                                        if (newInfo.availNum >= 0 && newInfo.availNum < maxAvailability) {
                                            hslColor = new HSLColor();
                                            hslColor.initHSLbyRGB(bg.getRed(), bg.getGreen(), bg.getBlue());
                                            float pct = (1.0f - (float)newInfo.availNum / (float)maxAvailability) / 2.0f;
                                            hslColor.blend(canvasBG.getRed(), canvasBG.getGreen(), canvasBG.getBlue(), pct);
                                            bg = ColorCache.getColor(gcImg.getDevice(), hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                                        }
                                    }
                                    gcImg.setBackground(bg);
                                    gcImg.fillRectangle(iXPos + newInfo.haveWidth, iYPos, 14 - newInfo.haveWidth, 14);
                                    if (bgMain == null) {
                                        bgMain = bg;
                                    }
                                    if (newInfo.showDown > 0) {
                                        boolean isSmall = newInfo.showDown == 1;
                                        bg = blockColors[isSmall ? 3 : 2];
                                        gcImg.setBackground(bg);
                                        PieceMapView.drawDownloadIndicator(gcImg, iXPos, iYPos, isSmall, 14);
                                    }
                                    if (newInfo.showUp > 0) {
                                        boolean isSmall = newInfo.showUp == 1;
                                        bg = blockColors[isSmall ? 3 : 2];
                                        gcImg.setBackground(bg);
                                        PieceMapView.drawUploadIndicator(gcImg, iXPos, iYPos, isSmall, 14);
                                    }
                                    Color availCol = isSel ? (Colors.isBlackTextReadable(bg) ? Colors.red : Colors.white) : colorsInstance.getReadableColor(bg);
                                    int availNum = newInfo.availNum;
                                    int alpha = 255;
                                    if (!newInfo.needed) {
                                        alpha = 100;
                                        gcImg.setAlpha(alpha);
                                    }
                                    if (newInfo.forced) {
                                        gcImg.setForeground(blockColors[7]);
                                        gcImg.setLineWidth(2);
                                        gcImg.drawRectangle(iXPos, iYPos, 14, 14);
                                        gcImg.setLineWidth(1);
                                        gcImg.setForeground(availCol);
                                    } else if (minAvailability == availNum) {
                                        gcImg.setAlpha((int)((double)alpha * 0.8));
                                        gcImg.setForeground(availCol);
                                        gcImg.drawRectangle(rectWithBorder);
                                        gcImg.setAlpha(alpha);
                                    } else if (newInfo.availDotted) {
                                        gcImg.setAlpha((int)((double)alpha * 0.8));
                                        gcImg.setForeground(bgMain);
                                        gcImg.drawRectangle(rectWithBorder);
                                        gcImg.setLineDash(new int[]{1, 2});
                                        gcImg.setForeground(availCol);
                                        gcImg.drawRectangle(rectWithBorder);
                                        gcImg.setLineStyle(1);
                                        gcImg.setAlpha(alpha);
                                    } else if (isSel) {
                                        gcImg.setForeground(availCol);
                                        gcImg.drawRectangle(rectWithBorder);
                                    } else {
                                        gcImg.setForeground(availNum >= 0 ? canvasBG : availCol);
                                        gcImg.drawRectangle(rectWithBorder);
                                        gcImg.setForeground(availCol);
                                    }
                                    if (availNum != -1) {
                                        String availText = availNum < 100 ? String.valueOf(availNum) : "+";
                                        Point size = this.textExtents.get(availText);
                                        if (size == null) {
                                            size = gcImg.stringExtent(availText);
                                            this.textExtents.put(availText, size);
                                        }
                                        int x = iXPos + 7 - size.x / 2;
                                        int y = iYPos + 7 - size.y / 2;
                                        gcImg.drawText(availText, x, y, 1);
                                    }
                                    if (alpha != 255) {
                                        gcImg.setAlpha(255);
                                    }
                                    if (dirtyBounds == null) {
                                        dirtyBounds = new Rectangle(newInfo.bounds.x, newInfo.bounds.y, newInfo.bounds.width, newInfo.bounds.height);
                                    } else {
                                        dirtyBounds.add(newInfo.bounds);
                                    }
                                    ++iCol;
                                    ++numChanged;
                                    this.oldBlockInfo[i] = newInfo;
                                    this.distinctPieceCache.remove((Object)i);
                                    if (newInfo.showDown == 0 && newInfo.showUp == 0 && (newInfo.haveWidth == 0 || newInfo.haveWidth == 14)) {
                                        boolean haveSimilar = false;
                                        for (Integer cachePieceNo : this.distinctPieceCache) {
                                            if (!newInfo.sameAs(this.oldBlockInfo[cachePieceNo])) continue;
                                            haveSimilar = true;
                                            break;
                                        }
                                        if (!haveSimilar) {
                                            this.distinctPieceCache.add(i);
                                            needGCrecycle = Constants.isOSX;
                                            if (this.distinctPieceCache.size() > 15) {
                                                this.distinctPieceCache.remove(0);
                                            }
                                        }
                                    }
                                    if ((diff = SystemTime.getMonotonousTime() - startTime) > 200L) {
                                        needsMore = true;
                                        break;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        Logger.log(new LogEvent(LogIDs.GUI, "drawing piece map", e));
                        gcImg.dispose();
                        break block99;
                    }
                }
                catch (Throwable throwable) {
                    gcImg.dispose();
                    throw throwable;
                }
            }
            gcImg.dispose();
        }
        this.topLabelLHS = String.valueOf(numPieces) + " " + MessageText.getString("Peers.column.pieces");
        if (pm != null) {
            String egm_info;
            PiecePicker picker = pm.getPiecePicker();
            int seq_info = picker.getSequentialInfo();
            if (seq_info != 0) {
                boolean asc;
                int seq_from;
                if (seq_info > 0) {
                    seq_from = seq_info - 1;
                    asc = true;
                } else {
                    seq_from = -(seq_info + 1);
                    asc = false;
                }
                this.topLabelLHS = String.valueOf(this.topLabelLHS) + "; seq=" + seq_from + (asc ? (char)'+' : '-');
            }
            if ((egm_info = picker.getEGMInfo()) != null) {
                this.topLabelLHS = String.valueOf(this.topLabelLHS) + "; EGM=" + egm_info;
            }
        }
        this.updateTopLabel();
        if (dirtyBounds != null) {
            this.pieceInfoCanvas.redraw(dirtyBounds.x, dirtyBounds.y, dirtyBounds.width, dirtyBounds.height, false);
        }
        if (result == -1 && (this.selectedPiece >= 0 || this.selectedPieceExplicit != null)) {
            int i = this.selectedPiece >= 0 ? this.selectedPiece : this.selectedPieceExplicit.get(0);
            result = i / iNumCols * 17;
        }
        if (needsMore) {
            Utils.execSWTThreadLater(0, this::refreshInfoCanvas);
        }
        return result;
    }

    private static void log(String s) {
        System.out.println(String.valueOf(SystemTime.getCurrentTime()) + " PIV] " + s);
    }

    public static void drawDownloadIndicator(GC gcImg, int iXPos, int iYPos, boolean small, int blockFillsize) {
        if (small) {
            gcImg.fillPolygon(new int[]{iXPos + 2, iYPos + 2, iXPos + blockFillsize - 1, iYPos + 2, iXPos + blockFillsize / 2, iYPos + blockFillsize - 1});
        } else {
            gcImg.fillPolygon(new int[]{iXPos, iYPos, iXPos + blockFillsize, iYPos, iXPos + blockFillsize / 2, iYPos + blockFillsize});
        }
    }

    public static void drawUploadIndicator(GC gcImg, int iXPos, int iYPos, boolean small, int blockFillsize) {
        if (!small) {
            gcImg.fillPolygon(new int[]{iXPos, iYPos + blockFillsize, iXPos + blockFillsize, iYPos + blockFillsize, iXPos + blockFillsize / 2, iYPos});
        } else {
            gcImg.fillPolygon(new int[]{iXPos + 1, iYPos + blockFillsize - 2, iXPos + blockFillsize - 2, iYPos + blockFillsize - 2, iXPos + blockFillsize / 2, iYPos + 2});
        }
    }

    private Composite getComposite() {
        return this.pieceInfoComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        if (this.imageLabel != null && !this.imageLabel.isDisposed() && this.imageLabel.getImage() != null) {
            Image image = this.imageLabel.getImage();
            this.imageLabel.setImage(null);
            image.dispose();
        }
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
            this.img = null;
        }
        this.distinctPieceCache.clear();
        if (this.textExtents != null) {
            this.textExtents.clear();
            this.textExtents = null;
        }
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
            this.font = null;
        }
        PieceMapView pieceMapView = this;
        synchronized (pieceMapView) {
            if (this.dlm != null) {
                this.dlm.removePieceListener(this);
                this.dlm.removePeerListener(this);
                if (this.current_pp != null) {
                    this.current_pp.removeListener(this);
                }
                this.dlm = null;
            }
        }
        this.selectedPieceExplicit = null;
        this.selectedPiece = -1;
    }

    @Override
    public void somethingChanged(PiecePicker pp, int thing, Object data) {
        Utils.execSWTThread(this::refreshInfoCanvas);
    }

    private void obfuscatedImage(Image image) {
        UIDebugGenerator.obfuscateArea(image, this.topLabel.getControl(), "");
    }

    @Override
    public void pieceAdded(PEPiece piece) {
        this.fillPieceInfoSection();
    }

    @Override
    public void pieceRemoved(PEPiece piece) {
        this.fillPieceInfoSection();
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
        PiecePicker pp = manager.getPiecePicker();
        if (pp != null) {
            this.current_pp = pp;
            pp.addListener(this);
        }
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        PiecePicker pp = manager.getPiecePicker();
        if (pp != null && this.current_pp == pp) {
            pp.removeListener(this);
            this.current_pp = null;
        }
    }

    @Override
    public void peerAdded(PEPeer peer) {
    }

    @Override
    public void peerRemoved(PEPeer peer) {
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                if (this.swtView instanceof MdiEntry && "TorrentDetailsView".equals(((MdiEntry)((Object)this.swtView)).getMDI().getViewID())) {
                    return false;
                }
                this.swtView.setTitle(PieceMapView.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(PieceMapView.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfuscatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        }
        return true;
    }

    private static class BlockInfo {
        public int haveWidth = 0;
        int availNum;
        boolean availDotted;
        byte showUp;
        byte showDown;
        boolean selectedRange;
        boolean selected;
        boolean forced;
        boolean needed;
        Rectangle bounds;

        public boolean sameAs(BlockInfo otherBlockInfo) {
            if (otherBlockInfo == null) {
                return false;
            }
            return this.haveWidth == otherBlockInfo.haveWidth && this.availNum == otherBlockInfo.availNum && this.needed == otherBlockInfo.needed && this.availDotted == otherBlockInfo.availDotted && this.showDown == otherBlockInfo.showDown && this.showUp == otherBlockInfo.showUp && this.selectedRange == otherBlockInfo.selectedRange && this.selected == otherBlockInfo.selected && this.forced == otherBlockInfo.forced;
        }

        public String toString() {
            return "BlockInfo@" + Integer.toHexString(this.hashCode()) + "{" + "haveWidth=" + this.haveWidth + ", availNum=" + this.availNum + ", needed=" + this.needed + ", availDotted=" + this.availDotted + ", showUp=" + this.showUp + ", showDown=" + this.showDown + ", selectedRange=" + this.selectedRange + ", selected=" + this.selected + ", forced=" + this.forced + '}';
        }
    }

    private static class DoNothingListener
    implements Listener {
        private DoNothingListener() {
        }

        public void handleEvent(Event event2) {
        }
    }

    private static class SelectionListenerForcePiece
    extends SelectionAdapter {
        private final PiecePicker picker;
        private final int piece_number;
        private final MenuItem force_piece;

        public SelectionListenerForcePiece(PiecePicker picker, int piece_number, MenuItem force_piece) {
            this.picker = picker;
            this.piece_number = piece_number;
            this.force_piece = force_piece;
        }

        public void widgetSelected(SelectionEvent e) {
            this.picker.setForcePiece(this.piece_number, this.force_piece.getSelection());
        }
    }

    private static class SelectionListenerResetPiece
    extends SelectionAdapter {
        private final DiskManagerPiece dm_piece;
        private final PEPiece pm_piece;

        public SelectionListenerResetPiece(DiskManagerPiece dm_piece, PEPiece pm_piece) {
            this.dm_piece = dm_piece;
            this.pm_piece = pm_piece;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.pm_piece != null) {
                this.pm_piece.reset();
            } else {
                this.dm_piece.reset();
            }
        }
    }
}

