/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.category.Category;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagGroup;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.InitializerListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Initializer;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.shells.main.MainMDISetup;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.skin.SB_Transfers;
import com.biglybt.ui.swt.views.skin.SkinView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SBC_LibraryView
extends SkinView
implements UIPluginViewToolBarListener {
    private static final String ID = "library-list";
    public static final int MODE_BIGTABLE = 0;
    public static final int MODE_SMALLTABLE = 1;
    public static final int TORRENTS_ALL = 0;
    public static final int TORRENTS_COMPLETE = 1;
    public static final int TORRENTS_INCOMPLETE = 2;
    public static final int TORRENTS_UNOPENED = 3;
    private static final String[] modeViewIDs = new String[]{"library-big-area", "library-small-area"};
    private static final String[] modeIDs = new String[]{"library.table.big", "library.table.small"};
    private static volatile int selection_count;
    private static volatile long selection_size;
    private static volatile long selection_done;
    private static volatile DownloadManager[] selection_dms;
    private SelectedContentListener selectedContentListener;
    private int viewMode = -1;
    private SWTSkinButtonUtility btnSmallTable;
    private SWTSkinButtonUtility btnBigTable;
    private SWTSkinObject soListArea;
    private int torrentFilterMode = 0;
    private String torrentFilter;
    private SWTSkinObject soWait;
    private SWTSkinObject soWaitProgress;
    private SWTSkinObjectText soWaitTask;
    private int waitProgress = 0;
    private SWTSkinObjectText soLibraryInfo;
    private Object datasource;

    static {
        selection_dms = new DownloadManager[0];
    }

    public void setViewMode(int viewMode, boolean save) {
        SB_Transfers sb_t;
        SWTSkinObject soOldViewArea;
        if (viewMode >= modeViewIDs.length || viewMode < 0 || viewMode == this.viewMode) {
            return;
        }
        if (!COConfigurationManager.getBooleanParameter("Library.EnableSimpleView")) {
            viewMode = 1;
        }
        int oldViewMode = this.viewMode;
        this.viewMode = viewMode;
        if (oldViewMode >= 0 && oldViewMode < modeViewIDs.length && (soOldViewArea = this.getSkinObject(modeViewIDs[oldViewMode])) != null) {
            soOldViewArea.setVisible(false);
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        SWTSkinObject soViewArea = this.getSkinObject(modeViewIDs[viewMode]);
        if (soViewArea == null) {
            soViewArea = this.skin.createSkinObject(String.valueOf(modeIDs[viewMode]) + this.torrentFilterMode, modeIDs[viewMode], this.soListArea);
            soViewArea.getControl().setData("SBC_LibraryView:ViewMode", (Object)viewMode);
            this.skin.layout();
            soViewArea.setVisible(true);
            soViewArea.getControl().setLayoutData((Object)Utils.getFilledFormData());
        } else {
            soViewArea.setVisible(true);
        }
        if (save) {
            COConfigurationManager.setParameter(String.valueOf(this.torrentFilter) + ".viewmode", viewMode);
        }
        if ((sb_t = MainMDISetup.getSb_transfers()) != null) {
            sb_t.triggerCountRefreshListeners();
        }
    }

    @Override
    public Object skinObjectInitialShow(final SWTSkinObject skinObject, Object params) {
        this.selectedContentListener = new SelectedContentListener(){

            @Override
            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewId) {
                selection_count = currentContent.length;
                long total_size = 0L;
                long total_done = 0L;
                ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>(currentContent.length);
                IdentityHashSet<DownloadManager> dms_only = new IdentityHashSet<DownloadManager>();
                ISelectedContent[] iSelectedContentArray = currentContent;
                int n = currentContent.length;
                int n2 = 0;
                while (n2 < n) {
                    int file_index;
                    ISelectedContent sc = iSelectedContentArray[n2];
                    DownloadManager dm = sc.getDownloadManager();
                    if (dm != null && (file_index = sc.getFileIndex()) == -1) {
                        dms_only.add(dm);
                    }
                    ++n2;
                }
                IdentityHashSet<DiskManagerFileInfo> processedFiles = new IdentityHashSet<DiskManagerFileInfo>();
                IdentityHashSet<DownloadManager> processedDMs = new IdentityHashSet<DownloadManager>();
                ISelectedContent[] iSelectedContentArray2 = currentContent;
                int n3 = currentContent.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISelectedContent sc = iSelectedContentArray2[n4];
                    DownloadManager dm = sc.getDownloadManager();
                    if (dm != null) {
                        DiskManagerFileInfo file_info;
                        dms.add(dm);
                        int file_index = sc.getFileIndex();
                        if (file_index == -1) {
                            if (!processedDMs.contains(dm)) {
                                DiskManagerFileInfo[] file_infos;
                                processedDMs.add(dm);
                                DiskManagerFileInfo[] diskManagerFileInfoArray = file_infos = dm.getDiskManagerFileInfoSet().getFiles();
                                int n5 = file_infos.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    DiskManagerFileInfo file_info2 = diskManagerFileInfoArray[n6];
                                    if (!processedFiles.contains(file_info2)) {
                                        processedFiles.add(file_info2);
                                        if (!file_info2.isSkipped()) {
                                            total_size += file_info2.getLength();
                                            total_done += file_info2.getDownloaded();
                                        }
                                    }
                                    ++n6;
                                }
                            }
                        } else if (!dms_only.contains(dm) && !processedFiles.contains(file_info = dm.getDiskManagerFileInfoSet().getFiles()[file_index])) {
                            processedFiles.add(file_info);
                            if (!file_info.isSkipped()) {
                                total_size += file_info.getLength();
                                total_done += file_info.getDownloaded();
                            }
                        }
                    }
                    ++n4;
                }
                selection_size = total_size;
                selection_done = total_done;
                selection_dms = dms.toArray(new DownloadManager[dms.size()]);
                SB_Transfers transfers = MainMDISetup.getSb_transfers();
                if (transfers != null) {
                    transfers.triggerCountRefreshListeners();
                }
            }
        };
        SelectedContentManager.addCurrentlySelectedContentListener(this.selectedContentListener);
        this.soWait = null;
        try {
            this.soWait = this.getSkinObject("library-wait");
            this.soWaitProgress = this.getSkinObject("library-wait-progress");
            this.soWaitTask = (SWTSkinObjectText)this.getSkinObject("library-wait-task");
            if (this.soWaitProgress != null) {
                this.soWaitProgress.getControl().addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        if (!$assertionsDisabled && e == null) {
                            throw new AssertionError();
                        }
                        Control c = (Control)e.widget;
                        Point size = c.getSize();
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#23a7df"));
                        int breakX = size.x * SBC_LibraryView.this.waitProgress / 100;
                        e.gc.fillRectangle(0, 0, breakX, size.y);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#cccccc"));
                        e.gc.fillRectangle(breakX, 0, size.x - breakX, size.y);
                    }
                });
            }
            this.soLibraryInfo = (SWTSkinObjectText)this.getSkinObject("library-info");
            if (this.soLibraryInfo != null) {
                MainMDISetup.getSb_transfers().addCountRefreshListener(new SB_Transfers.countRefreshListener(){
                    final Map<Composite, ExtraInfoProvider> extra_info_map = new HashMap<Composite, ExtraInfoProvider>();
                    {
                        SBC_LibraryView.this.soLibraryInfo.getControl().getParent().setData("ViewUtils:ViewTitleExtraInfo", (Object)new ViewUtils.ViewTitleExtraInfo(){

                            @Override
                            public void setCountProvider(Composite reporter, ViewUtils.ViewTitleExtraInfo.CountProvider cp) {
                                ExtraInfoProvider provider = this.getProvider(reporter);
                                if (provider == null) {
                                    return;
                                }
                                provider.countProvider = cp;
                            }

                            @Override
                            public void searchUpdate(Composite reporter, int count, int active) {
                                ExtraInfoProvider provider = this.getProvider(reporter);
                                if (provider == null) {
                                    return;
                                }
                                if (provider.value != count || provider.active != active) {
                                    SB_Transfers xfers;
                                    provider.value = count;
                                    provider.active = active;
                                    if (SBC_LibraryView.this.viewMode == provider.view_mode && provider.search_active && (xfers = MainMDISetup.getSb_transfers()) != null) {
                                        xfers.triggerCountRefreshListeners();
                                    }
                                }
                            }

                            @Override
                            public void setSearchActive(Composite reporter, boolean active) {
                                ExtraInfoProvider provider = this.getProvider(reporter);
                                if (provider == null) {
                                    return;
                                }
                                if (provider.search_active != active) {
                                    provider.search_active = active;
                                    if (SBC_LibraryView.this.viewMode == provider.view_mode) {
                                        MainMDISetup.getSb_transfers().triggerCountRefreshListeners();
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            private ExtraInfoProvider getProvider(Composite reporter) {
                                Map<Composite, ExtraInfoProvider> map = extra_info_map;
                                synchronized (map) {
                                    ExtraInfoProvider provider = extra_info_map.get(reporter);
                                    if (provider != null) {
                                        return provider;
                                    }
                                    Composite temp = reporter;
                                    while (temp != null) {
                                        Integer vm = (Integer)temp.getData("SBC_LibraryView:ViewMode");
                                        if (vm != null) {
                                            provider = new ExtraInfoProvider(vm);
                                            extra_info_map.put(reporter, provider);
                                            return provider;
                                        }
                                        temp = temp.getParent();
                                    }
                                    Debug.out("No view mode found for " + reporter);
                                    return null;
                                }
                            }
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void countRefreshed(SB_Transfers.stats statsWithLowNoise, SB_Transfers.stats statsNoLowNoise) {
                        String id;
                        String s;
                        SB_Transfers.stats stats2 = SBC_LibraryView.this.viewMode == 1 ? statsWithLowNoise : statsNoLowNoise;
                        ArrayList<ViewUtils.ViewTitleExtraInfo.CountProvider> count_provs = new ArrayList<ViewUtils.ViewTitleExtraInfo.CountProvider>();
                        int filter_total = 0;
                        int filter_active = 0;
                        boolean filter_enabled = false;
                        Map<Composite, ExtraInfoProvider> map = this.extra_info_map;
                        synchronized (map) {
                            for (ExtraInfoProvider provider : this.extra_info_map.values()) {
                                ViewUtils.ViewTitleExtraInfo.CountProvider cp;
                                if (SBC_LibraryView.this.viewMode != provider.view_mode) continue;
                                if (provider.search_active) {
                                    filter_enabled = true;
                                    filter_total += provider.value;
                                    filter_active += provider.active;
                                }
                                if ((cp = provider.countProvider) == null) continue;
                                count_provs.add(cp);
                            }
                        }
                        int extra_total = 0;
                        int extra_active = 0;
                        int extra_queued = 0;
                        for (ViewUtils.ViewTitleExtraInfo.CountProvider cp : count_provs) {
                            int[] counts = cp.getCounts();
                            extra_total += counts[0];
                            extra_active += counts[1];
                            extra_queued += counts[2];
                        }
                        String extra_search = null;
                        if (filter_enabled) {
                            extra_search = MessageText.getString("filter.header.matches2", new String[]{String.valueOf(filter_total), String.valueOf(filter_active)});
                            extra_search = extra_search.toLowerCase(Locale.US);
                        }
                        if (SBC_LibraryView.this.torrentFilterMode == 0 || SBC_LibraryView.this.datasource instanceof Tag) {
                            String id2;
                            String id3;
                            boolean addExtra = false;
                            if (SBC_LibraryView.this.datasource instanceof Category) {
                                Category cat = (Category)SBC_LibraryView.this.datasource;
                                id3 = "library.category.header";
                                s = MessageText.getString(id3, new String[]{cat.getType() != 0 ? MessageText.getString(cat.getName()) : cat.getName()});
                                addExtra = true;
                            } else if (SBC_LibraryView.this.datasource instanceof Tag) {
                                Tag tag = (Tag)SBC_LibraryView.this.datasource;
                                id3 = "library.tag.header";
                                s = MessageText.getString(id3, new String[]{tag.getTagName(true)});
                                String desc = tag.getDescription();
                                if (desc != null) {
                                    s = String.valueOf(s) + " - " + desc;
                                }
                                addExtra = true;
                            } else if (SBC_LibraryView.this.datasource instanceof TagGroup) {
                                id2 = "library.taggroup.header";
                                TagGroup tg = (TagGroup)SBC_LibraryView.this.datasource;
                                s = MessageText.getString(id2, new String[]{tg.getName(), String.valueOf(tg.getTags().size())});
                                addExtra = true;
                            } else {
                                id2 = "library.all.header";
                                if (stats2.numComplete + stats2.numIncomplete != 1) {
                                    id2 = String.valueOf(id2) + ".p";
                                }
                                s = MessageText.getString(id2, new String[]{String.valueOf(stats2.numComplete + stats2.numIncomplete), String.valueOf(stats2.numSeeding + stats2.numDownloading)});
                                s = s.toLowerCase(Locale.US);
                                if (stats2.numQueued > 0) {
                                    s = String.valueOf(s) + ", " + MessageText.getString("label.num_queued", new String[]{String.valueOf(stats2.numQueued)});
                                }
                            }
                            if (addExtra) {
                                id2 = "library.all.header";
                                if (extra_total != 1) {
                                    id2 = String.valueOf(id2) + ".p";
                                }
                                s = String.valueOf(s) + " - " + MessageText.getString(id2, new String[]{String.valueOf(extra_total), String.valueOf(extra_active)});
                                s = s.toLowerCase(Locale.US);
                                if (extra_queued > 0) {
                                    s = String.valueOf(s) + ", " + MessageText.getString("label.num_queued", new String[]{String.valueOf(extra_queued)});
                                }
                            }
                        } else if (SBC_LibraryView.this.torrentFilterMode == 2) {
                            id = "library.incomplete.header";
                            if (stats2.numDownloading != 1) {
                                id = String.valueOf(id) + ".p";
                            }
                            int numWaiting = Math.max(stats2.numIncomplete - stats2.numDownloading, 0);
                            s = MessageText.getString(id, new String[]{String.valueOf(stats2.numDownloading), String.valueOf(numWaiting)});
                        } else if (SBC_LibraryView.this.torrentFilterMode == 3 || SBC_LibraryView.this.torrentFilterMode == 1) {
                            id = "library.unopened.header";
                            if (stats2.numUnOpened != 1) {
                                id = String.valueOf(id) + ".p";
                            }
                            s = MessageText.getString(id, new String[]{String.valueOf(stats2.numUnOpened)});
                        } else {
                            s = "";
                        }
                        if (extra_search != null) {
                            s = String.valueOf(s) + " " + extra_search;
                        }
                        SB_Transfers transfers = MainMDISetup.getSb_transfers();
                        if (selection_count > 0) {
                            s = String.valueOf(s) + ", " + MessageText.getString("label.num_selected", new String[]{String.valueOf(selection_count)});
                            String size_str = null;
                            String rate_str = null;
                            if (selection_size > 0L) {
                                size_str = selection_size == selection_done ? DisplayFormatters.formatByteCountToKiBEtc(selection_size) : String.valueOf(DisplayFormatters.formatByteCountToKiBEtc(selection_done)) + "/" + DisplayFormatters.formatByteCountToKiBEtc(selection_size);
                            }
                            DownloadManager[] dms = selection_dms;
                            if (transfers.header_show_rates && dms.length > 0) {
                                long total_data_up = 0L;
                                long total_prot_up = 0L;
                                long total_data_down = 0L;
                                long total_prot_down = 0L;
                                DownloadManager[] downloadManagerArray = dms;
                                int n = dms.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DownloadManager dm = downloadManagerArray[n2];
                                    DownloadManagerStats dm_stats = dm.getStats();
                                    total_prot_up += dm_stats.getProtocolSendRate();
                                    total_data_up += dm_stats.getDataSendRate();
                                    total_prot_down += dm_stats.getProtocolReceiveRate();
                                    total_data_down += dm_stats.getDataReceiveRate();
                                    ++n2;
                                }
                                rate_str = String.valueOf(MessageText.getString("ConfigView.download.abbreviated")) + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(total_data_down, total_prot_down) + " " + MessageText.getString("ConfigView.upload.abbreviated") + DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(total_data_up, total_prot_up);
                            }
                            if (size_str != null || rate_str != null) {
                                String temp = size_str == null ? rate_str : (rate_str == null ? size_str : String.valueOf(size_str) + "; " + rate_str);
                                s = String.valueOf(s) + " (" + temp + ")";
                            }
                        }
                        if (transfers.header_show_uptime && transfers.totalStats != null) {
                            String op;
                            long up_secs = transfers.totalStats.getSessionUpTime() / 60L * 60L;
                            if (up_secs < 60L) {
                                up_secs = 60L;
                                op = "<";
                            } else {
                                op = " ";
                            }
                            String up_str = TimeFormatter.format2(up_secs, false);
                            if (s.equals("")) {
                                Debug.out("eh");
                            }
                            s = String.valueOf(s) + "; " + MessageText.getString("label.uptime_coarse", new String[]{op, up_str});
                        }
                        SBC_LibraryView.this.soLibraryInfo.setText(s);
                    }

                    class ExtraInfoProvider {
                        int view_mode;
                        ViewUtils.ViewTitleExtraInfo.CountProvider countProvider;
                        boolean search_active;
                        int value;
                        int active;

                        ExtraInfoProvider(int vm) {
                            this.view_mode = vm;
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!CoreFactory.isCoreRunning()) {
            Initializer initializer;
            if (this.soWait != null) {
                this.soWait.setVisible(true);
            }
            if ((initializer = Initializer.getLastInitializer()) != null) {
                initializer.addListener(new InitializerListener(){

                    @Override
                    public void reportPercent(final int percent) {
                        Utils.execSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                if (SBC_LibraryView.this.soWaitProgress != null && !SBC_LibraryView.this.soWaitProgress.isDisposed()) {
                                    SBC_LibraryView.this.waitProgress = percent;
                                    SBC_LibraryView.this.soWaitProgress.getControl().redraw();
                                    SBC_LibraryView.this.soWaitProgress.getControl().update();
                                }
                            }
                        });
                        if (percent > 100) {
                            initializer.removeListener(this);
                        }
                    }

                    @Override
                    public void reportCurrentTask(String currentTask) {
                        if (SBC_LibraryView.this.soWaitTask != null && !SBC_LibraryView.this.soWaitTask.isDisposed()) {
                            SBC_LibraryView.this.soWaitTask.setText(currentTask);
                        }
                    }
                });
            }
        }
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(final Core core) {
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                final UIManager uim = pi.getUIManager();
                uim.addUIListener(new UIManagerListener(){

                    @Override
                    public void UIDetached(UIInstance instance) {
                    }

                    @Override
                    public void UIAttached(UIInstance instance) {
                        if (instance instanceof UISWTInstance) {
                            uim.removeUIListener(this);
                            Utils.execSWTThread(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    if (SBC_LibraryView.this.soWait != null) {
                                        SBC_LibraryView.this.soWait.setVisible(false);
                                    }
                                    if (!skinObject.isDisposed()) {
                                        SBC_LibraryView.this.setupView(core, skinObject);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        SelectedContentManager.removeCurrentlySelectedContentListener(this.selectedContentListener);
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void setupView(Core core, SWTSkinObject skinObject) {
        SB_Transfers sb_t;
        Tag tag;
        TagType tagType;
        this.torrentFilter = skinObject.getSkinObjectID();
        if (this.torrentFilter.equalsIgnoreCase("LibraryDL")) {
            this.torrentFilterMode = 2;
        } else if (this.torrentFilter.equalsIgnoreCase("LibraryCD")) {
            this.torrentFilterMode = 1;
        } else if (this.torrentFilter.equalsIgnoreCase("LibraryUnopened")) {
            this.torrentFilterMode = 3;
        }
        if (this.datasource instanceof Tag && (tagType = (tag = (Tag)this.datasource).getTagType()).getTagType() == 2) {
            int tagID = tag.getTagID();
            if (tagID == 1 || tagID == 3 || tagID == 11) {
                this.torrentFilterMode = 2;
            } else if (tagID == 2 || tagID == 4 || tagID == 10) {
                this.torrentFilterMode = 1;
            }
        }
        this.soListArea = this.getSkinObject("library-list-area");
        this.soListArea.getControl().setData("TorrentFilterMode", (Object)new Long(this.torrentFilterMode));
        this.soListArea.getControl().setData("DataSource", this.datasource);
        this.setViewMode(COConfigurationManager.getIntParameter(String.valueOf(this.torrentFilter) + ".viewmode"), false);
        SWTSkinObject so = this.getSkinObject("library-list-button-smalltable");
        if (so != null) {
            this.btnSmallTable = new SWTSkinButtonUtility(so);
            this.btnSmallTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_LibraryView.this.setViewMode(1, true);
                }
            });
        }
        if ((so = this.getSkinObject("library-list-button-bigtable")) != null) {
            this.btnBigTable = new SWTSkinButtonUtility(so);
            this.btnBigTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_LibraryView.this.setViewMode(0, true);
                }
            });
        }
        if ((sb_t = MainMDISetup.getSb_transfers()) != null) {
            sb_t.setupViewTitleWithCore(core);
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.isVisible()) {
            long stateSmall = 1L;
            long stateBig = 1L;
            if (this.viewMode == 0) {
                stateBig |= 2L;
            } else {
                stateSmall |= 2L;
            }
            list.put("modeSmall", stateSmall);
            list.put("modeBig", stateBig);
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        String itemKey = item.getID();
        if (itemKey.equals("modeSmall") && this.isVisible()) {
            this.setViewMode(1, true);
            return true;
        }
        if (itemKey.equals("modeBig") && this.isVisible()) {
            this.setViewMode(0, true);
            return true;
        }
        return false;
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        Control control;
        this.datasource = params;
        if (this.soListArea != null && !(control = this.soListArea.getControl()).isDisposed()) {
            control.setData("DataSource", params);
        }
        return null;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    protected void addHeaderInfoExtender(HeaderInfoExtender extender) {
    }

    protected void removeHeaderInfoExtender(HeaderInfoExtender extender) {
    }

    protected void refreshHeaderInfo() {
        MainMDISetup.getSb_transfers().triggerCountRefreshListeners();
    }

    protected static interface HeaderInfoExtender {
    }
}

