/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.content.ContentException;
import com.biglybt.core.content.RelatedAttributeLookupListener;
import com.biglybt.core.content.RelatedContentManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagDiscovery;
import com.biglybt.core.tag.TagException;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableColumnCoreCreationListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.tag.ColumnTagName;
import com.biglybt.ui.swt.columns.tagdiscovery.ColumnTagDiscoveryAddedOn;
import com.biglybt.ui.swt.columns.tagdiscovery.ColumnTagDiscoveryName;
import com.biglybt.ui.swt.columns.tagdiscovery.ColumnTagDiscoveryNetwork;
import com.biglybt.ui.swt.columns.tagdiscovery.ColumnTagDiscoveryTorrent;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectToggle;
import com.biglybt.ui.swt.skin.SWTSkinToggleListener;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.table.TableSelectedRowsListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class SBC_TagDiscovery
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<TagDiscovery>,
TableViewSWTMenuFillListener,
TableSelectionListener,
ViewTitleInfo2 {
    private static final String TABLE_TAGDISCOVERY = "TagDiscoveryView";
    private static final boolean DEBUG = false;
    private static final String CONFIG_FILE = "tag-discovery.config";
    private static final String ID_VITALITY_ACTIVE = "image.sidebar.vitality.dots";
    TableViewSWT<TagDiscovery> tv;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private int scansRemaining = 0;
    private AEMonitor mon_scansRemaining = new AEMonitor("scansRemaining");
    private Map<String, TagDiscovery> mapTagDiscoveries = new HashMap<String, TagDiscovery>();
    private MdiEntry entry;
    private SWTSkinObjectText soTitle;
    private MdiEntryVitalityImage vitalityImage;
    private Map mapConfig;

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        Object[] datasources;
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        if (item.getID().equals("remove") && (datasources = this.tv.getSelectedDataSources().toArray()).length > 0) {
            Object[] objectArray = datasources;
            int n = datasources.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof TagDiscovery) {
                    TagDiscovery tagDiscovery = (TagDiscovery)object;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        list.put("remove", this.tv.getSelectedDataSources().size() > 0 ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_TAGDISCOVERY;
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        MultipleDocumentInterfaceSWT mdi;
        SWTSkinObjectToggle soFilterButton;
        SWTSkinObject soFilterArea;
        this.mapConfig = FileUtil.readResilientConfigFile(CONFIG_FILE);
        this.soTitle = (SWTSkinObjectText)this.getSkinObject("title");
        SWTSkinObjectButton soScanButton = (SWTSkinObjectButton)this.getSkinObject("scan-button");
        if (soScanButton != null) {
            soScanButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_TagDiscovery.this.startScan();
                }
            });
        }
        if ((soFilterArea = this.getSkinObject("filterarea")) != null && (soFilterButton = (SWTSkinObjectToggle)this.getSkinObject("filter-button")) != null) {
            soFilterButton.addSelectionListener(new SWTSkinToggleListener(){

                @Override
                public void toggleChanged(SWTSkinObjectToggle so, boolean toggled) {
                    soFilterArea.setVisible(toggled);
                    Utils.relayout((Control)soFilterArea.getControl().getParent());
                }
            });
        }
        if ((mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null) {
            this.entry = mdi.getEntry("TagDiscovery");
            if (this.entry != null) {
                this.entry.setViewTitleInfo(this);
                this.vitalityImage = this.entry.addVitalityImage(ID_VITALITY_ACTIVE);
                if (this.vitalityImage != null) {
                    this.vitalityImage.setVisible(false);
                }
            }
        }
        this.initColumns();
        return null;
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        int num;
        if (propertyID == 0 && (num = this.mapTagDiscoveries.size()) > 0) {
            return "" + num;
        }
        return null;
    }

    @Override
    public void titleInfoLinked(MultipleDocumentInterface mdi, MdiEntry mdiEntry) {
        this.entry = mdiEntry;
    }

    @Override
    public MdiEntry getLinkedMdiEntry() {
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_TagDiscovery> clazz = SBC_TagDiscovery.class;
        synchronized (SBC_TagDiscovery.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(TagDiscovery.class, ColumnTagDiscoveryName.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDiscoveryName(column);
                }
            });
            tableManager.registerColumn(TagDiscovery.class, ColumnTagDiscoveryTorrent.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDiscoveryTorrent(column);
                }
            });
            tableManager.registerColumn(TagDiscovery.class, ColumnTagDiscoveryAddedOn.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(TagDiscovery.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDiscoveryAddedOn(column);
                }
            });
            tableManager.registerColumn(TagDiscovery.class, ColumnTagDiscoveryNetwork.COLUMN_ID, new TableColumnCreationListener(){

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnTagDiscoveryNetwork(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_TAGDISCOVERY, new String[]{ColumnTagDiscoveryName.COLUMN_ID, ColumnTagDiscoveryTorrent.COLUMN_ID, ColumnTagDiscoveryAddedOn.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_TAGDISCOVERY, ColumnTagDiscoveryAddedOn.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.mapConfig != null) {
            FileUtil.writeResilientConfigFile(CONFIG_FILE, this.mapConfig);
        }
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(this.table_parent);
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        SWTSkinObject so_list = this.getSkinObject("tag-discovery-list");
        if (so_list == null) {
            System.out.println("NO tag-discovery-list");
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        TagDiscovery[] tagDiscoveries = this.mapTagDiscoveries.values().toArray(new TagDiscovery[0]);
        this.tv.addDataSources((TagDiscovery[])tagDiscoveries);
        return null;
    }

    private void startScan() {
        try {
            this.mon_scansRemaining.enter();
            if (this.scansRemaining > 0) {
                return;
            }
        }
        finally {
            this.mon_scansRemaining.exit();
        }
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                GlobalManager gm = core.getGlobalManager();
                try {
                    try {
                        SBC_TagDiscovery.this.mon_scansRemaining.enter();
                        SBC_TagDiscovery.this.scansRemaining = 0;
                    }
                    finally {
                        SBC_TagDiscovery.this.mon_scansRemaining.exit();
                    }
                    RelatedContentManager rcm = RelatedContentManager.getSingleton();
                    List<DownloadManager> dms = gm.getDownloadManagers();
                    for (final DownloadManager dm : dms) {
                        if (SBC_TagDiscovery.this.tv == null) {
                            return;
                        }
                        TOTorrent torrent = dm.getTorrent();
                        if (torrent == null) continue;
                        try {
                            final byte[] hash = torrent.getHash();
                            try {
                                SBC_TagDiscovery.this.mon_scansRemaining.enter();
                                SBC_TagDiscovery sBC_TagDiscovery = SBC_TagDiscovery.this;
                                sBC_TagDiscovery.scansRemaining = sBC_TagDiscovery.scansRemaining + 1;
                                if (SBC_TagDiscovery.this.vitalityImage != null && SBC_TagDiscovery.this.scansRemaining == 1) {
                                    SBC_TagDiscovery.this.vitalityImage.setVisible(true);
                                }
                                if (SBC_TagDiscovery.this.soTitle != null) {
                                    SBC_TagDiscovery.this.soTitle.setText(String.valueOf(MessageText.getString("tag.discovery.view.heading")) + " : Scanning " + SBC_TagDiscovery.this.scansRemaining);
                                }
                            }
                            finally {
                                SBC_TagDiscovery.this.mon_scansRemaining.exit();
                            }
                            try {
                                rcm.lookupAttributes(hash, dm.getDownloadState().getNetworks(), new RelatedAttributeLookupListener(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void tagFound(String tag, String network) {
                                        if ((this).SBC_TagDiscovery.this.tv == null) {
                                            return;
                                        }
                                        if (TagUtils.isInternalTagName(tag)) {
                                            return;
                                        }
                                        String key = String.valueOf(Base32.encode(hash)) + tag;
                                        TagManager tm = TagManagerFactory.getTagManager();
                                        TagType tt_manual = tm.getTagType(3);
                                        List<Tag> existingDMTags = tt_manual.getTagsForTaggable(dm);
                                        for (Tag existingTag : existingDMTags) {
                                            if (!existingTag.getTagName(true).equalsIgnoreCase(tag)) continue;
                                            return;
                                        }
                                        Map map = SBC_TagDiscovery.this.mapTagDiscoveries;
                                        synchronized (map) {
                                            if (!SBC_TagDiscovery.this.mapTagDiscoveries.containsKey(key)) {
                                                TagDiscovery tagDiscovery = new TagDiscovery(tag, network, dm.getDisplayName(), hash);
                                                SBC_TagDiscovery.this.mapTagDiscoveries.put(key, tagDiscovery);
                                                ViewTitleInfoManager.refreshTitleInfo(SBC_TagDiscovery.this);
                                                (this).SBC_TagDiscovery.this.tv.addDataSource(tagDiscovery);
                                            }
                                        }
                                    }

                                    @Override
                                    public void lookupStart() {
                                    }

                                    @Override
                                    public void lookupFailed(ContentException error) {
                                    }

                                    @Override
                                    public void lookupComplete() {
                                        SBC_TagDiscovery.this.decreaseScansRemaining();
                                    }
                                });
                            }
                            catch (Throwable e) {
                                SBC_TagDiscovery.this.decreaseScansRemaining();
                            }
                        }
                        catch (TOTorrentException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (ContentException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void decreaseScansRemaining() {
        try {
            this.mon_scansRemaining.enter();
            --this.scansRemaining;
            if (this.soTitle != null) {
                if (this.scansRemaining <= 0) {
                    this.soTitle.setTextID("tag.discovery.view.heading");
                } else {
                    this.soTitle.setText(String.valueOf(MessageText.getString("tag.discovery.view.heading")) + " : Scanning " + this.scansRemaining);
                }
            }
            if (this.vitalityImage != null && this.scansRemaining <= 0) {
                this.vitalityImage.setVisible(false);
            }
        }
        finally {
            this.mon_scansRemaining.exit();
        }
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(TagDiscovery.class, TABLE_TAGDISCOVERY, TABLE_TAGDISCOVERY, new TableColumnCore[0], ColumnTagName.COLUMN_ID, 0x10010002);
            SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
            if (soFilter != null) {
                BubbleTextBox filter2 = soFilter.getBubbleTextBox();
                this.tv.enableFilterCheck(filter2, (TableViewFilterCheck<TagDiscovery>)this);
                filter2.setMessage(MessageText.getString("Button.search2"));
            }
            this.tv.setRowDefaultHeightEM(1.0f);
            this.table_parent = Utils.createSkinnedComposite(control, 2048, Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout((Layout)layout);
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.initialize(this.table_parent);
        }
        control.layout(true);
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        MenuItem menuTagIt = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)menuTagIt, "TagDiscoveriesView.menu.tagit");
        menuTagIt.addListener(13, (Listener)new TableSelectedRowsListener(this.tv){

            @Override
            public void run(TableRowCore row) {
                TagDiscovery tagDiscovery = (TagDiscovery)row.getDataSource(true);
                TagManager tm = TagManagerFactory.getTagManager();
                TagType manual_tt = tm.getTagType(3);
                Tag tag = manual_tt.getTag(tagDiscovery.getName(), true);
                if (tag == null) {
                    try {
                        tag = manual_tt.createTag(tagDiscovery.getName(), true);
                        tag.setPublic(true);
                        tag.setGroup("Discovery");
                        tag.setVisible(true);
                    }
                    catch (TagException e) {
                        return;
                    }
                }
                byte[] hash = tagDiscovery.getHash();
                DownloadManager dm = CoreFactory.getSingleton().getGlobalManager().getDownloadManager(new HashWrapper(hash));
                tag.addTaggable(dm);
                String key = String.valueOf(Base32.encode(hash)) + tag.getTagName(true);
                SBC_TagDiscovery.this.mapTagDiscoveries.remove(key);
                SBC_TagDiscovery.this.tv.removeDataSource(tagDiscovery);
                ViewTitleInfoManager.refreshTitleInfo(SBC_TagDiscovery.this);
            }
        });
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
    }

    @Override
    public void selected(TableRowCore[] row) {
    }

    @Override
    public void deselected(TableRowCore[] rows) {
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        Object obj;
        if (rows.length == 1 && (obj = rows[0].getDataSource()) instanceof TagDiscovery) {
            TagDiscovery tagDiscovery = (TagDiscovery)obj;
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public boolean filterCheck(TagDiscovery ds, String filter2, boolean regex, boolean confusable) {
        if (confusable) {
            return false;
        }
        String[] names = new String[]{ds.getName(), ds.getTorrentName()};
        String s = regex ? filter2 : RegExUtil.splitAndQuote(filter2, "\\s*[|;]\\s*");
        boolean match_result = true;
        if (regex && s.startsWith("!")) {
            s = s.substring(1);
            match_result = false;
        }
        Pattern pattern = RegExUtil.getCachedPattern("tagsoverview:search", s, 66);
        boolean bOurs = !match_result;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (pattern.matcher(name).find()) {
                bOurs = match_result;
                break;
            }
            ++n2;
        }
        return bOurs;
    }
}

