/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener2;
import com.biglybt.ui.mdi.MdiEntryDatasourceListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateTab;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MdiSWTMenuHackListener;
import com.biglybt.ui.swt.mdi.TabbedMDI;
import com.biglybt.ui.swt.mdi.TabbedMdiInterface;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectTabFolder;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.views.MyTorrentsView;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.util.DataSourceUtils;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;

public class SBC_TorrentDetailsView
extends SkinView
implements DownloadManagerListener,
UIPluginViewToolBarListener,
SelectedContentListener {
    private static final String VIEW_ID = "TorrentDetailsView";
    private DownloadManager manager;
    private TabbedMdiInterface tabbedMDI;
    private Object dataSource;

    private void dataSourceChanged(Object newDataSource) {
        this.dataSource = newDataSource;
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        this.manager = DataSourceUtils.getDM(newDataSource);
        if (this.tabbedMDI != null && newDataSource instanceof Object[] && ((Object[])newDataSource)[0] instanceof PEPeer) {
            this.tabbedMDI.showEntryByID("PeersView");
        }
        if (this.manager != null) {
            this.manager.addListener(this);
        }
        if (this.tabbedMDI != null) {
            this.tabbedMDI.setEntriesDataSource(this.manager);
        }
    }

    private void delete() {
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        SelectedContentManager.removeCurrentlySelectedContentListener(this);
    }

    private void initialize(SWTSkinObjectTabFolder soTabFolder) {
        MyTorrentsView.registerPluginViews();
        if (this.tabbedMDI == null) {
            this.tabbedMDI = new TabbedMDI(Download.class, VIEW_ID, "detailsview", this.getMdiEntry(), this.manager == null ? this.dataSource : this.manager);
            this.tabbedMDI.buildMDI(soTabFolder);
        } else {
            System.out.println("ManagerView::initialize : folder isn't null !!!");
        }
        SelectedContentManager.addCurrentlySelectedContentListener(this);
        this.tabbedMDI.addListener(new MdiSWTMenuHackListener(){

            @Override
            public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                menuTree.setData("downloads", (Object)new DownloadManager[]{SBC_TorrentDetailsView.this.manager});
                menuTree.setData("is_detailed_view", (Object)true);
                MenuFactory.buildTorrentMenu(menuTree);
            }
        });
        if (this.dataSource instanceof Object[] && ((Object[])this.dataSource)[0] instanceof PEPeer) {
            this.tabbedMDI.showEntryByID("PeersView");
        }
    }

    @Override
    public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewId) {
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        BaseMdiEntry activeView = this.getActiveView();
        if (activeView == null) {
            return;
        }
        activeView.refreshToolBarItems(list);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        BaseMdiEntry activeView = this.getActiveView();
        if (activeView == null) {
            return false;
        }
        return activeView.toolBarItemActivated(item, activationType, datasource);
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    @Override
    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
        if (this.tabbedMDI == null || this.tabbedMDI.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        });
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public DownloadManager getDownload() {
        return this.manager;
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SWTSkinObject soListArea = this.getSkinObject("torrentdetails-list-area");
        if (!(soListArea instanceof SWTSkinObjectTabFolder)) {
            return null;
        }
        this.initialize((SWTSkinObjectTabFolder)soListArea);
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.delete();
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        this.dataSourceChanged(params);
        return null;
    }

    private BaseMdiEntry getActiveView() {
        if (this.tabbedMDI == null || this.tabbedMDI.isDisposed()) {
            return null;
        }
        return (BaseMdiEntry)this.tabbedMDI.getSelectedEntry();
    }

    public static class TorrentDetailMdiEntry
    implements MdiSWTMenuHackListener,
    MdiCloseListener,
    MdiEntryDatasourceListener,
    UIUpdatable,
    ViewTitleInfo,
    ObfuscateTab {
        int lastCompleted = -1;
        protected GlobalManagerAdapter gmListener;
        private BaseMdiEntry entry;

        public static void register(MultipleDocumentInterface mdi) {
            mdi.registerEntry("DMDetails.*", new MdiEntryCreationListener2(){

                @Override
                public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map<?, ?> params) {
                    String hash = DataSourceUtils.getHash(datasource);
                    if (hash != null) {
                        id = "DMDetails_" + hash;
                    }
                    return new TorrentDetailMdiEntry().createTorrentDetailEntry(mdi, id, datasource);
                }
            });
        }

        public MdiEntry createTorrentDetailEntry(final MultipleDocumentInterface mdi, String id, Object ds) {
            if (ds == null) {
                return null;
            }
            this.entry = (BaseMdiEntry)mdi.getEntry(id);
            if (this.entry == null) {
                this.entry = (BaseMdiEntry)mdi.createEntryFromSkinRef("header.transfers", id, "torrentdetails", "", null, ds, true, null);
                this.entry.addListeners(this);
                this.entry.setViewTitleInfo(this);
                CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                        gmListener = new GlobalManagerAdapter(){

                            @Override
                            public void downloadManagerRemoved(DownloadManager dm) {
                                Object ds = entry.getDatasourceCore();
                                DownloadManager manager = DataSourceUtils.getDM(ds);
                                if (dm.equals(manager)) {
                                    mdi.closeEntry(entry, false);
                                } else if (manager == null) {
                                    try {
                                        String ds_hash = DataSourceUtils.getHash(ds);
                                        String dm_hash = Base32.encode(dm.getTorrent().getHash());
                                        if (ds_hash.equals(dm_hash)) {
                                            mdi.closeEntry(entry, false);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                        };
                        gm.addListener(gmListener, false);
                    }
                });
                UIUpdater updater = UIUpdaterSWT.getInstance();
                if (updater != null) {
                    updater.addUpdater(this);
                }
            }
            return this.entry;
        }

        @Override
        public Object getTitleInfoProperty(int propertyID) {
            Object ds = this.entry.getDatasourceCore();
            if (propertyID == 10) {
                return DataSourceUtils.getHash(ds);
            }
            if (propertyID == 2) {
                return "image.sidebar.details";
            }
            DownloadManager manager = DataSourceUtils.getDM(ds);
            if (manager == null) {
                return null;
            }
            if (propertyID == 5) {
                return manager.getDisplayName();
            }
            if (propertyID == 0) {
                int completed = manager.getStats().getPercentDoneExcludingDND();
                if (completed != 1000) {
                    return String.valueOf(completed / 10) + "%";
                }
            } else if (propertyID == 1) {
                String eta;
                String s = "";
                int completed = manager.getStats().getPercentDoneExcludingDND();
                if (completed != 1000) {
                    s = String.valueOf(completed / 10) + "% Complete\n";
                }
                if ((eta = DisplayFormatters.formatETA(manager.getStats().getSmoothedETA())).length() > 0) {
                    s = String.valueOf(s) + MessageText.getString("TableColumn.header.eta") + ": " + eta + "\n";
                }
                return String.valueOf(manager.getDisplayName()) + (s.length() == 0 ? "" : ": " + s);
            }
            return null;
        }

        @Override
        public void updateUI() {
            int completed;
            DownloadManager manager = DataSourceUtils.getDM(this.entry.getDatasourceCore());
            int n = completed = manager == null ? -1 : manager.getStats().getPercentDoneExcludingDND();
            if (this.lastCompleted != completed) {
                ViewTitleInfoManager.refreshTitleInfo(this);
                if (this.entry != null) {
                    this.entry.redraw();
                }
                this.lastCompleted = completed;
            }
        }

        @Override
        public String getUpdateUIName() {
            return this.entry == null ? "DMD" : this.entry.getViewID();
        }

        @Override
        public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
            UIUpdater updater = UIUpdaterSWT.getInstance();
            if (updater != null) {
                updater.removeUpdater(this);
            }
            try {
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                gm.removeListener(this.gmListener);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }

        @Override
        public void mdiEntryDatasourceChanged(final MdiEntry entry) {
            Object newDataSource = ((BaseMdiEntry)entry).getDatasourceCore();
            if (newDataSource instanceof String) {
                final String s = (String)newDataSource;
                if (!CoreFactory.isCoreRunning()) {
                    CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                        @Override
                        public void coreRunning(Core core) {
                            entry.setDatasource(DataSourceUtils.getDM(s));
                        }
                    });
                }
            }
            ViewTitleInfoManager.refreshTitleInfo(this);
        }

        @Override
        public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
            TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
            menuTree.setData("TableView", (Object)tv);
            DownloadManager manager = DataSourceUtils.getDM(((BaseMdiEntry)entry).getDatasourceCore());
            if (manager != null) {
                menuTree.setData("downloads", (Object)new DownloadManager[]{manager});
            }
            menuTree.setData("is_detailed_view", (Object)Boolean.TRUE);
            MenuFactory.buildTorrentMenu(menuTree);
        }

        @Override
        public String getObfuscatedHeader() {
            Object ds = this.entry.getDatasourceCore();
            DownloadManager manager = DataSourceUtils.getDM(ds);
            if (manager == null) {
                return null;
            }
            int completed = manager.getStats().getCompleted();
            return String.valueOf(DisplayFormatters.formatPercentFromThousands(completed)) + " : " + manager.toString().replaceFirst("DownloadManagerImpl", "DM");
        }
    }
}

