/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoListener;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.mdi.MdiEntryVitalityImageListener;
import com.biglybt.ui.mdi.MdiListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.shells.main.MainMDISetup;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinUtils;
import com.biglybt.ui.swt.views.IViewAlwaysInitialize;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.skin.SkinViewManager;
import com.biglybt.ui.swt.views.skin.SkinnedComposite;
import com.biglybt.ui.swt.views.skin.sidebar.SideBar;
import com.biglybt.ui.swt.widgets.TabFolderRenderer;
import com.biglybt.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SB_Dashboard {
    private static final String[][] examples = new String[][]{{"dashboard.example.1", "d5:itemsld4:_uidi173e12:control_typei0e2:id7:Library3:mdi7:sidebar9:parent_id16:header.transfers7:skin_id25:com.biglybt.ui.skin.skin38:skin_ref7:library5:title7:Library8:title_id15:sidebar.Libraryed4:_uidi175e12:control_typei0e11:data_source17:TransferStatsView14:event_listenerd4:name43:com.biglybt.ui.swt.views.stats.ActivityViewe2:id9:SpeedView3:mdi6:tabbed7:skin_id25:com.biglybt.ui.skin.skin35:title8:Activity8:title_id20:SpeedView.title.fulled4:_uidi177e12:control_typei0e14:event_listenerd4:name56:com.aelitis.azureus.plugins.view3d.Plugin3D$ViewListener9:plugin_id6:3dview11:plugin_name7:3D Viewe2:id23:view3d.most.active.name3:mdi7:sidebar9:parent_id14:header.plugins7:skin_id25:com.biglybt.ui.skin.skin35:title21:3D View (Most Active)8:title_id23:view3d.most.active.nameee6:layout35:173,173,177;173,173,177;175,175,1758:use_tabsi0e7:weights15:686,309;678,321e"}, {"dashboard.example.2", "d5:itemsld4:_uidi178e12:control_typei0e2:id7:Library3:mdi7:sidebar9:parent_id16:header.transfers7:skin_id25:com.biglybt.ui.skin.skin38:skin_ref7:library5:title7:Library8:title_id15:sidebar.Libraryed4:_uidi181e12:control_typei0e11:data_sourced6:exportd4:anoni1e4:h_cmi1e5:h_dlnl3:I2Pe2:id16:UHQOFCLPP5YEIFRO7:versioni2e2:voi1ee8:exporter50:com.biglybt.core.subs.impl.SubscriptionManagerImple14:event_listenerd4:name49:com.biglybt.ui.swt.subscriptions.SubscriptionViewe2:id111:Subscription_042F84BA33D7C69F5F0BBDF56771D065E56ECE405EF157C8B14389477F6260F62062DFBF5EC5FA2E4904AC0C361F8243923:mdi7:sidebar9:parent_id13:Subscriptions7:skin_id25:com.biglybt.ui.skin.skin35:title23:Anon - Shares: Receiveded4:_uidi182e12:control_typei0e11:data_sourced6:exportd2:dn12:Shares: Sent3:key27:Dashboard: Anonymous Shares7:network3:I2P2:vti2ee8:exporter44:com.biglybt.plugin.net.buddy.BuddyPluginBetae14:event_listenerd4:name41:com.biglybt.plugin.net.buddy.swt.ChatViewe2:id53:Chat_I2P:IRQXG2DCN5QXEZB2EBAW433OPFWW65LTEBJWQYLSMVZQ3:mdi7:sidebar9:parent_id12:ChatOverview7:skin_id25:com.biglybt.ui.skin.skin35:title19:Anon - Shares: Sentee6:layout35:178,182,182;178,181,181;178,181,1818:use_tabsi0e7:weights15:713,284;200,200e"}, {"dashboard.example.3", "d5:itemsld4:_uidi183e12:control_typei0e2:id7:Library3:mdi7:sidebar9:parent_id16:header.transfers7:skin_id25:com.biglybt.ui.skin.skin38:skin_ref7:library5:title7:Library8:title_id15:sidebar.Libraryed4:_uidi184e12:control_typei0e14:event_listenerd4:name39:com.biglybt.ui.swt.views.PeersSuperViewe2:id12:AllPeersView3:mdi7:sidebar9:parent_id16:header.transfers7:skin_id25:com.biglybt.ui.skin.skin35:title9:All Peers8:title_id23:AllPeersView.title.fulled4:_uidi185e12:control_typei0e2:id8:Activity3:mdi7:sidebar9:parent_id11:header.vuze7:skin_id25:com.biglybt.ui.skin.skin38:skin_ref8:activity5:title13:Notifications8:title_id16:sidebar.Activityed4:_uidi192e12:control_typei0e2:id12:ChatOverview3:mdi7:sidebar9:parent_id16:header.discovery7:skin_id25:com.biglybt.ui.skin.skin38:skin_ref9:chatsview5:title13:Chat Overview8:title_id18:chats.view.headinged4:_uidi193e12:control_typei0e2:id14:RelatedContent3:mdi7:sidebar9:parent_id16:header.discovery7:skin_id25:com.biglybt.ui.skin.skin38:skin_ref7:rcmview5:title17:Swarm Discoveries8:title_id25:RelatedContent.title.fulled4:_uidi194e12:control_typei0e14:event_listenerd4:name35:com.biglybt.ui.swt.views.ConfigViewe2:id10:ConfigView3:mdi7:sidebar9:parent_id14:header.plugins7:skin_id25:com.biglybt.ui.skin.skin35:title7:Options8:title_id21:ConfigView.title.fulled4:_uidi195e12:control_typei0e14:event_listenerd4:name40:com.biglybt.ui.swt.views.stats.StatsViewe2:id9:StatsView3:mdi7:sidebar9:parent_id14:header.plugins7:skin_id25:com.biglybt.ui.skin.skin35:title10:Statistics8:title_id16:Stats.title.fullee6:layout195:183,184,185,192,193,194,195;183,184,185,192,193,194,195;183,184,185,192,193,194,195;183,184,185,192,193,194,195;183,184,185,192,193,194,195;183,184,185,192,193,194,195;183,184,185,192,193,194,1958:use_tabsi1e7:weights0:e"}};
    private DashboardInstance main_dashboard = new DashboardInstance();
    private DashboardInstance sidebar_dashboard = new DashboardInstance("sidebar", true);
    private DashboardInstance rightbar_dashboard = new DashboardInstance("rightbarzzzzz", true);
    private DashboardInstance topbar_dashboard = new DashboardInstance("topbar", true);
    private final MultipleDocumentInterfaceSWT mdi;
    private final boolean bigly_ui;
    private MdiEntry mdi_entry;

    public SB_Dashboard(MultipleDocumentInterfaceSWT _mdi, boolean _bigly_ui) {
        this.mdi = _mdi;
        this.bigly_ui = _bigly_ui;
        if (this.bigly_ui) {
            this.main_dashboard.readConfig();
            if (!COConfigurationManager.getBooleanParameter("dashboard.init.0", false)) {
                COConfigurationManager.setParameter("dashboard.init.0", true);
                this.main_dashboard.startOfDay();
            }
            this.sidebar_dashboard.readConfig();
            this.rightbar_dashboard.readConfig();
        }
        this.topbar_dashboard.readConfig();
        if (!COConfigurationManager.getBooleanParameter("dashboard.init.1", false)) {
            COConfigurationManager.setParameter("dashboard.init.1", true);
            this.addTopbarStartupItems(false);
        } else if (!this.bigly_ui) {
            this.addTopbarStartupItems(true);
        }
        if (this.bigly_ui) {
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            UIManager uim = pi.getUIManager();
            final MenuManager menuManager = uim.getMenuManager();
            com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar.header.dashboard", "menu.add.website");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("enter.url", "enter.website");
                    entryWindow.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver receiver) {
                            if (!receiver.hasSubmittedInput()) {
                                return;
                            }
                            String key = receiver.getSubmittedInput().trim();
                            if (!key.isEmpty()) {
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                map.put("mdi", "sidebar");
                                map.put("skin_id", "com.biglybt.ui.skin.skin3");
                                map.put("parent_id", "header.dashboard");
                                map.put("skin_ref", "main.generic.browse");
                                map.put("id", "Browser: " + key);
                                map.put("title", key);
                                map.put("data_source", key);
                                map.put("control_type", 0L);
                                SB_Dashboard.this.main_dashboard.addItem(map);
                                SB_Dashboard.this.main_dashboard.fireChanged();
                            }
                        }
                    });
                }
            });
            menuItem = menuManager.addMenuItem("sidebar.header.dashboard", "sep0");
            menuItem.setStyle(4);
            menuItem.setDisposeWithUIDetach("swt");
            final com.biglybt.pif.ui.menus.MenuItem menuExamples = menuManager.addMenuItem("sidebar.header.dashboard", "label.examples");
            menuExamples.setDisposeWithUIDetach("swt");
            menuExamples.setStyle(5);
            menuExamples.addFillListener(new MenuItemFillListener(){

                @Override
                public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object _target) {
                    menu.removeAllChildItems();
                    String[][] stringArray = examples;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String[] entry = stringArray[n2];
                        com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem(menuExamples, entry[0]);
                        menuItem.setDisposeWithUIDetach("swt");
                        menuItem.addListener(new MenuItemListener(){

                            @Override
                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                SB_Dashboard.this.main_dashboard.importDashboard(entry[1], false);
                                SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                                if (sidebar != null && sidebar.isVisible()) {
                                    sidebar.flipSideBarVisibility();
                                }
                            }
                        });
                        ++n2;
                    }
                }
            });
            menuItem = menuManager.addMenuItem("sidebar.header.dashboard", "menu.export.to.clip");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    String data = SB_Dashboard.this.main_dashboard.exportDashboard();
                    Clipboard cb = new Clipboard(Utils.getDisplay());
                    try {
                        cb.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
                    }
                    finally {
                        cb.dispose();
                    }
                }
            });
            menuItem = menuManager.addMenuItem("sidebar.header.dashboard", "menu.import.from.clip");
            menuItem.setDisposeWithUIDetach("swt");
            menuItem.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    Clipboard cb = new Clipboard(Utils.getDisplay());
                    try {
                        TextTransfer transfer = TextTransfer.getInstance();
                        String data = (String)cb.getContents((Transfer)transfer);
                        if (data != null && !data.isEmpty()) {
                            SB_Dashboard.this.main_dashboard.importDashboard(data, true);
                        }
                    }
                    finally {
                        cb.dispose();
                    }
                }
            });
            menuItem = menuManager.addMenuItem("sidebar.header.dashboard", "sep1");
            menuItem.setStyle(4);
            menuItem.setDisposeWithUIDetach("swt");
            com.biglybt.pif.ui.menus.MenuItem resetItem = menuManager.addMenuItem("sidebar.header.dashboard", "Button.reset");
            resetItem.setDisposeWithUIDetach("swt");
            resetItem.setStyle(5);
            com.biglybt.pif.ui.menus.MenuItem resetDashsboard = menuManager.addMenuItem(resetItem, "sidebar.header.dashboard");
            resetDashsboard.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    SB_Dashboard.this.main_dashboard.reset();
                }
            });
            com.biglybt.pif.ui.menus.MenuItem resetTopbar = menuManager.addMenuItem(resetItem, "label.topbar");
            resetTopbar.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    SB_Dashboard.this.addTopbarStartupItems(false);
                }
            });
            com.biglybt.pif.ui.menus.MenuItem resetSidebar = menuManager.addMenuItem(resetItem, "label.sidebar");
            resetSidebar.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    SB_Dashboard.this.sidebar_dashboard.clear();
                }
            });
            com.biglybt.pif.ui.menus.MenuItem resetRightbar = menuManager.addMenuItem(resetItem, "label.rightbar");
            resetRightbar.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    SB_Dashboard.this.rightbar_dashboard.clear();
                }
            });
            menuItem = menuManager.addMenuItem("sidebar.header.dashboard", "sep2");
            menuItem.setStyle(4);
            menuItem.setDisposeWithUIDetach("swt");
            this.sidebar_dashboard.addAndFireListener(new DashboardListener(){
                private final String VIEW_ID = "SideBarDashboard";
                private boolean registered;

                @Override
                public void itemsChanged() {
                    ViewManagerSWT vi = ViewManagerSWT.getInstance();
                    if (SB_Dashboard.this.sidebar_dashboard.getItemCount() > 0) {
                        if (!this.registered) {
                            vi.registerView("SideBarArea", new UISWTViewBuilderCore("SideBarDashboard", null, SideBarDashboard.class));
                            this.registered = true;
                        }
                    } else if (this.registered) {
                        vi.unregisterView("SideBarArea", "SideBarDashboard");
                        this.registered = false;
                    }
                }
            });
            this.rightbar_dashboard.addAndFireListener(new DashboardListener(){
                private final String VIEW_ID = "RightBarDashboard";
                private boolean first_time = true;
                private boolean registered;

                @Override
                public void itemsChanged() {
                    SWTSkin skin = SWTSkinFactory.getInstance();
                    ViewManagerSWT vi = ViewManagerSWT.getInstance();
                    if (SB_Dashboard.this.rightbar_dashboard.getItemCount() > 0) {
                        if (!this.registered) {
                            vi.registerView("RightBarArea", new UISWTViewBuilderCore("RightBarDashboard", null, RightBarDashboard.class));
                            this.registered = true;
                        }
                        if (!this.first_time) {
                            SWTSkinUtils.setVisibility(skin, "rightbar.visible", "rightbar", true, true);
                        }
                    } else {
                        if (this.registered) {
                            vi.unregisterView("RightBarArea", "RightBarDashboard");
                            this.registered = false;
                        }
                        SWTSkinUtils.setVisibility(skin, "rightbar.visible", "rightbar", false, true);
                    }
                    this.first_time = false;
                }
            });
        }
        this.topbar_dashboard.addAndFireListener(new DashboardListener(){
            private final String VIEW_ID = "TopBarDashboard";
            private boolean first_time = true;
            private boolean registered;

            @Override
            public void itemsChanged() {
                SWTSkin skin = SWTSkinFactory.getInstance();
                ViewManagerSWT vi = ViewManagerSWT.getInstance();
                if (SB_Dashboard.this.topbar_dashboard.getItemCount() > 0) {
                    if (!this.registered) {
                        vi.registerView("TopBar", new UISWTViewBuilderCore("TopBarDashboard", null, TopBarDashboard.class));
                        this.registered = true;
                    }
                    if (!this.first_time) {
                        SWTSkinUtils.setVisibility(skin, "pluginbar.visible", "pluginbar", true, true);
                    }
                } else {
                    if (this.registered) {
                        vi.unregisterView("TopBar", "TopBarDashboard");
                        this.registered = false;
                    }
                    SWTSkinUtils.setVisibility(skin, "pluginbar.visible", "pluginbar", false, true);
                }
                this.first_time = false;
            }
        });
        ViewTitleInfoManager.addListener(new ViewTitleInfoListener(){

            @Override
            public void viewTitleInfoRefresh(ViewTitleInfo titleInfo) {
                if (SB_Dashboard.this.bigly_ui) {
                    SB_Dashboard.this.main_dashboard.refresh(titleInfo);
                    SB_Dashboard.this.sidebar_dashboard.refresh(titleInfo);
                    SB_Dashboard.this.rightbar_dashboard.refresh(titleInfo);
                }
                SB_Dashboard.this.topbar_dashboard.refresh(titleInfo);
            }
        });
        MessageText.addListener((l1, l2) -> {
            if (this.bigly_ui) {
                this.main_dashboard.updateLocale();
                this.sidebar_dashboard.updateLocale();
                this.rightbar_dashboard.updateLocale();
            }
            this.topbar_dashboard.updateLocale();
        });
    }

    public void addItem(BaseMdiEntry entry) {
        Map<String, Object> map = entry.exportStandAlone();
        this.main_dashboard.addItem(map);
        this.main_dashboard.fireChanged();
    }

    public void build(Composite comp2) {
        this.main_dashboard.build(comp2);
    }

    public void addItemToSidebar(BaseMdiEntry entry) {
        Map<String, Object> map = entry.exportStandAlone();
        this.sidebar_dashboard.addItem(map);
        this.sidebar_dashboard.fireChanged();
    }

    public DashboardInstance getSidebarDashboard() {
        return this.sidebar_dashboard;
    }

    public void addItemToRightbar(BaseMdiEntry entry) {
        Map<String, Object> map = entry.exportStandAlone();
        this.rightbar_dashboard.addItem(map);
        this.rightbar_dashboard.fireChanged();
    }

    public DashboardInstance getRightbarDashboard() {
        return this.rightbar_dashboard;
    }

    public void addItemToTopbar(BaseMdiEntry entry) {
        Map<String, Object> map = entry.exportStandAlone();
        this.topbar_dashboard.addItem(map);
        this.topbar_dashboard.fireChanged();
    }

    public DashboardInstance getTopbarDashboard() {
        return this.topbar_dashboard;
    }

    private void addTopbarStartupItems(boolean only_if_all_invisible) {
        if (only_if_all_invisible) {
            int[][] layout = this.topbar_dashboard.getDashboardLayout();
            for (DashboardInstance.DashboardItem item : this.topbar_dashboard.getItems()) {
                if (!this.topbar_dashboard.isUIDInLayout(layout, item.getUID())) continue;
                return;
            }
        }
        this.topbar_dashboard.clear();
        String[][] data = new String[][]{{"!TableColumn.header.downspeed!", "com.biglybt.ui.swt.views.ViewDownSpeedGraph"}, {"!TableColumn.header.upspeed!", "com.biglybt.ui.swt.views.ViewUpSpeedGraph"}, {"!label.quick.config!", "com.biglybt.ui.swt.views.ViewQuickConfig"}, {"!label.quick.net.info!", "com.biglybt.ui.swt.views.ViewQuickNetInfo"}, {"!label.quick.notifications!", "com.biglybt.ui.swt.views.ViewQuickNotifications"}};
        ArrayList items = new ArrayList();
        String[][] stringArrayArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String[] entry = stringArrayArray[n2];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skin_id", "com.biglybt.ui.skin.skin3");
            map.put("title", entry[0]);
            map.put("control_type", 0L);
            HashMap<String, String> listener = new HashMap<String, String>();
            listener.put("name", entry[1]);
            map.put("event_listener", listener);
            items.add(map);
            ++n2;
        }
        this.topbar_dashboard.addItems(items);
        this.topbar_dashboard.fireChanged();
    }

    public void dispose() {
    }

    public MdiEntry setupMDIEntry() {
        ViewTitleInfo title_info = new ViewTitleInfo(){

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    return String.valueOf(SB_Dashboard.this.main_dashboard.getItemCount());
                }
                if (propertyID == 1) {
                    return null;
                }
                return null;
            }
        };
        this.mdi_entry = this.mdi.createEntryFromSkinRef("", "header.dashboard", "dashboard", "{sidebar.header.dashboard}", title_info, null, false, null);
        this.mdi_entry.setImageLeftID("image.sidebar.dashboard");
        MdiEntryVitalityImage cog = this.mdi_entry.addVitalityImage("image.sidebar.cog");
        cog.setToolTip(MessageText.getString("configure.dashboard"));
        final long[] cog_click_time = new long[1];
        cog.addListener(new MdiEntryVitalityImageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mdiEntryVitalityImage_clicked(int x, int y) {
                long[] lArray = cog_click_time;
                synchronized (cog_click_time) {
                    cog_click_time[0] = SystemTime.getMonotonousTime();
                    SB_Dashboard.this.main_dashboard.showConfig();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        });
        cog.setVisible(true);
        this.mdi.addListener(new MdiListener(){

            @Override
            public void mdiEntrySelected(MdiEntry newEntry, MdiEntry oldEntry) {
                if (SB_Dashboard.this.mdi_entry == newEntry && SB_Dashboard.this.mdi_entry == oldEntry) {
                    SimpleTimer.addEvent("changed", SystemTime.getOffsetTime(250L), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            long[] lArray = cog_click_time;
                            synchronized (cog_click_time) {
                                if (SystemTime.getMonotonousTime() - cog_click_time[0] < 250L) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return;
                                }
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                SB_Dashboard.this.main_dashboard.fireChanged();
                                return;
                            }
                        }
                    });
                }
            }

            @Override
            public void mdiDisposed(MultipleDocumentInterface mdi) {
            }
        });
        return this.mdi_entry;
    }

    public void addListener(DashboardListener l) {
        this.main_dashboard.addListener(l);
    }

    public void removeListener(DashboardListener l) {
        this.main_dashboard.removeListener(l);
    }

    private class DashboardInstance {
        private final String config_prefix;
        private final boolean use_tabs_default;
        Composite main_composite;
        private CopyOnWriteList<DashboardItem> items = new CopyOnWriteList();
        private boolean config_dirty;
        private CopyOnWriteList<DashboardListener> listeners = new CopyOnWriteList();
        private volatile boolean config_active;
        private int building = 0;

        private DashboardInstance() {
            this.config_prefix = "dashboard";
            this.use_tabs_default = false;
        }

        private DashboardInstance(String _id, boolean _use_tabs_default) {
            this.config_prefix = "dashboard." + _id;
            this.use_tabs_default = _use_tabs_default;
        }

        private void startOfDay() {
            if (this.items.isEmpty()) {
                this.addStartupItem();
                this.writeConfig();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                this.items.clear();
                COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".layout", "");
                this.addStartupItem();
            }
            this.fireChanged();
        }

        private void addListener(DashboardListener l) {
            this.listeners.add(l);
        }

        private void addAndFireListener(DashboardListener l) {
            this.listeners.add(l);
            l.itemsChanged();
        }

        private void removeListener(DashboardListener l) {
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readConfig() {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                Map config = COConfigurationManager.getMapParameter(String.valueOf(this.config_prefix) + ".config", new HashMap());
                config = BDecoder.decodeStrings(BEncoder.cloneMap(config));
                List item_list = (List)config.get("items");
                if (item_list != null) {
                    for (Map map : item_list) {
                        if ("https://github.com/BiglySoftware/BiglyBT/wiki/Dashboard".equals(MapUtils.getMapString(map, "data_source", ""))) {
                            map.put("data_source", "https://wiki.biglybt.com/w/Dashboard");
                        }
                        DashboardItem item = new DashboardItem(map);
                        this.items.add(item);
                    }
                }
                if (this.config_dirty) {
                    this.writeConfig();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void configDirty() {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                this.config_dirty = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeConfig() {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                this.config_dirty = false;
                HashMap config = new HashMap();
                ArrayList<Object> item_list = new ArrayList<Object>(this.items.size());
                config.put("items", item_list);
                for (DashboardItem item : this.items) {
                    item_list.add(BEncoder.clone(item.getState()));
                }
                COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".config", config);
                COConfigurationManager.setDirty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String exportDashboard() {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ArrayList<Map<String, Object>> l_items = new ArrayList<Map<String, Object>>();
                for (DashboardItem item : this.items) {
                    l_items.add(item.getState());
                }
                map.put("items", l_items);
                String layout_str = COConfigurationManager.getStringParameter(String.valueOf(this.config_prefix) + ".layout");
                layout_str = this.encodeIAA(this.compactLayout(this.decodeIAA(layout_str), this.items.size()));
                map.put("layout", layout_str);
                map.put("weights", COConfigurationManager.getStringParameter(String.valueOf(this.config_prefix) + ".sash.weights"));
                map.put("use_tabs", new Long(this.getUseTabs() ? 1 : 0));
                try {
                    System.out.println(new String(BEncoder.encode(map), "UTF-8"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return BEncoder.encodeToJSON(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void importDashboard(String data, boolean is_json) {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                try {
                    Map map = BDecoder.decodeStrings(is_json ? BDecoder.decodeFromJSON(data) : BDecoder.decode(data.getBytes("UTF-8")));
                    List l_items = (List)map.get("items");
                    ArrayList<DashboardItem> new_items = new ArrayList<DashboardItem>();
                    for (Map m : l_items) {
                        new_items.add(new DashboardItem(m));
                    }
                    String layout = (String)map.get("layout");
                    this.decodeIAA(layout);
                    String weights = (String)map.get("weights");
                    this.decodeIAA(weights);
                    this.items.clear();
                    this.items.addAll(new_items);
                    COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".layout", layout);
                    COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".sash.weights", weights);
                    Number l_use_tabs = (Number)map.get("use_tabs");
                    boolean use_tabs = l_use_tabs != null && l_use_tabs.intValue() != 0;
                    this.setUseTabs(use_tabs);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.fireChanged();
        }

        private void addStartupItem() {
            String starting_url = "https://wiki.biglybt.com/w/Dashboard";
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("mdi", "sidebar");
            map.put("skin_id", "com.biglybt.ui.skin.skin3");
            map.put("parent_id", "header.dashboard");
            map.put("skin_ref", "main.generic.browse");
            map.put("id", "Browser: Dashboard");
            map.put("title", "Wiki: Dashboard");
            map.put("data_source", starting_url);
            map.put("control_type", 0L);
            this.addItem(map);
        }

        private int getItemCount() {
            return this.items.size();
        }

        private List<DashboardItem> getItems() {
            return this.items.getList();
        }

        private void addItem(Map map) {
            ArrayList<Map> list = new ArrayList<Map>(1);
            list.add(map);
            this.addItems(list);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addItems(List<Map> item_list) {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                int[][] initial_layout;
                int[][] layout = initial_layout = this.getDashboardLayout();
                for (Map map : item_list) {
                    DashboardItem item = new DashboardItem(map);
                    this.items.add(item);
                    layout = this.ensureUIDInLayout(layout, item.getUID());
                }
                if (layout != initial_layout) {
                    this.setDashboardLayout(layout, this.items.size(), false);
                }
            }
        }

        private void refresh(ViewTitleInfo info) {
            for (DashboardItem item : this.items) {
                item.refresh(info);
            }
        }

        private void updateLocale() {
            Utils.execSWTThread(() -> {
                if (this.main_composite == null || this.main_composite.isDisposed()) {
                    return;
                }
                this.updateLocale(this.main_composite);
            });
        }

        private void updateLocale(Composite comp2) {
            String new_text;
            String title_id;
            int n;
            int n2;
            CTabItem[] cTabItemArray;
            if (comp2 instanceof CTabFolder) {
                CTabItem[] items;
                cTabItemArray = items = ((CTabFolder)comp2).getItems();
                n2 = items.length;
                n = 0;
                while (n < n2) {
                    String new_text2;
                    CTabItem item = cTabItemArray[n];
                    String title_id2 = (String)item.getData("sb:itemtitleid");
                    if (title_id2 != null && (new_text2 = MessageText.getString(title_id2)) != null) {
                        item.setText(String.valueOf(new_text2) + (item.getText().endsWith("...") ? "..." : ""));
                    }
                    ++n;
                }
            } else if (comp2 instanceof Group && (title_id = (String)comp2.getData("sb:itemtitleid")) != null && (new_text = MessageText.getString(title_id)) != null) {
                ((Group)comp2).setText(new_text);
            }
            Control[] kids = comp2.getChildren();
            cTabItemArray = kids;
            n2 = kids.length;
            n = 0;
            while (n < n2) {
                CTabItem k = cTabItemArray[n];
                if (k instanceof Composite) {
                    this.updateLocale((Composite)k);
                }
                ++n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() {
            ArrayList<DashboardItem> copy;
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                copy = new ArrayList<DashboardItem>(this.items.getList());
            }
            for (DashboardItem item : copy) {
                item.remove(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setSashWeights(int[][] weights) {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                String str;
                block4: {
                    str = this.encodeIAA(weights);
                    String old_str = COConfigurationManager.getStringParameter(String.valueOf(this.config_prefix) + ".sash.weights", "");
                    if (!str.equals(old_str)) break block4;
                    return false;
                }
                COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".sash.weights", str);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int[][] getSashWeights() {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                String str = COConfigurationManager.getStringParameter(String.valueOf(this.config_prefix) + ".sash.weights");
                return this.decodeIAA(str);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setDashboardLayout(int[][] layout, int grid_size, boolean compact) {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                block6: {
                    String new_str = this.encodeIAA(layout);
                    String old_str = COConfigurationManager.getStringParameter(String.valueOf(this.config_prefix) + ".layout");
                    boolean same = new_str.equals(old_str);
                    if (compact) {
                        new_str = this.encodeIAA(this.compactLayout(layout, grid_size));
                    }
                    if (!new_str.equals(old_str)) {
                        COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".layout", new_str);
                    }
                    if (!same) break block6;
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int[][] getDashboardLayout() {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                String str = COConfigurationManager.getStringParameter(String.valueOf(this.config_prefix) + ".layout");
                return this.decodeIAA(str);
            }
        }

        private boolean getAddNewHorizontal() {
            return COConfigurationManager.getBooleanParameter(String.valueOf(this.config_prefix) + ".config.addhoriz", true);
        }

        private void setAddNewHorizontal(boolean b) {
            COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".config.addhoriz", b);
        }

        private boolean getUseTabs() {
            return COConfigurationManager.getBooleanParameter(String.valueOf(this.config_prefix) + ".config.usetabs", this.use_tabs_default);
        }

        private void setUseTabs(boolean b) {
            COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".config.usetabs", b);
        }

        private void tabSelected(int folder_id, int tab_index) {
            COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".tab.selection." + folder_id, tab_index);
        }

        private int getTabSelection(int folder_id) {
            return COConfigurationManager.getIntParameter(String.valueOf(this.config_prefix) + ".tab.selection." + folder_id, 0);
        }

        private void setupTabFolder(CTabFolder tf) {
            tf.setUnselectedCloseVisible(false);
            tf.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event2) {
                    DashboardItem di = (DashboardItem)event2.item.getData("sb:dashboarditem");
                    if (di != null) {
                        di.remove(true);
                    }
                }
            });
            TabFolderRenderer renderer = new TabFolderRenderer(tf, new TabFolderRenderer.Adapter(){

                @Override
                public TabFolderRenderer.TabbedEntry getTabbedEntryFromTabItem(CTabItem item) {
                    DashboardItem entry = (DashboardItem)item.getData("sb:tabbedentry");
                    if (entry != null) {
                        return entry;
                    }
                    for (DashboardItem di : DashboardInstance.this.items) {
                        if (di.item != item) continue;
                        item.setData("sb:tabbedentry", (Object)di);
                        return di;
                    }
                    return null;
                }
            });
        }

        private void setupTabItem(CTabItem tab_item, List<DashboardItem> visible_items) {
            tab_item.setShowClose(tab_item.getData("sb:dashboarditem") != null && SB_Dashboard.this.bigly_ui);
            DashboardItem main_item = visible_items.get(0);
            tab_item.setText(String.valueOf(main_item.getTitle()) + (visible_items.size() > 1 ? "..." : ""));
            String title_id = main_item.getTitleID();
            if (title_id != null) {
                tab_item.setData("sb:itemtitleid", (Object)title_id);
            }
        }

        private void refreshTabFolder(DashboardItem di) {
            Utils.execSWTThread(() -> {
                TabFolderRenderer renderer = (TabFolderRenderer)di.getTabbedEntryItem().getParent().getRenderer();
                renderer.redraw(di);
            });
        }

        private void refreshTabFolder(CTabFolder tf, int index) {
            TabFolderRenderer renderer = (TabFolderRenderer)tf.getRenderer();
            renderer.redraw(index);
        }

        private void fireChanged() {
            if (SB_Dashboard.this.mdi_entry != null) {
                SB_Dashboard.this.mdi_entry.redraw();
            }
            for (DashboardListener l : this.listeners) {
                try {
                    l.itemsChanged();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.writeConfig();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getItemUID() {
            CopyOnWriteList<DashboardItem> copyOnWriteList = this.items;
            synchronized (copyOnWriteList) {
                int next = COConfigurationManager.getIntParameter(String.valueOf(this.config_prefix) + ".uid.next");
                int t = next + 1;
                if (t < 0) {
                    t = 0;
                }
                COConfigurationManager.setParameter(String.valueOf(this.config_prefix) + ".uid.next", t);
                return next;
            }
        }

        private int[][] ensureUIDInLayout(int[][] layout, int uid) {
            int i;
            int[][] nArray = layout;
            int n = layout.length;
            int n2 = 0;
            while (n2 < n) {
                int[] row;
                int[] nArray2 = row = nArray[n2];
                int n3 = row.length;
                int n4 = 0;
                while (n4 < n3) {
                    i = nArray2[n4];
                    if (i == uid) {
                        return layout;
                    }
                    ++n4;
                }
                ++n2;
            }
            boolean add_horiz = this.getAddNewHorizontal();
            int size = layout.length;
            int new_size = size + 1;
            int[][] new_layout = new int[new_size][new_size];
            if (new_size == 1) {
                new_layout[0][0] = uid;
            } else {
                i = 0;
                while (i < new_size) {
                    int[] old_row = i < size ? layout[i] : null;
                    int[] new_row = new_layout[i];
                    int j = 0;
                    while (j < new_size) {
                        new_row[j] = i < size ? (j < size ? old_row[j] : (add_horiz ? uid : new_row[j - 1])) : (j < size ? (add_horiz ? layout[i - 1][j] : uid) : uid);
                        ++j;
                    }
                    ++i;
                }
            }
            return new_layout;
        }

        private boolean removeUIDFromLayout(int[][] layout, int uid) {
            boolean changed = false;
            int[][] nArray = layout;
            int n = layout.length;
            int n2 = 0;
            while (n2 < n) {
                int[] row = nArray[n2];
                int i = 0;
                while (i < row.length) {
                    if (row[i] == uid) {
                        row[i] = -1;
                        changed = true;
                    }
                    ++i;
                }
                ++n2;
            }
            return changed;
        }

        private boolean isUIDInLayout(int[][] layout, int uid) {
            int[][] nArray = layout;
            int n = layout.length;
            int n2 = 0;
            while (n2 < n) {
                int[] row = nArray[n2];
                int i = 0;
                while (i < row.length) {
                    if (row[i] == uid) {
                        return true;
                    }
                    ++i;
                }
                ++n2;
            }
            return false;
        }

        private int[][] compactLayout(int[][] layout, int grid_size) {
            return this.compactLayout(layout, grid_size, 4);
        }

        private int[][] compactLayout(int[][] layout, int grid_size, int min_grid_size) {
            int layout_size = layout.length;
            if (layout_size > grid_size && layout_size > min_grid_size) {
                int row_to_remove = -1;
                int col_to_remove = -1;
                int i = 0;
                while (i < layout_size) {
                    int j;
                    int[] row = layout[i];
                    if (i < layout_size - 1) {
                        int[] next_row = layout[i + 1];
                        boolean same = true;
                        j = 0;
                        while (j < layout_size) {
                            if (row[j] != next_row[j]) {
                                same = false;
                                break;
                            }
                            ++j;
                        }
                        if (same) {
                            row_to_remove = i;
                        }
                    }
                    boolean all_undef = true;
                    int[] nArray = row;
                    int n = row.length;
                    j = 0;
                    while (j < n) {
                        int uid = nArray[j];
                        if (uid != -1) {
                            all_undef = false;
                            break;
                        }
                        ++j;
                    }
                    if (all_undef) {
                        row_to_remove = i;
                    }
                    ++i;
                }
                int j = 0;
                while (j < layout_size) {
                    int i2;
                    if (j < layout_size - 1) {
                        boolean same = true;
                        i2 = 0;
                        while (i2 < layout_size) {
                            if (layout[i2][j] != layout[i2][j + 1]) {
                                same = false;
                                break;
                            }
                            ++i2;
                        }
                        if (same) {
                            col_to_remove = j;
                        }
                    }
                    boolean all_undef = true;
                    i2 = 0;
                    while (i2 < layout_size) {
                        if (layout[i2][j] != -1) {
                            all_undef = false;
                            break;
                        }
                        ++i2;
                    }
                    if (all_undef) {
                        col_to_remove = j;
                    }
                    ++j;
                }
                if (row_to_remove != -1 && col_to_remove != -1) {
                    int[][] new_layout = new int[layout_size - 1][layout_size - 1];
                    int i3 = 0;
                    while (i3 < layout_size) {
                        if (i3 != row_to_remove) {
                            int j2 = 0;
                            while (j2 < layout_size) {
                                if (j2 != col_to_remove) {
                                    int target_i = i3 < row_to_remove ? i3 : i3 - 1;
                                    int target_j = j2 < col_to_remove ? j2 : j2 - 1;
                                    new_layout[target_i][target_j] = layout[i3][j2];
                                }
                                ++j2;
                            }
                        }
                        ++i3;
                    }
                    return this.compactLayout(new_layout, grid_size, min_grid_size);
                }
            }
            return layout;
        }

        private String encodeIAA(int[][] data) {
            String str = "";
            int[][] nArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                int[] row = nArray[n2];
                String r_str = "";
                int[] nArray2 = row;
                int n3 = row.length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = nArray2[n4];
                    if (!r_str.isEmpty()) {
                        r_str = String.valueOf(r_str) + ",";
                    }
                    r_str = String.valueOf(r_str) + n5;
                    ++n4;
                }
                if (!str.isEmpty()) {
                    str = String.valueOf(str) + ";";
                }
                str = String.valueOf(str) + r_str;
                ++n2;
            }
            return str;
        }

        private int[][] decodeIAA(String str) {
            if (str.isEmpty()) {
                return new int[0][0];
            }
            String[] rows = str.split(";");
            int[][] layout = new int[rows.length][];
            int row_num = 0;
            String[] stringArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                String[] cells = row.split(",");
                int[] x = new int[cells.length];
                layout[row_num++] = x;
                int i = 0;
                while (i < cells.length) {
                    try {
                        x[i] = Integer.parseInt(cells[i]);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    ++i;
                }
                ++n2;
            }
            return layout;
        }

        protected void build(Composite dashboard_composite) {
            block16: {
                this.main_composite = dashboard_composite;
                ++this.building;
                if (dashboard_composite != null) break block16;
                SimpleTimer.addEvent("delayer", SystemTime.getOffsetTime(2500L), new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                DashboardInstance dashboardInstance = DashboardInstance.this;
                                dashboardInstance.building = dashboardInstance.building - 1;
                            }
                        });
                    }
                });
                return;
            }
            try {
                Utils.disposeComposite(dashboard_composite, false);
                Object layout = this.getDashboardLayout();
                layout = this.compactLayout((int[][])layout, 0, 0);
                boolean use_tabs = this.getUseTabs();
                if (use_tabs && ((int[][])layout).length == 1 && layout[0].length == 1) {
                    layout = new int[][]{{layout[0][0], -1}, {layout[0][0], -1}};
                }
                HashMap<Integer, DashboardItem> item_map = new HashMap<Integer, DashboardItem>();
                for (DashboardItem item : this.items) {
                    item_map.put(item.getUID(), item);
                }
                int[][] nArray = layout;
                int n = ((int[][])layout).length;
                int n2 = 0;
                while (n2 < n) {
                    int[] row = nArray[n2];
                    int i = 0;
                    while (i < row.length) {
                        int c = row[i];
                        if (!item_map.containsKey(c)) {
                            row[i] = -1;
                        }
                        ++i;
                    }
                    ++n2;
                }
                final ArrayList<SashForm> sashes = new ArrayList<SashForm>();
                ArrayList<Control> controls = new ArrayList<Control>();
                this.build((Map<Integer, DashboardItem>)item_map, null, dashboard_composite, use_tabs, (List<SashForm>)sashes, (List<Control>)controls, (int[][])layout, 0, 0, ((int[][])layout).length, ((int[][])layout).length, new int[1]);
                int[][] sash_weights = this.getSashWeights();
                if (sash_weights.length == sashes.size()) {
                    int i = 0;
                    while (i < sash_weights.length) {
                        int[] weights = sash_weights[i];
                        SashForm sf = (SashForm)sashes.get(i);
                        int[] sf_weights = sf.getWeights();
                        if (sf_weights.length == weights.length) {
                            try {
                                sf.setWeights(weights);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        sf.setData("sb:weights", (Object)sf_weights.length);
                        ++i;
                    }
                } else {
                    this.setSashWeights(new int[0][0]);
                    for (SashForm sf : sashes) {
                        int[] weights = sf.getWeights();
                        sf.setData("sb:weights", (Object)weights.length);
                    }
                }
                for (Control c : controls) {
                    c.addControlListener(new ControlListener(){

                        public void controlResized(ControlEvent arg0) {
                            if (DashboardInstance.this.building > 0) {
                                return;
                            }
                            int[][] weights = new int[sashes.size()][];
                            int i = 0;
                            while (i < sashes.size()) {
                                SashForm sf = (SashForm)sashes.get(i);
                                if (sf.isDisposed()) {
                                    return;
                                }
                                weights[i] = sf.getWeights();
                                Object d = sf.getData("sb:weights");
                                if (d == null || (Integer)d != weights[i].length) {
                                    return;
                                }
                                ++i;
                            }
                            DashboardInstance.this.setSashWeights(weights);
                        }

                        public void controlMoved(ControlEvent arg0) {
                        }
                    });
                }
                dashboard_composite.getParent().layout(true, true);
            }
            catch (Throwable throwable) {
                SimpleTimer.addEvent("delayer", SystemTime.getOffsetTime(2500L), new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SimpleTimer.addEvent("delayer", SystemTime.getOffsetTime(2500L), new /* invalid duplicate definition of identical inner class */);
        }

        private boolean testBuild(List<DashboardItem> items, int[][] layout) {
            HashMap<Integer, DashboardItem> item_map = new HashMap<Integer, DashboardItem>();
            for (DashboardItem item : items) {
                item_map.put(item.getUID(), item);
            }
            int[][] nArray = layout;
            int n = layout.length;
            int n2 = 0;
            while (n2 < n) {
                int[] row = nArray[n2];
                int i = 0;
                while (i < row.length) {
                    int c = row[i];
                    if (!item_map.containsKey(c)) {
                        row[i] = -1;
                    }
                    ++i;
                }
                ++n2;
            }
            int before = item_map.size();
            this.build(item_map, null, null, false, null, null, layout, 0, 0, layout.length, layout.length, new int[1]);
            return item_map.size() < before;
        }

        private List<DashboardItem> build(Map<Integer, DashboardItem> item_map, CTabItem parent_tab_item, Composite comp2, boolean use_tabs, List<SashForm> sashes, List<Control> controls, int[][] cells, int x, int y, int width, int height, int[] next_tf_id) {
            int current;
            List<DashboardItem> items;
            CTabItem tab_item;
            List<DashboardItem> items2;
            CTabItem tab_item2;
            int tf_id;
            boolean ok;
            ArrayList<DashboardItem> result = new ArrayList<DashboardItem>();
            int temp = -1;
            boolean not_same = false;
            int i = y;
            while (i < y + height) {
                int j = x;
                while (j < x + width) {
                    int val = cells[i][j];
                    if (temp == -1) {
                        temp = val;
                    } else if (temp != val) {
                        not_same = true;
                    }
                    ++j;
                }
                ++i;
            }
            if (!not_same) {
                DashboardItem item = item_map.remove(temp);
                if (item != null && comp2 != null) {
                    controls.add((Control)this.build(parent_tab_item, comp2, item, use_tabs));
                    result.add(item);
                }
                return result;
            }
            boolean done = false;
            if (height > 1) {
                ArrayList<Integer> splits = new ArrayList<Integer>();
                int i2 = y + 1;
                while (i2 < y + height) {
                    ok = true;
                    int[] row = cells[i2];
                    int[] prev_row = cells[i2 - 1];
                    int j = x;
                    while (j < x + width) {
                        if (prev_row[j] == row[j] && row[j] != -1) {
                            ok = false;
                            break;
                        }
                        ++j;
                    }
                    if (ok) {
                        splits.add(i2);
                    }
                    ++i2;
                }
                if (splits.size() > 0) {
                    if (use_tabs) {
                        CTabFolder tf;
                        if (comp2 != null) {
                            tf = new CTabFolder(comp2, 128);
                            this.setupTabFolder(tf);
                            tf.setLayoutData((Object)Utils.getFilledFormData());
                            int n = next_tf_id[0];
                            next_tf_id[0] = n + 1;
                            tf_id = n;
                        } else {
                            tf = null;
                            tf_id = -1;
                        }
                        int current2 = y;
                        Iterator j = splits.iterator();
                        while (j.hasNext()) {
                            int split = (Integer)j.next();
                            tab_item2 = null;
                            Composite tab_composite = null;
                            if (tf != null) {
                                tab_item2 = new CTabItem(tf, 0);
                                tab_composite = new Composite((Composite)tf, 0);
                                tab_composite.setLayout((Layout)new FormLayout());
                                tab_item2.setControl((Control)tab_composite);
                                tab_composite.setLayoutData((Object)Utils.getFilledFormData());
                            }
                            if ((items2 = this.build(item_map, tab_item2, tab_composite, use_tabs, sashes, controls, cells, x, current2, width, split - current2, next_tf_id)).isEmpty()) {
                                if (tab_item2 != null) {
                                    tab_item2.dispose();
                                }
                            } else {
                                if (tab_item2 != null) {
                                    this.setupTabItem(tab_item2, items2);
                                }
                                result.addAll(items2);
                            }
                            current2 = split;
                        }
                        tab_item = null;
                        Composite tab_composite = null;
                        if (tf != null) {
                            tab_item = new CTabItem(tf, 0);
                            tab_composite = new Composite((Composite)tf, 0);
                            tab_composite.setLayout((Layout)new FormLayout());
                            tab_item.setControl((Control)tab_composite);
                            tab_composite.setLayoutData((Object)Utils.getFilledFormData());
                        }
                        if ((items = this.build(item_map, tab_item, tab_composite, use_tabs, sashes, controls, cells, x, current2, width, height - (current2 - y), next_tf_id)).isEmpty()) {
                            if (tab_item != null) {
                                tab_item.dispose();
                            }
                        } else {
                            if (tab_item != null) {
                                this.setupTabItem(tab_item, items);
                            }
                            result.addAll(items);
                        }
                        if (tf != null) {
                            tf.addMenuDetectListener(new MenuDetectListener(){

                                public void menuDetected(MenuDetectEvent event2) {
                                    Menu m;
                                    CTabItem item = tf.getItem(tf.toControl(event2.x, event2.y));
                                    if (item != null && (m = item.getControl().getMenu()) != null) {
                                        m.setVisible(true);
                                    }
                                }
                            });
                            final int sel = Math.min(tf.getItemCount() - 1, this.getTabSelection(tf_id));
                            tf.setSelection(sel);
                            this.refreshTabFolder(tf, sel);
                            tf.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent ev) {
                                    Composite c = (Composite)tf.getSelection().getControl();
                                    Object o = c.getData("sb:reload");
                                    if (o instanceof Runnable) {
                                        ((Runnable)o).run();
                                        c.setData("sb:reload", null);
                                    }
                                    DashboardInstance.this.refreshTabFolder(tf, sel);
                                    DashboardInstance.this.tabSelected(tf_id, tf.getSelectionIndex());
                                }
                            });
                        }
                    } else {
                        SashForm sf;
                        if (comp2 != null) {
                            sf = new SashForm(comp2, 512);
                            sashes.add(sf);
                            sf.setLayoutData((Object)Utils.getFilledFormData());
                        } else {
                            sf = null;
                        }
                        current = y;
                        tab_item = splits.iterator();
                        while (tab_item.hasNext()) {
                            int split = (Integer)tab_item.next();
                            result.addAll(this.build(item_map, null, (Composite)sf, use_tabs, sashes, controls, cells, x, current, width, split - current, next_tf_id));
                            current = split;
                        }
                        result.addAll(this.build(item_map, null, (Composite)sf, use_tabs, sashes, controls, cells, x, current, width, height - (current - y), next_tf_id));
                    }
                    done = true;
                }
            }
            if (width > 1 && !done) {
                ArrayList<Integer> splits = new ArrayList<Integer>();
                int j = x + 1;
                while (j < x + width) {
                    ok = true;
                    int i3 = y;
                    while (i3 < y + height) {
                        if (cells[i3][j] == cells[i3][j - 1] && cells[i3][j] != -1) {
                            ok = false;
                            break;
                        }
                        ++i3;
                    }
                    if (ok) {
                        splits.add(j);
                    }
                    ++j;
                }
                if (splits.size() > 0) {
                    if (use_tabs) {
                        CTabFolder tf;
                        if (comp2 != null) {
                            tf = new CTabFolder(comp2, 262272);
                            this.setupTabFolder(tf);
                            tf.setLayoutData((Object)Utils.getFilledFormData());
                            int n = next_tf_id[0];
                            next_tf_id[0] = n + 1;
                            tf_id = n;
                        } else {
                            tf = null;
                            tf_id = -1;
                        }
                        int current3 = x;
                        Composite tab_composite = splits.iterator();
                        while (tab_composite.hasNext()) {
                            int split = (Integer)tab_composite.next();
                            tab_item2 = null;
                            Composite tab_composite2 = null;
                            if (tf != null) {
                                tab_item2 = new CTabItem(tf, 0);
                                tab_composite2 = new Composite((Composite)tf, 0);
                                tab_composite2.setLayout((Layout)new FormLayout());
                                tab_item2.setControl((Control)tab_composite2);
                                tab_composite2.setLayoutData((Object)Utils.getFilledFormData());
                            }
                            if ((items2 = this.build(item_map, tab_item2, tab_composite2, use_tabs, sashes, controls, cells, current3, y, split - current3, height, next_tf_id)).isEmpty()) {
                                if (tab_item2 != null) {
                                    tab_item2.dispose();
                                }
                            } else {
                                if (tab_item2 != null) {
                                    this.setupTabItem(tab_item2, items2);
                                }
                                result.addAll(items2);
                            }
                            current3 = split;
                        }
                        tab_item = null;
                        tab_composite = null;
                        if (tf != null) {
                            tab_item = new CTabItem(tf, 0);
                            tab_composite = new Composite((Composite)tf, 0);
                            tab_composite.setLayout((Layout)new FormLayout());
                            tab_item.setControl((Control)tab_composite);
                            tab_composite.setLayoutData((Object)Utils.getFilledFormData());
                        }
                        if ((items = this.build(item_map, tab_item, tab_composite, use_tabs, sashes, controls, cells, current3, y, width - (current3 - x), height, next_tf_id)).isEmpty()) {
                            if (tab_item != null) {
                                tab_item.dispose();
                            }
                        } else {
                            if (tab_item != null) {
                                this.setupTabItem(tab_item, items);
                            }
                            result.addAll(items);
                        }
                        if (tf != null) {
                            tf.addMenuDetectListener(new MenuDetectListener(){

                                public void menuDetected(MenuDetectEvent event2) {
                                    Menu m;
                                    CTabItem item = tf.getItem(tf.toControl(event2.x, event2.y));
                                    if (item != null && (m = item.getControl().getMenu()) != null) {
                                        m.setVisible(true);
                                    }
                                }
                            });
                            final int sel = Math.min(tf.getItemCount() - 1, this.getTabSelection(tf_id));
                            tf.setSelection(sel);
                            this.refreshTabFolder(tf, sel);
                            tf.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent ev) {
                                    Composite c = (Composite)tf.getSelection().getControl();
                                    Object o = c.getData("sb:reload");
                                    if (o instanceof Runnable) {
                                        ((Runnable)o).run();
                                        c.setData("sb:reload", null);
                                    }
                                    DashboardInstance.this.refreshTabFolder(tf, sel);
                                    DashboardInstance.this.tabSelected(tf_id, tf.getSelectionIndex());
                                }
                            });
                        }
                    } else {
                        SashForm sf;
                        if (comp2 != null) {
                            sf = new SashForm(comp2, 256);
                            sashes.add(sf);
                            sf.setLayoutData((Object)Utils.getFilledFormData());
                        } else {
                            sf = null;
                        }
                        current = x;
                        Iterator iterator = splits.iterator();
                        while (iterator.hasNext()) {
                            int split = (Integer)iterator.next();
                            result.addAll(this.build(item_map, null, (Composite)sf, use_tabs, sashes, controls, cells, current, y, split - current, height, next_tf_id));
                            current = split;
                        }
                        result.addAll(this.build(item_map, null, (Composite)sf, use_tabs, sashes, controls, cells, current, y, width - (current - x), height, next_tf_id));
                    }
                }
            }
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return result;
        }

        private Composite build(final CTabItem parent_tab_item, final Composite sf, final DashboardItem item, boolean use_tabs) {
            final Composite g = use_tabs ? new Composite(sf, 0) : Utils.createSkinnedGroup(sf, 0);
            g.setLayoutData((Object)Utils.getFilledFormData());
            g.setLayout((Layout)new GridLayout());
            g.setData("com.biglybt.ui.swt.Utils.RELAYOUT_UP_STOP_HERE", (Object)true);
            if (parent_tab_item != null) {
                parent_tab_item.setData("sb:dashboarditem", (Object)item);
            }
            try {
                if (g instanceof Group) {
                    ((Group)g).setText(item.getTitle());
                    String title_id = item.getTitleID();
                    if (title_id != null) {
                        g.setData("sb:itemtitleid", (Object)title_id);
                    }
                }
                Composite menu_comp = use_tabs ? sf : g;
                Menu menu = new Menu((Control)menu_comp);
                MenuItem itemReload = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemReload, "Button.reload");
                final Runnable reload_action = new Runnable(){

                    @Override
                    public void run() {
                        if (Utils.isSWTThread()) {
                            if (!g.isDisposed()) {
                                Utils.disposeComposite(g, false);
                                SkinnedComposite skinned_comp = new SkinnedComposite(g);
                                SWTSkin skin = skinned_comp.getSkin();
                                SWTSkinObjectContainer obj = BaseMdiEntry.importStandAlone((SWTSkinObjectContainer)skin.getSkinObject("content-area"), item.getState(), this);
                                if (obj != null) {
                                    sf.setData("sb:reload", null);
                                }
                                Control c = ((SWTSkinObjectContainer)skin.getSkinObject("content-area")).getControl();
                                c.setLayoutData((Object)Utils.getFilledFormData());
                                g.layout(true, true);
                                item.setCurrentTab(parent_tab_item);
                            }
                        } else {
                            Utils.execSWTThread(this);
                        }
                    }
                };
                sf.setData("sb:reload", (Object)reload_action);
                itemReload.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        reload_action.run();
                    }
                });
                MenuItem itemPop = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemPop, "menu.pop.out");
                itemPop.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        PopOutManager.popOutStandAlone(item.getTitle(), item.getState(), null);
                    }
                });
                new MenuItem(menu, 2);
                if (SB_Dashboard.this.bigly_ui) {
                    MenuItem itemRemove = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemRemove, "MySharesView.menu.remove");
                    Utils.setMenuItemImage(itemRemove, "delete");
                    itemRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent arg0) {
                            item.remove(false);
                        }
                    });
                    new MenuItem(menu, 2);
                }
                MenuItem itemConfig = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemConfig, "device.configure");
                Utils.setMenuItemImage(itemConfig, "image.sidebar.cog");
                itemConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        DashboardInstance.this.showConfig();
                    }
                });
                menu_comp.setMenu(menu);
                if (parent_tab_item == null) {
                    menu_comp.addListener(8, ev -> PopOutManager.popOutStandAlone(item.getTitle(), item.getState(), null));
                } else {
                    CTabFolder folder = parent_tab_item.getParent();
                    folder.addListener(8, ev -> {
                        if (folder.getItem(new Point(ev.x, ev.y)) == parent_tab_item) {
                            PopOutManager.popOutStandAlone(item.getTitle(), item.getState(), null);
                        }
                    });
                }
                SkinnedComposite skinned_comp = new SkinnedComposite(g);
                SWTSkin skin = skinned_comp.getSkin();
                SWTSkinObjectContainer imported = BaseMdiEntry.importStandAlone((SWTSkinObjectContainer)skin.getSkinObject("content-area"), item.getState(), reload_action);
                if (imported != null) {
                    sf.setData("sb:reload", null);
                }
                Control c = ((SWTSkinObjectContainer)skin.getSkinObject("content-area")).getControl();
                c.setLayoutData((Object)Utils.getFilledFormData());
                item.setCurrentTab(parent_tab_item);
                c.addListener(22, new Listener(){

                    public void handleEvent(Event arg0) {
                        g.layout(true, true);
                        item.setCurrentTab(parent_tab_item);
                    }
                });
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            return g;
        }

        private void showConfig() {
            if (this.config_active) {
                return;
            }
            this.config_active = true;
            DBConfigWindow config = new DBConfigWindow(new ArrayList<DashboardItem>(this.items.getList()));
            config.addCloseListener(() -> {
                this.config_active = false;
            });
        }

        private class DBConfigWindow {
            private final Shell shell;
            private final org.eclipse.swt.widgets.List list;
            final Composite cGrid;
            final Button btnSave;
            private final List<DashboardItem> items;
            private final int num_items;
            private final int[] item_uids;
            final Map<Integer, Integer> uid_to_item_map = new HashMap<Integer, Integer>();
            final boolean original_use_tabs;
            int[][] existing_mapping;
            int[][] mapping;
            Composite[][] cells;
            List<Runnable> listeners;

            private DBConfigWindow(List<DashboardItem> _items) {
                this.original_use_tabs = DashboardInstance.this.getUseTabs();
                this.listeners = new ArrayList<Runnable>();
                this.items = _items;
                this.shell = ShellFactory.createMainShell(2160);
                Messages.setLanguageText((Widget)this.shell, "configure.dashboard");
                Utils.setShellIcon(this.shell);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                this.shell.setLayout((Layout)layout);
                this.list = new org.eclipse.swt.widgets.List((Composite)this.shell, 772);
                GridData gridData = new GridData(1040);
                this.list.setLayoutData((Object)gridData);
                this.existing_mapping = DashboardInstance.this.getDashboardLayout();
                this.num_items = this.items.size();
                this.item_uids = new int[this.num_items];
                int i = 0;
                while (i < this.num_items) {
                    int uid;
                    DashboardItem item = this.items.get(i);
                    this.item_uids[i] = uid = item.getUID();
                    this.uid_to_item_map.put(uid, i);
                    this.list.add(String.valueOf(i + 1) + ") " + item.getTitle());
                    ++i;
                }
                this.cGrid = new Composite((Composite)this.shell, 0);
                gridData = new GridData(768);
                this.cGrid.setLayoutData((Object)gridData);
                int grid_size = this.buildGrid();
                final Button add_horiz = new Button((Composite)this.shell, 32);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                add_horiz.setLayoutData((Object)gridData);
                add_horiz.setText(MessageText.getString("dashboard.add.right"));
                add_horiz.setSelection(DashboardInstance.this.getAddNewHorizontal());
                add_horiz.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        DashboardInstance.this.setAddNewHorizontal(add_horiz.getSelection());
                    }
                });
                final Button use_tabs = new Button((Composite)this.shell, 32);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                use_tabs.setLayoutData((Object)gridData);
                use_tabs.setText(MessageText.getString("dashboard.use.tabs"));
                use_tabs.setSelection(DashboardInstance.this.getUseTabs());
                use_tabs.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        DashboardInstance.this.setUseTabs(use_tabs.getSelection());
                    }
                });
                Label labelSeparator = new Label((Composite)this.shell, 258);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                labelSeparator.setLayoutData((Object)gridData);
                Composite cButtons = new Composite((Composite)this.shell, 0);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                cButtons.setLayoutData((Object)gridData);
                GridLayout layoutButtons = new GridLayout();
                layoutButtons.numColumns = 6;
                cButtons.setLayout((Layout)layoutButtons);
                ArrayList<Button> buttons = new ArrayList<Button>();
                Button btnReset = new Button(cButtons, 8);
                buttons.add(btnReset);
                gridData = new GridData();
                gridData.horizontalAlignment = 3;
                btnReset.setLayoutData((Object)gridData);
                Messages.setLanguageText((Widget)btnReset, "Button.reset");
                btnReset.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        DBConfigWindow.this.existing_mapping = new int[0][0];
                        int[] nArray = DBConfigWindow.this.item_uids;
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int uid = nArray[n2];
                            DBConfigWindow.this.existing_mapping = DashboardInstance.this.ensureUIDInLayout(DBConfigWindow.this.existing_mapping, uid);
                            ++n2;
                        }
                        DBConfigWindow.this.buildGrid();
                        DBConfigWindow.this.shell.layout(true, true);
                    }
                });
                Button btnClear = new Button(cButtons, 8);
                buttons.add(btnClear);
                gridData = new GridData();
                gridData.horizontalAlignment = 3;
                btnClear.setLayoutData((Object)gridData);
                Messages.setLanguageText((Widget)btnClear, "Button.clear");
                btnClear.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        DBConfigWindow.this.existing_mapping = new int[0][0];
                        DBConfigWindow.this.buildGrid();
                        DBConfigWindow.this.btnSave.setEnabled(false);
                        DBConfigWindow.this.shell.layout(true, true);
                    }
                });
                Label label = new Label(cButtons, 0);
                gridData = new GridData(768);
                label.setLayoutData((Object)gridData);
                this.btnSave = new Button(cButtons, 8);
                buttons.add(this.btnSave);
                gridData = new GridData();
                gridData.horizontalAlignment = 3;
                this.btnSave.setLayoutData((Object)gridData);
                Messages.setLanguageText((Widget)this.btnSave, "wizard.multitracker.edit.save");
                this.btnSave.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (DashboardInstance.this.setDashboardLayout(DBConfigWindow.this.mapping, DBConfigWindow.this.num_items, true) || DashboardInstance.this.getUseTabs() != DBConfigWindow.this.original_use_tabs) {
                            DashboardInstance.this.fireChanged();
                        }
                        DBConfigWindow.this.shell.dispose();
                    }
                });
                Button btnCancel = new Button(cButtons, 8);
                buttons.add(btnCancel);
                gridData = new GridData();
                gridData.horizontalAlignment = 3;
                btnCancel.setLayoutData((Object)gridData);
                Messages.setLanguageText((Widget)btnCancel, "Button.cancel");
                btnCancel.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        DBConfigWindow.this.shell.dispose();
                    }
                });
                Utils.makeButtonsEqualWidth(buttons);
                this.shell.setDefaultButton(this.btnSave);
                this.shell.addListener(31, new Listener(){

                    public void handleEvent(Event e) {
                        if (e.character == '\u001b') {
                            DBConfigWindow.this.shell.dispose();
                        }
                    }
                });
                if (grid_size < 5) {
                    Point size = this.shell.computeSize(500, -1);
                    this.shell.setSize(size);
                } else {
                    this.shell.pack();
                }
                Utils.centreWindow(this.shell);
                this.shell.addListener(12, ev -> {
                    for (Runnable r : this.listeners) {
                        try {
                            r.run();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                this.shell.open();
            }

            private void addCloseListener(Runnable r) {
                this.listeners.add(r);
            }

            private int buildGrid() {
                final int grid_size = this.existing_mapping.length > this.num_items ? this.existing_mapping.length : this.num_items;
                int[][] nArray = this.mapping = new int[grid_size][grid_size];
                int n = this.mapping.length;
                int n2 = 0;
                while (n2 < n) {
                    int[] row = nArray[n2];
                    Arrays.fill(row, -1);
                    ++n2;
                }
                int i = 0;
                while (i < this.existing_mapping.length) {
                    int[] old_row = this.existing_mapping[i];
                    int[] new_row = this.mapping[i];
                    int j = 0;
                    while (j < old_row.length) {
                        int uid = old_row[j];
                        new_row[j] = this.uid_to_item_map.containsKey(uid) ? uid : -1;
                        ++j;
                    }
                    ++i;
                }
                this.cells = new Composite[grid_size][grid_size];
                Utils.disposeComposite(this.cGrid, false);
                GridLayout layoutGrid = new GridLayout(grid_size, true);
                layoutGrid.horizontalSpacing = 0;
                layoutGrid.verticalSpacing = 0;
                this.cGrid.setLayout((Layout)layoutGrid);
                int i2 = 0;
                while (i2 < grid_size) {
                    int j = 0;
                    while (j < grid_size) {
                        final Canvas cell = new Canvas(this.cGrid, 0x20000000);
                        GridData gridData = new GridData();
                        gridData.widthHint = 50;
                        gridData.heightHint = 50;
                        cell.setLayoutData((Object)gridData);
                        this.cells[i2][j] = cell;
                        final int f_i = i2;
                        final int f_j = j++;
                        cell.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDown(MouseEvent arg0) {
                                int uid = DBConfigWindow.this.item_uids[DBConfigWindow.this.list.getSelectionIndex()];
                                DBConfigWindow.this.mapping[f_i][f_j] = DBConfigWindow.this.mapping[f_i][f_j] == uid ? -1 : uid;
                                DBConfigWindow.this.btnSave.setEnabled(DashboardInstance.this.testBuild(DBConfigWindow.this.items, (int[][])DBConfigWindow.this.mapping.clone()));
                                cell.redraw();
                            }
                        });
                        cell.addPaintListener(new PaintListener(){

                            public void paintControl(PaintEvent ev) {
                                GC gc = ev.gc;
                                Rectangle bounds = cell.getBounds();
                                int uid = DBConfigWindow.this.mapping[f_i][f_j];
                                if (uid != -1 && DBConfigWindow.this.uid_to_item_map.get(uid).intValue() == DBConfigWindow.this.list.getSelectionIndex()) {
                                    gc.setBackground(Colors.dark_grey);
                                } else {
                                    gc.setBackground(uid == -1 ? Colors.light_grey : Colors.grey);
                                }
                                gc.fillRectangle(0, 0, bounds.width, bounds.height);
                                gc.setForeground(Colors.white);
                                gc.drawLine(0, 0, 0, bounds.height - 1);
                                gc.drawLine(0, 0, bounds.width - 1, 0);
                                if (f_i == grid_size - 1) {
                                    gc.drawLine(0, bounds.height - 1, bounds.width - 1, bounds.height - 1);
                                }
                                if (f_j == grid_size - 1) {
                                    gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
                                }
                                if (uid != -1) {
                                    new GCStringPrinter(gc, String.valueOf(DBConfigWindow.this.uid_to_item_map.get(uid) + 1), new Rectangle(0, 0, bounds.width, bounds.height), 0, 0x1000000).printString();
                                }
                            }
                        });
                    }
                    ++i2;
                }
                this.list.select(0);
                this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Composite[][] compositeArray = DBConfigWindow.this.cells;
                        int n = DBConfigWindow.this.cells.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Composite[] row;
                            Composite[] compositeArray2 = row = compositeArray[n2];
                            int n3 = row.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Composite c = compositeArray2[n4];
                                c.redraw();
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                });
                return grid_size;
            }
        }

        public class DashboardItem
        implements TabFolderRenderer.TabbedEntry {
            private Map<String, Object> map;
            private CTabItem item;
            private ViewTitleInfo title_info;

            private DashboardItem(Map<String, Object> _map) {
                this.map = _map;
                Long uid = (Long)this.map.get("_uid");
                if (uid == null) {
                    uid = new Long(DashboardInstance.this.getItemUID());
                    this.map.put("_uid", uid);
                    DashboardInstance.this.configDirty();
                }
            }

            public int getUID() {
                return ((Long)this.map.get("_uid")).intValue();
            }

            public String getTitleID() {
                String title;
                String title_id = (String)this.map.get("title_id");
                if (title_id == null && (title = (String)this.map.get("title")).startsWith("!") && title.endsWith("!")) {
                    title_id = title.substring(1, title.length() - 1);
                }
                if (title_id != null && MessageText.getString(title_id) != null) {
                    return title_id;
                }
                return null;
            }

            public String getTitle() {
                String t;
                String t2;
                String title_id = (String)this.map.get("title_id");
                if (title_id != null && (t2 = MessageText.getString(title_id)) != null) {
                    return t2;
                }
                String title = (String)this.map.get("title");
                if (title.startsWith("!") && title.endsWith("!") && (t = MessageText.getString(title.substring(1, title.length() - 1))) != null) {
                    title = t;
                }
                return title;
            }

            public Map<String, Object> getState() {
                return this.map;
            }

            public void setCurrentTab(CTabItem _item) {
                this.item = _item;
                this.title_info = null;
                if (this.item == null) {
                    return;
                }
                Control[] parent = new Control[]{this.item.getControl()};
                LinkedList<Control[]> controls = new LinkedList<Control[]>();
                controls.add(parent);
                block0: while (!controls.isEmpty()) {
                    Control[] cs;
                    Control[] controlArray = cs = (Control[])controls.removeFirst();
                    int n = cs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        UISWTView view = (UISWTView)c.getData("UISWTView");
                        if (view instanceof UISWTViewCore) {
                            this.title_info = ((UISWTViewCore)view).getViewTitleInfo();
                            if (this.title_info != null) continue block0;
                        }
                        if (c instanceof ViewTitleInfo) {
                            this.title_info = (ViewTitleInfo)c;
                            continue block0;
                        }
                        if (c instanceof Composite) {
                            controls.add(((Composite)c).getChildren());
                        }
                        ++n2;
                    }
                }
            }

            private void refresh(ViewTitleInfo info) {
                if (info == this.title_info) {
                    DashboardInstance.this.refreshTabFolder(this);
                }
            }

            @Override
            public CTabItem getTabbedEntryItem() {
                return this.item;
            }

            @Override
            public ViewTitleInfo getTabbedEntryViewTitleInfo() {
                return this.title_info;
            }

            @Override
            public List<TabFolderRenderer.TabbedEntryVitalityImage> getTabbedEntryVitalityImages() {
                return new ArrayList<TabFolderRenderer.TabbedEntryVitalityImage>();
            }

            @Override
            public boolean isTabbedEntryActive() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove(boolean already_disposed) {
                CopyOnWriteList copyOnWriteList = DashboardInstance.this.items;
                synchronized (copyOnWriteList) {
                    DashboardInstance.this.items.remove(this);
                    int[][] layout = DashboardInstance.this.getDashboardLayout();
                    if (DashboardInstance.this.removeUIDFromLayout(layout, this.getUID())) {
                        DashboardInstance.this.setDashboardLayout(layout, DashboardInstance.this.items.size(), true);
                    }
                }
                if (DashboardInstance.this.items.size() == 0 || !already_disposed) {
                    DashboardInstance.this.fireChanged();
                }
            }
        }
    }

    public static interface DashboardListener {
        public void itemsChanged();
    }

    public static class RightBarDashboard
    implements UISWTViewCoreEventListener,
    IViewAlwaysInitialize,
    DashboardListener {
        final SB_Dashboard db = MainMDISetup.getSb_dashboard();
        final DashboardInstance rb = this.db.getRightbarDashboard();
        UISWTView swtView;
        Composite comp;

        @Override
        public void itemsChanged() {
            if (this.rb.getItemCount() == 0) {
                this.swtView.closeView();
            } else {
                Utils.disposeComposite(this.comp, false);
                this.rb.build(this.comp);
                this.comp.layout(true, true);
            }
        }

        @Override
        public boolean eventOccurred(UISWTViewEvent event2) {
            switch (event2.getType()) {
                case 0: {
                    this.swtView = event2.getView();
                    break;
                }
                case 7: {
                    this.rb.removeListener(this);
                    break;
                }
                case 2: {
                    this.comp = (Composite)event2.getData();
                    this.comp.setLayout((Layout)new FormLayout());
                    this.rb.build(this.comp);
                    this.rb.addListener(this);
                    break;
                }
                case 6: {
                    Messages.updateLanguageForControl((Widget)this.comp);
                    break;
                }
            }
            return true;
        }
    }

    public static class SideBarDashboard
    implements UISWTViewCoreEventListener,
    IViewAlwaysInitialize,
    DashboardListener {
        final SB_Dashboard db = MainMDISetup.getSb_dashboard();
        final DashboardInstance sb = this.db.getSidebarDashboard();
        UISWTView swtView;
        Composite comp;

        @Override
        public void itemsChanged() {
            if (this.sb.getItemCount() == 0) {
                this.swtView.closeView();
            } else {
                Utils.disposeComposite(this.comp, false);
                this.sb.build(this.comp);
                this.comp.layout(true, true);
            }
        }

        @Override
        public boolean eventOccurred(UISWTViewEvent event2) {
            switch (event2.getType()) {
                case 0: {
                    this.swtView = event2.getView();
                    break;
                }
                case 7: {
                    this.sb.removeListener(this);
                    break;
                }
                case 2: {
                    this.comp = (Composite)event2.getData();
                    this.comp.setLayout((Layout)new FormLayout());
                    this.sb.build(this.comp);
                    this.sb.addListener(this);
                    break;
                }
                case 6: {
                    Messages.updateLanguageForControl((Widget)this.comp);
                    break;
                }
            }
            return true;
        }
    }

    public static class TopBarDashboard
    implements UISWTViewCoreEventListener,
    IViewAlwaysInitialize,
    DashboardListener {
        final SB_Dashboard db = MainMDISetup.getSb_dashboard();
        final DashboardInstance rb = this.db.getTopbarDashboard();
        UISWTView swtView;
        Composite comp;

        @Override
        public void itemsChanged() {
            if (this.rb.getItemCount() == 0) {
                this.swtView.closeView();
            } else {
                Utils.disposeComposite(this.comp, false);
                this.rb.build(this.comp);
                this.comp.layout(true, true);
            }
        }

        @Override
        public boolean eventOccurred(UISWTViewEvent event2) {
            switch (event2.getType()) {
                case 0: {
                    this.swtView = event2.getView();
                    break;
                }
                case 7: {
                    this.rb.removeListener(this);
                    break;
                }
                case 2: {
                    this.comp = (Composite)event2.getData();
                    this.comp.setLayout((Layout)new FormLayout());
                    this.rb.build(this.comp);
                    this.rb.addListener(this);
                    break;
                }
                case 6: {
                    Messages.updateLanguageForControl((Widget)this.comp);
                    break;
                }
            }
            return true;
        }
    }
}

