/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.swt.mdi.BaseMDI;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectAdapter;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.views.skin.SkinViewManager;

public abstract class SkinView
extends SWTSkinObjectAdapter {
    private boolean shownOnce = false;
    private boolean visible;
    protected SWTSkinObject soMain;
    protected SWTSkin skin;
    private boolean disposed = false;
    private BaseMdiEntry mdiEntry;

    public SkinView() {
        if (this instanceof UIUpdatable) {
            UIUpdatable updateable = (UIUpdatable)((Object)this);
            try {
                UIUpdater updater = UIUpdaterSWT.getInstance();
                if (updater != null) {
                    updater.addUpdater(updateable);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        this.setMainSkinObject(skinObject);
        this.visible = true;
        if (this.shownOnce) {
            return null;
        }
        this.shownOnce = true;
        try {
            return this.skinObjectInitialShow(skinObject, params);
        }
        catch (Exception e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.visible = false;
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.disposed = true;
        SkinViewManager.remove(this);
        if (this instanceof UIUpdatable) {
            UIUpdatable updateable = (UIUpdatable)((Object)this);
            try {
                UIUpdater updater = UIUpdaterSWT.getInstance();
                if (updater != null) {
                    updater.removeUpdater(updateable);
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        return null;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public abstract Object skinObjectInitialShow(SWTSkinObject var1, Object var2);

    public SWTSkinObject getMainSkinObject() {
        return this.soMain;
    }

    @Override
    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        SkinViewManager.add(this);
        this.mdiEntry = BaseMDI.getEntryFromSkinObject(skinObject);
        if (this.mdiEntry != null && this instanceof UIPluginViewToolBarListener) {
            this.mdiEntry.addToolbarEnabler((UIPluginViewToolBarListener)((Object)this));
        }
        return super.skinObjectCreated(skinObject, params);
    }

    public final void setMainSkinObject(SWTSkinObject main) {
        if (this.soMain != null) {
            return;
        }
        this.soMain = main;
        if (this.soMain != null) {
            this.skin = this.soMain.getSkin();
            this.soMain.setSkinView(this);
        }
    }

    public final SWTSkin getSkin() {
        return this.skin;
    }

    public final SWTSkinObject getSkinObject(String viewID) {
        return this.skin.getSkinObject(viewID, this.soMain);
    }

    public BaseMdiEntry getMdiEntry() {
        return this.mdiEntry;
    }
}

