/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.debug.ObfuscateShell;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SkinnedDialog
implements ObfuscateShell {
    private final String shellSkinObjectID;
    private Shell shell;
    private SWTSkin skin;
    private List<SkinnedDialogClosedListener> closeListeners = new CopyOnWriteArrayList<SkinnedDialogClosedListener>();
    private Shell mainShell;
    protected boolean disposed;

    public SkinnedDialog(String skinFile, String shellSkinObjectID) {
        this(skinFile, shellSkinObjectID, 2160);
    }

    public SkinnedDialog(String skinFile, String shellSkinObjectID, int style) {
        this(SkinnedDialog.class.getClassLoader(), skinFile, shellSkinObjectID, style);
    }

    public SkinnedDialog(ClassLoader loader, String skinFile, String shellSkinObjectID, int style) {
        this(loader, "com/biglybt/ui/skin/", skinFile, shellSkinObjectID, style);
    }

    public SkinnedDialog(String skinFile, String shellSkinObjectID, Shell parent, int style) {
        this(SkinnedDialog.class.getClassLoader(), skinFile, shellSkinObjectID, parent, style);
    }

    public SkinnedDialog(ClassLoader loader, String skinFile, String shellSkinObjectID, Shell parent, int style) {
        this(loader, "com/biglybt/ui/skin/", skinFile, shellSkinObjectID, parent, style);
    }

    public SkinnedDialog(ClassLoader cla, String skinPath, String skinFile, String shellSkinObjectID, int style) {
        this(cla, skinPath, skinFile, shellSkinObjectID, UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell(), style);
    }

    public SkinnedDialog(ClassLoader cla, String skinPath, String skinFile, String shellSkinObjectID, Shell parent, int style) {
        if (cla == null) {
            cla = SkinnedDialog.class.getClassLoader();
        }
        this.shellSkinObjectID = shellSkinObjectID;
        this.mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
        this.shell = ShellFactory.createShell(parent, style);
        this.shell.setData("class", (Object)this);
        Utils.setShellIcon(this.shell);
        SWTSkin skin = SWTSkinFactory.getNonPersistentInstance(cla, skinPath, String.valueOf(skinFile) + ".properties");
        this.setSkin(skin);
        skin.initialize((Composite)this.shell, shellSkinObjectID);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    Control c = SkinnedDialog.this.shell.getDisplay().getFocusControl();
                    if (c != null && c.getData("BubbleTextBox::hasContent") != null) {
                        e.doit = false;
                    } else {
                        SkinnedDialog.this.shell.close();
                    }
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SkinnedDialog.this.disposed = true;
                Utils.execSWTThreadLater(0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        for (SkinnedDialogClosedListener l : SkinnedDialog.this.closeListeners) {
                            try {
                                l.skinDialogClosed(SkinnedDialog.this);
                            }
                            catch (Exception e2) {
                                Debug.out(e2);
                            }
                        }
                    }
                });
            }
        });
        this.disposed = false;
    }

    @Override
    public Image generateObfuscatedImage() {
        return UIDebugGenerator.generateObfuscatedImage(this.shell);
    }

    protected void setSkin(SWTSkin _skin) {
        this.skin = _skin;
    }

    public void open() {
        this.open(null, true);
    }

    public void openUnadjusted() {
        this.skin.setAutoSizeOnLayout(false, false);
        this.open("none", true);
    }

    public void open(String idShellMetrics, boolean bringToFront) {
        this.open(idShellMetrics, bringToFront, null);
    }

    public void open(String idShellMetrics, boolean bringToFront, Shell moveBelow) {
        if (this.disposed) {
            Debug.out("can't opened disposed skinnedialog");
            return;
        }
        this.skin.layout();
        if (idShellMetrics != null && !"none".equals(idShellMetrics)) {
            boolean had_metrics = Utils.hasShellMetricsConfig(idShellMetrics);
            Utils.linkShellMetricsToConfig(this.shell, idShellMetrics);
            if (!had_metrics) {
                Utils.centerWindowRelativeTo(this.shell, (Control)this.mainShell);
                Utils.verifyShellRect(this.shell, true);
            }
        } else if (idShellMetrics == null) {
            Utils.centerWindowRelativeTo(this.shell, (Control)this.mainShell);
            Utils.verifyShellRect(this.shell, true);
        }
        this.shell.setData("bringToFront", (Object)bringToFront);
        if (moveBelow == null) {
            this.shell.open();
        } else {
            this.shell.moveBelow((Control)moveBelow);
            this.shell.setVisible(true);
        }
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public void close() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SkinnedDialog.this.disposed) {
                    return;
                }
                if (SkinnedDialog.this.shell != null && !SkinnedDialog.this.shell.isDisposed()) {
                    SkinnedDialog.this.shell.close();
                }
            }
        });
    }

    public void addCloseListener(SkinnedDialogClosedListener l) {
        this.closeListeners.add(l);
    }

    public void setTitle(String string) {
        if (!this.disposed && this.shell != null && !this.shell.isDisposed()) {
            this.shell.setText(string);
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public boolean isDisposed() {
        return this.disposed || this.shell == null || this.shell.isDisposed();
    }

    public static interface SkinnedDialogClosedListener {
        public void skinDialogClosed(SkinnedDialog var1);
    }
}

