/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AERunnableBoolean;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.toolbar.UIToolBarActivationListener;
import com.biglybt.pif.ui.toolbar.UIToolBarEnablerBase;
import com.biglybt.pif.ui.toolbar.UIToolBarItem;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.ISelectedVuzeFileContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pifimpl.UIToolBarItemImpl;
import com.biglybt.ui.swt.pifimpl.UIToolBarManagerCore;
import com.biglybt.ui.swt.pifimpl.UIToolBarManagerImpl;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.toolbar.ToolBarItemSO;
import com.biglybt.ui.swt.utils.SWTRunnable;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.skin.TorrentListViewsUtils;
import com.biglybt.util.JSONUtils;
import com.biglybt.util.PlayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.json.simple.JSONObject;

public class ToolBarView
extends SkinView
implements SelectedContentListener,
UIToolBarManagerImpl.ToolBarManagerListener,
ToolBarItem.ToolBarItemListener,
ParameterListener {
    private static boolean DEBUG = false;
    private static toolbarButtonListener buttonListener;
    private Map<UIToolBarItem, ToolBarItemSO> itemMap = new HashMap<UIToolBarItem, ToolBarItemSO>();
    private boolean showText = true;
    private boolean initComplete = false;
    private boolean rebuilding;
    private boolean rebuild_pending;
    private boolean showCalled = false;
    private ArrayList<ToolBarViewListener> listeners = new ArrayList(1);
    private UIToolBarManagerCore tbm;
    private boolean firstTimeEver = true;
    private Set<String> visible_items = new HashSet<String>();
    private List<String> item_listeners = new ArrayList<String>();
    private FrequencyLimitedDispatcher refresh_limiter = new FrequencyLimitedDispatcher(new AERunnable(){
        private AERunnable lock = this;
        private boolean refresh_pending;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSupport() {
            AERunnable aERunnable = this.lock;
            synchronized (aERunnable) {
                if (this.refresh_pending) {
                    return;
                }
                this.refresh_pending = true;
            }
            if (DEBUG) {
                System.out.println("refreshCoreItems via " + Debug.getCompressedStackTrace());
            }
            Utils.execSWTThread(new SWTRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runNoDisplay() {
                    AERunnable aERunnable = lock;
                    synchronized (aERunnable) {
                        refresh_pending = false;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runWithDisplay(Display display) {
                    AERunnable aERunnable = lock;
                    synchronized (aERunnable) {
                        refresh_pending = false;
                    }
                    ToolBarView.this._refreshCoreToolBarItems();
                }
            });
        }
    }, 250);
    private IdentityHashMap<DownloadManager, DownloadManagerListener> dm_listener_map = new IdentityHashMap();
    private SWTSkinObject soLastGroup;

    public ToolBarView() {
        this.tbm = (UIToolBarManagerCore)UIToolBarManagerImpl.getInstance();
    }

    private ToolBarItem createItem(ToolBarView tbv, String id, String imageid, String textID) {
        UIToolBarItemImpl base = new UIToolBarItemImpl(id);
        base.setImageID(imageid);
        base.setTextID(textID);
        return base;
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        if (uiClassic && !"global-toolbar".equals(skinObject.getViewID())) {
            skinObject.setVisible(false);
            return null;
        }
        SWTSkinObject temp = skinObject;
        while (temp != null) {
            int visible = temp.getSkin().getSkinProperties().getIntValue("mdientry.toolbar.visible", 1);
            if (visible == 0) {
                skinObject.setVisible(false);
                return null;
            }
            temp = temp.getParent();
        }
        buttonListener = new toolbarButtonListener();
        if (this.firstTimeEver) {
            this.firstTimeEver = false;
            if (!uiClassic) {
                COConfigurationManager.addParameterListener("IconBar.enabled", (ParameterListener)this);
            }
            this.setupToolBarItems(uiClassic);
            TorrentUtil.init();
        }
        this.tbm.addListener(this);
        this.rebuild();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(Map<UIToolBarItem, ToolBarItemSO> newMap) {
        String[] groupIDs;
        String[] id;
        this.soLastGroup = null;
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        UIToolBarItem[] items = this.tbm.getAllToolBarItems();
        this.removeItemListeners();
        this.visible_items.clear();
        this.addItemListener("IconBar.start.stop.separate");
        boolean start_top_sep = COConfigurationManager.getBooleanParameter("IconBar.start.stop.separate", false);
        UIToolBarItem[] uIToolBarItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            UIToolBarItem item = uIToolBarItemArray[n2];
            id = item.getID();
            String key = "IconBar.visible." + (String)id;
            this.addItemListener(key);
            if (!(!COConfigurationManager.getBooleanParameter(key, true) || start_top_sep && id.equals("startstop") || !start_top_sep && (id.equals("start") || id.equals("stop")))) {
                this.visible_items.add((String)id);
            }
            ++n2;
        }
        if (uiClassic || !COConfigurationManager.getBooleanParameter("IconBar.enabled")) {
            this.bulkSetupItems(newMap, "classic", "toolbar.area.sitem");
        }
        this.bulkSetupItems(newMap, "main", "toolbar.area.sitem");
        this.bulkSetupItems(newMap, "views", "toolbar.area.vitem");
        id = groupIDs = this.tbm.getGroupIDs();
        int n3 = groupIDs.length;
        n = 0;
        while (n < n3) {
            String groupID = id[n];
            if (!("classic".equals(groupID) || "main".equals(groupID) || "views".equals(groupID))) {
                this.bulkSetupItems(newMap, groupID, "toolbar.area.sitem");
            }
            ++n;
        }
        this.initComplete = true;
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (ToolBarViewListener l : this.listeners) {
                try {
                    l.toolbarViewInitialized(this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        Map<UIToolBarItem, ToolBarItemSO> map = this.itemMap;
        synchronized (map) {
            if (this.rebuilding) {
                this.rebuild_pending = true;
                return;
            }
            this.rebuilding = true;
        }
        Utils.execSWTThread(() -> {
            Map<UIToolBarItem, ToolBarItemSO> map = this.itemMap;
            synchronized (map) {
                HashSet<String> groups = new HashSet<String>();
                for (ToolBarItemSO so : this.itemMap.values()) {
                    groups.add(so.getBase().getGroupID());
                }
                this.itemMap.clear();
                for (String group : groups) {
                    SWTSkinObject[] children;
                    SWTSkinObjectContainer groupSO = this.peekGroupSO(group);
                    if (groupSO == null) continue;
                    SWTSkinObject[] sWTSkinObjectArray = children = groupSO.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SWTSkinObject so = sWTSkinObjectArray[n2];
                        so.dispose();
                        ++n2;
                    }
                    groupSO.dispose();
                }
            }
            HashMap<UIToolBarItem, ToolBarItemSO> newMap = new HashMap<UIToolBarItem, ToolBarItemSO>();
            try {
                this.skin.constructionStart();
                this.build(newMap);
            }
            finally {
                this.skin.constructionEnd();
            }
            Composite comp2 = (Composite)this.soMain.getControl();
            this.addMenus(comp2);
            Utils.relayout((Control)comp2);
            Map<UIToolBarItem, ToolBarItemSO> map2 = this.itemMap;
            synchronized (map2) {
                this.itemMap.putAll(newMap);
                this.rebuilding = false;
                if (this.rebuild_pending) {
                    this.rebuild_pending = false;
                    Utils.getOffOfSWTThread(() -> this.rebuild());
                }
            }
        });
    }

    private void addMenus(Composite comp2) {
        Control[] controlArray = comp2.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control kid = controlArray[n2];
            Menu menu = kid.getMenu();
            if (menu != null) {
                menu.dispose();
            }
            menu = new Menu(kid);
            kid.setMenu(menu);
            MenuItem mi = new MenuItem(menu, 8);
            mi.setText(MessageText.getString("menu.toolbar.options"));
            mi.addListener(13, ev -> {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    JSONObject args = new JSONObject();
                    args.put("select", "section-toolbar");
                    String args_str = JSONUtils.encodeToJSON(args);
                    uif.getMDI().showEntryByID("ConfigView", "display" + args_str);
                }
            });
            if (kid instanceof Composite) {
                this.addMenus((Composite)kid);
            }
            ++n2;
        }
    }

    private void setupToolBarItems(boolean uiClassic) {
        ToolBarItem item = this.createItem(this, "open", "image.toolbar.open", "Button.add.torrent");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            @Override
            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType != 0L) {
                    Boolean result = Utils.execSWTThreadWithBool("open", new AERunnableBoolean(){

                        @Override
                        public boolean runSupport() {
                            Clipboard clipboard = new Clipboard(Display.getDefault());
                            try {
                                String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                                if (text != null && text.length() <= 2048 && TorrentOpener.openTorrentsFromClipboard(text)) {
                                    return true;
                                }
                            }
                            finally {
                                clipboard.dispose();
                            }
                            return false;
                        }
                    }, 1000L);
                    return result != null && result != false;
                }
                UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
                return true;
            }
        });
        item.setAlwaysAvailable(true);
        item.setGroupID("classic");
        this.tbm.addToolBarItem(item, false);
        item = this.createItem(this, "search", "search", "Button.search");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            @Override
            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType != 0L) {
                    return false;
                }
                UIFunctionsManagerSWT.getUIFunctionsSWT().promptForSearch();
                return true;
            }
        });
        item.setAlwaysAvailable(true);
        item.setGroupID("classic");
        this.tbm.addToolBarItem(item, false);
        if (!uiClassic) {
            item = this.createItem(this, "play", "image.button.play", "iconBar.play");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                @Override
                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
                    if (sc != null && sc.length > 0) {
                        if (PlayUtils.canStreamDS(sc[0], sc[0].getFileIndex(), true)) {
                            TorrentListViewsUtils.playOrStreamDataSource(sc[0], "toolbar", true, false);
                        } else {
                            TorrentListViewsUtils.playOrStreamDataSource(sc[0], "toolbar", false, true);
                        }
                    }
                    return false;
                }
            });
            this.tbm.addToolBarItem(item, false);
        }
        item = this.createItem(this, "run", "image.toolbar.run", "iconBar.run");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            @Override
            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType != 0L) {
                    return false;
                }
                TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                Object[] ds = tv != null ? tv.getSelectedDataSources().toArray() : SelectedContentManager.getDMSFromSelectedContent();
                if (ds != null) {
                    TorrentUtil.runDataSources(ds);
                    return true;
                }
                return false;
            }
        });
        this.tbm.addToolBarItem(item, false);
        if (uiClassic) {
            item = this.createItem(this, "top", "image.toolbar.top", "iconBar.top");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                @Override
                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType == 0L) {
                        return ToolBarView.this.moveTop();
                    }
                    return false;
                }
            });
            this.tbm.addToolBarItem(item, false);
        }
        item = this.createItem(this, "up", "image.toolbar.up", "iconBar.up");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            @Override
            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType == 0L) {
                    if (!CoreFactory.isCoreRunning()) {
                        return false;
                    }
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return a.getPosition() - b.getPosition();
                            }
                        });
                        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                        int i = 0;
                        while (i < dms.length) {
                            DownloadManager dm = dms[i];
                            if (gm.isMoveableUp(dm)) {
                                gm.moveUp(dm);
                            }
                            ++i;
                        }
                    }
                } else if (activationType == 1L) {
                    return ToolBarView.this.moveTop();
                }
                return false;
            }
        });
        this.tbm.addToolBarItem(item, false);
        item = this.createItem(this, "down", "image.toolbar.down", "iconBar.down");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            @Override
            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType == 0L) {
                    if (!CoreFactory.isCoreRunning()) {
                        return false;
                    }
                    GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return b.getPosition() - a.getPosition();
                            }
                        });
                        int i = 0;
                        while (i < dms.length) {
                            DownloadManager dm = dms[i];
                            if (gm.isMoveableDown(dm)) {
                                gm.moveDown(dm);
                            }
                            ++i;
                        }
                        return true;
                    }
                } else if (activationType == 1L) {
                    return ToolBarView.this.moveBottom();
                }
                return false;
            }
        });
        this.tbm.addToolBarItem(item, false);
        if (uiClassic) {
            item = this.createItem(this, "bottom", "image.toolbar.bottom", "iconBar.bottom");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                @Override
                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    return ToolBarView.this.moveBottom();
                }
            });
            this.tbm.addToolBarItem(item, false);
        }
        item = this.createItem(this, "start", "image.toolbar.startstop.start", "iconBar.start");
        item.setDefaultActivationListener(new UIToolBarActivationListener_OffSWT(){

            @Override
            public void toolBarItemActivated_OffSWT(ToolBarItem item, long activationType, Object datasource) {
                Object[] selected = SelectedContentManager.getCurrentlySelectedContent();
                TorrentUtil.queueDataSources(selected, activationType == 1L);
            }
        });
        this.tbm.addToolBarItem(item, false);
        item = this.createItem(this, "stop", "image.toolbar.startstop.stop", "iconBar.stop");
        item.setDefaultActivationListener(new UIToolBarActivationListener_OffSWT(){

            @Override
            public void toolBarItemActivated_OffSWT(ToolBarItem item, long activationType, Object datasource) {
                Object[] selected = SelectedContentManager.getCurrentlySelectedContent();
                TorrentUtil.stopDataSources(selected, activationType == 1L);
            }
        });
        this.tbm.addToolBarItem(item, false);
        item = this.createItem(this, "startstop", "image.toolbar.startstop.start", "iconBar.startstop");
        item.setDefaultActivationListener(new UIToolBarActivationListener_OffSWT(){

            @Override
            public void toolBarItemActivated_OffSWT(ToolBarItem item, long activationType, Object datasource) {
                Object[] selected = SelectedContentManager.getCurrentlySelectedContent();
                TorrentUtil.stopOrStartDataSources(selected, activationType == 1L);
            }
        });
        this.tbm.addToolBarItem(item, false);
        item = this.createItem(this, "remove", "image.toolbar.remove", "iconBar.remove");
        item.setDefaultActivationListener(new UIToolBarActivationListener_OffSWT(0L){

            @Override
            public void toolBarItemActivated_OffSWT(ToolBarItem item, long activationType, Object datasource) {
                Object[] selected = SelectedContentManager.getCurrentlySelectedContent();
                TorrentUtil.removeDataSources(selected);
            }
        });
        this.tbm.addToolBarItem(item, false);
        if (COConfigurationManager.getBooleanParameter("Library.EnableSimpleView")) {
            item = this.createItem(this, "modeBig", "image.toolbar.table_large", "v3.iconBar.view.big");
            item.setGroupID("views");
            this.tbm.addToolBarItem(item, false);
            item = this.createItem(this, "modeSmall", "image.toolbar.table_normal", "v3.iconBar.view.small");
            item.setGroupID("views");
            this.tbm.addToolBarItem(item, false);
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.rebuild();
    }

    @Override
    public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
        this.refreshCoreToolBarItems();
        UIFunctionsSWT uiFunctionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctionsSWT != null) {
            uiFunctionsSWT.refreshTorrentMenu();
        }
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        if (this.showCalled) {
            return null;
        }
        this.showCalled = true;
        Object object = super.skinObjectShown(skinObject, params);
        this.addActiveListeners();
        return object;
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.showCalled = false;
        this.removeActiveListeners();
        return super.skinObjectHidden(skinObject, params);
    }

    private void addActiveListeners() {
        ToolBarItem[] allToolBarItems = this.tbm.getAllSWTToolBarItems();
        int i = 0;
        while (i < allToolBarItems.length) {
            ToolBarItem toolBarItem = allToolBarItems[i];
            toolBarItem.addToolBarItemListener(this);
            this.uiFieldChanged(toolBarItem);
            ++i;
        }
        SelectedContentManager.addCurrentlySelectedContentListener(this);
    }

    private void removeActiveListeners() {
        SelectedContentManager.removeCurrentlySelectedContentListener(this);
        ToolBarItem[] allToolBarItems = this.tbm.getAllSWTToolBarItems();
        int i = 0;
        while (i < allToolBarItems.length) {
            ToolBarItem toolBarItem = allToolBarItems[i];
            toolBarItem.removeToolBarItemListener(this);
            ++i;
        }
    }

    private void addItemListener(String key) {
        this.item_listeners.add(key);
        COConfigurationManager.addParameterListener(key, (ParameterListener)this);
    }

    private void removeItemListeners() {
        for (String key : this.item_listeners) {
            COConfigurationManager.removeParameterListener(key, this);
        }
        this.item_listeners.clear();
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.tbm.removeListener(this);
        this.removeItemListeners();
        this.removeActiveListeners();
        COConfigurationManager.removeParameterListener("IconBar.enabled", this);
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public boolean triggerToolBarItem(ToolBarItem item, long activationType, Object datasource) {
        if (!this.isVisible()) {
            if (DEBUG) {
                Debug.out("Trying to triggerToolBarItem when toolbar is not visible");
            }
            return false;
        }
        if (this.triggerViewToolBar(item, activationType, datasource)) {
            return true;
        }
        UIToolBarActivationListener defaultActivation = item.getDefaultActivationListener();
        if (defaultActivation != null) {
            return defaultActivation.toolBarItemActivated(item, activationType, datasource);
        }
        if (DEBUG) {
            String viewID = SelectedContentManager.getCurrentySelectedViewID();
            System.out.println("Warning: Fallback of toolbar button " + item.getID() + " via " + viewID + " view");
        }
        return false;
    }

    protected boolean moveBottom() {
        if (!CoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            gm.moveEnd(dms);
        }
        return true;
    }

    protected boolean moveTop() {
        if (!CoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            gm.moveTop(dms);
        }
        return true;
    }

    public void refreshCoreToolBarItems() {
        if (DEBUG) {
            System.out.println("refreshCoreItems Start via " + Debug.getCompressedStackTrace());
        }
        this.refresh_limiter.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _refreshCoreToolBarItems() {
        UIFunctionsSWT uiFunctionsSWT;
        MultipleDocumentInterfaceSWT mdi;
        if (DEBUG && !this.isVisible()) {
            Debug.out("Trying to refresh core toolbar items when toolbar is not visible " + this + this.getMainSkinObject());
        }
        MultipleDocumentInterfaceSWT multipleDocumentInterfaceSWT = mdi = (uiFunctionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null ? uiFunctionsSWT.getMDISWT() : null;
        if (mdi != null) {
            String[] TBKEYS;
            int can_start;
            UIToolBarItem ssItem;
            UIToolBarItem stopItem;
            UIToolBarItem startItem;
            Object[] currentContent;
            UIToolBarItem[] allToolBarItems = this.tbm.getAllToolBarItems();
            MdiEntrySWT entry = mdi.getSelectedEntry();
            HashMap<String, Long> mapStates = new HashMap<String, Long>();
            if (entry != null) {
                UIToolBarEnablerBase[] enablers;
                UIToolBarEnablerBase[] uIToolBarEnablerBaseArray = enablers = entry.getToolbarEnablers();
                int n = enablers.length;
                int n2 = 0;
                while (n2 < n) {
                    UIToolBarEnablerBase enabler = uIToolBarEnablerBaseArray[n2];
                    if (enabler instanceof UIPluginViewToolBarListener) {
                        try {
                            ((UIPluginViewToolBarListener)enabler).refreshToolBarItems(mapStates);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    ++n2;
                }
            }
            boolean allFiles = (currentContent = SelectedContentManager.getCurrentlySelectedContent()).length > 0;
            IdentityHashMap<DownloadManager, DownloadManagerListener> identityHashMap = this.dm_listener_map;
            synchronized (identityHashMap) {
                IdentityHashMap<DownloadManager, DownloadManagerListener> copy = new IdentityHashMap<DownloadManager, DownloadManagerListener>(this.dm_listener_map);
                Object[] objectArray = currentContent;
                int n = currentContent.length;
                int e = 0;
                while (e < n) {
                    ISelectedContent content = objectArray[e];
                    DownloadManager dm = content.getDownloadManager();
                    if (dm != null) {
                        if (content.getFileIndex() == -1) {
                            allFiles = false;
                        }
                        copy.remove(dm);
                        if (!this.dm_listener_map.containsKey(dm)) {
                            DownloadManagerListener l = new DownloadManagerListener(){

                                @Override
                                public void stateChanged(DownloadManager manager, int state) {
                                    ToolBarView.this.refreshCoreToolBarItems();
                                }

                                @Override
                                public void downloadComplete(DownloadManager manager) {
                                    ToolBarView.this.refreshCoreToolBarItems();
                                }

                                @Override
                                public void completionChanged(DownloadManager manager, boolean bCompleted) {
                                    ToolBarView.this.refreshCoreToolBarItems();
                                }

                                @Override
                                public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                                    ToolBarView.this.refreshCoreToolBarItems();
                                }

                                @Override
                                public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
                                    ToolBarView.this.refreshCoreToolBarItems();
                                }
                            };
                            dm.addListener(l, false);
                            this.dm_listener_map.put(dm, l);
                        }
                    }
                    ++e;
                }
                for (Map.Entry e2 : copy.entrySet()) {
                    DownloadManager dm = (DownloadManager)e2.getKey();
                    dm.removeListener((DownloadManagerListener)e2.getValue());
                    this.dm_listener_map.remove(dm);
                }
            }
            boolean has1Selection = currentContent.length == 1;
            boolean can_play = false;
            boolean can_stream = false;
            boolean stream_permitted = false;
            if (has1Selection && !(currentContent[0] instanceof ISelectedVuzeFileContent)) {
                can_play = PlayUtils.canPlayDS(currentContent[0], currentContent[0].getFileIndex(), false);
                can_stream = PlayUtils.canStreamDS(currentContent[0], currentContent[0].getFileIndex(), false);
                if (can_stream) {
                    stream_permitted = PlayUtils.isStreamPermitted();
                }
            }
            if (mapStates.containsKey("play")) {
                can_play |= ((Long)mapStates.get("play") & 1L) > 0L;
            }
            if (mapStates.containsKey("stream")) {
                can_stream |= ((Long)mapStates.get("stream") & 1L) > 0L;
            }
            mapStates.put("play", can_play | can_stream ? 1L : 0L);
            UIToolBarItem pitem = this.tbm.getToolBarItem("play");
            if (pitem != null) {
                if (can_stream) {
                    pitem.setImageID(stream_permitted ? "image.button.stream" : "image.button.pstream");
                    pitem.setTextID(stream_permitted ? "iconBar.stream" : "iconBar.pstream");
                } else {
                    pitem.setImageID("image.button.play");
                    pitem.setTextID("iconBar.play");
                }
            }
            if ((startItem = this.tbm.getToolBarItem("start")) != null) {
                startItem.setTextID(allFiles ? "iconBar.startFiles" : "iconBar.start");
            }
            if ((stopItem = this.tbm.getToolBarItem("stop")) != null) {
                stopItem.setTextID(allFiles ? "iconBar.stopFiles" : "iconBar.stop");
            }
            if ((ssItem = this.tbm.getToolBarItem("startstop")) != null) {
                boolean shouldStopGroup = false;
                boolean use_other_states = false;
                if (currentContent.length == 0) {
                    use_other_states = true;
                } else {
                    Boolean test = TorrentUtil.shouldStopGroupTest(currentContent);
                    if (test == null) {
                        use_other_states = true;
                    } else {
                        shouldStopGroup = test;
                    }
                }
                if (use_other_states) {
                    shouldStopGroup = !mapStates.containsKey("start") || ((Long)mapStates.get("start") & 1L) <= 0L || mapStates.containsKey("stop") && ((Long)mapStates.get("stop") & 1L) != 0L;
                }
                if (allFiles) {
                    ssItem.setTextID(shouldStopGroup ? "iconBar.stopFiles" : "iconBar.startFiles");
                } else {
                    ssItem.setTextID(shouldStopGroup ? "iconBar.stop" : "iconBar.start");
                }
                ssItem.setImageID("image.toolbar.startstop." + (shouldStopGroup ? "stop" : "start"));
                if (currentContent.length == 0 && !mapStates.containsKey("startstop")) {
                    boolean can_stop = mapStates.containsKey("stop") && ((Long)mapStates.get("stop") & 1L) > 0L;
                    int n = can_start = mapStates.containsKey("start") && ((Long)mapStates.get("start") & 1L) > 0L ? 1 : 0;
                    if (can_start != 0 && can_stop) {
                        can_stop = false;
                    }
                    if (can_start != 0 || can_stop) {
                        ssItem.setTextID(can_stop ? "iconBar.stop" : "iconBar.start");
                        ssItem.setImageID("image.toolbar.startstop." + (can_stop ? "stop" : "start"));
                        mapStates.put("startstop", 1L);
                    }
                }
            }
            Map<String, Long> fallBackStates = TorrentUtil.calculateToolbarStates((ISelectedContent[])currentContent, null);
            for (String key : fallBackStates.keySet()) {
                if (mapStates.containsKey(key)) continue;
                mapStates.put(key, fallBackStates.get(key));
            }
            String[] stringArray = TBKEYS = new String[]{"play", "run", "top", "up", "down", "bottom", "start", "stop", "startstop", "remove"};
            int n = TBKEYS.length;
            can_start = 0;
            while (can_start < n) {
                String key = stringArray[can_start];
                if (!mapStates.containsKey(key)) {
                    mapStates.put(key, 0L);
                }
                ++can_start;
            }
            int i = 0;
            while (i < allToolBarItems.length) {
                UIToolBarItem toolBarItem = allToolBarItems[i];
                Long state = (Long)mapStates.get(toolBarItem.getID());
                if (state != null) {
                    toolBarItem.setState(state);
                }
                ++i;
            }
        }
    }

    private boolean triggerViewToolBar(ToolBarItem item, long activationType, Object datasource) {
        MdiEntrySWT entry;
        if (DEBUG && !this.isVisible()) {
            Debug.out("Trying to triggerViewToolBar when toolbar is not visible");
            return false;
        }
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getSelectedEntry()) != null) {
            UIToolBarEnablerBase[] enablers;
            UIToolBarEnablerBase[] uIToolBarEnablerBaseArray = enablers = entry.getToolbarEnablers();
            int n = enablers.length;
            int n2 = 0;
            while (n2 < n) {
                UIToolBarEnablerBase enabler = uIToolBarEnablerBaseArray[n2];
                if (enabler instanceof UIPluginViewToolBarListener && ((UIPluginViewToolBarListener)enabler).toolBarItemActivated(item, activationType, datasource)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void bulkSetupItems(Map<UIToolBarItem, ToolBarItemSO> newMap, String groupID, String templatePrefix) {
        int n;
        int n2;
        Object[] objectArray;
        String[] idsByGroupAll = this.tbm.getToolBarIDsByGroup(groupID);
        SWTSkinObjectContainer groupSO = this.peekGroupSO(groupID);
        if (groupSO != null) {
            SWTSkinObject[] children = groupSO.getChildren();
            objectArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                Object so = objectArray[n];
                so.dispose();
                ++n;
            }
        }
        ArrayList<Object> idsByGroup = new ArrayList<Object>();
        objectArray = idsByGroupAll;
        n2 = idsByGroupAll.length;
        n = 0;
        while (n < n2) {
            Object id = objectArray[n];
            if (this.visible_items.contains(id)) {
                idsByGroup.add(id);
            }
            ++n;
        }
        int size = idsByGroup.size();
        if (size > 0) {
            groupSO = this.getGroupSO(groupID);
            int i = 0;
            while (i < size) {
                String itemID = (String)idsByGroup.get(i);
                UIToolBarItem item = this.tbm.getToolBarItem(itemID);
                if (item instanceof ToolBarItem) {
                    int position = 0;
                    if (size == 1) {
                        position = 4;
                    } else if (i == 0) {
                        position = 16384;
                    } else if (i == size - 1) {
                        this.addSeperator(groupID);
                        position = 131072;
                    } else {
                        this.addSeperator(groupID);
                    }
                    this.createItemSO(newMap, (ToolBarItem)item, templatePrefix, position);
                }
                ++i;
            }
            this.addNonToolBar("toolbar.area.sitem.left2", groupID);
        }
    }

    private Control getLastControl(String groupID) {
        SWTSkinObjectContainer groupSO = this.getGroupSO(groupID);
        SWTSkinObject[] children = groupSO.getChildren();
        if (children == null || children.length == 0) {
            return null;
        }
        return children[children.length - 1].getControl();
    }

    private void createItemSO(Map<UIToolBarItem, ToolBarItemSO> newMap, ToolBarItem item, String templatePrefix, int position) {
        SWTSkinObject so;
        ToolBarItemSO existingItemSO = newMap.get(item);
        if (existingItemSO != null && (so = existingItemSO.getSO()) != null) {
            so.dispose();
        }
        String templateID = templatePrefix;
        if (position == 131072) {
            templateID = String.valueOf(templateID) + ".right";
        } else if (position == 16384) {
            templateID = String.valueOf(templateID) + ".left";
        } else if (position == 4) {
            templateID = String.valueOf(templateID) + ".lr";
        }
        Control attachToControl = this.getLastControl(item.getGroupID());
        String id = "toolbar:" + item.getID();
        SWTSkinObject so2 = this.skin.createSkinObject(id, templateID, this.getGroupSO(item.getGroupID()));
        if (so2 != null) {
            ToolBarItemSO itemSO = new ToolBarItemSO((UIToolBarItemImpl)item, so2);
            if (attachToControl != null) {
                FormData fd = (FormData)so2.getControl().getLayoutData();
                fd.left = new FormAttachment(attachToControl);
            }
            this.initSO(newMap, so2, itemSO);
            if (this.initComplete) {
                Utils.relayout((Control)so2.getControl().getParent());
            }
        }
    }

    private SWTSkinObjectContainer peekGroupSO(String groupID) {
        String soID = "toolbar-group-" + groupID;
        SWTSkinObjectContainer soGroup = (SWTSkinObjectContainer)this.skin.getSkinObjectByID(soID, this.soMain);
        return soGroup;
    }

    private SWTSkinObjectContainer getGroupSO(String groupID) {
        String soID = "toolbar-group-" + groupID;
        SWTSkinObjectContainer soGroup = (SWTSkinObjectContainer)this.skin.getSkinObjectByID(soID, this.soMain);
        if (soGroup == null) {
            soGroup = (SWTSkinObjectContainer)this.skin.createSkinObject(soID, "toolbar.group", this.soMain);
            FormData fd = (FormData)soGroup.getControl().getLayoutData();
            fd.left = this.soLastGroup != null ? new FormAttachment(this.soLastGroup.getControl(), 0, 131072) : new FormAttachment(0, 2);
        }
        this.soLastGroup = soGroup;
        return soGroup;
    }

    private void initSO(Map<UIToolBarItem, ToolBarItemSO> newMap, SWTSkinObject so, ToolBarItemSO itemSO) {
        ToolBarItem item = itemSO.getBase();
        itemSO.setSO(so);
        String toolTip = item.getToolTip();
        if (toolTip != null) {
            so.setTooltipID("!" + toolTip + "!");
        } else {
            so.setTooltipID(item.getToolTipID());
        }
        so.setData("toolbaritem", item);
        SWTSkinButtonUtility btn = (SWTSkinButtonUtility)so.getData("btn");
        if (btn == null) {
            btn = new SWTSkinButtonUtility(so, "toolbar-item-image");
            so.setData("btn", btn);
        }
        btn.setImage(item.getImageID());
        btn.addSelectionListener(buttonListener);
        itemSO.setSkinButton(btn);
        SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
        if (soTitle instanceof SWTSkinObjectText) {
            ((SWTSkinObjectText)soTitle).setTextID(item.getTextID());
            itemSO.setSkinTitle((SWTSkinObjectText)soTitle);
        }
        newMap.put(item, itemSO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uiFieldChanged(ToolBarItem item) {
        ToolBarItemSO itemSO;
        Map<UIToolBarItem, ToolBarItemSO> map = this.itemMap;
        synchronized (map) {
            itemSO = this.itemMap.get(item);
        }
        if (itemSO != null) {
            itemSO.updateUI();
        }
    }

    private void addSeperator(String groupID) {
        this.addSeperator("toolbar.area.sitem.sep", groupID);
    }

    private void addSeperator(String id, String groupID) {
        SWTSkinObjectContainer soGroup = this.getGroupSO(groupID);
        Control lastControl = this.getLastControl(groupID);
        SWTSkinObject so = this.skin.createSkinObject("toolbar_sep" + Math.random(), id, soGroup);
        if (so != null && lastControl != null) {
            FormData fd = (FormData)so.getControl().getLayoutData();
            fd.left = new FormAttachment(lastControl, fd.left == null ? 0 : fd.left.offset);
        }
    }

    private void addNonToolBar(String skinid, String groupID) {
        SWTSkinObjectContainer soGroup = this.getGroupSO(groupID);
        Control lastControl = this.getLastControl(groupID);
        SWTSkinObject so = this.skin.createSkinObject("toolbar_d" + Math.random(), skinid, soGroup);
        if (so != null && lastControl != null) {
            FormData fd = (FormData)so.getControl().getLayoutData();
            fd.left = new FormAttachment(lastControl, fd.left == null ? 0 : fd.left.offset);
        }
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
        UIToolBarItem[] allToolBarItems = this.tbm.getAllToolBarItems();
        int i = 0;
        while (i < allToolBarItems.length) {
            UIToolBarItem tbi = allToolBarItems[i];
            SWTSkinObject so = ((ToolBarItemSO)((Object)tbi)).getSkinButton().getSkinObject();
            SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
            if (soTitle != null) {
                soTitle.setVisible(showText);
            }
            ++i;
        }
    }

    public boolean getShowText() {
        return this.showText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ToolBarViewListener l) {
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
            if (this.initComplete) {
                try {
                    l.toolbarViewInitialized(this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ToolBarViewListener l) {
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void toolbarItemRemoved(UIToolBarItem toolBarItem) {
        this.rebuild();
    }

    @Override
    public void toolbarItemAdded(UIToolBarItem item) {
        if (this.isVisible() && item instanceof ToolBarItem) {
            ToolBarItem toolBarItem = (ToolBarItem)item;
            toolBarItem.addToolBarItemListener(this);
        }
        this.rebuild();
    }

    public static interface ToolBarViewListener {
        public void toolbarViewInitialized(ToolBarView var1);
    }

    public static abstract class UIToolBarActivationListener_OffSWT
    implements UIToolBarActivationListener {
        private long onlyOnActivationType;

        public UIToolBarActivationListener_OffSWT(long onlyOnActivationType) {
            this.onlyOnActivationType = onlyOnActivationType;
        }

        public UIToolBarActivationListener_OffSWT() {
            this.onlyOnActivationType = -1L;
        }

        @Override
        public final boolean toolBarItemActivated(final ToolBarItem item, final long activationType, final Object datasource) {
            if (this.onlyOnActivationType >= 0L && activationType != this.onlyOnActivationType) {
                return false;
            }
            Utils.getOffOfSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    this.toolBarItemActivated_OffSWT(item, activationType, datasource);
                }
            });
            return true;
        }

        public abstract void toolBarItemActivated_OffSWT(ToolBarItem var1, long var2, Object var4);
    }

    private class toolbarButtonListener
    extends SWTSkinButtonUtility.ButtonListenerAdapter {
        private toolbarButtonListener() {
        }

        @Override
        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int button, int stateMask) {
            if (button != 1) {
                return;
            }
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            boolean rightClick = (stateMask & (0x200000 | SWT.MOD4)) > 0;
            Object o = SelectedContentManager.convertSelectedContentToObject(null);
            item.triggerToolBarItem(rightClick ? 2L : 0L, o);
        }

        @Override
        public boolean held(SWTSkinButtonUtility buttonUtility) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            buttonUtility.getSkinObject().switchSuffix("", 0, false, true);
            Object o = SelectedContentManager.convertSelectedContentToObject(null);
            boolean triggerToolBarItemHold = item.triggerToolBarItem(1L, o);
            return triggerToolBarItemHold;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entered(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
            ToolBarItemSO item_so;
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            Map map = ToolBarView.this.itemMap;
            synchronized (map) {
                item_so = (ToolBarItemSO)ToolBarView.this.itemMap.get(item);
            }
            if (item_so != null) {
                if ((stateMask & 0x40000) != 0) {
                    String str = SelectedContentManager.getCurrentlySelectedContentDetails();
                    item_so.setToolTip("!" + str + "!");
                } else {
                    item_so.setToolTip(null);
                }
            }
        }
    }
}

