/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener;
import com.biglybt.ui.mdi.MdiEntryDropListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.browser.BrowserContext;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBrowser;
import com.biglybt.ui.swt.views.skin.SkinView;

public class WelcomeView
extends SkinView {
    private static boolean waitLoadingURL = true;
    private static WelcomeView instance;
    private SWTSkinObjectBrowser browserSkinObject;
    private SWTSkinObject skinObject;

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        instance = null;
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public Object skinObjectInitialShow(final SWTSkinObject skinObject, Object params) {
        MdiEntry entry;
        this.skinObject = skinObject;
        instance = this;
        this.browserSkinObject = (SWTSkinObjectBrowser)this.skin.getSkinObject("welcome", this.soMain);
        this.browserSkinObject.addListener(new BrowserContext.loadingListener(){

            @Override
            public void browserLoadingChanged(boolean loading, String url) {
                if (!loading) {
                    skinObject.getControl().getParent().layout(true, true);
                }
            }
        });
        COConfigurationManager.setParameter("v3.Show Welcome", false);
        this.openURL();
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi != null && (entry = mdi.getEntry("Welcome")) != null) {
            entry.addListener(new MdiCloseListener(){

                @Override
                public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    if (mdi != null) {
                        mdi.showEntryByID("Library");
                    }
                }
            });
        }
        return null;
    }

    private void openURL() {
        if (waitLoadingURL) {
            return;
        }
        Object o = this.skinObject.getData("CreationParams");
        String sURL = o instanceof String ? (String)o : "https://biglybt.github.io/GettingStarted.html";
        this.browserSkinObject.enablePluginProxy("welcome");
        this.browserSkinObject.setURL(sURL);
    }

    public static void setWaitLoadingURL(boolean waitLoadingURL) {
        WelcomeView.waitLoadingURL = waitLoadingURL;
        if (!waitLoadingURL && instance != null) {
            instance.openURL();
        }
    }

    public static void setupSidebarEntry(final MultipleDocumentInterface mdi) {
        mdi.registerEntry("Welcome", new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.vuze", "Welcome", "main.area.welcome", MessageText.getString("v3.MainWindow.menu.getting_started").replaceAll("&", ""), null, null, true, "");
                entry.setImageLeftID("image.sidebar.welcome");
                WelcomeView.addDropTest(entry);
                return entry;
            }
        });
    }

    private static void addDropTest(MdiEntry entry) {
        if (!Constants.isCVSVersion()) {
            return;
        }
        entry.addListener(new MdiEntryDropListener(){

            @Override
            public boolean mdiEntryDrop(MdiEntry entry, Object droppedObject) {
                String s = "You just dropped " + droppedObject.getClass() + "\n" + droppedObject + "\n\n";
                if (droppedObject.getClass().isArray()) {
                    Object[] o = (Object[])droppedObject;
                    int i = 0;
                    while (i < o.length) {
                        s = String.valueOf(s) + i + ":  ";
                        Object object = o[i];
                        s = object == null ? String.valueOf(s) + "null" : String.valueOf(s) + object.getClass() + ";" + object;
                        s = String.valueOf(s) + "\n";
                        ++i;
                    }
                }
                UIFunctionsManager.getUIFunctions().promptUser("test", s, null, 0, null, null, false, 0, null);
                return true;
            }
        });
    }
}

