/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.skin.sidebar;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AERunnableObject;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.swt.FixedHTMLTransfer;
import com.biglybt.ui.swt.FixedURLTransfer;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.mdi.BaseMDI;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MdiEntryVitalityImageSWT;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTInstanceImpl;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewEventCancelledException;
import com.biglybt.ui.swt.pifimpl.UISWTViewImpl;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.shells.main.MainMDISetup;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectSash;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.uiupdater.UIUpdaterSWT;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.IViewAlwaysInitialize;
import com.biglybt.ui.swt.views.QuickLinksView;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.biglybt.ui.swt.views.skin.sidebar.SideBarToolTips;
import com.biglybt.util.JSONUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.json.simple.JSONObject;

public class SideBar
extends BaseMDI
implements ObfuscateImage,
AEDiagnosticsEvidenceGenerator {
    protected static final boolean END_INDENT = Constants.isUnix || Constants.isWindows2000 || Constants.isWindows9598ME;
    private static final boolean USE_PAINT = !Constants.isWindows && !Utils.isGTK;
    protected static final boolean USE_NATIVE_EXPANDER = Utils.isGTK;
    private static final int GAP_BETWEEN_LEVEL_1 = Math.min(5, Math.max(0, COConfigurationManager.getIntParameter("Side Bar Top Level Gap", 1)));
    protected static final int SIDEBAR_ATTENTION_PERIOD = 500;
    protected static final int SIDEBAR_ATTENTION_DURATION = 5000;
    private SWTSkin skin;
    private SWTSkinObjectContainer soSideBarContents;
    private Tree tree;
    private Font fontHeader;
    private SWTSkinObject soSideBarPopout;
    private SWTSkinButtonUtility btnCloseItem;
    private SelectionListener dropDownSelectionListener;
    private DropTarget dropTarget;
    protected SideBarEntrySWT draggingOver;
    protected SideBarEntrySWT mousingOver;
    private Color fg;
    private Color bg;
    private List<SideBarEntrySWT> attention_seekers = new ArrayList<SideBarEntrySWT>();
    private TimerEventPeriodic attention_event;
    private Composite cPluginsArea;
    private Utils.SashWrapper pluginSash;
    private final List<UISWTViewImpl> pluginViews = new ArrayList<UISWTViewImpl>();
    private ParameterListener configShowSideBarListener;
    private ParameterListener configRedrawListener;
    private ParameterListener configBGColorListener;
    private UISWTInstanceImpl.SWTViewListener swtViewListener;
    private SideBarEntrySWT activeMenuEntry;
    private SideBarEntrySWT lastMenuEntry;
    private final Stack<String> entryViewHistory = new Stack();
    private final Stack<String> entryViewFuture = new Stack();
    private List<Runnable> idle_pending = new ArrayList<Runnable>();
    private int activity_count;

    public SideBar() {
        super(null, "Main", null);
        this.setCloseableConfigFile("sidebarauto.config");
        AEDiagnostics.addWeakEvidenceGenerator(this);
    }

    @Override
    public void buildMDI(Composite parent) {
        Debug.out("uh oh, we didn't code a way make a Sidebar in a Composite yet");
    }

    @Override
    public void buildMDI(SWTSkinObject skinObject) {
        this.setMainSkinObject(skinObject);
        skinObject.addListener(this);
    }

    @Override
    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        super.skinObjectCreated(skinObject, params);
        this.skin = skinObject.getSkin();
        this.soSideBarContents = (SWTSkinObjectContainer)this.skin.getSkinObject("sidebar-contents");
        this.soSideBarPopout = this.skin.getSkinObject("sidebar-pop");
        SWTSkinObjectContainer soSideBarPluginsArea = (SWTSkinObjectContainer)this.skin.getSkinObject("sidebar-plugins");
        if (soSideBarPluginsArea != null) {
            soSideBarPluginsArea.setVisible(false);
        }
        this.addGeneralMenus();
        this.createSideBar();
        try {
            UIUpdater updater = UIUpdaterSWT.getInstance();
            if (updater != null && !updater.isAdded(this)) {
                updater.addUpdater(this);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        Display.getDefault().addFilter(1, new Listener(){

            public void handleEvent(Event event2) {
                SideBarEntrySWT entry;
                if (event2.keyCode == 0x1000010 || event2.keyCode == 116 && event2.stateMask == 0x410000) {
                    event2.doit = false;
                    event2.keyCode = 0;
                    event2.character = '\u0000';
                    SideBar.this.flipSideBarVisibility();
                } else if (event2.keyCode == 0x100000D && event2.stateMask == 262144 && (entry = SideBar.this.getSelectedEntry()) instanceof SideBarEntrySWT && entry.isCloseable()) {
                    entry.getTreeItem().dispose();
                }
            }
        });
        Display.getDefault().addFilter(31, ev -> {
            if (ev.character == '\t' && (ev.stateMask & SWT.MOD1 + 131072) == SWT.MOD1) {
                this.showNext();
                ev.doit = false;
            } else if (ev.character == '\t' && (ev.stateMask & SWT.MOD1 + 131072) == SWT.MOD1 + 131072) {
                this.showPrevious();
                ev.doit = false;
            }
        });
        return null;
    }

    private void addGeneralMenus() {
        PluginManager pm = CoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getDefaultPluginInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        com.biglybt.pif.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar._end_", "sep");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.setStyle(4);
        menuItem = menuManager.addMenuItem("sidebar._end_", "UpdateWindow.close");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                if (sbe != null && !sbe.isCloseable()) {
                    menu.setVisible(false);
                } else {
                    menu.setVisible(true);
                }
            }
        });
        menuItem.addListener((com.biglybt.pif.ui.menus.MenuItem menu, Object target) -> {
            BaseMdiEntry baseMdiEntry = this.closeEntry(this.getMenuEntry(false), true);
        });
        menuItem = menuManager.addMenuItem("sidebar._end_", "menu.show.at.start");
        menuItem.setDisposeWithUIDetach("swt");
        menuItem.setStyle(2);
        menuItem.setData(false);
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                if (sbe != null) {
                    String id = sbe.getId();
                    String sas = COConfigurationManager.getStringParameter("Show Side Entry At Start", "");
                    menu.setData(sas.equals(id));
                } else {
                    menu.setVisible(false);
                }
            }
        });
        menuItem.addListener((com.biglybt.pif.ui.menus.MenuItem menu, Object target) -> {
            SideBarEntrySWT sbe = this.getMenuEntry(false);
            if (sbe != null) {
                COConfigurationManager.setParameter("Show Side Entry At Start", menu.isSelected() ? sbe.getId() : "");
            }
        });
        com.biglybt.pif.ui.menus.MenuItem menuParentItem = menuManager.addMenuItem("sidebar._end_", "menu.add.to");
        menuParentItem.setDisposeWithUIDetach("swt");
        menuParentItem.setStyle(5);
        String ql_res = "v3.MainWindow.menu.view.quick-links";
        menuParentItem.addFillListener((menu, data) -> {
            SideBarEntrySWT entry = this.getMenuEntry(false);
            boolean visible = entry != null && entry.canBuildStandAlone() && !entry.getViewID().equals("header.dashboard");
            menu.setVisible(visible);
            if (visible) {
                com.biglybt.pif.ui.menus.MenuItem[] items;
                boolean ql_ok = QuickLinksView.canAddItem(this, entry);
                com.biglybt.pif.ui.menus.MenuItem[] menuItemArray = items = menu.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    com.biglybt.pif.ui.menus.MenuItem item = menuItemArray[n2];
                    String res = item.getResourceKey();
                    if (res.equals(ql_res)) {
                        item.setVisible(ql_ok);
                    }
                    ++n2;
                }
            }
        });
        com.biglybt.pif.ui.menus.MenuItem menuItemDashBoard = menuManager.addMenuItem(menuParentItem, "label.dashboard");
        menuItemDashBoard.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                if (sbe != null) {
                    MainMDISetup.getSb_dashboard().addItem(sbe);
                }
            }
        });
        com.biglybt.pif.ui.menus.MenuItem menuItemTopbar = menuManager.addMenuItem(menuParentItem, "label.topbar");
        menuItemTopbar.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                if (sbe != null) {
                    MainMDISetup.getSb_dashboard().addItemToTopbar(sbe);
                }
            }
        });
        com.biglybt.pif.ui.menus.MenuItem menuItemSidebar = menuManager.addMenuItem(menuParentItem, "label.sidebar");
        menuItemSidebar.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                if (sbe != null) {
                    MainMDISetup.getSb_dashboard().addItemToSidebar(sbe);
                }
            }
        });
        com.biglybt.pif.ui.menus.MenuItem menuItemRightbar = menuManager.addMenuItem(menuParentItem, "label.rightbar");
        menuItemRightbar.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                if (sbe != null) {
                    MainMDISetup.getSb_dashboard().addItemToRightbar(sbe);
                }
            }
        });
        com.biglybt.pif.ui.menus.MenuItem menuItemQuickLinks = menuManager.addMenuItem(menuParentItem, ql_res);
        menuItemQuickLinks.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                if (sbe != null) {
                    QuickLinksView.addItem(SideBar.this, sbe);
                }
            }
        });
        menuParentItem = menuManager.addMenuItem("sidebar._end_", "label.pop.out");
        menuParentItem.setStyle(5);
        menuParentItem.setDisposeWithUIDetach("swt");
        menuParentItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                menu.setVisible(sbe != null && sbe.canBuildStandAlone());
            }
        });
        com.biglybt.pif.ui.menus.MenuItem menuItemIndependent = menuManager.addMenuItem(menuParentItem, "menu.independent");
        final com.biglybt.pif.ui.menus.MenuItem menuItemOnTop = menuManager.addMenuItem(menuParentItem, "menu.on.top");
        MenuItemListener listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                SideBarEntrySWT sbe = SideBar.this.getMenuEntry(false);
                if (sbe != null) {
                    SideBar.this.popoutEntry(sbe, menu == menuItemOnTop ? PopOutManager.OPT_MAP_ON_TOP : PopOutManager.OPT_MAP_NONE);
                }
            }
        };
        menuItemIndependent.addListener(listener);
        menuItemOnTop.addListener(listener);
    }

    @Override
    protected String getShowIDAtStartup() {
        return COConfigurationManager.getStringParameter("Show Side Entry At Start", "");
    }

    public boolean canPopoutEntry(MdiEntry entry) {
        SideBarEntrySWT sbe = (SideBarEntrySWT)entry;
        return sbe.canBuildStandAlone();
    }

    @Override
    public boolean popoutEntry(MdiEntry entry, Map<String, Object> options) {
        return PopOutManager.popOut((SideBarEntrySWT)entry, options);
    }

    public void flipSideBarVisibility() {
        final SWTSkinObjectSash soSash = (SWTSkinObjectSash)this.skin.getSkinObject("sidebar-sash");
        if (soSash == null) {
            return;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                boolean visible = !soSash.isAboveVisible();
                soSash.setAboveVisible(visible);
                SideBar.this.updateSidebarVisibility();
                COConfigurationManager.setParameter("Show Side Bar", visible);
            }
        });
    }

    private void updateSidebarVisibility() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObjectSash soSash = (SWTSkinObjectSash)SideBar.this.skin.getSkinObject("sidebar-sash");
                if (soSash == null) {
                    return;
                }
                if (soSash.isAboveVisible()) {
                    if (SideBar.this.soSideBarPopout != null) {
                        Object ld = SideBar.this.soSideBarPopout.getControl().getLayoutData();
                        if (ld instanceof FormData) {
                            FormData fd = (FormData)ld;
                            fd.width = 0;
                        }
                        SideBar.this.soSideBarPopout.setVisible(false);
                        Utils.relayout(SideBar.this.soSideBarPopout.getControl());
                    }
                } else if (SideBar.this.soSideBarPopout != null) {
                    Object ld = SideBar.this.soSideBarPopout.getControl().getLayoutData();
                    if (ld instanceof FormData) {
                        FormData fd = (FormData)ld;
                        fd.width = 36;
                    }
                    SideBar.this.soSideBarPopout.setVisible(true);
                    SideBar.this.soSideBarPopout.getControl().moveAbove(null);
                    Utils.relayout(SideBar.this.soSideBarPopout.getControl());
                }
            }
        });
    }

    @Override
    public boolean isVisible() {
        SWTSkinObjectSash soSash = (SWTSkinObjectSash)this.skin.getSkinObject("sidebar-sash");
        if (soSash == null) {
            return false;
        }
        return soSash.isAboveVisible();
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        super.skinObjectInitialShow(skinObject, params);
        this.configShowSideBarListener = new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                boolean visible = COConfigurationManager.getBooleanParameter(name);
                if (visible != SideBar.this.isVisible()) {
                    SideBar.this.flipSideBarVisibility();
                }
            }
        };
        COConfigurationManager.addParameterListener("Show Side Bar", this.configShowSideBarListener);
        this.configRedrawListener = new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        SideBar.this.swt_redraw();
                    }
                });
            }
        };
        COConfigurationManager.addParameterListener(new String[]{"Side Bar Close Position", "Side Bar Indent Expanders", "Side Bar Compact View", "Side Bar Hide Left Icon"}, this.configRedrawListener);
        this.updateSidebarVisibility();
        return null;
    }

    @Override
    protected void setupPluginViews() {
        super.setupPluginViews();
        this.createSideBarPluginViews();
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        try {
            UIUpdater uiUpdater;
            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
            if (uiFunctions != null && (uiUpdater = uiFunctions.getUIUpdater()) != null) {
                uiUpdater.removeUpdater(this);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        COConfigurationManager.removeParameterListener("Show Side Bar", this.configShowSideBarListener);
        COConfigurationManager.removeParameterListener("config.skin.color.sidebar.bg", this.configBGColorListener);
        COConfigurationManager.removeParameterListener("Side Bar Close Position", this.configBGColorListener);
        COConfigurationManager.removeParameterListener("Side Bar Close Position", this.configRedrawListener);
        COConfigurationManager.removeParameterListener("Side Bar Indent Expanders", this.configRedrawListener);
        COConfigurationManager.removeParameterListener("Side Bar Compact View", this.configRedrawListener);
        COConfigurationManager.removeParameterListener("Side Bar Hide Left Icon", this.configRedrawListener);
        if (this.swtViewListener != null) {
            try {
                ViewManagerSWT.getInstance().removeSWTViewListener(this.swtViewListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    protected void setBackground(SWTSkinProperties sp) {
        this.bg = Utils.isDarkAppearanceNativeWindows() ? Colors.getWindowsDarkSystemColor((Device)this.tree.getDisplay(), 22) : sp.getColor("color.sidebar.bg");
    }

    protected Color getBackground() {
        return this.bg;
    }

    private void createSideBar() {
        SWTSkinObject soSideBarList = this.skin.getSkinObject("sidebar-list");
        if (soSideBarList == null) {
            return;
        }
        Composite sidebarList = (Composite)soSideBarList.getControl();
        this.pluginSash = Utils.createSashWrapper(sidebarList, "Sidebar.Plugin.SplitAt", 75);
        this.pluginSash.setBottomVisible(false);
        Composite[] kids = this.pluginSash.getChildren();
        this.cPluginsArea = new Composite(kids[1], 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.cPluginsArea.setLayout((Layout)layout);
        this.cPluginsArea.setLayoutData((Object)Utils.getFilledFormData());
        this.tree = new Tree(kids[0], 0x20010210);
        this.tree.setHeaderVisible(false);
        new SideBarToolTips(this, this.tree);
        this.tree.setLayoutData((Object)Utils.getFilledFormData());
        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
        this.setBackground(skinProperties);
        this.fg = skinProperties.getColor("color.sidebar.fg");
        this.configBGColorListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        SideBar.this.swt_updateSideBarColors();
                    }
                });
            }
        };
        COConfigurationManager.addParameterListener("config.skin.color.sidebar.bg", this.configBGColorListener);
        COConfigurationManager.addParameterListener("Side Bar Close Position", this.configBGColorListener);
        this.tree.setBackground(this.bg);
        this.tree.setForeground(this.fg);
        this.fontHeader = FontUtils.getFontWithStyle(this.tree.getFont(), 1, 1.0f);
        ScrollBar vBar = this.tree.getVerticalBar();
        vBar.setData("ScrollOnMouseOver", () -> {
            int pos = vBar.getSelection();
            TreeItem item = this.getTreeItemAt(pos);
            if (item != null) {
                this.tree.setTopItem(item);
            }
        });
        if (Constants.isOSX) {
            vBar.setData("ScrollOnMouseOver2", () -> this.tree.redraw());
        }
        vBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 0) {
                    SideBarEntrySWT[] sideBarEntries = (SideBarEntrySWT[])SideBar.this.getEntries(new SideBarEntrySWT[0]);
                    SideBar.this.swt_updateSideBarHitAreasY(sideBarEntries);
                }
                if (Constants.isOSX) {
                    SideBar.this.tree.redraw();
                }
            }
        });
        Listener treeListener = new Listener(){
            TreeItem lastTopItem = null;
            boolean mouseDowned = false;
            int mouseDownedButton;
            Rectangle lastCloseAreaClicked = null;
            private boolean wasExpanded;

            public void handleEvent(Event event2) {
                if (Utils.isDisplayDisposed()) {
                    if (event2.type == 12) {
                        SideBar.this.saveCloseables();
                    }
                    return;
                }
                TreeItem treeItem = (TreeItem)event2.item;
                Tree tree = SideBar.this.getTree();
                try {
                    block1 : switch (event2.type) {
                        case 41: {
                            int clientWidth = tree.getClientArea().width;
                            String text = treeItem.getText(event2.index);
                            Point size = event2.gc.textExtent(text);
                            if (event2.x + event2.width < clientWidth) {
                                event2.width = size.x + event2.x;
                                event2.x = 0;
                            }
                            if (Constants.isWindows) {
                                event2.width = clientWidth - event2.x;
                            }
                            event2.height = 20;
                            break;
                        }
                        case 42: {
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            if (entry != null) {
                                boolean selected;
                                boolean bl = selected = SideBar.this.getSelectedEntry() == entry;
                                event2.detail = !selected ? (event2.detail &= 0xFFFFFFFD) : (event2.detail |= 2);
                                entry.swt_paintSideBar(event2);
                            }
                            break;
                        }
                        case 9: {
                            if (!USE_PAINT) {
                                return;
                            }
                            Rectangle bounds = event2.getBounds();
                            int indent = END_INDENT ? tree.getClientArea().width - 1 : 0;
                            int y = event2.y + 1;
                            treeItem = tree.getItem(new Point(indent, y));
                            while (treeItem != null) {
                                TreeItem oldTreeItem;
                                Rectangle itemBounds;
                                SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                                Rectangle rectangle = itemBounds = entry == null ? null : entry.swt_getBounds();
                                if (itemBounds != null && entry != null) {
                                    event2.item = treeItem;
                                    boolean selected = SideBar.this.getSelectedEntry() == entry && entry.isSelectable();
                                    event2.detail = selected ? 2 : 0;
                                    Rectangle newClip = bounds.intersection(itemBounds);
                                    event2.setBounds(newClip);
                                    Utils.setClipping(event2.gc, newClip);
                                    entry.swt_paintSideBar(event2);
                                    y = itemBounds.y + itemBounds.height + 1;
                                } else {
                                    y += tree.getItemHeight();
                                }
                                if (y > bounds.y + bounds.height || (oldTreeItem = treeItem) == (treeItem = tree.getItem(new Point(indent, y)))) break;
                            }
                            if (tree.getTopItem() != this.lastTopItem) {
                                this.lastTopItem = tree.getTopItem();
                                SideBarEntrySWT[] sideBarEntries = (SideBarEntrySWT[])SideBar.this.getEntries(new SideBarEntrySWT[0]);
                                SideBar.this.swt_updateSideBarHitAreasY(sideBarEntries);
                            }
                            break;
                        }
                        case 40: {
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            if (entry == null) {
                                event2.detail = 0;
                            }
                            event2.doit = true;
                            break;
                        }
                        case 11: {
                            tree.redraw();
                            break;
                        }
                        case 13: {
                            if (treeItem == null) {
                                return;
                            }
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            if (Constants.isOSX && SideBar.this.mousingOver != entry) {
                                SideBarEntrySWT old = SideBar.this.mousingOver;
                                SideBar.this.mousingOver = entry;
                                if (old != null) {
                                    old.redraw();
                                }
                                if (entry != null) {
                                    entry.redraw();
                                }
                            }
                            if (entry != null) {
                                Point cursorLocation = tree.toControl(event2.display.getCursorLocation());
                                if (this.lastCloseAreaClicked != null && this.lastCloseAreaClicked.contains(cursorLocation.x, cursorLocation.y)) {
                                    return;
                                }
                                if (!this.mouseDowned || this.mouseDownedButton != 3) {
                                    SideBar.this.showEntry(entry);
                                }
                            } else if (SideBar.this.getSelectedEntry() != null) {
                                TreeItem topItem = tree.getTopItem();
                                tree.setRedraw(false);
                                TreeItem ti = SideBar.this.getSelectedEntry().getTreeItem();
                                if (ti != null) {
                                    tree.setSelection(ti);
                                }
                                if (topItem != null) {
                                    tree.setTopItem(topItem);
                                }
                                tree.setRedraw(true);
                                event2.doit = false;
                            }
                            break;
                        }
                        case 7: {
                            SideBarEntrySWT old = SideBar.this.mousingOver;
                            SideBar.this.mousingOver = null;
                            if (old != null) {
                                old.redraw();
                            }
                            break;
                        }
                        case 5: 
                        case 6: {
                            int indent = END_INDENT ? tree.getClientArea().width - 1 : 0;
                            treeItem = tree.getItem(new Point(indent, event2.y));
                            SideBarEntrySWT entry = (SideBarEntrySWT)(treeItem == null || treeItem.isDisposed() ? null : treeItem.getData("MdiEntry"));
                            if (SideBar.this.mousingOver != entry) {
                                SideBarEntrySWT old = SideBar.this.mousingOver;
                                SideBar.this.mousingOver = entry;
                                if (old != null) {
                                    old.redraw();
                                }
                                if (entry != null) {
                                    entry.redraw();
                                }
                            }
                            int cursorNo = 0;
                            if (treeItem != null) {
                                Rectangle closeArea = (Rectangle)treeItem.getData("closeArea");
                                if (closeArea != null && closeArea.contains(event2.x, event2.y)) {
                                    cursorNo = 21;
                                } else if (entry != null && treeItem.getItemCount() > 0) {
                                    cursorNo = 21;
                                } else if (entry != null) {
                                    List<MdiEntryVitalityImageSWT> vitalityImages = entry.getVitalityImages();
                                    for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
                                        Rectangle hitArea;
                                        if (vitalityImage == null || !vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null) continue;
                                        Rectangle itemBounds = entry.swt_getBounds();
                                        int relY = event2.y - (itemBounds == null ? 0 : itemBounds.y);
                                        if (!hitArea.contains(event2.x, relY) || !vitalityImage.hasListeners()) continue;
                                        cursorNo = 21;
                                    }
                                }
                            }
                            Cursor cursor = event2.display.getSystemCursor(cursorNo);
                            if (tree.getCursor() != cursor) {
                                tree.setCursor(cursor);
                            }
                            if (treeItem != null) {
                                this.wasExpanded = entry != null && entry.isExpanded();
                                break;
                            }
                            this.wasExpanded = false;
                            break;
                        }
                        case 3: {
                            this.mouseDowned = true;
                            this.mouseDownedButton = event2.button;
                            this.lastCloseAreaClicked = null;
                            if (tree.getItemCount() == 0 || event2.button != 1) {
                                return;
                            }
                            int indent = END_INDENT ? tree.getClientArea().width - 1 : 0;
                            treeItem = tree.getItem(new Point(indent, event2.y));
                            if (treeItem == null) {
                                return;
                            }
                            Rectangle closeArea = (Rectangle)treeItem.getData("closeArea");
                            if (closeArea != null && closeArea.contains(event2.x, event2.y)) {
                                this.lastCloseAreaClicked = closeArea;
                                SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                                if (entry != null) {
                                    SideBar.this.closeEntry(entry, true);
                                } else {
                                    treeItem.dispose();
                                }
                                this.mouseDowned = false;
                            }
                            break;
                        }
                        case 4: {
                            if (!this.mouseDowned) {
                                return;
                            }
                            this.mouseDowned = false;
                            if (tree.getItemCount() == 0 || event2.button != 1) {
                                return;
                            }
                            int indent = END_INDENT ? tree.getClientArea().width - 1 : 0;
                            treeItem = tree.getItem(new Point(indent, event2.y));
                            if (treeItem == null) {
                                return;
                            }
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            Rectangle closeArea = (Rectangle)treeItem.getData("closeArea");
                            if (closeArea != null && closeArea.contains(event2.x, event2.y)) {
                                return;
                            }
                            if (SideBar.this.getSelectedEntry() != entry) {
                            }
                            if (entry != null) {
                                List<MdiEntryVitalityImageSWT> vitalityImages = entry.getVitalityImages();
                                for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
                                    Rectangle hitArea;
                                    if (vitalityImage == null || !vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null) continue;
                                    Rectangle itemBounds = entry.swt_getBounds();
                                    int relY = event2.y - (itemBounds == null ? 0 : itemBounds.y);
                                    if (!hitArea.contains(event2.x, relY)) continue;
                                    vitalityImage.triggerClickedListeners(event2.x, relY);
                                    return;
                                }
                                if (treeItem.getItemCount() > 0) {
                                    int limit;
                                    Integer rhs = (Integer)treeItem.getData("expandoRHS");
                                    int n = limit = rhs == null ? 20 : rhs;
                                    if (event2.x < limit) {
                                        SideBarEntrySWT currentEntry = SideBar.this.getSelectedEntry();
                                        String collapsedID = entry.getViewID();
                                        while (currentEntry != null) {
                                            String parentID = currentEntry.getParentID();
                                            if (collapsedID.equals(parentID)) {
                                                SideBar.this.showEntryByID(collapsedID);
                                                break;
                                            }
                                            currentEntry = SideBar.this.getEntry(parentID);
                                        }
                                        entry.setExpanded(!this.wasExpanded);
                                        this.wasExpanded = !this.wasExpanded;
                                    }
                                }
                            }
                            break;
                        }
                        case 8: {
                            int indent = END_INDENT ? tree.getClientArea().width - 1 : 0;
                            treeItem = tree.getItem(new Point(indent, event2.y));
                            SideBarEntrySWT entry = (SideBarEntrySWT)(treeItem == null || treeItem.isDisposed() ? null : treeItem.getData("MdiEntry"));
                            if (entry != null && (event2.button == 1 || event2.button == 2)) {
                                boolean done = false;
                                Point cursorLocation = tree.toControl(event2.display.getCursorLocation());
                                if (this.lastCloseAreaClicked == null || !this.lastCloseAreaClicked.contains(cursorLocation.x, cursorLocation.y)) {
                                    Integer offset = (Integer)treeItem.getData("contentStartOffset");
                                    if ((treeItem.getItemCount() == 0 || offset != null && event2.x >= offset) && SideBar.this.canPopoutEntry(entry)) {
                                        int action = COConfigurationManager.getIntParameter("Side Bar Double Click Action");
                                        done = SideBar.this.popoutEntry(entry, action == 0 ? PopOutManager.OPT_MAP_ON_TOP : PopOutManager.OPT_MAP_NONE);
                                    }
                                }
                                if (!done && treeItem.getItemCount() > 0) {
                                    entry.setExpanded(!entry.isExpanded());
                                }
                            }
                            break;
                        }
                        case 12: {
                            SideBar.this.fontHeader.dispose();
                            if (SideBar.this.dropTarget != null && !SideBar.this.dropTarget.isDisposed()) {
                                SideBar.this.dropTarget.dispose();
                            }
                            SideBar.this.saveCloseables();
                            break;
                        }
                        case 18: {
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            SideBarEntrySWT currentEntry = SideBar.this.getSelectedEntry();
                            String collapsedID = entry.getViewID();
                            while (currentEntry != null) {
                                String parentID = currentEntry.getParentID();
                                if (collapsedID.equals(parentID)) {
                                    SideBar.this.showEntryByID(collapsedID);
                                    break block1;
                                }
                                currentEntry = SideBar.this.getEntry(parentID);
                            }
                            break;
                        }
                        case 1: {
                            SideBarEntrySWT currentEntry = SideBar.this.getSelectedEntry();
                            if (currentEntry == null || !currentEntry.processAccelerator(event2.character, event2.stateMask)) break;
                            event2.doit = false;
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        };
        this.tree.addListener(11, treeListener);
        if (USE_PAINT) {
            this.tree.addListener(9, treeListener);
        }
        this.tree.addListener(41, treeListener);
        this.tree.addListener(42, treeListener);
        this.tree.addListener(40, treeListener);
        this.tree.addListener(13, treeListener);
        this.tree.addListener(12, treeListener);
        this.tree.addListener(8, treeListener);
        this.tree.addListener(4, treeListener);
        this.tree.addListener(3, treeListener);
        this.tree.addListener(6, treeListener);
        this.tree.addListener(5, treeListener);
        this.tree.addListener(7, treeListener);
        this.tree.addListener(18, treeListener);
        this.tree.addListener(1, treeListener);
        this.dropTarget = new DropTarget((Control)this.tree, 31);
        this.dropTarget.setTransfer(new Transfer[]{FixedHTMLTransfer.getInstance(), FixedURLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
        this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dropAccept(DropTargetEvent event2) {
                event2.currentDataType = FixedURLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
            }

            public void dragEnter(DropTargetEvent event2) {
            }

            public void dragOperationChanged(DropTargetEvent event2) {
            }

            public void dragOver(DropTargetEvent event2) {
                SideBarEntrySWT entry;
                TreeItem treeItem = event2.item instanceof TreeItem ? (TreeItem)event2.item : null;
                SideBar.this.draggingOver = treeItem != null ? (entry = (SideBarEntrySWT)treeItem.getData("MdiEntry")) : null;
                if (SideBar.this.draggingOver == null || !SideBar.this.draggingOver.hasDropListeners()) {
                    boolean isTorrent = TorrentOpener.doesDropHaveTorrents(event2);
                    event2.detail = isTorrent ? 1 : 0;
                    SideBar.this.draggingOver = null;
                } else if ((event2.operations & 4) > 0) {
                    event2.detail = 4;
                } else if ((event2.operations & 1) > 0) {
                    event2.detail = 1;
                } else if ((event2.operations & 0x10) > 0) {
                    event2.detail = 1;
                }
                if (Constants.isOSX) {
                    SideBar.this.tree.redraw();
                }
                event2.feedback = 25;
            }

            public void dragLeave(DropTargetEvent event2) {
                SideBar.this.draggingOver = null;
                SideBar.this.tree.redraw();
            }

            public void drop(DropTargetEvent event2) {
                boolean handled;
                SideBar.this.draggingOver = null;
                SideBar.this.tree.redraw();
                if (!(event2.item instanceof TreeItem)) {
                    SideBar.this.defaultDrop(event2);
                    return;
                }
                TreeItem treeItem = (TreeItem)event2.item;
                SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                boolean bl = handled = entry != null && entry.triggerDropListeners(event2.data);
                if (!handled) {
                    SideBar.this.defaultDrop(event2);
                }
            }
        });
        final Menu menuTree = new Menu((Control)this.tree);
        this.tree.setMenu(menuTree);
        this.tree.addMenuDetectListener(e -> {
            SideBarEntrySWT entry = null;
            if (e.detail == 0) {
                Point ptMouse = ((Control)e.widget).toControl(e.x, e.y);
                int indent = END_INDENT ? this.tree.getClientArea().width - 1 : 0;
                TreeItem treeItem = this.tree.getItem(new Point(indent, ptMouse.y));
                entry = treeItem != null ? (SideBarEntrySWT)treeItem.getData("MdiEntry") : null;
            }
            menuTree.setData("MdiEntry", entry);
        });
        menuTree.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                SideBarEntrySWT menuEntry = SideBar.this.getMenuEntry(false);
                if (menuEntry != null) {
                    SideBar.this.setMenuEntry(null);
                    menuEntry.redraw();
                }
                if (Constants.isOSX) {
                    return;
                }
                Utils.execSWTThreadLater(0, new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (bShown || menuTree.isDisposed()) {
                            return;
                        }
                        Utils.disposeSWTObjects(menuTree.getItems());
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                Utils.disposeSWTObjects(menuTree.getItems());
                this.bShown = true;
                SideBarEntrySWT entry = (SideBarEntrySWT)menuTree.getData("MdiEntry");
                SideBar.this.setMenuEntry(entry);
                if (entry != null) {
                    entry.redraw();
                    SideBar.this.fillMenu(menuTree, entry, "sidebar");
                }
                if (entry == null || entry.getParentID() == null) {
                    MenuBuildUtils.addSeparator(menuTree);
                    MenuItem mi = new MenuItem(menuTree, 8);
                    mi.setText(MessageText.getString("menu.sidebar.options"));
                    mi.addListener(13, ev -> {
                        UIFunctions uif = UIFunctionsManager.getUIFunctions();
                        if (uif != null) {
                            JSONObject args = new JSONObject();
                            args.put("select", "section-sidebar");
                            String args_str = JSONUtils.encodeToJSON(args);
                            uif.getMDI().showEntryByID("ConfigView", "display" + args_str);
                        }
                    });
                }
                if (menuTree.getItemCount() == 0) {
                    Utils.execSWTThreadLater(0, () -> menuTree.setVisible(false));
                }
            }
        });
        if (this.soSideBarPopout != null) {
            SWTSkinObject soCloseItem;
            SWTSkinObject soExpand;
            SWTSkinObject soDropDown = this.skin.getSkinObject("sidebar-dropdown");
            if (soDropDown != null) {
                final Menu menuDropDown = new Menu(soDropDown.getControl());
                menuDropDown.addMenuListener(new MenuListener(){
                    boolean bShown = false;

                    public void menuHidden(MenuEvent e) {
                        this.bShown = false;
                        if (Constants.isOSX) {
                            return;
                        }
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            @Override
                            public void runSupport() {
                                if (bShown || menuDropDown.isDisposed()) {
                                    return;
                                }
                                Utils.disposeSWTObjects(menuDropDown.getItems());
                            }
                        });
                    }

                    public void menuShown(MenuEvent e) {
                        Utils.disposeSWTObjects(menuDropDown.getItems());
                        this.bShown = true;
                        SideBar.this.fillDropDownMenu(menuDropDown, SideBar.this.tree.getItems(), 0);
                    }
                });
                this.dropDownSelectionListener = new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String id = (String)e.widget.getData("Plugin.viewID");
                        SideBar.this.showEntryByID(id);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                };
                SWTSkinButtonUtility btnDropDown = new SWTSkinButtonUtility(soDropDown);
                btnDropDown.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    @Override
                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        Control c = buttonUtility.getSkinObject().getControl();
                        menuDropDown.setLocation(c.getDisplay().getCursorLocation());
                        menuDropDown.setVisible(!menuDropDown.getVisible());
                    }
                });
            }
            if ((soExpand = this.skin.getSkinObject("sidebar-expand")) != null) {
                SWTSkinButtonUtility btnExpand = new SWTSkinButtonUtility(soExpand);
                btnExpand.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    @Override
                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        SideBar.this.flipSideBarVisibility();
                    }
                });
            }
            if ((soCloseItem = this.skin.getSkinObject("sidebar-closeitem")) != null) {
                this.btnCloseItem = new SWTSkinButtonUtility(soCloseItem);
                this.btnCloseItem.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    @Override
                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        SideBar.this.closeEntry(SideBar.this.getSelectedEntry(), true);
                    }
                });
            }
        }
        Utils.addTerminateListener(() -> this.saveCloseables());
    }

    private void createSideBarPluginViews() {
        if (this.cPluginsArea == null) {
            return;
        }
        List<UISWTViewBuilderCore> pluginViewBuilders = ViewManagerSWT.getInstance().getBuilders("SideBarArea");
        for (UISWTViewBuilderCore builder : pluginViewBuilders) {
            if (builder == null) continue;
            try {
                UISWTViewImpl view = new UISWTViewImpl(builder, false);
                view.setDestroyOnDeactivate(false);
                this.addSideBarView(view, this.cPluginsArea);
                this.cPluginsArea.getParent().getParent().layout(true, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.swtViewListener = new UISWTInstanceImpl.SWTViewListener(){

            @Override
            public void setViewRegistered(Object forDSTypeOrViewID, UISWTViewBuilderCore builder) {
                if (!"SideBarArea".equals(forDSTypeOrViewID)) {
                    return;
                }
                Utils.execSWTThread(() -> {
                    try {
                        UISWTViewImpl view = new UISWTViewImpl(builder, false);
                        view.setDestroyOnDeactivate(false);
                        SideBar.this.addSideBarView(view, SideBar.this.cPluginsArea);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }

            @Override
            public void setViewDeregistered(Object forDSTypeOrViewID, UISWTViewBuilderCore builder) {
                if (!"SideBarArea".equals(forDSTypeOrViewID)) {
                    return;
                }
                Utils.execSWTThread(() -> {
                    ArrayList views;
                    List list = SideBar.this.pluginViews;
                    synchronized (list) {
                        views = new ArrayList(SideBar.this.pluginViews);
                    }
                    for (UISWTViewImpl view : views) {
                        if (!builder.equals(view.getEventListenerBuilder())) continue;
                        SideBar.this.removeSideBarView(view);
                    }
                });
            }
        };
        ViewManagerSWT.getInstance().addSWTViewListener(this.swtViewListener);
        this.cPluginsArea.getParent().getParent().layout(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSideBarView(UISWTViewImpl view, Composite cPluginsArea) {
        List<UISWTViewImpl> list = this.pluginViews;
        synchronized (list) {
            this.pluginViews.add(view);
            try {
                view.create();
            }
            catch (UISWTViewEventCancelledException e) {
                this.pluginViews.remove(view);
                return;
            }
            if (this.pluginViews.size() > 0) {
                this.pluginSash.setBottomVisible(true);
            }
        }
        Utils.disposeComposite(cPluginsArea, false);
        Composite parent = new Composite(cPluginsArea, 0);
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        parent.setLayout((Layout)new FormLayout());
        view.initialize(parent);
        cPluginsArea.getParent().layout(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSideBarView(UISWTViewImpl view) {
        try {
            view.closeView();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        List<UISWTViewImpl> list = this.pluginViews;
        synchronized (list) {
            this.pluginViews.remove(view);
            if (this.pluginViews.isEmpty()) {
                this.pluginSash.setBottomVisible(false);
            }
        }
    }

    protected void defaultDrop(DropTargetEvent event2) {
        TorrentOpener.openDroppedTorrents(event2, false);
    }

    protected boolean fillDropDownMenu(Menu menuDropDown, TreeItem[] items, int indent) {
        boolean hit = false;
        String s = "";
        int i = 0;
        while (i < indent) {
            s = String.valueOf(s) + "   ";
            ++i;
        }
        i = 0;
        while (i < items.length) {
            TreeItem treeItem = items[i];
            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
            if (entry != null) {
                TreeItem[] subItems;
                String o;
                MenuItem menuItem = new MenuItem(menuDropDown, entry.isSelectable() ? 16 : 64);
                String id = entry.getViewID();
                menuItem.setData("Plugin.viewID", (Object)id);
                ViewTitleInfo titleInfo = entry.getViewTitleInfo();
                String ind = "";
                if (titleInfo != null && (o = (String)titleInfo.getTitleInfoProperty(0)) != null) {
                    ind = "  (" + o + ")";
                }
                String title = String.valueOf(s) + entry.getTitle() + ind;
                menuItem.setText(title);
                menuItem.addSelectionListener(this.dropDownSelectionListener);
                SideBarEntrySWT currentEntry = this.getSelectedEntry();
                if (currentEntry != null && currentEntry.getViewID().equals(id)) {
                    menuItem.setSelection(true);
                    hit = true;
                }
                if ((subItems = treeItem.getItems()).length > 0) {
                    Menu parent = menuDropDown;
                    if (!entry.isSelectable()) {
                        parent = new Menu((Decorations)menuDropDown.getParent().getShell(), 4);
                        menuItem.setMenu(parent);
                    }
                    if (this.fillDropDownMenu(parent, subItems, indent + 1)) {
                        hit = true;
                        if (!entry.isSelectable()) {
                            menuItem.setText(String.valueOf(title) + " (*)");
                        }
                    }
                }
            }
            ++i;
        }
        return hit;
    }

    private void swt_updateSideBarHitAreasY(SideBarEntrySWT[] entries) {
        int x = 0;
        while (x < entries.length) {
            Rectangle itemBounds;
            SideBarEntrySWT entry = entries[x];
            TreeItem treeItem = entry.getTreeItem();
            if (treeItem != null && !treeItem.isDisposed() && (itemBounds = entry.swt_getBounds()) != null) {
                Rectangle closeArea;
                if (entry.isCloseable() && (closeArea = (Rectangle)treeItem.getData("closeArea")) != null) {
                    closeArea.y = itemBounds.y + (itemBounds.height - closeArea.height) / 2;
                }
                List<MdiEntryVitalityImageSWT> vitalityImages = entry.getVitalityImages();
                for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
                    Rectangle bounds;
                    Image image;
                    if (!vitalityImage.isVisible() || (image = vitalityImage.getImage()) == null || (bounds = vitalityImage.getHitArea()) == null) continue;
                    bounds.y = (itemBounds.height - bounds.height) / 2;
                }
            }
            ++x;
        }
    }

    private void swt_updateSideBarColors() {
        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
        skinProperties.clearCache();
        this.setBackground(skinProperties);
        this.tree.setBackground(this.bg);
        this.tree.redraw();
        this.swt_updateSideBarColors(this.tree.getItems());
    }

    private void swt_updateSideBarColors(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            SideBarEntrySWT entry = (SideBarEntrySWT)ti.getData("MdiEntry");
            if (entry != null) {
                entry.updateColors();
                entry.redraw();
            }
            this.swt_updateSideBarColors(ti.getItems());
            ++n2;
        }
    }

    private void swt_redraw() {
        this.tree.redraw();
        this.swt_redraw(this.tree.getItems());
    }

    private void swt_redraw(TreeItem[] items) {
        this.tree.redraw();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            SideBarEntrySWT entry = (SideBarEntrySWT)ti.getData("MdiEntry");
            if (entry != null) {
                entry.updateColors();
                entry.redraw();
            }
            this.swt_redraw(ti.getItems());
            ++n2;
        }
    }

    protected int indexOf(final MdiEntry entry) {
        Object o = Utils.execSWTThreadWithObject("indexOf", new AERunnableObject(){

            @Override
            public Object runSupport() {
                TreeItem treeItem = ((SideBarEntrySWT)entry).getTreeItem();
                if (treeItem == null) {
                    return -1;
                }
                TreeItem parentItem = treeItem.getParentItem();
                if (parentItem != null) {
                    return parentItem.indexOf(treeItem);
                }
                return SideBar.this.tree.indexOf(treeItem);
            }
        }, 500L);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return -1;
    }

    @Override
    public SideBarEntrySWT createHeader(String id, String titleID, String preferredAfterID) {
        SideBarEntrySWT oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        SideBarEntrySWT entry = new SideBarEntrySWT(this, this.skin, id);
        entry.setSelectable(false);
        entry.setPreferredAfterID(preferredAfterID);
        entry.setTitleID(titleID);
        entry.setParentView(this.getParentView());
        this.setupNewEntry(entry, id, true, false);
        return entry;
    }

    private void setupNewEntry(final SideBarEntrySWT entry, final String id, final boolean expandParent, final boolean closeable) {
        this.addItem(entry);
        entry.setCloseable(closeable);
        entry.setParentSkinObject(this.soSideBarContents);
        entry.setDestroyOnDeactivate(false);
        if ("header.plugins".equals(entry.getParentID()) && entry.getImageLeftID() == null) {
            entry.setImageLeftID("image.sidebar.plugin");
        }
        this.activityStart();
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    SideBar.this._setupNewEntry(entry, id, expandParent, closeable);
                }
                finally {
                    SideBar.this.activityEnd();
                }
            }
        });
    }

    private void _setupNewEntry(SideBarEntrySWT entry, String id, boolean expandParent, boolean closeable) {
        TreeItem treeItem;
        if (this.tree.isDisposed()) {
            return;
        }
        String view_id = entry.getViewID();
        SideBarEntrySWT existing = this.getEntry(view_id);
        if (existing != entry) {
            return;
        }
        SideBarEntrySWT currentEntry = entry;
        String currentID = id;
        while (true) {
            if (MainMDISetup.hiddenTopLevelIDs.contains(currentID)) {
                return;
            }
            if (currentEntry == null || (currentID = currentEntry.getParentID()) == null) break;
            currentEntry = this.getEntry(currentID);
        }
        String parentID = entry.getParentID();
        SideBarEntrySWT parent = this.getEntry(parentID);
        TreeItem parentTreeItem = null;
        if (parent instanceof SideBarEntrySWT) {
            SideBarEntrySWT parentSWT = parent;
            parentTreeItem = parentSWT.getTreeItem();
            if (expandParent) {
                parentTreeItem.setExpanded(true);
            }
        }
        int index = -1;
        String preferredAfterID = entry.getPreferredAfterID();
        if (preferredAfterID != null) {
            if (preferredAfterID.length() == 0) {
                index = 0;
            } else {
                SideBarEntrySWT entryAbove;
                boolean hack_it = preferredAfterID.startsWith("~");
                if (hack_it) {
                    preferredAfterID = preferredAfterID.substring(1);
                }
                if ((entryAbove = this.getEntry(preferredAfterID)) != null) {
                    index = this.indexOf(entryAbove);
                    if (!hack_it && index >= 0) {
                        ++index;
                    }
                }
            }
        }
        if (index == -1 && parent == null) {
            index = 0;
            String[] order = this.getPreferredOrder();
            int i = 0;
            while (i < order.length) {
                int i2;
                String orderID = order[i];
                if (orderID.equals(id)) break;
                SideBarEntrySWT entry2 = this.getEntry(orderID);
                if (entry2 != null && (i2 = this.indexOf(entry2)) >= 0) {
                    index = i2 + 1;
                }
                ++i;
            }
        }
        if (GAP_BETWEEN_LEVEL_1 > 0 && parentTreeItem == null && this.tree.getItemCount() > 0 && index != 0) {
            int i = 0;
            while (i < GAP_BETWEEN_LEVEL_1) {
                this.createTreeItem(null, null, index);
                if (index >= 0) {
                    ++index;
                }
                ++i;
            }
        }
        if ((treeItem = this.createTreeItem(entry, parentTreeItem, index)) != null) {
            this.triggerEntryLoadedListeners(entry);
        }
        if (GAP_BETWEEN_LEVEL_1 > 0 && parentTreeItem == null && this.tree.getItemCount() > 1 && index == 0) {
            int i = 0;
            while (i < GAP_BETWEEN_LEVEL_1) {
                this.createTreeItem(null, null, ++index);
                ++i;
            }
        }
    }

    private TreeItem createTreeItem(SideBarEntrySWT entry, TreeItem parentSwtItem, int index) {
        TreeItem treeItem;
        if (parentSwtItem == null) {
            if (this.tree.isDisposed()) {
                return null;
            }
            treeItem = index >= 0 && index < this.tree.getItemCount() ? new TreeItem(this.tree, 0, index) : new TreeItem(this.tree, 0);
        } else {
            if (parentSwtItem.isDisposed()) {
                return null;
            }
            treeItem = index >= 0 && index < parentSwtItem.getItemCount() ? new TreeItem(parentSwtItem, 0, index) : new TreeItem(parentSwtItem, 0);
        }
        if (entry != null) {
            treeItem.setData("MdiEntry", (Object)entry);
            entry.setTreeItem(treeItem);
        }
        return treeItem;
    }

    @Override
    protected void setSelectedEntry(MdiEntrySWT entry) {
        if (entry != null && this.btnCloseItem != null) {
            this.btnCloseItem.setDisabled(!entry.isCloseable());
        }
        super.setSelectedEntry(entry);
    }

    @Override
    public void showEntry(MdiEntry newEntry) {
        MdiEntrySWT[] entries;
        if (this.tree.isDisposed()) {
            return;
        }
        if (newEntry == null) {
            return;
        }
        SideBarEntrySWT oldEntry = this.getSelectedEntry();
        if (oldEntry == newEntry) {
            this.triggerSelectionListener(newEntry, newEntry);
            return;
        }
        this.setSelectedEntry((MdiEntrySWT)newEntry);
        if (oldEntry != null && oldEntry != newEntry) {
            oldEntry.redraw();
        }
        if (newEntry != null) {
            ((BaseMdiEntry)newEntry).show();
        }
        if (oldEntry != null && oldEntry != newEntry) {
            oldEntry.hide();
            oldEntry.redraw();
        }
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            SWTSkinObject obj;
            MdiEntrySWT entry = mdiEntrySWTArray[n2];
            if (entry != null && entry != this.getSelectedEntry() && (obj = ((SideBarEntrySWT)entry).getSkinObjectMaster()) != null && obj.isVisible()) {
                entry.hide();
                entry.redraw();
            }
            ++n2;
        }
        newEntry.redraw();
        this.triggerSelectionListener(newEntry, oldEntry);
    }

    @Override
    public SideBarEntrySWT createEntry(UISWTViewBuilderCore builder, boolean closeable) {
        String id = builder.getViewID();
        SideBarEntrySWT oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            oldEntry.setDatasource(builder.getInitialDataSource());
            return oldEntry;
        }
        SideBarEntrySWT entry = new SideBarEntrySWT(this, this.skin, id);
        entry.setDatasource(builder.getInitialDataSource());
        entry.setPreferredAfterID(builder.getPreferredAfterID());
        entry.setParentView(this.getParentView());
        try {
            this.addItem(entry);
            UISWTViewEventListener l = builder.createEventListener(entry);
            entry.setEventListener(l, builder, true);
            entry.setParentEntryID(builder.getParentEntryID());
            this.setupNewEntry(entry, id, false, closeable);
            if (l instanceof IViewAlwaysInitialize) {
                entry.build();
            }
        }
        catch (Exception e) {
            Debug.out(e);
            this.closeEntry(entry, false);
            return null;
        }
        return entry;
    }

    @Override
    public SideBarEntrySWT createEntryFromSkinRef(String parentEntryID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, String preferredAfterID) {
        SideBarEntrySWT oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        SideBarEntrySWT entry = new SideBarEntrySWT(this, this.skin, id);
        entry.setTitle(title);
        entry.setSkinRef(configID, params);
        if (parentEntryID == null || !parentEntryID.isEmpty()) {
            entry.setParentEntryID(parentEntryID);
        }
        entry.setViewTitleInfo(titleInfo);
        entry.setPreferredAfterID(preferredAfterID);
        entry.setParentView(this.getParentView());
        this.setupNewEntry(entry, id, false, closeable);
        return entry;
    }

    @Override
    public void updateUI() {
        Object[] views = this.pluginViews.toArray();
        int i = 0;
        while (i < views.length) {
            try {
                UISWTViewCore view = (UISWTViewCore)views[i];
                Composite composite = view.getComposite();
                if (composite != null) {
                    if (composite.isDisposed()) {
                        this.pluginViews.remove(view);
                    } else if (composite.isVisible()) {
                        view.triggerEvent(5, null);
                    }
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++i;
        }
        if (this.tree.getSelectionCount() == 0) {
            return;
        }
        super.updateUI();
    }

    @Override
    protected boolean wasEntryLoadedOnce(String id) {
        boolean loadedOnce = COConfigurationManager.getBooleanParameter("sb.once." + id, false);
        return loadedOnce;
    }

    @Override
    protected void setEntryLoadedOnce(String id) {
        COConfigurationManager.setParameter("sb.once." + id, true);
    }

    public Font getHeaderFont() {
        return this.fontHeader;
    }

    protected Tree getTree() {
        return this.tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestAttention(SideBarEntrySWT entry) {
        List<SideBarEntrySWT> list = this.attention_seekers;
        synchronized (list) {
            if (!this.attention_seekers.contains(entry)) {
                this.attention_seekers.add(entry);
            }
            if (this.attention_event == null) {
                this.attention_event = SimpleTimer.addPeriodicEvent("SideBar:attention", 500L, new TimerEventPerformer(){
                    int tick_count = 0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        ++this.tick_count;
                        final ArrayList<SideBarEntrySWT> repaints = new ArrayList<SideBarEntrySWT>();
                        List list = SideBar.this.attention_seekers;
                        synchronized (list) {
                            TimerEventPeriodic ev;
                            Iterator it = SideBar.this.attention_seekers.iterator();
                            while (it.hasNext()) {
                                SideBarEntrySWT entry = (SideBarEntrySWT)it.next();
                                if (entry.isEntryDisposed()) {
                                    it.remove();
                                    continue;
                                }
                                if (!entry.attentionUpdate(this.tick_count)) {
                                    it.remove();
                                }
                                repaints.add(entry);
                            }
                            if (SideBar.this.attention_seekers.size() == 0 && (ev = SideBar.this.attention_event) != null) {
                                ev.cancel();
                                SideBar.this.attention_event = null;
                            }
                        }
                        if (repaints.size() > 0) {
                            Utils.execSWTThread(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    for (SideBarEntrySWT entry : repaints) {
                                        entry.redraw();
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    private TreeItem getTreeItemAt(int pos) {
        TreeItem[] items = this.tree.getItems();
        return this.getTreeItemAt(items, new int[]{pos});
    }

    private TreeItem getTreeItemAt(TreeItem[] items, int[] pos) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem x;
            TreeItem ti = treeItemArray[n2];
            if (pos[0] == 0) {
                return ti;
            }
            pos[0] = pos[0] - 1;
            if (ti.getExpanded() && (x = this.getTreeItemAt(ti.getItems(), pos)) != null) {
                return x;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void addItem(BaseMdiEntry entry) {
        super.addItem(entry);
    }

    @Override
    protected void itemSelected(MdiEntry entry) {
        super.itemSelected(entry);
        this.addHistory(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BaseMdiEntry closeEntryByID(String id, boolean user_initiated) {
        SideBarEntrySWT currentBeforeClose = this.getSelectedEntry();
        BaseMdiEntry entry = super.closeEntryByID(id, user_initiated);
        if (entry == null || Utils.isDisplayDisposed()) {
            return entry;
        }
        String next = null;
        Stack<String> stack = this.entryViewHistory;
        synchronized (stack) {
            this.entryViewHistory.remove(id);
            if (currentBeforeClose == null) {
                return entry;
            }
            if (currentBeforeClose != null && currentBeforeClose != entry) {
                return entry;
            }
            while (!this.entryViewHistory.isEmpty() && !this.entryExists(next = this.entryViewHistory.pop())) {
                next = null;
            }
        }
        if (next == null) {
            next = "Library";
        }
        this.showEntryByID(next);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistory(MdiEntry entry) {
        Stack<String> stack = this.entryViewHistory;
        synchronized (stack) {
            String id = entry.getViewID();
            if (!this.entryViewHistory.remove(id) && !this.entryViewFuture.contains(id)) {
                this.entryViewFuture.clear();
            }
            if (entry.isSelectable()) {
                if (!this.isInitialized()) {
                    this.entryViewHistory.clear();
                }
                this.entryViewHistory.push(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNext() {
        SideBarEntrySWT current = this.getSelectedEntry();
        String next = null;
        Stack<String> stack = this.entryViewHistory;
        synchronized (stack) {
            while (!this.entryViewFuture.isEmpty()) {
                String maybe_next = this.entryViewFuture.pop();
                if (!this.entryExists(maybe_next) || current != null && current.getViewID().equals(maybe_next)) continue;
                next = maybe_next;
                this.entryViewHistory.push(next);
                break;
            }
        }
        if (next != null) {
            this.showEntryByID(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPrevious() {
        SideBarEntrySWT current = this.getSelectedEntry();
        String next = null;
        Stack<String> stack = this.entryViewHistory;
        synchronized (stack) {
            boolean future_added = false;
            if (current != null && this.entryExists(current.getViewID()) && current.isSelectable()) {
                String cid = current.getViewID();
                if (this.entryViewFuture.isEmpty() || !this.entryViewFuture.peek().equals(cid)) {
                    this.entryViewFuture.push(cid);
                }
                future_added = true;
            }
            while (!this.entryViewHistory.isEmpty()) {
                String maybe_next = this.entryViewHistory.pop();
                if (current != null && current.getViewID().equals(maybe_next) || !this.entryExists(maybe_next)) continue;
                next = maybe_next;
                if (!(future_added || !this.entryViewFuture.isEmpty() && this.entryViewFuture.peek().equals(next))) {
                    this.entryViewFuture.push(next);
                }
                this.entryViewHistory.push(next);
                break;
            }
        }
        if (next == null) {
            next = "Library";
        }
        this.showEntryByID(next);
    }

    @Override
    public void generate(IndentWriter writer) {
        MdiEntrySWT[] entries;
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                MdiEntrySWT entry = mdiEntrySWTArray[n2];
                if (entry != null && !(entry instanceof AEDiagnosticsEvidenceGenerator)) {
                    writer.println("Sidebar View (No Generator): " + entry.getViewID());
                    try {
                        try {
                            writer.indent();
                            writer.println("Parent: " + entry.getParentID());
                            writer.println("Title: " + entry.getTitle());
                        }
                        catch (Exception exception) {
                            writer.exdent();
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        writer.exdent();
                        throw throwable;
                    }
                    writer.exdent();
                }
            }
            ++n2;
        }
    }

    @Override
    public Image obfuscatedImage(Image image) {
        SideBarEntrySWT[] sideBarEntries;
        Rectangle treeBounds = this.tree.getBounds();
        SideBarEntrySWT[] sideBarEntrySWTArray = sideBarEntries = (SideBarEntrySWT[])this.getEntries(new SideBarEntrySWT[0]);
        int n = sideBarEntries.length;
        int n2 = 0;
        while (n2 < n) {
            SideBarEntrySWT entry = sideBarEntrySWTArray[n2];
            Rectangle entryBounds = entry.swt_getBounds();
            if (entryBounds != null && treeBounds.intersects(entryBounds)) {
                entry.obfuscatedImage(image);
            }
            ++n2;
        }
        return image;
    }

    @Override
    public SideBarEntrySWT getEntry(String id) {
        return (SideBarEntrySWT)super.getEntry(id);
    }

    @Override
    public SideBarEntrySWT getSelectedEntry() {
        return (SideBarEntrySWT)super.getSelectedEntry();
    }

    private void setMenuEntry(SideBarEntrySWT me) {
        this.activeMenuEntry = me;
        if (me != null) {
            this.lastMenuEntry = me;
        }
    }

    @Override
    public SideBarEntrySWT getMenuEntry(boolean activeOnly) {
        return activeOnly ? this.activeMenuEntry : this.lastMenuEntry;
    }

    @Override
    public SideBarEntrySWT getEntryBySkinView(Object skinView) {
        return (SideBarEntrySWT)super.getEntryBySkinView(skinView);
    }

    @Override
    protected SideBarEntrySWT createEntryByCreationListener(String id, Map<?, ?> autoOpenInfo) {
        return (SideBarEntrySWT)super.createEntryByCreationListener(id, autoOpenInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activityStart() {
        List<Runnable> list = this.idle_pending;
        synchronized (list) {
            ++this.activity_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activityEnd() {
        ArrayList<Runnable> to_run = null;
        List<Runnable> list = this.idle_pending;
        synchronized (list) {
            --this.activity_count;
            if (this.activity_count == 0 && !this.idle_pending.isEmpty()) {
                to_run = new ArrayList<Runnable>(this.idle_pending);
                this.idle_pending.clear();
            }
        }
        if (to_run != null) {
            ArrayList<Runnable> x = to_run;
            Runnable doit = () -> {
                for (Runnable r : x) {
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            };
            if (Utils.isSWTThread()) {
                Utils.getOffOfSWTThread(doit);
            } else {
                doit.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWhenIdle(Runnable r) {
        List<Runnable> list = this.idle_pending;
        synchronized (list) {
            if (this.activity_count > 0) {
                this.idle_pending.add(r);
                return;
            }
        }
        r.run();
    }
}

