/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.TabbedEntry;
import com.biglybt.ui.swt.mdi.TabbedMDI;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.IViewAlwaysInitialize;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.stats.ActivityView;
import com.biglybt.ui.swt.views.stats.CacheView;
import com.biglybt.ui.swt.views.stats.CountersView;
import com.biglybt.ui.swt.views.stats.DHTOpsView;
import com.biglybt.ui.swt.views.stats.DHTView;
import com.biglybt.ui.swt.views.stats.TagStatsView;
import com.biglybt.ui.swt.views.stats.TrackerActivityView;
import com.biglybt.ui.swt.views.stats.TransferStatsView;
import com.biglybt.ui.swt.views.stats.VivaldiView;
import com.biglybt.ui.swt.views.stats.XferStatsView;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class StatsView
implements IViewAlwaysInitialize,
UISWTViewCoreEventListener {
    public static String VIEW_ID = "StatsView";
    public static final int EVENT_PERIODIC_UPDATE = 256;
    private TabbedMDI tabbedMDI;
    private UpdateThread updateThread;
    private Object dataSource;
    private UISWTView swtView;
    private Composite parent;

    private void initialize(Composite composite) {
        this.parent = composite;
        StatsView.registerPluginViews();
        this.tabbedMDI = new TabbedMDI(null, VIEW_ID, VIEW_ID, this.swtView, this.dataSource);
        this.tabbedMDI.setDestroyEntriesOnDeactivate(true);
        this.tabbedMDI.buildMDI(composite);
        CTabFolder folder = this.tabbedMDI.getTabFolder();
        Label lblClose = new Label((Composite)folder, 64);
        lblClose.setText("x");
        lblClose.addListener(4, new Listener(){

            public void handleEvent(Event event2) {
                StatsView.this.delete();
            }
        });
        folder.setTopRight((Control)lblClose);
        this.updateThread = new UpdateThread();
        this.updateThread.setDaemon(true);
        this.updateThread.start();
        this.dataSourceChanged(this.dataSource);
    }

    private static void registerPluginViews() {
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        if (vm.areCoreViewsRegistered(VIEW_ID)) {
            return;
        }
        vm.registerView(VIEW_ID, new UISWTViewBuilderCore("SpeedView", null, ActivityView.class));
        vm.registerView(VIEW_ID, new UISWTViewBuilderCore("TransferStatsView", null, TransferStatsView.class));
        vm.registerView(VIEW_ID, new UISWTViewBuilderCore("CacheView", null, CacheView.class));
        vm.registerView(VIEW_ID, new UISWTViewBuilderCore("TrackerActivityView", null, TrackerActivityView.class));
        boolean hasV4 = NetworkAdmin.getSingleton().hasDHTIPV4();
        if (hasV4) {
            vm.registerView(VIEW_ID, new UISWTViewBuilderCore("DHTView", null, DHTView.class).setInitialDatasource(0));
            vm.registerView(VIEW_ID, new UISWTViewBuilderCore("DHTOpsView", null, DHTOpsView.class).setInitialDatasource(0));
            vm.registerView(VIEW_ID, new UISWTViewBuilderCore("VivaldiView", null, VivaldiView.class).setInitialDatasource(0));
        }
        if (NetworkAdmin.getSingleton().hasDHTIPV6()) {
            vm.registerView(VIEW_ID, new UISWTViewBuilderCore("DHTView.6", null, DHTView.class).setInitialDatasource(3));
            if (!hasV4) {
                vm.registerView(VIEW_ID, new UISWTViewBuilderCore("DHTOpsView.6", null, DHTOpsView.class).setInitialDatasource(3));
            }
            vm.registerView(VIEW_ID, new UISWTViewBuilderCore("VivaldiView.6", null, VivaldiView.class).setInitialDatasource(3));
        }
        if (hasV4) {
            if (Constants.isCVSVersion()) {
                vm.registerView(VIEW_ID, new UISWTViewBuilderCore("DHTView.biglybt", null, DHTView.class).setInitialDatasource(4));
                vm.registerView(VIEW_ID, new UISWTViewBuilderCore("VivaldiView.biglybt", null, VivaldiView.class).setInitialDatasource(4));
            } else {
                vm.registerView(VIEW_ID, new UISWTViewBuilderCore("DHTView.biglybt", null, DHTView.class).setInitialDatasource(4));
            }
        }
        vm.registerView(VIEW_ID, new UISWTViewBuilderCore("TagStatsView", null, TagStatsView.class));
        vm.registerView(VIEW_ID, new UISWTViewBuilderCore("XferStatsView", null, XferStatsView.class));
        vm.registerView(VIEW_ID, new UISWTViewBuilderCore("CountersView", null, CountersView.class));
        vm.setCoreViewsRegistered(VIEW_ID);
    }

    private void refresh() {
        if (this.tabbedMDI == null || this.tabbedMDI.isDisposed()) {
            return;
        }
        TabbedEntry entry = this.tabbedMDI.getSelectedEntry();
        if (entry != null) {
            entry.updateUI(false);
        }
    }

    public static String getFullTitle() {
        return MessageText.getString("Stats.title.full");
    }

    private void delete() {
        if (this.updateThread != null) {
            this.updateThread.stopIt();
        }
        Utils.disposeSWTObjects(this.parent);
    }

    private void dataSourceChanged(Object newDataSource) {
        this.dataSource = newDataSource;
        if (this.tabbedMDI == null) {
            return;
        }
        if (newDataSource instanceof String) {
            this.tabbedMDI.showEntryByID((String)newDataSource);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(StatsView.getFullTitle());
                this.swtView.setDestroyOnDeactivate(false);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                this.swtView.setTitle(StatsView.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private class UpdateThread
    extends Thread {
        boolean bContinue;

        public UpdateThread() {
            super("StatsView Update Thread");
        }

        @Override
        public void run() {
            this.bContinue = true;
            while (this.bContinue) {
                MdiEntrySWT[] entries;
                MdiEntrySWT[] mdiEntrySWTArray = entries = StatsView.this.tabbedMDI.getEntries();
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    MdiEntrySWT entry = mdiEntrySWTArray[n2];
                    try {
                        entry.triggerEvent(256, null);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                    ++n2;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    break;
                }
            }
        }

        public void stopIt() {
            this.bContinue = false;
        }
    }
}

