/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.components.graphics.MultiPlotGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.components.graphics.ValueSource;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TrackerActivityView
implements UISWTViewCoreEventListener {
    public static final String MSGID_PREFIX = "TrackerActivityView";
    private static MultiPlotGraphic[] mpg_histories = new MultiPlotGraphic[3];
    private static Color[] mpg_rates_colors = new Color[]{Colors.blues[9], Colors.fadedGreen};
    private static Color[] mpg_lags_colors = new Color[]{Colors.blues[9], Colors.maroon, Colors.fadedGreen};
    private static Color[] mpg_sched_colors = new Color[]{Colors.blues[9], Colors.maroon, Colors.fadedGreen, Colors.dark_grey};
    private Composite panel;
    private MultiPlotGraphic[] mpgs = new MultiPlotGraphic[3];
    private AllTrackersManager.AllTrackers all_trackers = AllTrackersManager.getAllTrackers();

    private void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new GridLayout(2, true));
        Group gRates = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gRates, "TrackerActivityView.rates");
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gRates.setLayoutData((Object)gridData);
        gRates.setLayout((Layout)new GridLayout());
        ValueFormater formatter = new ValueFormater(){

            @Override
            public String format(int value) {
                return String.valueOf((float)value / 1000.0f) + "/" + TimeFormatter.getShortSuffix(0);
            }
        };
        ValueSource[] sources = new ValueSourceImpl[]{new ValueSourceImpl("Announce", 0, mpg_rates_colors, 0, false, false){

            @Override
            public int getValue() {
                return (int)(TrackerActivityView.this.all_trackers.getAnnouncesPerSecond() * 1000.0f);
            }
        }, new ValueSourceImpl("Scrape", 1, mpg_rates_colors, 0, false, false){

            @Override
            public int getValue() {
                return (int)(TrackerActivityView.this.all_trackers.getScrapesPerSecond() * 1000.0f);
            }
        }};
        MultiPlotGraphic mpg_rates = this.mpgs[0] = MultiPlotGraphic.getInstance(sources, formatter);
        String[] color_configs = new String[]{"TrackerActivityView.legend.rate.announce", "TrackerActivityView.legend.rate.scrape"};
        Legend.LegendListener legend_listener = new Legend.LegendListener((ValueSourceImpl[])sources, mpg_rates){
            private int hover_index = -1;
            private final /* synthetic */ ValueSourceImpl[] val$sources;
            private final /* synthetic */ MultiPlotGraphic val$mpg_rates;
            {
                this.val$sources = valueSourceImplArray;
                this.val$mpg_rates = multiPlotGraphic;
            }

            @Override
            public void hoverChange(boolean entry, int index) {
                if (this.hover_index != -1) {
                    this.val$sources[this.hover_index].setHover(false);
                }
                if (entry) {
                    this.hover_index = index;
                    this.val$sources[index].setHover(true);
                }
                this.val$mpg_rates.refresh(true);
            }

            @Override
            public void visibilityChange(boolean visible, int index) {
                this.val$sources[index].setVisible(visible);
                this.val$mpg_rates.refresh(true);
            }
        };
        Canvas ratesCanvas = new Canvas((Composite)gRates, 262144);
        gridData = new GridData(1808);
        ratesCanvas.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        Legend.createLegendComposite((Composite)gRates, mpg_rates_colors, color_configs, null, gridData, true, legend_listener);
        mpg_rates.initialize(ratesCanvas, false);
        MultiPlotGraphic history = mpg_histories[0];
        if (history != null) {
            mpg_rates.reset(history.getHistory());
        }
        mpg_rates.setActive(true);
        Group gLag = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gLag, "TrackerActivityView.lags");
        gridData = new GridData(1808);
        gLag.setLayoutData((Object)gridData);
        gLag.setLayout((Layout)new GridLayout());
        final Canvas lagsCanvas = new Canvas((Composite)gLag, 262144);
        gridData = new GridData(1808);
        lagsCanvas.setLayoutData((Object)gridData);
        ValueFormater formatter2 = new ValueFormater(){

            @Override
            public String format(int value) {
                String str = value < 10000 ? DisplayFormatters.formatDecimal((double)value / 1000.0, 3, true, true) : String.valueOf(value / 1000);
                return String.valueOf(str) + " " + TimeFormatter.getShortSuffix(0);
            }
        };
        ValueSource[] sources2 = new ValueSourceImpl[]{new ValueSourceImpl("Announce Public", 0, mpg_lags_colors, 0, false, false){

            @Override
            public int getValue() {
                AllTrackersManager.AnnounceStats stats2 = TrackerActivityView.this.all_trackers.getAnnounceStats();
                int result = (int)stats2.getPublicLagMillis();
                Utils.execSWTThread(() -> {
                    int lines;
                    if (lagsCanvas.isDisposed()) {
                        return;
                    }
                    List<String> active = stats2.getPublicActive();
                    String tt = "";
                    if (!active.isEmpty()) {
                        tt = String.valueOf(tt) + MessageText.getString("subs.prop.is_public") + " (" + active.size() + ")\n";
                        lines = 0;
                        for (String s : active) {
                            if (lines == 5) {
                                tt = String.valueOf(tt) + "    ...\n";
                                break;
                            }
                            tt = String.valueOf(tt) + "    " + s + "\n";
                            ++lines;
                        }
                    }
                    if (!(active = stats2.getPrivateActive()).isEmpty()) {
                        if (!tt.isEmpty()) {
                            tt = String.valueOf(tt) + "\n";
                        }
                        tt = String.valueOf(tt) + MessageText.getString("label.private") + " (" + active.size() + ")\n";
                        lines = 0;
                        for (String s : active) {
                            if (lines == 5) {
                                tt = String.valueOf(tt) + "    ...\n";
                                break;
                            }
                            tt = String.valueOf(tt) + "    " + s + "\n";
                            ++lines;
                        }
                    }
                    Utils.setTT((Control)lagsCanvas, tt);
                });
                if (result < 500) {
                    result = 0;
                }
                return result;
            }
        }, new ValueSourceImpl("Announce Private", 1, mpg_lags_colors, 0, false, false){

            @Override
            public int getValue() {
                int result = (int)TrackerActivityView.this.all_trackers.getAnnounceStats().getPrivateLagMillis();
                if (result < 500) {
                    result = 0;
                }
                return result;
            }
        }, new ValueSourceImpl("Scrape", 2, mpg_lags_colors, 0, false, false){

            @Override
            public int getValue() {
                int result = (int)TrackerActivityView.this.all_trackers.getScrapeStats().getLagMillis();
                if (result < 500) {
                    result = 0;
                }
                return result;
            }
        }};
        MultiPlotGraphic mpg_lags = this.mpgs[1] = MultiPlotGraphic.getInstance(sources2, formatter2);
        String[] color_configs2 = new String[]{"TrackerActivityView.legend.lag.announce.pub", "TrackerActivityView.legend.lag.announce.priv", "TrackerActivityView.legend.lag.scrape"};
        Legend.LegendListener legend_listener2 = new Legend.LegendListener((ValueSourceImpl[])sources2, mpg_lags){
            private int hover_index = -1;
            private final /* synthetic */ ValueSourceImpl[] val$sources;
            private final /* synthetic */ MultiPlotGraphic val$mpg_lags;
            {
                this.val$sources = valueSourceImplArray;
                this.val$mpg_lags = multiPlotGraphic;
            }

            @Override
            public void hoverChange(boolean entry, int index) {
                if (this.hover_index != -1) {
                    this.val$sources[this.hover_index].setHover(false);
                }
                if (entry) {
                    this.hover_index = index;
                    this.val$sources[index].setHover(true);
                }
                this.val$mpg_lags.refresh(true);
            }

            @Override
            public void visibilityChange(boolean visible, int index) {
                this.val$sources[index].setVisible(visible);
                this.val$mpg_lags.refresh(true);
            }
        };
        gridData = new GridData(768);
        Legend.createLegendComposite((Composite)gLag, mpg_lags_colors, color_configs2, null, gridData, true, legend_listener2);
        mpg_lags.initialize(lagsCanvas, false);
        history = mpg_histories[1];
        if (history != null) {
            mpg_lags.reset(history.getHistory());
        }
        mpg_lags.setActive(true);
        Group gSched = Utils.createSkinnedGroup(this.panel, 0);
        Messages.setLanguageText((Widget)gSched, "TrackerActivityView.scheduled");
        gridData = new GridData(1808);
        gSched.setLayoutData((Object)gridData);
        gSched.setLayout((Layout)new GridLayout());
        formatter = new ValueFormater(){

            @Override
            public String format(int value) {
                return String.valueOf(value);
            }
        };
        sources = new ValueSourceImpl[]{new ValueSourceImpl("Sched Public", 0, mpg_sched_colors, 0, false, false){

            @Override
            public int getValue() {
                return TrackerActivityView.this.all_trackers.getAnnounceStats().getPublicScheduledCount();
            }
        }, new ValueSourceImpl("Sched Private", 1, mpg_sched_colors, 0, false, false){

            @Override
            public int getValue() {
                return TrackerActivityView.this.all_trackers.getAnnounceStats().getPrivateScheduledCount();
            }
        }, new ValueSourceImpl("Sched Active", 2, mpg_sched_colors, 0, false, false){

            @Override
            public int getValue() {
                return TrackerActivityView.this.all_trackers.getActiveRequestCount();
            }
        }, new ValueSourceImpl("Sched Pending", 3, mpg_sched_colors, 0, false, false){

            @Override
            public int getValue() {
                AllTrackersManager.AnnounceStats stats2 = TrackerActivityView.this.all_trackers.getAnnounceStats();
                return stats2.getPrivatePendingCount() + stats2.getPublicPendingCount();
            }
        }};
        MultiPlotGraphic mpg_sched = this.mpgs[2] = MultiPlotGraphic.getInstance(sources, formatter);
        color_configs = new String[]{"TrackerActivityView.legend.sched.announce.pub", "TrackerActivityView.legend.sched.announce.priv", "TrackerActivityView.legend.sched.announce.active", "TrackerActivityView.legend.sched.announce.pending"};
        legend_listener = new Legend.LegendListener((ValueSourceImpl[])sources, mpg_sched){
            private int hover_index = -1;
            private final /* synthetic */ ValueSourceImpl[] val$sources;
            private final /* synthetic */ MultiPlotGraphic val$mpg_sched;
            {
                this.val$sources = valueSourceImplArray;
                this.val$mpg_sched = multiPlotGraphic;
            }

            @Override
            public void hoverChange(boolean entry, int index) {
                if (this.hover_index != -1) {
                    this.val$sources[this.hover_index].setHover(false);
                }
                if (entry) {
                    this.hover_index = index;
                    this.val$sources[index].setHover(true);
                }
                this.val$mpg_sched.refresh(true);
            }

            @Override
            public void visibilityChange(boolean visible, int index) {
                this.val$sources[index].setVisible(visible);
                this.val$mpg_sched.refresh(true);
            }
        };
        Canvas lagsCanvas2 = new Canvas((Composite)gSched, 262144);
        gridData = new GridData(1808);
        lagsCanvas2.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        Legend.createLegendComposite((Composite)gSched, mpg_sched_colors, color_configs, null, gridData, true, legend_listener);
        mpg_sched.initialize(lagsCanvas2, false);
        history = mpg_histories[2];
        if (history != null) {
            mpg_sched.reset(history.getHistory());
        }
        mpg_sched.setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        Class<TrackerActivityView> clazz = TrackerActivityView.class;
        synchronized (TrackerActivityView.class) {
            int i = 0;
            while (i < mpg_histories.length) {
                MultiPlotGraphic mpg;
                if (mpg_histories[i] == null && (mpg = this.mpgs[i]) != null) {
                    TrackerActivityView.mpg_histories[i] = mpg;
                    mpg.dispose(true);
                    this.mpgs[i] = null;
                    int f_i = i;
                    Utils.execSWTThread(() -> {
                        Shell shell = Utils.findAnyShell(true);
                        if (shell != null && !shell.isDisposed()) {
                            shell.addListener(12, ev -> {
                                Class<TrackerActivityView> clazz = TrackerActivityView.class;
                                synchronized (TrackerActivityView.class) {
                                    if (mpg_histories[f_i] != null) {
                                        mpg_histories[f_i].dispose();
                                        TrackerActivityView.mpg_histories[n] = null;
                                    }
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return;
                                }
                            });
                        }
                    });
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            int i2 = 0;
            while (i2 < this.mpgs.length) {
                if (this.mpgs[i2] != null) {
                    this.mpgs[i2].dispose();
                    this.mpgs[i2] = null;
                }
                ++i2;
            }
            return;
        }
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh(boolean force) {
        int i = 0;
        while (i < this.mpgs.length) {
            if (this.mpgs[i] != null) {
                this.mpgs[i].refresh(force);
            }
            ++i;
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                UISWTView swtView = event2.getView();
                swtView.setTitle(MessageText.getString("TrackerActivityView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.refresh(true);
                break;
            }
            case 5: {
                this.refresh(false);
            }
        }
        return true;
    }

    private static abstract class ValueSourceImpl
    implements ValueSource {
        private String name;
        private int index;
        private Color[] colours;
        private int base_style;
        private boolean trimmable;
        private boolean is_hover;
        private boolean is_invisible;
        private boolean is_dotted;

        private ValueSourceImpl(String _name, int _index, Color[] _colours, boolean _is_up, boolean _trimmable, boolean _is_dotted) {
            this.name = _name;
            this.index = _index;
            this.colours = _colours;
            this.trimmable = _trimmable;
            this.is_dotted = _is_dotted;
            this.base_style = _is_up ? 1 : 2;
        }

        private ValueSourceImpl(String _name, int _index, Color[] _colours, int _base_style, boolean _trimmable, boolean _is_dotted) {
            this.name = _name;
            this.index = _index;
            this.colours = _colours;
            this.trimmable = _trimmable;
            this.is_dotted = _is_dotted;
            this.base_style = _base_style;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Color getLineColor() {
            return this.colours[this.index];
        }

        @Override
        public boolean isTrimmable() {
            return this.trimmable;
        }

        private void setHover(boolean h) {
            this.is_hover = h;
        }

        private void setVisible(boolean visible) {
            this.is_invisible = !visible;
        }

        @Override
        public int getStyle() {
            if (this.is_invisible) {
                return 16;
            }
            int style = this.base_style;
            if (this.is_hover) {
                style |= 8;
            }
            if (this.is_dotted) {
                style |= 0x40;
            }
            return style;
        }

        @Override
        public int getAlpha() {
            return this.is_dotted ? 128 : 255;
        }
    }
}

