/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.stats;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.PeersViewBase;
import com.biglybt.ui.swt.views.stats.BasePanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class XferStatsPanel
extends BasePanel {
    private static final int ALPHA_FOCUS = 255;
    private static final int ALPHA_NOFOCUS = 150;
    private final boolean is_global;
    private final String config_key;
    private Display display;
    private BufferedLabel header_label;
    private Canvas canvas;
    private BasePanel.Scale scale = new BasePanel.Scale();
    private boolean button1_selected;
    private Image img;
    private int alpha = 255;
    private boolean autoAlpha = false;
    private boolean initialised;
    private GlobalManagerStats.AggregateStats my_stats;
    private long latest_sequence = Long.MAX_VALUE;
    int flag_width;
    int flag_height;
    int text_height;
    private List<Object[]> currentPositions = new ArrayList<Object[]>();
    private Node hover_node;
    private float tp_ratio;
    private boolean isRefreshQueued = false;

    public XferStatsPanel(Composite composite, boolean _is_global) {
        this.is_global = _is_global;
        this.config_key = this.is_global ? "XferStats.show.samples" : "XferStats.local.show.rates";
        this.button1_selected = COConfigurationManager.getBooleanParameter(this.config_key);
        this.display = composite.getDisplay();
        boolean dark = Utils.isDarkAppearanceNative();
        Color white = ColorCache.getColor((Device)this.display, 255, 255, 255);
        Color dark_grey = Colors.dark_grey;
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        if (!dark) {
            panel.setBackground(white);
        }
        this.header_label = new BufferedLabel(panel, 0x20000000);
        GridData grid_data = new GridData(768);
        grid_data.horizontalIndent = 5;
        this.header_label.setLayoutData(grid_data);
        if (!dark) {
            this.header_label.getControl().setBackground(white);
            this.header_label.getControl().setForeground(dark_grey);
        }
        if (!this.is_global) {
            Messages.setLanguageText(this.header_label.getWidget(), "XferStatsView.local.header");
        }
        Composite controls = new Composite(panel, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.numColumns = 3;
        controls.setLayout((Layout)layout);
        if (!dark) {
            controls.setBackground(white);
        }
        Label label = new Label(controls, 0);
        if (!dark) {
            label.setBackground(white);
            label.setForeground(dark_grey);
        }
        Messages.setLanguageText((Widget)label, "ConfigView.section.display");
        final Button button1 = new Button(controls, 16);
        if (!dark) {
            button1.setBackground(white);
            button1.setForeground(dark_grey);
        }
        Messages.setLanguageText((Widget)button1, this.is_global ? "label.samples" : "Pieces.column.speed");
        button1.setSelection(this.button1_selected);
        Button button2 = new Button(controls, 16);
        if (!dark) {
            button2.setBackground(white);
            button2.setForeground(dark_grey);
        }
        Messages.setLanguageText((Widget)button2, this.is_global ? "label.throughput" : "SpeedView.stats.total");
        button2.setSelection(!this.button1_selected);
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XferStatsPanel.this.button1_selected = button1.getSelection();
                COConfigurationManager.setParameter(XferStatsPanel.this.config_key, XferStatsPanel.this.button1_selected);
                XferStatsPanel.this.requestRefresh();
            }
        };
        button1.addSelectionListener((SelectionListener)sa);
        button2.addSelectionListener((SelectionListener)sa);
        this.canvas = new Canvas(panel, 262144);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 2;
        this.canvas.setLayoutData((Object)grid_data);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (XferStatsPanel.this.img != null && !XferStatsPanel.this.img.isDisposed()) {
                    Rectangle bounds = XferStatsPanel.this.img.getBounds();
                    if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                        if (XferStatsPanel.this.alpha != 255) {
                            try {
                                e.gc.setAlpha(XferStatsPanel.this.alpha);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        e.gc.drawImage(XferStatsPanel.this.img, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                } else {
                    e.gc.setBackground(Utils.isDarkAppearanceNative() ? XferStatsPanel.this.canvas.getBackground() : Colors.white);
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    if (!XferStatsPanel.this.initialised) {
                        e.gc.drawText(MessageText.getString("v3.MainWindow.view.wait"), 10, 10, true);
                    }
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event2) {
                XferStatsPanel.this.scale.mouseDown(event2);
            }

            public void mouseUp(MouseEvent event2) {
                XferStatsPanel.this.scale.mouseUp(event2);
                if (event2.button == 3) {
                    Menu menu = XferStatsPanel.this.canvas.getMenu();
                    if (menu != null && !menu.isDisposed()) {
                        menu.dispose();
                    }
                    Node closest = null;
                    int closest_distance = Integer.MAX_VALUE;
                    int x = event2.x;
                    int y = event2.y;
                    for (Object[] entry : XferStatsPanel.this.currentPositions) {
                        int e_y;
                        long y_diff;
                        int e_x = (Integer)entry[0];
                        long x_diff = x - e_x;
                        int distance = (int)Math.sqrt(x_diff * x_diff + (y_diff = (long)(y - (e_y = ((Integer)entry[1]).intValue()))) * y_diff);
                        if (distance >= closest_distance) continue;
                        closest_distance = distance;
                        closest = (Node)entry[2];
                    }
                    if (closest_distance <= 30) {
                        menu = new Menu((Control)XferStatsPanel.this.canvas);
                        PeersViewBase.addPeerSetMenu(menu, false, closest.cc);
                        Point cursorLocation = Display.getCurrent().getCursorLocation();
                        menu.setLocation(cursorLocation.x, cursorLocation.y);
                        menu.setVisible(true);
                    }
                }
                XferStatsPanel.this.refresh();
            }

            public void mouseDoubleClick(MouseEvent e) {
                XferStatsPanel.this.scale.reset();
                XferStatsPanel.this.refresh();
            }
        });
        this.canvas.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
            }
        });
        this.canvas.addListener(37, new Listener(){

            public void handleEvent(Event event2) {
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event2) {
                if (XferStatsPanel.this.scale.mouseMove(event2)) {
                    XferStatsPanel.this.requestRefresh();
                }
            }
        });
        this.canvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                int x = e.x;
                int y = e.y;
                Node closest = null;
                int closest_distance = Integer.MAX_VALUE;
                for (Object[] entry : XferStatsPanel.this.currentPositions) {
                    int e_y;
                    long y_diff;
                    int e_x = (Integer)entry[0];
                    long x_diff = x - e_x;
                    int distance = (int)Math.sqrt(x_diff * x_diff + (y_diff = (long)(y - (e_y = ((Integer)entry[1]).intValue()))) * y_diff);
                    if (distance >= closest_distance) continue;
                    closest_distance = distance;
                    closest = (Node)entry[2];
                }
                if (closest_distance <= 30) {
                    Utils.setTT((Control)XferStatsPanel.this.canvas, closest.getToolTip());
                    XferStatsPanel.this.hover_node = closest;
                } else {
                    XferStatsPanel.this.hover_node = null;
                    Utils.setTT((Control)XferStatsPanel.this.canvas, "");
                }
                XferStatsPanel.this.requestRefresh();
            }

            public void mouseExit(MouseEvent e) {
                if (XferStatsPanel.this.autoAlpha) {
                    XferStatsPanel.this.setAlpha(150);
                }
            }

            public void mouseEnter(MouseEvent e) {
                if (XferStatsPanel.this.autoAlpha) {
                    XferStatsPanel.this.setAlpha(255);
                }
            }
        });
        this.canvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                XferStatsPanel.this.requestRefresh();
            }
        });
    }

    public void setLayoutData(Object data) {
        this.canvas.setLayoutData(data);
    }

    public void init(GlobalManagerStats.AggregateStats _stats) {
        this.initialised = true;
        this.my_stats = _stats;
        this.requestRefresh();
    }

    private String getBPSForDisplay(long bytes) {
        if (this.is_global || this.button1_selected) {
            if (this.button1_selected) {
                bytes /= 60L;
            } else {
                if (this.tp_ratio == 0.0f) {
                    return "";
                }
                bytes = (long)(this.tp_ratio * (float)bytes / 60.0f);
            }
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(bytes);
        }
        return DisplayFormatters.formatByteCountToKiBEtc(bytes);
    }

    public void refreshView() {
        if (this.my_stats == null) {
            return;
        }
        if (this.latest_sequence == Long.MAX_VALUE || this.latest_sequence != (long)this.my_stats.getSequence()) {
            this.refresh();
        }
    }

    public void requestRefresh() {
        if (this.isRefreshQueued) {
            return;
        }
        this.isRefreshQueued = true;
        Utils.execSWTThreadLater(20, () -> {
            this.isRefreshQueued = false;
            this.refresh();
        });
    }

    public void refresh() {
        boolean needNewImage;
        if (this.canvas.isDisposed()) {
            return;
        }
        Point canvasSize = this.canvas.getSize();
        Rectangle size = new Rectangle(0, 0, canvasSize.x, canvasSize.y);
        if (size.width <= 0 || size.height <= 0) {
            return;
        }
        this.scale.setSize(size);
        boolean bl = needNewImage = this.img == null || this.img.isDisposed();
        if (!needNewImage) {
            Rectangle bounds = this.img.getBounds();
            boolean bl2 = needNewImage = bounds.width != size.width || bounds.height != size.height;
        }
        if (needNewImage) {
            this.img = new Image((Device)this.display, size);
        }
        GC gc = new GC((Drawable)this.img);
        boolean dark = Utils.isDarkAppearanceNative();
        try {
            gc.setAdvanced(true);
            gc.setAntialias(1);
            gc.setTextAntialias(1);
            Color white = ColorCache.getColor((Device)this.display, 255, 255, 255);
            gc.setForeground(white);
            gc.setBackground(dark ? this.canvas.getBackground() : white);
            gc.fillRectangle(size);
            if (this.my_stats == null) {
                return;
            }
            gc.setForeground(dark ? Colors.light_grey : Colors.black);
            this.flag_width = this.scale.getReverseWidth(25.0f);
            this.flag_height = this.scale.getReverseHeight(15.0f);
            Point text_extent = gc.textExtent("1234567890" + DisplayFormatters.formatByteCountToKiBEtcPerSec(1024L));
            this.text_height = this.scale.getReverseHeight(text_extent.y);
            this.currentPositions.clear();
            this.latest_sequence = this.my_stats.getSequence();
            if (this.is_global) {
                String throughput;
                float samples = this.my_stats.getSamples();
                float population = this.my_stats.getEstimatedPopulation();
                long received = this.my_stats.getLatestReceived();
                long sent = this.my_stats.getLatestSent();
                if (samples > 0.0f && population > 0.0f) {
                    this.tp_ratio = population / samples;
                    throughput = DisplayFormatters.formatByteCountToKiBEtcPerSec((long)(this.tp_ratio * (float)(received + sent) / 60.0f));
                } else {
                    this.tp_ratio = 0.0f;
                    throughput = "";
                }
                String header = MessageText.getString("XferStatsView.header", new String[]{String.valueOf((int)samples), String.valueOf((int)population), throughput});
                this.header_label.setText(header);
            }
            Map<String, Map<String, long[]>> stats2 = this.my_stats.getStats();
            ArrayList<Node> origins = new ArrayList<Node>();
            HashMap<String, Node> dest_recv_map = new HashMap<String, Node>();
            HashMap<String, Node> dest_sent_map = new HashMap<String, Node>();
            for (Map.Entry<String, Map<String, long[]>> entry : stats2.entrySet()) {
                String from_cc = entry.getKey();
                if (from_cc.isEmpty()) continue;
                Node from_node = new Node(0);
                origins.add(from_node);
                Image from_image = ImageRepository.getCountryFlag(from_cc, false);
                from_node.cc = from_cc;
                from_node.image = from_image;
                from_node.links = new LinkedList<Link>();
                for (Map.Entry<String, long[]> entry2 : entry.getValue().entrySet()) {
                    Node to_node;
                    long to_sent;
                    long to_recv;
                    String to_cc = entry2.getKey();
                    if (to_cc.isEmpty()) continue;
                    long[] to_counts = entry2.getValue();
                    if (this.is_global || this.button1_selected) {
                        to_recv = to_counts[0];
                        to_sent = to_counts[1];
                    } else {
                        to_recv = to_counts[2];
                        to_sent = to_counts[3];
                    }
                    Image to_image = ImageRepository.getCountryFlag(to_cc, false);
                    if (to_recv > 0L) {
                        to_node = (Node)dest_recv_map.get(to_cc);
                        if (to_node == null) {
                            to_node = new Node(1);
                            dest_recv_map.put(to_cc, to_node);
                            to_node.cc = to_cc;
                            to_node.image = to_image;
                        }
                        from_node.count_recv += to_recv;
                        to_node.count_recv += to_recv;
                        Link link = new Link(from_node, to_node, to_recv, false);
                        from_node.links.add(link);
                    }
                    if (to_sent <= 0L) continue;
                    to_node = (Node)dest_sent_map.get(to_cc);
                    if (to_node == null) {
                        to_node = new Node(2);
                        dest_sent_map.put(to_cc, to_node);
                        to_node.cc = to_cc;
                        to_node.image = to_image;
                    }
                    from_node.count_sent += to_sent;
                    to_node.count_sent += to_sent;
                    Link link = new Link(from_node, to_node, to_sent, true);
                    from_node.links.add(link);
                }
            }
            ArrayList dests_recv = new ArrayList(dest_recv_map.values());
            ArrayList dests_sent = new ArrayList(dest_sent_map.values());
            float lhs = this.scale.getMinX();
            float rhs = this.scale.getMaxX() - (float)this.flag_width - 10.0f;
            boolean hide_nodes = origins.size() > 1;
            int i = 0;
            while (i < 3) {
                boolean odd;
                int flag_y;
                ArrayList<Object> nodes;
                int flag_x = -1000 + this.scale.getReverseHeight(5.0f);
                if (i == 0) {
                    nodes = dests_recv;
                    flag_y = -1000 + this.text_height;
                    odd = false;
                } else if (i == 1) {
                    nodes = dests_sent;
                    flag_y = 1000 - this.flag_height - this.text_height - this.scale.getReverseHeight(5.0f);
                    odd = true;
                } else {
                    nodes = origins;
                    flag_y = dests_recv.isEmpty() && dests_sent.isEmpty() ? -this.flag_height / 2 : (dests_recv.isEmpty() ? -1000 + this.text_height : (dests_sent.isEmpty() ? 1000 - this.flag_height - this.text_height - this.scale.getReverseHeight(5.0f) : -this.flag_height / 2));
                    odd = true;
                }
                Collections.sort(nodes, new Comparator<Node>(){

                    @Override
                    public int compare(Node o1, Node o2) {
                        return Long.compare(o2.count_recv + o2.count_sent, o1.count_recv + o1.count_sent);
                    }
                });
                int max_flags = (int)((rhs - lhs) / (float)(2 * this.flag_width));
                int pad = nodes.size() >= max_flags ? 0 : (int)(lhs + 2000.0f - (float)(nodes.size() * 2 * this.flag_width / 2));
                for (Node node : nodes) {
                    node.x_pos = flag_x + pad;
                    node.y_pos = flag_y;
                    if ((float)node.x_pos > rhs || (float)node.x_pos < lhs) {
                        if (hide_nodes) {
                            node.hidden = true;
                            flag_x += this.flag_width;
                            continue;
                        }
                        flag_x += this.flag_width * 2;
                        continue;
                    }
                    flag_x += this.flag_width * 2;
                }
                boolean bl3 = nodes == origins;
                ArrayList<Link> hup_links = new ArrayList<Link>(1024);
                ArrayList<Link> hdown_links = new ArrayList<Link>(1024);
                for (Node node : nodes) {
                    if (node.hidden) continue;
                    node.draw(gc, odd);
                    boolean bl4 = odd = !odd;
                    if (!bl3) continue;
                    for (Link link : node.links) {
                        if (!link.isVisible() || !link.draw(gc)) continue;
                        if (link.upload) {
                            hup_links.add(link);
                            continue;
                        }
                        hdown_links.add(link);
                    }
                }
                if (!hup_links.isEmpty() || !hdown_links.isEmpty()) {
                    Comparator<Link> comparator = new Comparator<Link>(){

                        @Override
                        public int compare(Link o1, Link o2) {
                            int diff = o1.target.x_pos - o2.target.x_pos;
                            if (diff == 0) {
                                diff = o1.source.x_pos - o2.source.x_pos;
                            }
                            return diff;
                        }
                    };
                    Collections.sort(hup_links, comparator);
                    Collections.sort(hdown_links, comparator);
                    int pos = 0;
                    for (Link link : hup_links) {
                        link.drawCount(gc, pos++);
                    }
                    pos = 0;
                    for (Link link : hdown_links) {
                        link.drawCount(gc, pos++);
                    }
                }
                ++i;
            }
        }
        finally {
            gc.dispose();
            this.canvas.redraw();
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setAutoAlpha(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
        if (autoAlpha) {
            this.setAlpha(this.canvas.getDisplay().getCursorControl() == this.canvas ? 255 : 150);
        }
    }

    public void delete() {
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
    }

    private class Link {
        final boolean upload;
        final Node source;
        final Node target;
        final long count;

        private Link(Node _source, Node _target, long _count, boolean is_upload) {
            this.source = _source;
            this.target = _target;
            this.count = _count;
            this.upload = is_upload;
        }

        private boolean isVisible() {
            return !this.source.hidden && !this.target.hidden;
        }

        private boolean draw(GC gc) {
            boolean hovering;
            int y2;
            int y1;
            boolean above = this.source.y_pos > this.target.y_pos;
            int x1 = this.source.x_pos + XferStatsPanel.this.flag_width / 2;
            int x2 = this.target.x_pos + XferStatsPanel.this.flag_width / 2;
            if (above) {
                y1 = this.source.y_pos - XferStatsPanel.this.text_height;
                y2 = this.target.y_pos + XferStatsPanel.this.flag_height + XferStatsPanel.this.text_height;
            } else {
                y1 = this.source.y_pos + XferStatsPanel.this.flag_height + XferStatsPanel.this.text_height;
                y2 = this.target.y_pos - XferStatsPanel.this.text_height;
            }
            int[] xy1 = XferStatsPanel.this.scale.getXY(x1, y1);
            int[] xy2 = XferStatsPanel.this.scale.getXY(x2, y2);
            Color old = gc.getForeground();
            boolean bl = hovering = XferStatsPanel.this.hover_node != null && (this.source.cc.equals(((XferStatsPanel)XferStatsPanel.this).hover_node.cc) || this.target.cc.equals(((XferStatsPanel)XferStatsPanel.this).hover_node.cc));
            if (hovering) {
                gc.setForeground(Colors.fadedGreen);
                gc.setLineWidth(2);
            } else {
                long per_sec = this.count / 60L;
                int kinb = DisplayFormatters.getKinB();
                if (per_sec > (long)(10 * kinb * kinb)) {
                    gc.setForeground(Colors.blue);
                } else {
                    int blues_index = per_sec > (long)(kinb * kinb) ? 9 : (per_sec > (long)(100 * kinb) ? 7 : (per_sec > (long)(10 * kinb) ? 5 : 3));
                    gc.setForeground(Colors.blues[blues_index]);
                }
                gc.setLineWidth(1);
            }
            gc.drawLine(xy1[0], xy1[1], xy2[0], xy2[1]);
            gc.setForeground(old);
            return hovering;
        }

        private void drawCount(GC gc, int link_num) {
            int y2;
            int y1;
            boolean above = this.source.y_pos > this.target.y_pos;
            int x1 = this.source.x_pos + XferStatsPanel.this.flag_width / 2;
            int x2 = this.target.x_pos + XferStatsPanel.this.flag_width / 2;
            if (above) {
                y1 = this.source.y_pos - XferStatsPanel.this.text_height;
                y2 = this.target.y_pos + XferStatsPanel.this.flag_height + XferStatsPanel.this.text_height;
            } else {
                y1 = this.source.y_pos + XferStatsPanel.this.flag_height + XferStatsPanel.this.text_height;
                y2 = this.target.y_pos - XferStatsPanel.this.text_height;
            }
            int[] xy1 = XferStatsPanel.this.scale.getXY(x1, y1);
            int[] xy2 = XferStatsPanel.this.scale.getXY(x2, y2);
            int x_diff = xy2[0] - xy1[0];
            int y_diff = xy2[1] - xy1[1];
            int room = Math.abs(y2 - y1) / XferStatsPanel.this.text_height;
            if (room == 0) {
                room = 1;
            }
            float x_chunk = (float)x_diff / (float)room;
            float y_chunk = (float)y_diff / (float)room;
            int offset = 0;
            if (room > 6) {
                room -= 2;
                offset = 1;
            }
            int slot = offset + link_num % room;
            String speed = XferStatsPanel.this.getBPSForDisplay(this.count);
            String nums = speed;
            int pos = nums.indexOf(" ");
            if (pos != -1) {
                nums = nums.substring(0, pos);
            }
            int speed_width = gc.textExtent((String)nums).x;
            int speed_height = gc.textExtent((String)nums).y;
            int speed_pad_x = speed_width / 2;
            int speed_pad_y = speed_height / 2;
            int x_pos = (int)((float)xy1[0] + x_chunk * (float)slot);
            int y_pos = (int)((float)xy1[1] + y_chunk * (float)slot);
            Color old = gc.getForeground();
            gc.setForeground(Colors.fadedRed);
            gc.drawText(speed, x_pos - speed_pad_x, y_pos - speed_pad_y);
            gc.setForeground(old);
        }
    }

    private class Node {
        final int type;
        String cc;
        Image image;
        long count_sent;
        long count_recv;
        List<Link> links;
        int x_pos;
        int y_pos;
        boolean hidden;

        private Node(int _type) {
            this.type = _type;
        }

        private void draw(GC gc, boolean odd) {
            String speed = XferStatsPanel.this.getBPSForDisplay(this.count_recv + this.count_sent);
            String nums = speed;
            int pos = nums.indexOf(" ");
            if (pos != -1) {
                nums = nums.substring(0, pos);
            }
            int speed_width = gc.textExtent((String)nums).x;
            int speed_pad = (XferStatsPanel.this.flag_width - XferStatsPanel.this.scale.getReverseWidth(speed_width)) / 2;
            int[] xy = XferStatsPanel.this.scale.getXY(speed_pad + this.x_pos, odd ? this.y_pos + XferStatsPanel.this.flag_height : this.y_pos - XferStatsPanel.this.text_height);
            gc.drawText(speed, xy[0], xy[1]);
            int width = this.image == null ? gc.textExtent((String)this.cc).x : this.image.getBounds().width;
            int flag_pad = (XferStatsPanel.this.flag_width - XferStatsPanel.this.scale.getReverseWidth(width)) / 2;
            xy = XferStatsPanel.this.scale.getXY(flag_pad + this.x_pos, this.y_pos);
            if (this.image == null) {
                gc.drawText(this.cc, xy[0], xy[1]);
            } else {
                gc.drawImage(this.image, xy[0], xy[1]);
            }
            XferStatsPanel.this.currentPositions.add(new Object[]{xy[0], xy[1], this});
        }

        private String getToolTip() {
            String tt = Utils.getCCString(this.cc);
            if (this.type == 0) {
                if (this.count_recv > 0L) {
                    tt = String.valueOf(tt) + "; " + MessageText.getString("label.download") + "=" + XferStatsPanel.this.getBPSForDisplay(this.count_recv);
                }
                if (this.count_sent > 0L) {
                    tt = String.valueOf(tt) + "; " + MessageText.getString("label.upload") + "=" + XferStatsPanel.this.getBPSForDisplay(this.count_sent);
                }
            } else if (this.type == 1) {
                if (this.count_recv > 0L) {
                    tt = String.valueOf(tt) + "; " + MessageText.getString("label.upload") + "=" + XferStatsPanel.this.getBPSForDisplay(this.count_recv);
                }
            } else if (this.count_sent > 0L) {
                tt = String.valueOf(tt) + "; " + MessageText.getString("label.download") + "=" + XferStatsPanel.this.getBPSForDisplay(this.count_sent);
            }
            return tt;
        }
    }
}

