/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.impl;

import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableRowMouseEvent;
import com.biglybt.pif.ui.tables.TableRowMouseListener;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.TableCellSWTBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class TableRowSWTBase
implements TableRowSWT {
    public static boolean DEBUG_ROW_PAINT = false;
    protected final Object lock;
    private final TableViewSWT tv;
    private final TableRowCore parentRow;
    private final Object coreDataSource;
    private int lastIndex = -1;
    private int visibleRowIndex = -1;
    protected Map<String, TableCellSWTBase> mTableCells;
    private boolean bDisposed;
    private Object pluginDataSource;
    protected boolean wasShown = false;
    private boolean bSetNotUpToDateLastRefresh;
    private ArrayList<TableRowMouseListener> mouseListeners;
    private Map<String, Object> dataList;
    private int alpha = 255;
    private int fontStyle;
    private boolean expanded;
    private boolean isAttention;

    public TableRowSWTBase(Object lock, TableRowCore parentRow, TableViewSWT tv, Object dataSource) {
        this.lock = lock;
        this.parentRow = parentRow;
        this.tv = tv;
        this.coreDataSource = dataSource;
    }

    @Override
    public void invalidate() {
        this.invalidate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(boolean mustRefresh) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return;
            }
            for (TableCellCore tableCellCore : this.mTableCells.values()) {
                if (tableCellCore == null) continue;
                tableCellCore.invalidate(mustRefresh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doesAnyCellHaveFlag(int flag) {
        Object object = this.lock;
        synchronized (object) {
            TableCellCore cell;
            if (this.bDisposed || this.mTableCells == null) {
                return false;
            }
            Iterator<TableCellSWTBase> iterator = this.mTableCells.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((cell = (TableCellCore)iterator.next()) instanceof TableCellSWTBase) || !((TableCellSWTBase)cell).hasFlag(flag));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCellFlag(int flag) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return;
            }
            for (TableCellCore tableCellCore : this.mTableCells.values()) {
                if (tableCellCore == null) continue;
                ((TableCellSWTBase)tableCellCore).setFlag(flag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCellFlag(int flag, boolean subRows) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return;
            }
            for (TableCellCore tableCellCore : this.mTableCells.values()) {
                if (tableCellCore == null) continue;
                ((TableCellSWTBase)tableCellCore).clearFlag(flag);
            }
            if (subRows) {
                TableRowCore[] tableRowCoreArray;
                TableRowCore[] tableRowCoreArray2 = tableRowCoreArray = this.getSubRowsWithNull();
                int n = tableRowCoreArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore row = tableRowCoreArray2[n2];
                    ((TableRowSWTBase)row).clearCellFlag(flag, false);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed) {
                return;
            }
            if (this.mTableCells != null) {
                for (TableCellCore tableCellCore : this.mTableCells.values()) {
                    try {
                        if (tableCellCore == null || tableCellCore.isDisposed()) continue;
                        tableCellCore.dispose();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            }
            this.setHeight(0);
            this.bDisposed = true;
        }
    }

    @Override
    public List refresh(boolean bDoGraphics) {
        if (this.bDisposed) {
            return Collections.EMPTY_LIST;
        }
        boolean bVisible = this.isVisible();
        return this.refresh(bDoGraphics, bVisible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locationChanged(int iStartColumn) {
        if (this.bDisposed || !this.isVisible()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells == null) {
                return;
            }
            for (TableCellCore tableCellCore : this.mTableCells.values()) {
                if (tableCellCore == null || tableCellCore.getTableColumn().getPosition() <= iStartColumn) continue;
                tableCellCore.locationChanged();
            }
        }
    }

    @Override
    public Object getDataSource(boolean bCoreObject) {
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        this.pluginDataSource = PluginCoreUtils.convert(this.coreDataSource, bCoreObject);
        return this.pluginDataSource;
    }

    @Override
    public int getIndex() {
        if (this.bDisposed) {
            return -1;
        }
        if (this.lastIndex >= 0) {
            if (this.parentRow != null) {
                return this.lastIndex;
            }
            TableRowCore row = this.tv.getRowQuick(this.lastIndex);
            if (row == this) {
                return this.lastIndex;
            }
        }
        return this.tv.indexOf(this);
    }

    @Override
    public boolean setVisibleRowIndex(int index) {
        if (index != this.visibleRowIndex) {
            this.visibleRowIndex = index;
            this.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public int getVisibleRowIndex() {
        return this.visibleRowIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore getTableCellCore(String name) {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (!this.bDisposed && this.mTableCells != null) break block4;
                return null;
            }
            return this.mTableCells.get(name);
        }
    }

    @Override
    public boolean isVisible() {
        return this.tv.isRowVisible(this);
    }

    @Override
    public boolean setTableItem(int newIndex) {
        boolean changedIndex;
        if (this.bDisposed) {
            System.out.println("XXX setTI: bDisposed from " + Debug.getCompressedStackTrace());
            return false;
        }
        boolean bl = changedIndex = this.lastIndex != newIndex;
        if (changedIndex) {
            this.lastIndex = newIndex;
        }
        return changedIndex;
    }

    @Override
    public void setSelected(boolean selected) {
        TableView tableView = this.getView();
        if (tableView instanceof TableViewSWT) {
            ((TableViewSWT)tableView).setRowSelected(this, selected, true);
        }
    }

    @Override
    public boolean isRowDisposed() {
        return this.bDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUpToDate(boolean upToDate) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bDisposed || this.mTableCells == null) {
                return;
            }
            for (TableCellCore tableCellCore : this.mTableCells.values()) {
                if (tableCellCore == null) continue;
                tableCellCore.setUpToDate(upToDate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableCellCore> refresh(boolean bDoGraphics, boolean bVisible) {
        ArrayList<TableCellCore> list = Collections.EMPTY_LIST;
        if (this.bDisposed) {
            return list;
        }
        if (!bVisible) {
            if (!this.bSetNotUpToDateLastRefresh) {
                this.setUpToDate(false);
                this.bSetNotUpToDateLastRefresh = true;
            }
            return list;
        }
        this.bSetNotUpToDateLastRefresh = false;
        this.tv.invokeRefreshListeners(this);
        ArrayList<TableCellSWTBase> lTableCells = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells != null) {
                lTableCells = new ArrayList<TableCellSWTBase>(this.mTableCells.values());
            }
        }
        if (lTableCells != null) {
            for (TableCellCore tableCellCore : lTableCells) {
                boolean cellVisible;
                boolean changed;
                TableColumn column;
                if (tableCellCore == null || tableCellCore.isDisposed() || !this.tv.hasSortColumn(column = tableCellCore.getTableColumn()) && !this.tv.isColumnVisible(column) || !(changed = tableCellCore.refresh(bDoGraphics, bVisible, cellVisible = bVisible && tableCellCore.isShown()))) continue;
                if (list == Collections.EMPTY_LIST) {
                    list = new ArrayList<TableCellCore>(lTableCells.size());
                }
                list.add(tableCellCore);
            }
        }
        return list;
    }

    @Override
    public TableViewSWT<?> getView() {
        return this.tv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMouseListener(TableRowMouseListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mouseListeners == null) {
                this.mouseListeners = new ArrayList(1);
            }
            this.mouseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMouseListener(TableRowMouseListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mouseListeners == null) {
                return;
            }
            this.mouseListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeMouseListeners(TableRowMouseEvent event2) {
        ArrayList<TableRowMouseListener> listeners;
        Object object = this.lock;
        synchronized (object) {
            listeners = this.mouseListeners == null ? null : new ArrayList<TableRowMouseListener>(this.mouseListeners);
        }
        if (listeners == null) {
            return;
        }
        int i = 0;
        while (i < listeners.size()) {
            try {
                TableRowMouseListener l = listeners.get(i);
                l.rowMouseTrigger(event2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public boolean isMouseOver() {
        return this.tv.getTableRowWithCursor() == this;
    }

    public boolean canExpand() {
        return this.tv.isExpandEnabled();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean b) {
        if (this.canExpand() && this.expanded != b) {
            this.expanded = b;
            this.tv.invokeExpansionChangeListeners(this, b);
        }
    }

    @Override
    public TableRowCore getParentRowCore() {
        return this.parentRow;
    }

    @Override
    public Object getDataSource() {
        return this.getDataSource(false);
    }

    @Override
    public String getTableID() {
        return this.tv.getTableID();
    }

    @Override
    public void setRequestAttention(boolean on) {
        if (on != this.isAttention) {
            this.isAttention = on;
            this.redraw();
        }
    }

    public boolean isRequestAttention() {
        return this.isAttention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            TableCell cell;
            if (this.bDisposed || this.mTableCells == null) {
                return true;
            }
            boolean valid = true;
            Iterator<TableCellSWTBase> iterator = this.mTableCells.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return valid;
            } while ((cell = (TableCell)iterator.next()) == null || !cell.isValid());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCell getTableCell(String field) {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (!this.bDisposed && this.mTableCells != null) break block4;
                return null;
            }
            return this.mTableCells.get(field);
        }
    }

    @Override
    public boolean isSelected() {
        return this.getView().isSelected(this);
    }

    public boolean isFocused() {
        return this.getView().getFocusedRow() == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String id) {
        TableRowSWTBase tableRowSWTBase = this;
        synchronized (tableRowSWTBase) {
            return this.dataList == null ? null : this.dataList.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String id, Object data) {
        TableRowSWTBase tableRowSWTBase = this;
        synchronized (tableRowSWTBase) {
            if (this.dataList == null) {
                this.dataList = new HashMap<String, Object>(1);
            }
            if (data == null) {
                this.dataList.remove(id);
            } else {
                this.dataList.put(id, data);
            }
        }
    }

    @Override
    public abstract boolean setIconSize(Point var1);

    @Override
    public abstract Color getForeground();

    @Override
    public abstract Color getBackground();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellSWT getTableCellSWT(String name) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (!this.bDisposed && this.mTableCells != null) break block5;
                return null;
            }
            TableCellCore cell = this.mTableCells.get(name);
            if (cell instanceof TableCellSWT) {
                return (TableCellSWT)cell;
            }
            return null;
        }
    }

    @Override
    public abstract Rectangle getBounds();

    @Override
    public abstract void setBackgroundImage(Image var1);

    @Override
    public int getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public boolean setFontStyle(int style) {
        if (this.fontStyle == style) {
            return false;
        }
        this.fontStyle = style;
        this.invalidate();
        return true;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public boolean setAlpha(int alpha) {
        if (alpha == this.alpha) {
            return false;
        }
        this.alpha = alpha;
        return true;
    }

    @Override
    public abstract void setWidgetSelected(boolean var1);

    @Override
    public boolean isShown() {
        return this.wasShown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setShown(boolean b, boolean force) {
        if (this.bDisposed) {
            return false;
        }
        if (b == this.wasShown && !force) {
            return false;
        }
        this.wasShown = b;
        ArrayList<TableCellSWTBase> lTableCells = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells != null) {
                lTableCells = new ArrayList<TableCellSWTBase>(this.mTableCells.values());
            }
        }
        if (lTableCells != null) {
            for (TableCellCore tableCellCore : lTableCells) {
                if (tableCellCore == null) continue;
                tableCellCore.invokeVisibilityListeners(b ? 0 : 1, true);
            }
        }
        return true;
    }

    @Override
    public void redraw() {
        this.redraw(false);
    }
}

