/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.impl.ConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.mdi.TabbedEntry;
import com.biglybt.ui.swt.mdi.TabbedMDI;
import com.biglybt.ui.swt.mdi.TabbedMdiMaximizeListener;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.util.DataSourceUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class TableViewSWT_TabsCommon
implements SelectedContentListener {
    UISWTView parentView;
    TableViewSWT<?> tv;
    public Composite tableComposite;
    private TableView<?> tvOverride;
    private Sash sash;
    private TabbedMDI tabbedMDI;
    private Composite cTabsHolder;
    private FormData fdHeightChanger;
    private MenuItem menuItemShowTabs;
    private ISelectedContent[] selectedContent;

    public TableViewSWT_TabsCommon(UISWTView parentView, TableViewSWT<?> tv) {
        this.parentView = parentView;
        this.tv = tv;
    }

    public void triggerTabViewsDataSourceChanged(TableView<?> tv) {
        Object[] dataSourcesCore;
        if (this.tabbedMDI == null || this.tabbedMDI.isDisposed()) {
            return;
        }
        TableView<?> tvToUse = this.tvOverride != null ? this.tvOverride : tv;
        Object[] ds = dataSourcesCore = tvToUse.getSelectedDataSources(true);
        if (this.tabbedMDI != null) {
            DownloadManager[] dms = DataSourceUtils.getDMs(dataSourcesCore);
            this.tabbedMDI.setMaximizeVisible(dms.length == 1);
            this.tabbedMDI.setEntriesDataSource(ds);
        }
    }

    public void setTvOverride(TableView<?> tvOverride) {
        if (this.tvOverride == tvOverride) {
            return;
        }
        this.tvOverride = tvOverride;
        this.selectedContent = SelectedContentManager.getCurrentlySelectedContent();
        this.triggerTabViewsDataSourceChanged(this.tv);
    }

    public void delete() {
        SelectedContentManager.removeCurrentlySelectedContentListener(this);
        if (this.menuItemShowTabs != null) {
            this.menuItemShowTabs.remove();
        }
    }

    public void generate(IndentWriter writer) {
        writer.println("# of SubViews: " + (this.tabbedMDI == null ? "null" : Integer.valueOf(this.tabbedMDI.getEntriesCount())));
    }

    public void localeChanged() {
        if (this.tabbedMDI == null) {
            return;
        }
        MdiEntrySWT[] entries = this.tabbedMDI.getEntries();
        if (entries.length == 0) {
            return;
        }
        MdiEntrySWT[] mdiEntrySWTArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntrySWT entry = mdiEntrySWTArray[n2];
            entry.triggerEvent(6, null);
            ++n2;
        }
    }

    public MdiEntrySWT getActiveSubView() {
        if (!this.tv.isTabViewsEnabled() || this.tabbedMDI == null || this.tabbedMDI.isDisposed() || this.tabbedMDI.getMinimized()) {
            return null;
        }
        return this.tabbedMDI.getSelectedEntry();
    }

    public Composite createSashForm(Composite composite) {
        double pct;
        String legacy_key;
        if (!this.tv.isTabViewsEnabled()) {
            this.tableComposite = this.tv.createMainPanel(composite);
            return this.tableComposite;
        }
        if (this.parentView instanceof TabbedEntry && !((TabbedEntry)this.parentView).getMDI().getAllowSubViews()) {
            this.tableComposite = this.tv.createMainPanel(composite);
            return this.tableComposite;
        }
        SelectedContentManager.addCurrentlySelectedContentListener(this);
        ConfigurationManager configMan = ConfigurationManager.getInstance();
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        int iNumViews = vm.getBuilders(this.tv.getTableID()).size() + vm.getBuilders(this.tv.getDataSourceType()).size();
        if (iNumViews == 0) {
            this.tableComposite = this.tv.createMainPanel(composite);
            return this.tableComposite;
        }
        final String props_prefix = String.valueOf(this.tv.getTableID()) + "." + this.tv.getTextPrefixID();
        final Composite form = new Composite(composite, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        form.setLayoutData((Object)gridData);
        this.cTabsHolder = new Composite(form, 0);
        this.tabbedMDI = new TabbedMDI(this.tv.getDataSourceType(), this.tv.getTableID(), props_prefix, this.parentView, null);
        this.tabbedMDI.setAllowSubViews(false);
        this.tabbedMDI.setMinimizeVisible(true);
        this.tabbedMDI.buildMDI(this.cTabsHolder);
        if (this.tabbedMDI.isEmpty()) {
            form.dispose();
            this.tableComposite = this.tv.createMainPanel(composite);
            return this.tableComposite;
        }
        this.tabbedMDI.setTabbedMdiMaximizeListener(new TabbedMdiMaximizeListener(){

            @Override
            public void maximizePressed() {
                UIFunctions uiFunctions;
                TableView<Object> tvToUse = TableViewSWT_TabsCommon.this.tvOverride == null ? TableViewSWT_TabsCommon.this.tv : TableViewSWT_TabsCommon.this.tvOverride;
                Object[] ds = tvToUse.getSelectedDataSources(true);
                if (ds.length == 1 && ds[0] instanceof DownloadManager && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.getMDI().showEntryByID("DMDetails", ds);
                }
            }
        });
        int SASH_WIDTH = 5;
        this.sash = Utils.createSash(form, 5);
        Composite cFixLayout = this.tableComposite = this.tv.createMainPanel(form);
        while (cFixLayout != null && cFixLayout.getParent() != form) {
            cFixLayout = cFixLayout.getParent();
        }
        if (cFixLayout == null) {
            cFixLayout = this.tableComposite;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cFixLayout.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        int iSplitAt = configMan.getIntParameter(String.valueOf(props_prefix) + ".SplitAt2", 300000);
        if (iSplitAt == 300000 && configMan.hasParameter(legacy_key = String.valueOf(props_prefix) + ".SplitAt", false)) {
            iSplitAt = configMan.getIntParameter(legacy_key, 3000);
            configMan.removeParameter(legacy_key);
            if (iSplitAt < 100) {
                iSplitAt *= 100;
            }
            iSplitAt *= 100;
        }
        if ((pct = (double)iSplitAt / 1000000.0) < 0.03) {
            pct = 0.03;
        } else if (pct > 0.97) {
            pct = 0.97;
        }
        this.sash.setData("PCT", (Object)new Double(pct));
        this.cTabsHolder.setLayout((Layout)new FormLayout());
        this.fdHeightChanger = formData;
        this.cTabsHolder.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)this.cTabsHolder);
        formData.height = 5;
        this.sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)this.sash);
        cFixLayout.setLayoutData((Object)formData);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                Rectangle area = form.getClientArea();
                int height = area.height - e.y - e.height;
                if (!Constants.isWindows) {
                    height -= 5;
                }
                if (area.height - height < 100) {
                    height = area.height - 100;
                }
                if (height < 0) {
                    height = 0;
                }
                ((TableViewSWT_TabsCommon)TableViewSWT_TabsCommon.this).fdHeightChanger.height = height;
                Double l = new Double((double)height / (double)area.height);
                TableViewSWT_TabsCommon.this.sash.setData("PCT", (Object)l);
                if (e.detail != 1) {
                    int split_at;
                    ConfigurationManager configMan = ConfigurationManager.getInstance();
                    double d_split_at = l * 1000000.0;
                    if (d_split_at - (double)(split_at = (int)d_split_at) > 0.0) {
                        ++split_at;
                    }
                    configMan.setParameter(String.valueOf(props_prefix) + ".SplitAt2", split_at);
                }
                form.layout();
                TableViewSWT_TabsCommon.this.cTabsHolder.redraw();
            }
        });
        this.buildFolder(form, props_prefix);
        return form;
    }

    private void buildFolder(final Composite form, String props_prefix) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        this.menuItemShowTabs = menuManager.addMenuItem(String.valueOf(props_prefix) + "._end_", "ConfigView.section.style.ShowTabsInTorrentView");
        this.menuItemShowTabs.setDisposeWithUIDetach("swt");
        this.menuItemShowTabs.setStyle(2);
        this.menuItemShowTabs.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(COConfigurationManager.getBooleanParameter("Library.ShowTabsInTorrentView"));
            }
        });
        this.menuItemShowTabs.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter("Library.ShowTabsInTorrentView", (Boolean)menu.getData());
            }
        });
        this.cTabsHolder.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                int newHeight;
                if (TableViewSWT_TabsCommon.this.tabbedMDI.getMinimized()) {
                    ((TableViewSWT_TabsCommon)TableViewSWT_TabsCommon.this).fdHeightChanger.height = TableViewSWT_TabsCommon.this.tabbedMDI.getFolderHeight();
                    TableViewSWT_TabsCommon.this.cTabsHolder.getParent().layout();
                    return;
                }
                Double l = (Double)TableViewSWT_TabsCommon.this.sash.getData("PCT");
                if (l != null && (newHeight = (int)((double)form.getBounds().height * l)) != ((TableViewSWT_TabsCommon)TableViewSWT_TabsCommon.this).fdHeightChanger.height) {
                    ((TableViewSWT_TabsCommon)TableViewSWT_TabsCommon.this).fdHeightChanger.height = newHeight;
                    TableViewSWT_TabsCommon.this.cTabsHolder.getParent().layout();
                }
            }
        });
    }

    @Override
    public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
        TableView<?> tvToUse;
        TableView<?> tableView = tvToUse = this.tvOverride == null ? this.tv : this.tvOverride;
        if (viewID != null && viewID.equals(tvToUse.getTableID())) {
            this.selectedContent = currentContent;
        }
        if (currentContent.length == 0 && this.tv.isVisible() && this.selectedContent != null && this.selectedContent.length != 0) {
            SelectedContentManager.changeCurrentlySelectedContent(tvToUse.getTableID(), this.selectedContent, tvToUse);
        }
    }

    public void obfuscatedImage(Image image) {
        if (this.tabbedMDI instanceof ObfuscateImage) {
            TabbedMDI o = this.tabbedMDI;
            image = o.obfuscatedImage(image);
        }
    }

    public MultipleDocumentInterfaceSWT getMDI() {
        return this.tabbedMDI;
    }
}

