/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.impl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.ui.common.table.TableViewFilterCheck;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.util.MapUtils;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public abstract class TableViewTab<DATASOURCETYPE>
implements UISWTViewCoreEventListener,
AEDiagnosticsEvidenceGenerator,
ObfuscateImage {
    private TableViewSWT<DATASOURCETYPE> tv;
    private final String textPrefixID;
    private Composite composite;
    private UISWTView swtView;
    private BubbleTextBox filterTextControl;
    private TableViewFilterCheck<DATASOURCETYPE> filterCheck;
    private boolean enableTabs = true;

    public TableViewTab(String textPrefixID) {
        this.textPrefixID = textPrefixID;
    }

    public TableViewSWT<DATASOURCETYPE> getTableView() {
        return this.tv;
    }

    public final void initialize(Composite composite) {
        Object dataSource;
        this.tv = this.initYourTableView();
        if (!this.enableTabs) {
            this.tv.setEnableTabViews(false, false);
        }
        Composite parent = this.initComposite(composite);
        if (this.swtView == null) {
            this.tv.initialize(parent);
        } else {
            this.tv.initialize(this.swtView, parent);
        }
        this.composite = parent != composite ? composite : this.tv.getComposite();
        if (this.filterCheck != null) {
            this.tv.enableFilterCheck(this.filterTextControl, this.filterCheck);
        }
        if (this.swtView != null && (dataSource = this.swtView.getDataSource()) != null) {
            this.tv.setParentDataSource(dataSource);
        }
        this.tableViewTabInitComplete();
    }

    public void setEnableTabViews(boolean b) {
        this.enableTabs = b;
    }

    public void tableViewTabInitComplete() {
    }

    public Composite initComposite(Composite composite) {
        return composite;
    }

    public abstract TableViewSWT<DATASOURCETYPE> initYourTableView();

    public final void dataSourceChanged(Object newDataSource) {
        this.parentDataSourceChanged(newDataSource);
        if (this.tv != null) {
            this.tv.setParentDataSource(newDataSource);
        }
    }

    public void parentDataSourceChanged(Object newParentDataSource) {
    }

    public final void refresh() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    public final void delete() {
        if (this.tv != null) {
            this.tv.delete();
        }
        this.tv = null;
    }

    public String getFullTitle() {
        return MessageText.getString(String.valueOf(this.getTextPrefixID()) + ".title.full");
    }

    @Override
    public void generate(IndentWriter writer) {
        if (this.tv != null) {
            this.tv.generate(writer);
        }
    }

    public Composite getComposite() {
        return this.composite;
    }

    public String getTextPrefixID() {
        return this.textPrefixID;
    }

    public void viewActivated() {
        if (this.tv != null) {
            this.tv.isVisible();
        }
    }

    private void viewDeactivated() {
        if (this.tv != null) {
            this.tv.isVisible();
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                if (this.swtView == null || !this.allowCreate(this.swtView)) {
                    return false;
                }
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                this.swtView = null;
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                this.updateLanguage();
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfuscatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        }
        return true;
    }

    public boolean allowCreate(UISWTView swtView) {
        return true;
    }

    public void updateLanguage() {
        if (this.swtView != null) {
            this.swtView.setTitle(this.getFullTitle());
        }
        Messages.updateLanguageForControl((Widget)this.composite);
    }

    public UISWTView getSWTView() {
        return this.swtView;
    }

    public void enableFilterCheck(BubbleTextBox textControl, TableViewFilterCheck<DATASOURCETYPE> filter_check_handler) {
        if (this.tv != null) {
            this.tv.enableFilterCheck(textControl, filter_check_handler);
        } else {
            this.filterTextControl = textControl;
            this.filterCheck = filter_check_handler;
        }
    }

    @Override
    public Image obfuscatedImage(Image image) {
        if (this.tv != null) {
            return this.tv.obfuscatedImage(image);
        }
        return null;
    }
}

