/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.table.painted;

import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.utils.SWTRunnable;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableRowSWTChildController;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.TableCellSWTBase;
import com.biglybt.ui.swt.views.table.impl.TableRowSWTBase;
import com.biglybt.ui.swt.views.table.painted.TableCellPainted;
import com.biglybt.ui.swt.views.table.painted.TablePaintedUtils;
import com.biglybt.ui.swt.views.table.painted.TableViewPainted;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TableRowPainted
extends TableRowSWTBase {
    private static final boolean DEBUG_SUBS = false;
    private final boolean isFake;
    private Point drawOffset = new Point(0, 0);
    private int numSubItems;
    private Object[] subDataSources;
    private TableRowPainted[] subRows;
    private final Object subRows_sync;
    private int subRowsHeightUseAccessors;
    private TableCellSWTBase[] sortCells;
    private int heightUseAccessors = 0;
    private boolean isHidden;
    private boolean initializing = true;
    private boolean inPaintItem;
    private Color colorFG = null;
    private Object colorLock = new Object();
    private CopyOnWriteList<Object[]> FGRequesters;
    private CopyOnWriteList<Object[]> BGRequesters;
    private static final Map<Integer, Object[]> fake_images = new HashMap<Integer, Object[]>();

    public TableRowPainted(TableRowCore parentRow, TableViewPainted tv, Object dataSource, boolean triggerHeightChange) {
        super(tv.getSyncObject(), parentRow, tv, dataSource);
        this.isFake = false;
        this.subRows_sync = tv.getSyncObject();
        TableColumnCore[] sortColumns = tv.getSortColumns();
        String[] sortColumnNames = new String[sortColumns.length];
        int i = 0;
        while (i < sortColumnNames.length) {
            sortColumnNames[i] = sortColumns[i].getName();
            ++i;
        }
        this.setSortColumn(sortColumnNames);
        this.isHidden = parentRow != null && tv.getFilterSubRows() && !tv.isFiltered(dataSource);
        this.setHeight(tv.getRowDefaultHeight(), false);
        if (dataSource instanceof TableRowSWTChildController) {
            TableRowSWTChildController c = (TableRowSWTChildController)dataSource;
            this.setExpanded(c.isExpanded(), false);
            Object[] kids = c.getChildDataSources();
            if (kids != null && kids.length > 0) {
                this.setSubItems(kids, false);
            }
        }
        this.initializing = false;
        if (triggerHeightChange) {
            this.heightChanged(0, this.getFullHeight());
        }
        tv.rowCreated();
    }

    public TableRowPainted(TableRowCore parentRow, TableViewPainted tv, Object dataSource) {
        super(tv.getSyncObject(), parentRow, tv, dataSource);
        this.isFake = true;
        this.subRows_sync = tv.getSyncObject();
        this.isHidden = false;
        if (dataSource instanceof TableRowSWTChildController) {
            TableRowSWTChildController c = (TableRowSWTChildController)dataSource;
            this.setExpanded(c.isExpanded(), false);
            Object[] kids = c.getChildDataSources();
            if (kids != null && kids.length > 0) {
                this.setSubItems(kids, false);
            }
        }
        this.initializing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refilter() {
        boolean changed = false;
        Object object = this.subRows_sync;
        synchronized (object) {
            boolean newHidden;
            if (this.subRows != null) {
                TableRowPainted[] tableRowPaintedArray = this.subRows;
                int n = this.subRows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowPainted subrow = tableRowPaintedArray[n2];
                    if (subrow.refilter()) {
                        changed = true;
                    }
                    ++n2;
                }
            }
            Object ds = this.getDataSource(true);
            boolean bl = newHidden = !this.getViewPainted().isFiltered(ds);
            if (newHidden != this.isHidden) {
                TableRowCore row = this;
                boolean expanded = true;
                while (expanded) {
                    if ((row = row.getParentRowCore()) == null) break;
                    expanded = row.isExpanded();
                }
                int old_height = this.getHeight();
                this.isHidden = newHidden;
                int new_height = this.getHeight();
                if (expanded) {
                    this.heightChanged(old_height, new_height);
                    changed = true;
                } else {
                    row = this.getParentRowCore();
                    if (row instanceof TableRowPainted) {
                        ((TableRowPainted)row).subRowHeightChanged(old_height, new_height);
                    }
                }
            }
        }
        return changed;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(boolean mustRefersh) {
        super.invalidate(mustRefersh);
        Object object = this.lock;
        synchronized (object) {
            if (this.sortCells != null) {
                TableCellSWTBase[] tableCellSWTBaseArray = this.sortCells;
                int n = this.sortCells.length;
                int n2 = 0;
                while (n2 < n) {
                    TableCellSWTBase sortCell = tableCellSWTBaseArray[n2];
                    sortCell.invalidate(mustRefersh);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCells() {
        TableColumnCore[] visibleColumns = this.getView().getVisibleColumns();
        if (visibleColumns == null) {
            return;
        }
        TableViewPainted table = this.getViewPainted();
        Object object = this.lock;
        synchronized (object) {
            this.mTableCells = new LinkedHashMap(visibleColumns.length, 1.0f);
            TableRowCore parentRow = this.getParentRowCore();
            int i = 0;
            while (i < visibleColumns.length) {
                TableColumnCore coreColumn = visibleColumns[i];
                if (coreColumn != null) {
                    if (parentRow != null && !coreColumn.handlesDataSourceType(this.getDataSource(false).getClass())) {
                        this.mTableCells.put(coreColumn.getName(), null);
                    } else {
                        TableCellSWTBase cell = null;
                        if (this.sortCells != null) {
                            TableCellSWTBase[] tableCellSWTBaseArray = this.sortCells;
                            int n = this.sortCells.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableCellSWTBase sortCell = tableCellSWTBaseArray[n2];
                                if (coreColumn.equals(sortCell.getTableColumnCore())) {
                                    cell = sortCell;
                                }
                                ++n2;
                            }
                        }
                        if (cell == null) {
                            cell = new TableCellPainted(this, table.getColumnPainted(coreColumn), i);
                        }
                        this.mTableCells.put(coreColumn.getName(), cell);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyCells() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells == null) {
                return;
            }
            block3: for (TableCellCore cell : this.mTableCells.values()) {
                if (cell == null) continue;
                if (this.sortCells != null) {
                    TableCellSWTBase[] tableCellSWTBaseArray = this.sortCells;
                    int n = this.sortCells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableCellSWTBase sortCell = tableCellSWTBaseArray[n2];
                        if (cell == sortCell) continue block3;
                        ++n2;
                    }
                }
                if (cell.isDisposed()) continue;
                cell.dispose();
            }
            this.mTableCells = null;
        }
    }

    public TableViewPainted getViewPainted() {
        return (TableViewPainted)this.getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swt_paintGC(GC gc, Rectangle drawBounds, int rowStartX, int rowStartY, int pos, boolean isTableSelected, boolean isTableEnabled) {
        Color bg;
        Color altColor;
        boolean rowHasForeground;
        if (this.isRowDisposed() || gc == null || gc.isDisposed() || drawBounds == null || this.isHidden) {
            return;
        }
        TableColumnCore[] visibleColumns = this.getView().getVisibleColumns();
        if (visibleColumns == null || visibleColumns.length == 0) {
            return;
        }
        boolean isAttention = this.isRequestAttention();
        boolean isSelected = this.isSelected();
        boolean isSelectedNotFocused = isSelected && !isTableSelected;
        Color origBG = gc.getBackground();
        Color origFG = gc.getForeground();
        Color fg = this.getForeground();
        Color shadowColor = null;
        boolean isAltColor = false;
        boolean rowHasBackground = false;
        boolean bl = rowHasForeground = fg != null;
        if (isTableEnabled) {
            int altIndex = pos >= 0 ? pos % 2 : 0;
            altColor = Colors.alternatingColors[altIndex];
            if (altColor == null) {
                altColor = TablePaintedUtils.getColour(gc, 25);
            } else {
                boolean bl2 = isAltColor = altIndex == 1;
            }
            if (isSelected) {
                Color color = TablePaintedUtils.getColour(gc, 26);
                gc.setBackground(color);
            } else {
                gc.setBackground(altColor);
            }
            bg = this.getBackground();
            if (bg == null) {
                bg = gc.getBackground();
            } else {
                rowHasBackground = true;
                gc.setBackground(bg);
            }
            if (isSelected) {
                shadowColor = fg;
                fg = TablePaintedUtils.getColour(gc, 27);
            } else if (fg == null) {
                fg = TablePaintedUtils.getColour(gc, 24);
            }
        } else {
            Device device = gc.getDevice();
            altColor = TablePaintedUtils.getColour(device, 22);
            bg = isSelected ? TablePaintedUtils.getColour(device, 19) : altColor;
            gc.setBackground(bg);
            fg = TablePaintedUtils.getColour(device, 18);
        }
        if (isAttention) {
            bg = Colors.fadedRed;
            gc.setBackground(bg);
        }
        gc.setForeground(fg);
        int rowAlpha = this.getAlpha();
        Font font = gc.getFont();
        Rectangle clipping = gc.getClipping();
        int x = rowStartX;
        Object object = this.lock;
        synchronized (object) {
            Rectangle r;
            int w;
            block31: {
                if (this.mTableCells == null) {
                    this.setShown(true, true);
                }
                if (this.mTableCells == null) break block31;
                TableColumnCore[] tableColumnCoreArray = visibleColumns;
                int n = visibleColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    block34: {
                        int w2;
                        block35: {
                            Rectangle r2;
                            TableCellSWTBase cell;
                            block32: {
                                TableCellPainted cellSWT;
                                block33: {
                                    TableColumnCore tc = tableColumnCoreArray[n2];
                                    cell = (TableCellSWTBase)this.mTableCells.get(tc.getName());
                                    w2 = tc.getWidth();
                                    r2 = new Rectangle(x, rowStartY, w2, this.getHeight());
                                    cellSWT = null;
                                    if (cell instanceof TableCellPainted && !cell.isDisposed()) {
                                        cellSWT = (TableCellPainted)cell;
                                        cellSWT.setBoundsRaw(r2);
                                    }
                                    if (!drawBounds.intersects(r2)) break block32;
                                    gc.setAlpha(255);
                                    if (isSelectedNotFocused) {
                                        gc.setBackground(altColor);
                                        gc.fillRectangle(r2);
                                        gc.setAlpha(100);
                                        gc.setBackground(bg);
                                        gc.fillRectangle(r2);
                                    } else {
                                        gc.setBackground(bg);
                                        gc.fillRectangle(r2);
                                        if (isSelected && Utils.gradientFillSelection()) {
                                            gc.setAlpha(80);
                                            gc.setForeground(altColor);
                                            gc.fillGradientRectangle(r2.x, r2.y, r2.width, r2.height, true);
                                            gc.setForeground(fg);
                                        }
                                    }
                                    gc.setAlpha(rowAlpha);
                                    if (cellSWT != null) break block33;
                                    x += w2;
                                    break block34;
                                }
                                if (this.swt_paintCell(gc, cellSWT.getBounds(), cellSWT, shadowColor, !isSelected && !rowHasBackground, !rowHasForeground, isAltColor)) {
                                    gc.setBackground(bg);
                                    gc.setForeground(fg);
                                    gc.setFont(font);
                                    Utils.setClipping(gc, clipping);
                                }
                                if (DEBUG_ROW_PAINT) {
                                    cell.debug("painted " + (cell.getVisuallyChangedSinceRefresh() ? "VC" : "!P") + " @ " + r2);
                                }
                                break block35;
                            }
                            if (DEBUG_ROW_PAINT) {
                                cell.debug("Skip paintItem; no intersects; r=" + r2 + ";dB=" + drawBounds + " from " + Debug.getCompressedStackTrace(4));
                            }
                        }
                        x += w2;
                    }
                    ++n2;
                }
            }
            if ((w = drawBounds.width - x) > 0 && clipping.intersects(r = new Rectangle(x, rowStartY, w, this.getHeight()))) {
                gc.setAlpha(255);
                if (isSelectedNotFocused) {
                    gc.setBackground(altColor);
                    gc.fillRectangle(r);
                    gc.setAlpha(100);
                    gc.setBackground(bg);
                    gc.fillRectangle(r);
                } else {
                    gc.fillRectangle(r);
                    if (isSelected && Utils.gradientFillSelection()) {
                        gc.setAlpha(80);
                        gc.setForeground(altColor);
                        gc.fillGradientRectangle(r.x, r.y, r.width, r.height, true);
                        gc.setForeground(fg);
                    }
                }
                gc.setAlpha(rowAlpha);
            }
        }
        if (this.isFocused()) {
            gc.setAlpha(40);
            gc.setForeground(origFG);
            gc.setLineDash(new int[]{1, 2});
            gc.drawRectangle(rowStartX, rowStartY, this.getViewPainted().getClientArea().width - 1, this.getHeight() - 1);
            gc.setLineStyle(1);
        }
        gc.setAlpha(255);
        gc.setBackground(origBG);
        gc.setForeground(origFG);
    }

    @Override
    public void fakeRedraw(final String col_name) {
        if (!Utils.isSWTThread()) {
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    TableRowPainted.this.swt_fakeRedraw(col_name);
                }
            });
        } else {
            this.swt_fakeRedraw(col_name);
        }
    }

    private static GC getFakeImageGC(Rectangle bounds) {
        int height = bounds.height;
        Object[] existing = fake_images.get(height);
        if (existing != null) {
            return (GC)existing[0];
        }
        Image image = new Image((Device)Utils.getDisplay(), bounds.width, height);
        GC gc = new GC((Drawable)image);
        fake_images.put(height, new Object[]{gc, image});
        SimpleTimer.addEvent("FakeImageDisposer", SystemTime.getOffsetTime(30000L), ev -> Utils.execSWTThread(() -> {
            Object[] entry = fake_images.remove(height);
            if (entry == null) {
                Debug.out("eh?");
            } else {
                ((GC)entry[0]).dispose();
                ((Image)entry[1]).dispose();
            }
        }));
        return gc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swt_fakeRedraw(String col_name) {
        block12: {
            this.setShown(true, true);
            TableCellPainted cell = (TableCellPainted)this.getTableCellCore(col_name);
            if (cell != null) {
                Rectangle bounds = new Rectangle(0, 0, 9999, this.getHeight());
                if (bounds.height <= 0) {
                    return;
                }
                boolean boundsSet = false;
                if (cell.getBoundsRaw() == null) {
                    cell.setBoundsRaw(bounds);
                    boundsSet = true;
                }
                try {
                    cell.refresh(true, true, true);
                    GC gc = TableRowPainted.getFakeImageGC(bounds);
                    this.swt_paintCell(gc, bounds, cell, null, false, false, false);
                    if (!this.isExpanded()) break block12;
                    Object object = this.subRows_sync;
                    synchronized (object) {
                        if (this.subRows != null) {
                            TableRowPainted[] tableRowPaintedArray = this.subRows;
                            int n = this.subRows.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableRowPainted subrow = tableRowPaintedArray[n2];
                                subrow.swt_fakeRedraw(col_name);
                                ++n2;
                            }
                        }
                    }
                }
                finally {
                    if (boundsSet) {
                        cell.setBoundsRaw(null);
                    }
                }
            }
        }
    }

    @Override
    public boolean isInPaintItem() {
        return this.inPaintItem;
    }

    private boolean swt_paintCell(GC gc, Rectangle cellBounds, TableCellSWTBase cell, Color shadowColor, boolean enableColumnBG, boolean enableColumnFG, boolean isAltColor) {
        if (cellBounds == null) {
            return false;
        }
        boolean gcChanged = false;
        Rectangle oldClipping = null;
        try {
            if (Constants.IS_CVS_VERSION) {
                oldClipping = gc.getClipping();
                int marginWidth = cell.getMarginWidth();
                int marginHeight = cell.getMarginHeight();
                Utils.setClipping(gc, new Rectangle(cellBounds.x - marginWidth, cellBounds.y - marginHeight, cellBounds.width + marginWidth * 2 - 1, cellBounds.height + marginHeight * 2));
            }
            if (this.inPaintItem) {
                Debug.out("hmm");
                return false;
            }
            try {
                Color bg;
                this.inPaintItem = true;
                gc.setTextAntialias(-1);
                TableView view = this.getView();
                TableColumnCore column = (TableColumnCore)cell.getTableColumn();
                view.invokePaintListeners(gc, this, column, cellBounds);
                int fontStyle = this.getFontStyle();
                Font oldFont = null;
                if (fontStyle == 1) {
                    oldFont = gc.getFont();
                    gc.setFont(FontUtils.getAnyFontBold(gc));
                    gcChanged = true;
                } else if (fontStyle == 2) {
                    oldFont = gc.getFont();
                    if (Constants.isWindows) {
                        gc.setTextAntialias(1);
                    }
                    gc.setFont(FontUtils.getAnyFontItalic(gc));
                    gcChanged = true;
                }
                if (!cell.isUpToDate()) {
                    cell.refresh(true, true);
                }
                StringInterner.StringSupplier textSupplier = cell.getTextSupplier();
                Color fg = cell.getForegroundSWT();
                if (fg == null && enableColumnFG) {
                    fg = cell.getTableColumnSWT().getForeground();
                }
                if (fg != null) {
                    gcChanged = true;
                    if (this.isSelected()) {
                        shadowColor = fg;
                    } else {
                        gc.setForeground(fg);
                    }
                }
                if ((bg = cell.getBackgroundSWT()) == null && enableColumnBG) {
                    bg = cell.getTableColumnSWT().getBackground();
                }
                if (bg != null) {
                    gcChanged = true;
                    gc.setBackground(bg);
                    if (!isAltColor) {
                        int alpha = gc.getAlpha();
                        gc.setAlpha(200);
                        gc.fillRectangle(cellBounds);
                        gc.setAlpha(alpha);
                    } else {
                        gc.fillRectangle(cellBounds);
                    }
                }
                if (cell.needsPainting()) {
                    Image graphicSWT = cell.getGraphicSWT();
                    if (graphicSWT != null && !graphicSWT.isDisposed()) {
                        Rectangle imageBounds = graphicSWT.getBounds();
                        Rectangle graphicBounds = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
                        if (cell.getFillCell()) {
                            if (!graphicBounds.isEmpty()) {
                                gc.setAdvanced(true);
                                gc.drawImage(graphicSWT, 0, 0, imageBounds.width, imageBounds.height, graphicBounds.x, graphicBounds.y, graphicBounds.width, graphicBounds.height);
                            }
                        } else {
                            if (imageBounds.width < graphicBounds.width) {
                                int alignment = column.getAlignment();
                                if ((alignment & 3) > 0) {
                                    graphicBounds.x += (graphicBounds.width - imageBounds.width) / 2;
                                } else if ((alignment & 2) > 0) {
                                    graphicBounds.x = graphicBounds.x + graphicBounds.width - imageBounds.width;
                                }
                            }
                            if (imageBounds.height < graphicBounds.height) {
                                graphicBounds.y += (graphicBounds.height - imageBounds.height) / 2;
                            }
                            gc.drawImage(graphicSWT, graphicBounds.x, graphicBounds.y);
                        }
                    }
                    cell.doPaint(gc);
                    gcChanged = true;
                }
                if (!textSupplier.isEmpty()) {
                    int textOpacity;
                    int ofsx = 0;
                    Image image = cell.getIcon();
                    Rectangle imageBounds = null;
                    if (image != null && !image.isDisposed()) {
                        imageBounds = image.getBounds();
                        int ofs = imageBounds.width;
                        ofsx += ofs;
                        cellBounds.x += ofs;
                        cellBounds.width -= ofs;
                    }
                    if ((textOpacity = cell.getTextAlpha()) < 255) {
                        gc.setAlpha(textOpacity);
                        gcChanged = true;
                    } else if (textOpacity > 255) {
                        boolean is_italic;
                        boolean bl = is_italic = (gc.getFont().getFontData()[0].getStyle() & 2) != 0;
                        if (is_italic) {
                            gc.setFont(FontUtils.getAnyFontBoldItalic(gc));
                        } else {
                            gc.setFont(FontUtils.getAnyFontBold(gc));
                        }
                        gcChanged = true;
                    }
                    ofsx += 6;
                    cellBounds.x += 3;
                    cellBounds.width -= 6;
                    cellBounds.y += 2;
                    cellBounds.height -= 4;
                    if (!cellBounds.isEmpty()) {
                        String text = (String)textSupplier.get();
                        int singleLineHeight = GCStringPrinter.stringExtent((GC)gc, (String)text).y;
                        boolean worthWrap = cellBounds.height >= singleLineHeight * 2;
                        int style = TableColumnSWTUtils.convertColumnAlignmentToSWT(column.getAlignment());
                        if (worthWrap) {
                            style |= 0x40;
                        }
                        GCStringPrinter sp = new GCStringPrinter(gc, text, cellBounds, true, worthWrap, style);
                        sp.calculateMetrics();
                        if (shadowColor != null) {
                            Color oldFG = gc.getForeground();
                            gc.setForeground(shadowColor);
                            ++cellBounds.x;
                            ++cellBounds.y;
                            int alpha = gc.getAlpha();
                            gc.setAlpha(64);
                            sp.printString(gc, cellBounds, style);
                            gc.setAlpha(alpha);
                            gc.setForeground(oldFG);
                            --cellBounds.x;
                            --cellBounds.y;
                            sp.printString2(gc, cellBounds, style);
                        } else {
                            sp.printString();
                        }
                        if (!sp.isTruncated()) {
                            cell.setDefaultToolTip(null);
                        } else {
                            cell.setDefaultToolTip(textSupplier);
                        }
                        Point psize = sp.getCalculatedPreferredSize();
                        psize.x += ofsx;
                        TableColumn tableColumn = cell.getTableColumn();
                        if (tableColumn != null && tableColumn.getPreferredWidth() < psize.x) {
                            tableColumn.setPreferredWidth(psize.x);
                        }
                        if (imageBounds != null) {
                            boolean hack_adv;
                            int drawToY = cellBounds.y + cellBounds.height / 2 - imageBounds.height / 2;
                            boolean bl = hack_adv = Constants.isWindows8OrHigher && gc.getAdvanced();
                            if (hack_adv) {
                                gc.setAdvanced(false);
                            }
                            if ((style & 0x20000) != 0) {
                                Point size = sp.getCalculatedSize();
                                size.x += ofsx;
                                int drawToX = cellBounds.x + cellBounds.width - size.x;
                                gc.drawImage(image, drawToX, drawToY);
                            } else if (imageBounds.height > cellBounds.height) {
                                float pct = (float)cellBounds.height / (float)imageBounds.height;
                                gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, cellBounds.x - imageBounds.width - 3, cellBounds.y, (int)((float)imageBounds.width * pct), (int)((float)imageBounds.height * pct));
                            } else {
                                gc.drawImage(image, cellBounds.x - imageBounds.width - 3, drawToY);
                            }
                            if (hack_adv) {
                                gc.setAdvanced(true);
                            }
                        }
                    } else {
                        cell.setDefaultToolTip(null);
                    }
                }
                cell.clearVisuallyChangedSinceRefresh();
                if (oldFont != null) {
                    gc.setFont(oldFont);
                }
            }
            catch (Exception e) {
                Debug.out(String.valueOf(cell.getTableID()) + ":" + cell.getTableColumn().getName(), e);
            }
        }
        finally {
            if (Constants.IS_CVS_VERSION) {
                Utils.setClipping(gc, oldClipping);
            }
            this.inPaintItem = false;
        }
        return gcChanged;
    }

    private Font getRandomFont() {
        FontData[] fontList = Display.getDefault().getFontList(null, Math.random() > 0.5);
        FontData fontData = fontList[(int)(Math.random() * (double)fontList.length)];
        fontData.setStyle((int)(Math.random() * 4.0));
        fontData.height = (float)(Math.random() * 50.0);
        return new Font((Device)Display.getDefault(), fontData);
    }

    @Override
    public List<TableCellCore> refresh(boolean bDoGraphics, boolean bVisible) {
        final List<TableCellCore> invalidCells = super.refresh(bDoGraphics, bVisible);
        if (invalidCells.size() > 0) {
            Utils.execSWTThread(new SWTRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runWithDisplay(Display display) {
                    boolean allCells;
                    Composite composite = TableRowPainted.this.getViewPainted().getComposite();
                    if (composite == null || composite.isDisposed() || !TableRowPainted.this.isVisible()) {
                        return;
                    }
                    Object object = TableRowPainted.this.lock;
                    synchronized (object) {
                        allCells = TableRowPainted.this.mTableCells != null && invalidCells.size() == TableRowPainted.this.mTableCells.size();
                    }
                    if (allCells) {
                        TableRowPainted.this.getViewPainted().swt_updateCanvasImage(TableRowPainted.this.getDrawBounds(), false);
                    } else {
                        Rectangle drawBounds = TableRowPainted.this.getDrawBounds();
                        for (Object o : invalidCells) {
                            TableCellPainted cell;
                            Rectangle bounds;
                            if (!(o instanceof TableCellPainted) || (bounds = (cell = (TableCellPainted)o).getBoundsRaw()) == null) continue;
                            bounds.y = drawBounds.y;
                            bounds.height = drawBounds.height;
                            cell.setBoundsRaw(bounds);
                            TableRowPainted.this.getViewPainted().swt_updateCanvasImage(bounds, false);
                        }
                    }
                }
            });
        }
        return invalidCells;
    }

    @Override
    public void redraw(boolean doChildren) {
        this.redraw(doChildren, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw(boolean doChildren, boolean immediateRedraw) {
        if (this.isRowDisposed()) {
            return;
        }
        if (this.isFake) {
            return;
        }
        this.getViewPainted().redrawRow(this, immediateRedraw);
        if (!doChildren) {
            return;
        }
        Object object = this.subRows_sync;
        synchronized (object) {
            if (this.subRows != null) {
                TableRowPainted[] tableRowPaintedArray = this.subRows;
                int n = this.subRows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowPainted subrow = tableRowPaintedArray[n2];
                    subrow.redraw();
                    ++n2;
                }
            }
        }
    }

    protected void debug(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("table");
        String prefix = String.valueOf(SystemTime.getCurrentTime()) + ":" + this.getTableID() + ": r" + this.getIndex();
        if (this.getParentRowCore() != null) {
            prefix = String.valueOf(prefix) + "of" + this.getParentRowCore().getIndex();
        }
        prefix = String.valueOf(prefix) + ": ";
        diag_logger.log(String.valueOf(prefix) + s);
        System.out.println(String.valueOf(prefix) + s);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, this.drawOffset.y, 9990, this.getHeight());
    }

    public Rectangle getDrawBounds() {
        TableViewPainted view = (TableViewPainted)this.getView();
        Rectangle clientArea = view.getClientArea();
        int offsetX = TableViewPainted.DIRECT_DRAW ? -clientArea.x : 0;
        Rectangle bounds = new Rectangle(offsetX, this.drawOffset.y - clientArea.y, 9990, this.getHeight());
        return bounds;
    }

    @Override
    public int getFullHeight() {
        if (this.isHidden) {
            return 0;
        }
        int h = this.getHeight();
        if (this.numSubItems > 0 && this.isExpanded()) {
            h += this.subRowsHeightUseAccessors;
        }
        return h;
    }

    public Point getDrawOffset() {
        return this.drawOffset;
    }

    public void heightChanged(int oldHeight, int newHeight) {
        TableRowCore row;
        if (!this.isFake) {
            this.getViewPainted().rowHeightChanged(this, oldHeight, newHeight);
        }
        if ((row = this.getParentRowCore()) instanceof TableRowPainted) {
            ((TableRowPainted)row).subRowHeightChanged(oldHeight, newHeight);
        }
    }

    private void setSubRowsHeight(int h) {
        this.subRowsHeightUseAccessors = h;
    }

    protected void subRowHeightChanged(int oldHeight, int newHeight) {
        TableRowCore row;
        int old = this.subRowsHeightUseAccessors;
        this.subRowsHeightUseAccessors += newHeight - oldHeight;
        if (old != this.subRowsHeightUseAccessors && this.isExpanded() && (row = this.getParentRowCore()) instanceof TableRowPainted) {
            ((TableRowPainted)row).subRowHeightChanged(old, this.subRowsHeightUseAccessors);
        }
    }

    public boolean setDrawOffset(Point drawOffset) {
        if (drawOffset.equals((Object)this.drawOffset)) {
            return false;
        }
        this.drawOffset = drawOffset;
        return true;
    }

    @Override
    public void setWidgetSelected(boolean selected) {
        this.redraw(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setShown(boolean b, boolean force) {
        if (b == this.wasShown && !force) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (b && this.mTableCells == null) {
                this.buildCells();
            }
        }
        boolean ret = super.setShown(b, force);
        if (b) {
            this.invalidate();
            this.redraw(false, false);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!b && this.mTableCells != null) {
                this.destroyCells();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        super.delete();
        Object object = this.lock;
        synchronized (object) {
            if (this.sortCells != null) {
                TableCellSWTBase[] tableCellSWTBaseArray = this.sortCells;
                int n = this.sortCells.length;
                int n2 = 0;
                while (n2 < n) {
                    TableCellSWTBase sortCell = tableCellSWTBaseArray[n2];
                    if (!sortCell.isDisposed()) {
                        sortCell.dispose();
                    }
                    ++n2;
                }
                this.sortCells = null;
            }
        }
        this.deleteExistingSubRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExistingSubRows() {
        Object object = this.subRows_sync;
        synchronized (object) {
            if (this.subRows != null) {
                TableRowPainted[] tableRowPaintedArray = this.subRows;
                int n = this.subRows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowPainted subrow = tableRowPaintedArray[n2];
                    subrow.delete();
                    ++n2;
                }
            }
            this.subRows = null;
        }
    }

    @Override
    public void setSubItemCount(int length) {
        this.setSubItemCount(length, true);
    }

    private void setSubItemCount(int length, boolean triggerHeightListener) {
        this.numSubItems = length;
        if (this.isExpanded() && this.subDataSources.length == length) {
            this.deleteExistingSubRows();
            TableRowCore[] newSubRows = new TableRowPainted[length];
            TableViewPainted tv = this.getViewPainted();
            int h = 0;
            int i = 0;
            while (i < newSubRows.length) {
                newSubRows[i] = new TableRowPainted(this, tv, this.subDataSources[i], false);
                newSubRows[i].setTableItem(i);
                h += newSubRows[i].getFullHeight();
                ++i;
            }
            int oldHeight = this.getFullHeight();
            this.setSubRowsHeight(h);
            int newHeight = this.getFullHeight();
            TableRowCore row = this.getParentRowCore();
            if (row instanceof TableRowPainted) {
                ((TableRowPainted)row).subRowHeightChanged(oldHeight, newHeight);
            }
            if (!this.isFake) {
                TableViewPainted tvp = this.getViewPainted();
                if (triggerHeightListener) {
                    tvp.rowHeightChanged(this, oldHeight, newHeight);
                }
                tvp.triggerListenerRowAdded(newSubRows);
            }
            this.subRows = newSubRows;
        }
    }

    @Override
    public int getSubItemCount() {
        return this.numSubItems;
    }

    @Override
    public TableRowCore linkSubItem(int indexOf) {
        return null;
    }

    @Override
    public void setSubItems(Object[] datasources) {
        this.setSubItems(datasources, true);
        this.getViewPainted().sortRows(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubItems(Object[] datasources, boolean triggerHeightListeners) {
        this.deleteExistingSubRows();
        Object object = this.subRows_sync;
        synchronized (object) {
            this.subDataSources = datasources;
            this.setSubRowsHeight(0);
            this.setSubItemCount(datasources.length, triggerHeightListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getSubRowsWithNull() {
        Object object = this.subRows_sync;
        synchronized (object) {
            return this.subRows == null ? new TableRowCore[]{} : this.subRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getSubRowsRecursive(boolean includeHidden) {
        Object object = this.subRows_sync;
        synchronized (object) {
            ArrayList<TableRowCore> result = new ArrayList<TableRowCore>();
            this.getSubRowsRecursive(result, this.getSubRowsWithNull(), includeHidden);
            return result.toArray(new TableRowCore[result.size()]);
        }
    }

    private void getSubRowsRecursive(List<TableRowCore> result, TableRowCore[] rows, boolean includeHidden) {
        TableRowCore[] tableRowCoreArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowCore row = tableRowCoreArray[n2];
            if (includeHidden || !row.isHidden()) {
                result.add(row);
                if (includeHidden || row.isExpanded()) {
                    this.getSubRowsRecursive(result, row.getSubRowsWithNull(), includeHidden);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubRow(Object datasource) {
        Object object = this.subRows_sync;
        synchronized (object) {
            int i = 0;
            while (i < this.subDataSources.length) {
                Object ds = this.subDataSources[i];
                if (ds == datasource) {
                    TableRowPainted rowToDel = this.subRows[i];
                    TableRowPainted[] newSubRows = new TableRowPainted[this.subRows.length - 1];
                    System.arraycopy(this.subRows, 0, newSubRows, 0, i);
                    System.arraycopy(this.subRows, i + 1, newSubRows, i, this.subRows.length - i - 1);
                    this.subRows = newSubRows;
                    Object[] newDatasources = new Object[this.subRows.length];
                    System.arraycopy(this.subDataSources, 0, newDatasources, 0, i);
                    System.arraycopy(this.subDataSources, i + 1, newDatasources, i, this.subDataSources.length - i - 1);
                    this.subDataSources = newDatasources;
                    rowToDel.delete();
                    this.setSubItemCount(this.subRows.length);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void setExpanded(boolean b) {
        this.setExpanded(b, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExpanded(boolean b, boolean triggerHeightChange) {
        if (this.canExpand()) {
            int oldHeight = this.getFullHeight();
            super.setExpanded(b);
            Object object = this.subRows_sync;
            synchronized (object) {
                TableRowCore[] newSubRows = null;
                if (b && (this.subRows == null || this.subRows.length != this.numSubItems) && this.subDataSources != null && this.subDataSources.length == this.numSubItems) {
                    this.deleteExistingSubRows();
                    newSubRows = new TableRowPainted[this.numSubItems];
                    TableViewPainted tv = this.getViewPainted();
                    int h = 0;
                    int i = 0;
                    while (i < newSubRows.length) {
                        newSubRows[i] = new TableRowPainted(this, tv, this.subDataSources[i], false);
                        ((TableRowSWTBase)newSubRows[i]).setTableItem(i);
                        h += ((TableRowPainted)newSubRows[i]).getFullHeight();
                        ++i;
                    }
                    this.setSubRowsHeight(h);
                    this.subRows = newSubRows;
                }
                int newHeight = this.getFullHeight();
                TableRowCore row = this.getParentRowCore();
                if (row instanceof TableRowPainted) {
                    ((TableRowPainted)row).subRowHeightChanged(oldHeight, newHeight);
                }
                if (!this.isFake) {
                    if (triggerHeightChange) {
                        this.getViewPainted().rowHeightChanged(this, oldHeight, newHeight);
                    }
                    if (newSubRows != null) {
                        this.getViewPainted().triggerListenerRowAdded(newSubRows);
                    }
                }
            }
            Object ds = this.getDataSource(true);
            if (ds instanceof TableRowSWTChildController) {
                ((TableRowSWTChildController)ds).setExpanded(b);
            }
            if (!this.isFake) {
                TableViewPainted tvp = this.getViewPainted();
                if (triggerHeightChange) {
                    tvp.tableMutated();
                }
                if (this.isVisible()) {
                    tvp.visibleRowsChanged();
                    tvp.redrawTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getSubRow(int pos) {
        Object object = this.subRows_sync;
        synchronized (object) {
            block5: {
                if (this.subRows != null) break block5;
                return null;
            }
            if (pos >= 0 && pos < this.subRows.length) {
                return this.subRows[pos];
            }
            return null;
        }
    }

    @Override
    public Color getForeground() {
        if (this.colorFG != null) {
            return this.colorFG;
        }
        if (this.FGRequesters == null) {
            return null;
        }
        List<Object[]> list = this.FGRequesters.getList();
        if (!list.isEmpty()) {
            return (Color)list.get(0)[1];
        }
        return null;
    }

    @Override
    public Color getBackground() {
        if (this.BGRequesters == null) {
            return null;
        }
        List<Object[]> list = this.BGRequesters.getList();
        if (!list.isEmpty()) {
            return (Color)list.get(0)[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestForegroundColor(TableViewSWT.ColorRequester requester, Color color) {
        Object object = this.colorLock;
        synchronized (object) {
            if (this.FGRequesters == null) {
                this.FGRequesters = new CopyOnWriteList(1);
            }
        }
        this.requestColor(this.FGRequesters, requester, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestBackgroundColor(TableViewSWT.ColorRequester requester, Color color) {
        Object object = this.colorLock;
        synchronized (object) {
            if (this.BGRequesters == null) {
                this.BGRequesters = new CopyOnWriteList(1);
            }
        }
        this.requestColor(this.BGRequesters, requester, color);
    }

    /*
     * Exception decompiling
     */
    private void requestColor(CopyOnWriteList<Object[]> cow, TableViewSWT.ColorRequester requester, Color color) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setBackgroundImage(Image image) {
    }

    @Override
    public boolean setIconSize(Point pt) {
        return false;
    }

    @Override
    public int getHeight() {
        if (this.isHidden) {
            return 0;
        }
        return this.heightUseAccessors == 0 ? this.getView().getRowDefaultHeight() : this.heightUseAccessors;
    }

    @Override
    public boolean setHeight(int newHeight) {
        boolean trigger;
        TableRowCore parentRowCore = this.getParentRowCore();
        if (parentRowCore == null) {
            trigger = true;
        } else {
            boolean expanded = parentRowCore.isExpanded();
            while (expanded) {
                if ((parentRowCore = parentRowCore.getParentRowCore()) == null) break;
                expanded = parentRowCore.isExpanded();
            }
            trigger = expanded;
        }
        return this.setHeight(newHeight, trigger);
    }

    public boolean setHeight(int newHeight, boolean trigger) {
        if (this.heightUseAccessors == newHeight) {
            return false;
        }
        int oldHeightToReport = this.isHidden ? 0 : this.heightUseAccessors;
        this.heightUseAccessors = newHeight;
        if (trigger && !this.initializing) {
            int heightToReport;
            int n = heightToReport = this.isHidden ? 0 : newHeight;
            if (oldHeightToReport != heightToReport) {
                this.heightChanged(oldHeightToReport, heightToReport);
            }
        }
        return true;
    }

    @Override
    public int getLineHeight() {
        return this.getViewPainted().getLineHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore getTableCellCore(String name) {
        if (this.isRowDisposed()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            block8: {
                block9: {
                    if (this.mTableCells != null) break block8;
                    if (this.sortCells != null) break block9;
                    return null;
                }
                TableCellSWTBase[] tableCellSWTBaseArray = this.sortCells;
                int n = this.sortCells.length;
                int n2 = 0;
                while (n2 < n) {
                    TableCellSWTBase sortCell = tableCellSWTBaseArray[n2];
                    if (!sortCell.isDisposed() && name.equals(sortCell.getTableColumn().getName())) {
                        return sortCell;
                    }
                    ++n2;
                }
                return null;
            }
            return (TableCellCore)this.mTableCells.get(name);
        }
    }

    @Override
    public TableCell getTableCell(TableColumn column) {
        return this.getTableCell(column.getName());
    }

    @Override
    public TableCellSWT getTableCellSWT(String name) {
        TableCellCore cell = this.getTableCellCore(name);
        return cell instanceof TableCellSWT ? (TableCellSWT)cell : null;
    }

    @Override
    public TableCell getTableCell(String field) {
        return this.getTableCellCore(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore[] getSortColumnCells(String hint) {
        Object object = this.lock;
        synchronized (object) {
            return this.sortCells == null ? new TableCellCore[]{} : this.sortCells;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSortColumn(String ... columnIDs) {
        Object object = this.lock;
        synchronized (object) {
            int n;
            ArrayList<TableCellSWTBase> list = new ArrayList<TableCellSWTBase>();
            if (this.mTableCells == null) {
                if (this.sortCells != null) {
                    TableCellSWTBase[] tableCellSWTBaseArray = this.sortCells;
                    n = this.sortCells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableCellSWTBase sortCell = tableCellSWTBaseArray[n2];
                        if (!sortCell.isDisposed()) {
                            sortCell.dispose();
                        }
                        ++n2;
                    }
                }
                TableViewPainted table = this.getViewPainted();
                String[] stringArray = columnIDs;
                int n3 = columnIDs.length;
                n = 0;
                while (n < n3) {
                    String columnID = stringArray[n];
                    TableColumnCore sortColumn = (TableColumnCore)this.getView().getTableColumn(columnID);
                    if (sortColumn != null && (this.getParentRowCore() == null || sortColumn.handlesDataSourceType(this.getDataSource(false).getClass()))) {
                        list.add(new TableCellPainted(this, table.getColumnPainted(sortColumn), sortColumn.getPosition()));
                    }
                    ++n;
                }
            } else {
                String[] stringArray = columnIDs;
                n = columnIDs.length;
                int n4 = 0;
                while (n4 < n) {
                    String columnID = stringArray[n4];
                    TableCellSWTBase cell = (TableCellSWTBase)this.mTableCells.get(columnID);
                    if (cell != null) {
                        list.add(cell);
                    }
                    ++n4;
                }
            }
            this.sortCells = list.toArray(new TableCellSWTBase[0]);
        }
        object = this.subRows_sync;
        synchronized (object) {
            if (this.subRows != null) {
                TableRowPainted[] tableRowPaintedArray = this.subRows;
                int n = this.subRows.length;
                int n5 = 0;
                while (n5 < n) {
                    TableRowPainted r = tableRowPaintedArray[n5];
                    r.setSortColumn(columnIDs);
                    ++n5;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sortSubRows(List<TableColumnCore> cols) {
        Object object = this.subRows_sync;
        synchronized (object) {
            block13: {
                if (this.subRows != null) break block13;
                return false;
            }
            boolean changed = false;
            boolean sorted = true;
            TableRowPainted prev = null;
            TableRowPainted[] tableRowPaintedArray = this.subRows;
            int n = this.subRows.length;
            int n2 = 0;
            while (n2 < n) {
                TableRowPainted r = tableRowPaintedArray[n2];
                if (sorted) {
                    if (prev != null) {
                        for (TableColumnCore col : cols) {
                            if (col.compare(prev, r) <= 0) continue;
                            sorted = false;
                            break;
                        }
                    }
                    prev = r;
                }
                if (r.sortSubRows(cols)) {
                    changed = true;
                }
                ++n2;
            }
            if (!sorted) {
                if (cols.size() == 1) {
                    Arrays.sort(this.subRows, cols.get(0));
                } else {
                    Arrays.sort(this.subRows, (o1, o2) -> {
                        for (TableColumnCore sortColumn : cols) {
                            int compare = sortColumn.compare(o1, o2);
                            if (compare == 0) continue;
                            return compare;
                        }
                        return 0;
                    });
                }
                int i = 0;
                while (i < this.subRows.length) {
                    this.subRows[i].setTableItem(i);
                    ++i;
                }
                changed = true;
            }
            return changed;
        }
    }
}

