/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public abstract class ColumnDateSizer
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    private static int PADDING = 10;
    static GC gc_singleton;
    static final int[] extent_max;
    static final int[] extent_hits;
    private ParameterListener configDateFormatListener;
    int curFormat = 0;
    int[] maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
    Date[] maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
    private boolean showTime = true;
    private boolean multiline = true;
    private String tableFormatOverride = "";
    private ViewUtils.CustomDateFormat cdf;
    private boolean sortInvalidToBottom = false;
    private AtomicInteger sortChanging = new AtomicInteger();
    private AtomicInteger recalculatingWidths = new AtomicInteger();

    static {
        extent_max = new int[64];
        extent_hits = new int[64];
    }

    static int stringExtent(String str) {
        int len;
        if (gc_singleton == null) {
            gc_singleton = new GC((Drawable)Display.getDefault());
            gc_singleton.setFont(FontUtils.getAnyFontBold(gc_singleton));
            MessageText.addListener((l1, l2) -> Utils.execSWTThread(() -> {
                Arrays.fill(extent_max, 0);
                Arrays.fill(extent_hits, 0);
            }));
        }
        if ((len = str.length()) >= extent_max.length) {
            return ColumnDateSizer.gc_singleton.stringExtent((String)str).x;
        }
        int hits = extent_hits[len];
        if (hits >= 100) {
            return extent_max[len];
        }
        int result = ColumnDateSizer.gc_singleton.stringExtent((String)str).x;
        ColumnDateSizer.extent_max[len] = Math.max(extent_max[len], result);
        ColumnDateSizer.extent_hits[len] = hits + 1;
        return result;
    }

    public ColumnDateSizer(String sName, int iAlignment, int iPosition, int iWidth, String sTableID) {
        super(sName, iAlignment, iPosition, iWidth, sTableID);
        this.init();
    }

    public ColumnDateSizer(Class forDataSourceType, String columnID, int width, String tableID) {
        super(forDataSourceType, columnID, 2, width, tableID);
        this.init();
    }

    private void init() {
        final TableContextMenuItem menuShowTime = this.addContextMenuItem("TableColumn.menu.date_added.time", 1);
        menuShowTime.setStyle(2);
        menuShowTime.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(ColumnDateSizer.this.showTime);
            }
        });
        menuShowTime.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                ColumnDateSizer.this.showTime = !ColumnDateSizer.this.showTime;
                ColumnDateSizer.this.setUserData("showTime", new Long(ColumnDateSizer.this.showTime ? 1 : 0));
                ColumnDateSizer.this.maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
                ColumnDateSizer.this.maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
                ColumnDateSizer.this.curFormat = -1;
                ColumnDateSizer.this.recalcWidth(new Date(), null);
                if (ColumnDateSizer.this.curFormat < 0) {
                    ColumnDateSizer.this.curFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
                }
            }
        });
        this.configDateFormatListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                ColumnDateSizer.this.tableFormatOverride = COConfigurationManager.getStringParameter("Table.column.dateformat", "");
                if (ColumnDateSizer.this.tableFormatOverride == null) {
                    ColumnDateSizer.this.tableFormatOverride = "";
                }
                ColumnDateSizer.this.curFormat = -1;
                if (ColumnDateSizer.this.tableFormatOverride.length() == 0) {
                    ColumnDateSizer.this.recalcWidth(new Date(), null);
                    if (ColumnDateSizer.this.curFormat < 0) {
                        ColumnDateSizer.this.curFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
                    }
                    menuShowTime.setVisible(true);
                } else {
                    ColumnDateSizer.this.invalidateCells();
                    menuShowTime.setVisible(false);
                }
            }
        };
        COConfigurationManager.addAndFireParameterListener("Table.column.dateformat", this.configDateFormatListener);
        this.cdf = ViewUtils.addCustomDateFormat(this);
    }

    @Override
    public void remove() {
        COConfigurationManager.removeParameterListener("Table.column.dateformat", this.configDateFormatListener);
        super.remove();
    }

    @Override
    public void postConfigLoad() {
        int userMode;
        Number nShowTime;
        boolean oldShowTime = this.showTime;
        Object oShowTime = this.getUserData("showTime");
        this.showTime = oShowTime instanceof Number ? (nShowTime = (Number)oShowTime).byteValue() == 1 : (userMode = COConfigurationManager.getIntParameter("User Mode")) > 1;
        this.cdf.update();
        if (oldShowTime != this.showTime) {
            this.recalcWidth(new Date(), null);
        }
        super.postConfigLoad();
    }

    @Override
    public final void refresh(TableCell cell) {
        double last = cell.getNumeric();
        long ts = Double.isNaN(last) ? 0L : (long)last;
        this.refresh(cell, ts);
    }

    public void refresh(TableCell cell, long timestamp) {
        this.refresh(cell, timestamp, timestamp, null);
    }

    public void refresh(TableCell cell, long timestamp, String prefix) {
        this.refresh(cell, timestamp, timestamp, prefix);
    }

    public void refresh(TableCell cell, long timestamp, long sort_order, String prefix) {
        cell.setNumeric(timestamp <= 0L || timestamp == Long.MAX_VALUE ? Double.NaN : (double)timestamp);
        if (!this.setSortValue(cell, sort_order) && cell.isValid()) {
            return;
        }
        if (timestamp <= 0L || timestamp == Long.MAX_VALUE) {
            cell.setText(prefix);
            return;
        }
        String cdf_str = this.cdf.formatDate(timestamp);
        if (cdf_str != null) {
            if (prefix != null) {
                cdf_str = String.valueOf(prefix) + cdf_str;
            }
            cell.setText(cdf_str);
            return;
        }
        if (this.tableFormatOverride.length() > 0) {
            Date date = new Date(timestamp);
            try {
                SimpleDateFormat temp = new SimpleDateFormat(this.tableFormatOverride);
                String date_str = temp.format(date);
                if (prefix != null) {
                    date_str = String.valueOf(prefix) + date_str;
                }
                cell.setText(date_str);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.curFormat >= 0) {
            if (Utils.isSWTThread()) {
                this.refreshDynamic(cell, timestamp, prefix);
            } else {
                Utils.execSWTThread(() -> this.refreshDynamic(cell, timestamp, prefix));
            }
        }
    }

    private void refreshDynamic(TableCell cell, long timestamp, String prefix) {
        String existing;
        int newWidth;
        String suffix;
        Date date = new Date(timestamp);
        if (this.multiline && cell.getHeight() < 20) {
            this.multiline = false;
        }
        String string = suffix = this.showTime && !this.multiline ? " hh:mm a" : "";
        if (this.sortChanging.get() == 0 && (newWidth = this.calcWidth(date, String.valueOf(TimeFormatter.DATEFORMATS_DESC[this.curFormat]) + suffix, prefix)) > cell.getWidth() - PADDING) {
            if (newWidth > this.maxWidthUsed[this.curFormat]) {
                this.maxWidthUsed[this.curFormat] = newWidth;
                this.maxWidthDate[this.curFormat] = date;
            }
            this.recalcWidth(date, prefix);
        }
        String s = String.valueOf(TimeFormatter.DATEFORMATS_DESC[this.curFormat]) + suffix;
        SimpleDateFormat temp = new SimpleDateFormat(String.valueOf(s) + (this.showTime && this.multiline ? "\nh:mm a" : ""));
        String date_str = temp.format(date);
        if (prefix != null) {
            date_str = String.valueOf(prefix) + date_str;
        }
        if (!date_str.equals(existing = cell.getText())) {
            cell.setText(date_str);
        }
    }

    @Override
    public void setWidthPX(int width) {
        int oldWidth = this.getWidth();
        super.setWidthPX(width);
        if (oldWidth == width) {
            return;
        }
        if (this.maxWidthDate != null && this.curFormat >= 0) {
            if (this.maxWidthDate[this.curFormat] == null) {
                this.maxWidthDate[this.curFormat] = new Date();
            }
            this.recalcWidth(this.maxWidthDate[this.curFormat], null);
        }
    }

    private void recalcWidth(Date date, String prefix) {
        if (this.recalculatingWidths.get() > 0) {
            return;
        }
        try {
            this.recalculatingWidths.incrementAndGet();
            String suffix = this.showTime && !this.multiline ? " hh:mm a" : "";
            int width = this.getWidth();
            if (this.maxWidthDate == null) {
                this.maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
                this.maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
            }
            int idxFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
            try {
                int minSize = 99999;
                int i = 0;
                while (i < TimeFormatter.DATEFORMATS_DESC.length) {
                    if (this.maxWidthUsed[i] <= width - PADDING) {
                        int newWidth;
                        SimpleDateFormat temp = new SimpleDateFormat(String.valueOf(TimeFormatter.DATEFORMATS_DESC[i]) + suffix);
                        String date_str = temp.format(date);
                        if (prefix != null) {
                            date_str = String.valueOf(prefix) + date_str;
                        }
                        if ((newWidth = ColumnDateSizer.stringExtent(date_str)) < width - PADDING) {
                            idxFormat = i;
                            if (this.maxWidthUsed[i] < newWidth) {
                                this.maxWidthUsed[i] = newWidth;
                                this.maxWidthDate[i] = date;
                            }
                            break;
                        }
                        if (newWidth < newWidth) {
                            minSize = newWidth;
                            idxFormat = i;
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                this.recalculatingWidths.decrementAndGet();
                return;
            }
            if (this.curFormat != idxFormat) {
                this.curFormat = idxFormat;
                this.invalidateCells();
            }
        }
        finally {
            this.recalculatingWidths.decrementAndGet();
        }
    }

    private int calcWidth(Date date, String format, String prefix) {
        SimpleDateFormat temp = new SimpleDateFormat(format);
        String date_str = temp.format(date);
        if (prefix != null) {
            date_str = String.valueOf(prefix) + date_str;
        }
        int newSize = ColumnDateSizer.stringExtent(date_str);
        return newSize;
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    @Override
    public void cellHover(TableCell cell) {
        long eta;
        long timestamp;
        Comparable ds = cell.getSortValue();
        if (ds instanceof Number && (timestamp = ((Number)((Object)ds)).longValue()) > 0L && (eta = (SystemTime.getCurrentTime() - timestamp) / 1000L) > 0L) {
            cell.setToolTip(String.valueOf(DisplayFormatters.formatETA(eta, false)) + " " + MessageText.getString("label.ago"));
        }
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    public void setSortInvalidToBottom(boolean b) {
        this.sortInvalidToBottom = b;
    }

    private boolean setSortValue(TableCell cell, long value) {
        if (this.sortInvalidToBottom && value <= 0L) {
            value = this.isSortAscending() ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return cell.setSortValue(value);
    }

    @Override
    public void setSortAscending(boolean bAscending) {
        super.setSortAscending(bAscending);
        Utils.execSWTThread(() -> {
            this.sortChanging.incrementAndGet();
            try {
                this.invalidateCells();
            }
            finally {
                this.sortChanging.decrementAndGet();
            }
        });
    }
}

