/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;

public class FileCreationItem
extends ColumnDateSizer {
    public FileCreationItem() {
        super("filecreated", 2, -1, 60, "Files");
        this.setRefreshInterval(2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        DiskManagerFileInfo file = (DiskManagerFileInfo)cell.getDataSource();
        if (file == null) {
            timestamp = 0L;
        } else {
            try {
                FileTime creationTime = (FileTime)Files.getAttribute(file.getFile(true).toPath(), "creationTime", new LinkOption[0]);
                timestamp = creationTime.toMillis();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.refresh(cell, timestamp);
    }
}

