/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

public class FileHashItemBase
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener {
    protected static final String HT_CRC32 = "crc32";
    protected static final String HT_MD5 = "md5";
    protected static final String HT_SHA1 = "sha1";
    final String hash_type;
    final TableContextMenuItem menuItem;
    private static AsyncDispatcher dispatcher = new AsyncDispatcher();
    private static Map<DiskManagerFileInfo, Set<String>> pending = new HashMap<DiskManagerFileInfo, Set<String>>();
    private static volatile DiskManagerFileInfo active;
    private static volatile String active_hash;
    private static volatile int active_percent;

    public FileHashItemBase(String _hash_type, int width) {
        super(_hash_type, 1, -1, width, "Files");
        this.hash_type = _hash_type;
        this.setType(1);
        this.setRefreshInterval(-2);
        this.menuItem = this.addContextMenuItem("FilesView." + this.hash_type + ".calculate");
        this.menuItem.setStyle(1);
        this.menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                Object[] files;
                Object[] objectArray = files = (Object[])target;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    Object _file = objectArray[n2];
                    if (_file instanceof TableRow) {
                        _file = ((TableRow)_file).getDataSource();
                    }
                    DiskManagerFileInfo file = (DiskManagerFileInfo)_file;
                    FileHashItemBase.updateHash(FileHashItemBase.this.hash_type, file);
                    ++n2;
                }
            }
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)2);
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DiskManagerFileInfo file = (DiskManagerFileInfo)event2.cell.getDataSource();
        if (file == null) {
            return;
        }
        TableCellCore core_cell = (TableCellCore)event2.cell;
        if (!event2.cell.getText().startsWith("<")) {
            core_cell.setCursorID(0);
            core_cell.setToolTip(null);
            return;
        }
        if (event2.eventType == 4) {
            core_cell.setCursorID(21);
            core_cell.setToolTip(MessageText.getString("FilesView.click.info"));
        } else if (event2.eventType == 5) {
            core_cell.setCursorID(0);
            core_cell.setToolTip(null);
        }
        if (event2.eventType != 1) {
            return;
        }
        if (event2.button != 1) {
            return;
        }
        event2.skipCoreFunctionality = true;
        FileHashItemBase.updateHash(this.hash_type, file);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo file = (DiskManagerFileInfo)cell.getDataSource();
        if (file == null) {
            return;
        }
        cell.setText(FileHashItemBase.getHash(this.hash_type, file));
    }

    private static boolean isFileReady(DiskManagerFileInfo file) {
        if (file == null || file.getLength() != file.getDownloaded() || file.getAccessMode() != 1) {
            return false;
        }
        File f = file.getFile(true);
        return Utils.fileLengthWithTimeout(f) == file.getLength() && Utils.canReadFileWithTimeout(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateHash(final String hash_type, final DiskManagerFileInfo file) {
        if (!FileHashItemBase.isFileReady(file)) {
            return;
        }
        Map<DiskManagerFileInfo, Set<String>> map = pending;
        synchronized (map) {
            Set<String> hashes = pending.get(file);
            if (hashes != null && hashes.contains(hash_type)) {
                return;
            }
            if (hashes == null) {
                hashes = new HashSet<String>();
                pending.put(file, hashes);
            }
            hashes.add(hash_type);
        }
        dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                block41: {
                    DownloadManager dm;
                    block39: {
                        block38: {
                            dm = file.getDownloadManager();
                            if (dm != null) break block38;
                            Map map = pending;
                            synchronized (map) {
                                Set hashes = (Set)pending.get(file);
                                hashes.remove(hash_type);
                                if (hashes.size() == 0) {
                                    pending.remove(file);
                                }
                                active = null;
                            }
                            return;
                        }
                        if (FileHashItemBase.isFileReady(file)) break block39;
                        Map map = pending;
                        synchronized (map) {
                            Set hashes = (Set)pending.get(file);
                            hashes.remove(hash_type);
                            if (hashes.size() == 0) {
                                pending.remove(file);
                            }
                            active = null;
                        }
                        return;
                    }
                    try {
                        try {
                            active_percent = 0;
                            active_hash = hash_type;
                            active = file;
                            File f = file.getFile(true);
                            CRC32 crc32 = null;
                            MessageDigest md = null;
                            if (hash_type == FileHashItemBase.HT_CRC32) {
                                crc32 = new CRC32();
                            } else {
                                md = hash_type == FileHashItemBase.HT_MD5 ? MessageDigest.getInstance(FileHashItemBase.HT_MD5) : MessageDigest.getInstance("SHA1");
                            }
                            FileInputStream fis = new FileInputStream(f);
                            long size = f.length();
                            long done = 0L;
                            if (size == 0L) {
                                size = 1L;
                            }
                            try {
                                byte[] hash;
                                int len;
                                byte[] buffer = new byte[524288];
                                while ((len = fis.read(buffer)) > 0) {
                                    if (crc32 != null) {
                                        crc32.update(buffer, 0, len);
                                    }
                                    if (md != null) {
                                        md.update(buffer, 0, len);
                                    }
                                    active_percent = (int)(1000L * (done += (long)len) / size);
                                }
                                if (crc32 != null) {
                                    long val = crc32.getValue();
                                    hash = ByteFormatter.intToByteArray(val);
                                } else {
                                    hash = md.digest();
                                }
                                Map<String, HashMap<String, Object>> other_hashes = dm.getDownloadState().getMapAttribute("fileotherhashes");
                                other_hashes = other_hashes == null ? new HashMap<String, HashMap<String, byte[]>>() : BEncoder.cloneMap(other_hashes);
                                HashMap<String, byte[]> file_hashes = (HashMap<String, byte[]>)other_hashes.get(String.valueOf(file.getIndex()));
                                if (file_hashes == null) {
                                    file_hashes = new HashMap<String, byte[]>();
                                    other_hashes.put(String.valueOf(file.getIndex()), file_hashes);
                                }
                                file_hashes.put(hash_type, hash);
                                dm.getDownloadState().setMapAttribute("fileotherhashes", other_hashes);
                            }
                            finally {
                                fis.close();
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            Map map = pending;
                            synchronized (map) {
                                Set hashes = (Set)pending.get(file);
                                hashes.remove(hash_type);
                                if (hashes.size() == 0) {
                                    pending.remove(file);
                                }
                                active = null;
                                break block41;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Map map = pending;
                        synchronized (map) {
                            Set hashes = (Set)pending.get(file);
                            hashes.remove(hash_type);
                            if (hashes.size() == 0) {
                                pending.remove(file);
                            }
                            active = null;
                        }
                        throw throwable;
                    }
                    Map map = pending;
                    synchronized (map) {
                        Set hashes = (Set)pending.get(file);
                        hashes.remove(hash_type);
                        if (hashes.size() == 0) {
                            pending.remove(file);
                        }
                        active = null;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getHash(String hash_type, DiskManagerFileInfo file) {
        byte[] hash;
        Map file_hashes;
        if (file == null) {
            return "";
        }
        DownloadManager dm = file.getDownloadManager();
        if (dm == null) {
            return "";
        }
        Map<DiskManagerFileInfo, Set<String>> map = pending;
        synchronized (map) {
            Set<String> hashes = pending.get(file);
            if (hashes != null && hashes.contains(hash_type)) {
                if (active == file && active_hash == hash_type) {
                    return DisplayFormatters.formatPercentFromThousands(active_percent);
                }
                return "...";
            }
        }
        Map other_hashes = dm.getDownloadState().getMapAttribute("fileotherhashes");
        if (other_hashes != null && (file_hashes = (Map)other_hashes.get(String.valueOf(file.getIndex()))) != null && (hash = (byte[])file_hashes.get(hash_type)) != null) {
            return ByteFormatter.encodeString(hash).toLowerCase();
        }
        if (!FileHashItemBase.isFileReady(file)) {
            return "";
        }
        return "<" + MessageText.getString("FilesView.click") + ">";
    }
}

