/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellInplaceEditorListener;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.FilesViewMenuUtil;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class NameItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfuscateCellText,
TableCellSWTPaintListener,
TableCellMouseMoveListener,
TableCellInplaceEditorListener,
TableCellToolTipListener {
    private static final String ID_CHECKHITAREA = "checkHitArea";
    private static final Object KEY_OLD_CELL_TT = new Object();
    private static final Object KEY_PATH_ICON = new Object();
    private static boolean NEVER_SHOW_TWISTY;
    private static boolean bShowIcon;
    private static AsyncDispatcher dispatcher;
    private ParameterListener configShowProgramIconListener;
    final TableContextMenuItem menuItem;

    static {
        COConfigurationManager.addAndFireParameterListener("FilesView.use.tree", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                NEVER_SHOW_TWISTY = !COConfigurationManager.getBooleanParameter("FilesView.use.tree");
            }
        });
        dispatcher = new AsyncDispatcher("NameItem");
    }

    public NameItem() {
        super("name", 1, -2, 300, "Files");
        this.setObfuscation(true);
        this.setInplaceEditorListener(this);
        this.setType(1);
        this.configShowProgramIconListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
                NameItem.this.invalidateCells();
            }
        };
        COConfigurationManager.addWeakParameterListener(this.configShowProgramIconListener, true, "NameColumn.showProgramIcon");
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showProgramIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(bShowIcon);
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter("NameColumn.showProgramIcon", (Boolean)menu.getData());
            }
        });
        this.menuItem = this.addContextMenuItem("Files.column.name.fastRename", 1);
        this.menuItem.setStyle(2);
        this.menuItem.setData(this.hasInplaceEditorListener());
        this.menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                menu.setData(!NameItem.this.hasInplaceEditorListener());
                NameItem.this.setInplaceEditorListener(NameItem.this.hasInplaceEditorListener() ? null : NameItem.this);
            }
        });
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.configShowProgramIconListener, "NameColumn.showProgramIcon");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void postConfigLoad() {
        this.setInplaceEditorListener(this.getUserData("noInplaceEdit") == null ? null : this);
        this.menuItem.setData(this.hasInplaceEditorListener());
    }

    @Override
    public void preConfigSave() {
        if (this.hasInplaceEditorListener()) {
            this.removeUserData("noInplaceEdit");
        } else {
            this.setUserData("noInplaceEdit", new Integer(1));
        }
    }

    @Override
    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String name;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String string = name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        if (name == null) {
            name = "";
        }
        cell.setSortValue((Comparable)((Object)name));
    }

    @Override
    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        int textX;
        int originalBoundxsX;
        Rectangle cellBounds;
        block54: {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
            cellBounds = cell.getBounds();
            textX = originalBoundxsX = cellBounds.x;
            TableRowCore rowCore = cell.getTableRowCore();
            boolean showIcon = bShowIcon;
            if (rowCore != null) {
                String check_key;
                boolean is_leaf;
                int depth;
                int is_skipped = -1;
                if (fileInfo2 instanceof FilesView.FilesViewTreeNode) {
                    FilesView.FilesViewTreeNode node = (FilesView.FilesViewTreeNode)((Object)fileInfo2);
                    depth = node.getDepth();
                    is_leaf = node.isLeaf();
                    if (!is_leaf) {
                        showIcon = false;
                        is_skipped = node.getSkippedState();
                    }
                } else {
                    depth = 0;
                    is_leaf = true;
                }
                int numSubItems = rowCore.getSubItemCount();
                int EXPANDOPADLEFT = 3;
                int paddingX = 3;
                int EXPANDOWIDTH = 7;
                paddingX += depth * 7;
                boolean show_twisty = NEVER_SHOW_TWISTY ? false : numSubItems > 1 || !is_leaf;
                if (!NEVER_SHOW_TWISTY) {
                    cellBounds.x += paddingX;
                    cellBounds.width -= paddingX;
                }
                int CHECKPADLEFT = 2;
                if (show_twisty) {
                    int middleY = cellBounds.y + cellBounds.height / 2 - 1;
                    int startX = cellBounds.x + paddingX;
                    int halfHeight = 2;
                    Color bg = gc.getBackground();
                    gc.setBackground(gc.getForeground());
                    gc.setAntialias(1);
                    gc.setAdvanced(true);
                    if (rowCore.isExpanded()) {
                        gc.fillPolygon(new int[]{startX, middleY - halfHeight, startX + 7, middleY - halfHeight, startX + 3, middleY + halfHeight * 2 + 1});
                    } else {
                        gc.fillPolygon(new int[]{startX, middleY - halfHeight, startX + 7, middleY + halfHeight, startX, middleY + halfHeight * 2 + 1});
                    }
                    gc.setBackground(bg);
                    Rectangle hitArea = new Rectangle(startX - originalBoundxsX - 3, 0, 12, cellBounds.height);
                    rowCore.setData("expandoHitArea", hitArea);
                    rowCore.setData("expandoHitColumn", this.getName());
                }
                if (!NEVER_SHOW_TWISTY) {
                    cellBounds.x += paddingX + 7;
                    cellBounds.width -= paddingX + 7;
                }
                ImageLoader im = ImageLoader.getInstance();
                boolean is_ro = false;
                TOTorrentFile tf = fileInfo2.getTorrentFile();
                if (tf != null && tf.isPadFile()) {
                    is_ro = true;
                    check_key = "check_ro_no";
                } else if (is_leaf) {
                    Boolean isSkipped = fileInfo2.isSkipping();
                    if (isSkipped == null) {
                        isSkipped = fileInfo2.isSkipped();
                    }
                    if (isSkipped.booleanValue()) {
                        int st = fileInfo2.getStorageType();
                        check_key = st == 2 || st == 4 ? "check_no" : "check_no_grey";
                    } else if (fileInfo2.getLength() == fileInfo2.getDownloaded()) {
                        check_key = "check_ro_yes";
                        is_ro = true;
                    } else {
                        check_key = "check_yes";
                    }
                } else if (is_skipped == 0) {
                    check_key = "check_no";
                } else if (is_skipped == 1) {
                    if (fileInfo2.getLength() == fileInfo2.getDownloaded()) {
                        check_key = "check_ro_yes";
                        is_ro = true;
                    } else {
                        check_key = "check_yes";
                    }
                } else {
                    check_key = "check_maybe";
                }
                Image check = im.getImage(check_key);
                Rectangle checkSize = check.getBounds();
                int checkYOffset = (cellBounds.height - checkSize.height) / 2 + 1;
                gc.drawImage(check, cellBounds.x + 2, cellBounds.y + checkYOffset);
                im.releaseImage(check_key);
                if (!is_ro) {
                    Rectangle hitArea = new Rectangle(cellBounds.x + 2 - originalBoundxsX, checkYOffset, checkSize.width, checkSize.height);
                    rowCore.setData(ID_CHECKHITAREA, hitArea);
                }
                cellBounds.x += checkSize.width + 4;
                cellBounds.width -= checkSize.width + 4;
            }
            if (!showIcon) {
                cellBounds.x += 2;
                cellBounds.width -= 4;
                this.cellPaintName(cell, gc, cellBounds, cellBounds.x, originalBoundxsX);
                return;
            }
            Image[] imgThumbnail = null;
            if (fileInfo2 != null) {
                Object[] temp;
                File file = fileInfo2.getFile(true);
                Object piCache = cell.getData(KEY_PATH_ICON);
                if (piCache != null && FileUtil.areFilePathsIdentical((File)(temp = (Object[])piCache)[0], file)) {
                    imgThumbnail = (Image[])temp[1];
                }
                if (imgThumbnail == null) {
                    imgThumbnail = new Image[]{ImageRepository.getPathIcon(file.getPath(), cell.getHeight() > 32, false)};
                    cell.setData(KEY_PATH_ICON, new Object[]{file, imgThumbnail});
                }
            }
            if (imgThumbnail != null && ImageLoader.isRealImage((Image)imgThumbnail[0])) {
                try {
                    int dstWidth;
                    int dstHeight;
                    if (cellBounds.height > 30) {
                        ++cellBounds.y;
                        cellBounds.height -= 3;
                    }
                    Rectangle imgBounds = imgThumbnail[0].getBounds();
                    if (imgBounds.height > cellBounds.height) {
                        dstHeight = cellBounds.height;
                        dstWidth = imgBounds.width * cellBounds.height / imgBounds.height;
                    } else if (imgBounds.width > cellBounds.width) {
                        dstWidth = cellBounds.width - 4;
                        dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
                    } else {
                        dstWidth = imgBounds.width;
                        dstHeight = imgBounds.height;
                    }
                    if (cellBounds.height <= 18) {
                        dstWidth = Math.min(dstWidth, cellBounds.height);
                        dstHeight = Math.min(dstHeight, cellBounds.height);
                        if (imgBounds.width > 16) {
                            ++cellBounds.y;
                            dstHeight -= 2;
                        }
                    }
                    try {
                        gc.setAdvanced(true);
                        gc.setInterpolation(2);
                    }
                    catch (Exception EXPANDOPADLEFT) {
                        // empty catch block
                    }
                    int x = cellBounds.x;
                    textX = x + dstWidth + 3;
                    int minWidth = dstHeight * 7 / 4;
                    int imgPad = 0;
                    if (dstHeight > 25 && dstWidth < minWidth) {
                        imgPad = (minWidth - dstWidth + 1) / 2;
                        x = cellBounds.x + imgPad;
                        textX = cellBounds.x + minWidth + 3;
                    }
                    if (cellBounds.width - dstWidth - imgPad * 2 < 100 && dstHeight > 18) {
                        dstWidth = Math.min(32, dstHeight);
                        x = cellBounds.x + (32 - dstWidth + 1) / 2;
                        dstHeight = imgBounds.height * dstWidth / imgBounds.width;
                        textX = cellBounds.x + dstWidth + 3;
                    }
                    int y = cellBounds.y + (cellBounds.height - dstHeight + 1) / 2;
                    if (dstWidth <= 0 || dstHeight <= 0 || imgBounds.isEmpty()) break block54;
                    Rectangle lastClipping = gc.getClipping();
                    try {
                        try {
                            boolean hack_adv;
                            Utils.setClipping(gc, cellBounds);
                            boolean bl = hack_adv = Constants.isWindows8OrHigher && gc.getAdvanced();
                            if (hack_adv) {
                                gc.setAdvanced(false);
                            }
                            int i = 0;
                            while (i < imgThumbnail.length) {
                                Image image = imgThumbnail[i];
                                if (image != null && !image.isDisposed()) {
                                    int h;
                                    int w;
                                    Rectangle srcBounds = image.getBounds();
                                    if (i == 0) {
                                        w = dstWidth;
                                        h = dstHeight;
                                        if (imgThumbnail.length > 1) {
                                            w = w * 9 / 10;
                                            h = h * 9 / 10;
                                        }
                                        gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x, y, w, h);
                                    } else {
                                        w = dstWidth * 3 / 8;
                                        h = dstHeight * 3 / 8;
                                        gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x + dstWidth - w, y + dstHeight - h, w, h);
                                    }
                                }
                                ++i;
                            }
                            if (hack_adv) {
                                gc.setAdvanced(true);
                            }
                        }
                        catch (Exception e) {
                            Debug.out(e);
                            Utils.setClipping(gc, lastClipping);
                            break block54;
                        }
                    }
                    catch (Throwable throwable) {
                        Utils.setClipping(gc, lastClipping);
                        throw throwable;
                    }
                    Utils.setClipping(gc, lastClipping);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }
        this.cellPaintName(cell, gc, cellBounds, textX, originalBoundxsX);
    }

    private void cellPaintName(TableCell cell, GC gc, Rectangle cellBounds, int textX, int originalBoundxsX) {
        String name;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String string = name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        if (name == null) {
            name = "";
        }
        GCStringPrinter sp = new GCStringPrinter(gc, name, new Rectangle(textX, cellBounds.y, cellBounds.x + cellBounds.width - textX, cellBounds.height), true, true, this.getTableID().endsWith(".big") ? 64 : 0);
        boolean fit = sp.printString();
        Point p = sp.getCalculatedPreferredSize();
        int pref = textX - originalBoundxsX + p.x + 10;
        TableColumn tableColumn = cell.getTableColumn();
        if (tableColumn != null && tableColumn.getPreferredWidth() < pref) {
            tableColumn.setPreferredWidth(pref);
        }
        String tooltip = fit ? "" : name;
        cell.setToolTip(tooltip.length() == 0 ? null : tooltip);
    }

    @Override
    public void cellHover(TableCell cell) {
        String origName;
        String name;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String tooltip = fileInfo2 == null ? null : ((name = fileInfo2.getFile(true).getName()).equals(origName = fileInfo2.getFile(false).getName()) ? name : String.valueOf(name) + "\n" + origName);
        cell.setToolTip(tooltip);
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    @Override
    public String getClipboardText(TableCell cell) {
        String name;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String string = name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        return UIDebugGenerator.obfuscateFileName((DiskManagerFileInfo)cell.getDataSource());
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType == 3 || event2.eventType == 0) {
            Rectangle hitArea;
            boolean inExpando;
            TableCell cell = event2.cell;
            TableRow row = cell.getTableRow();
            if (row == null) {
                return;
            }
            boolean inArea = false;
            Object data = row.getData("expandoHitArea");
            if (data instanceof Rectangle && (inExpando = (hitArea = (Rectangle)data).contains(event2.x, event2.y))) {
                inArea = true;
                if (event2.eventType == 0 && event2.button == 1 && row instanceof TableRowCore) {
                    TableRowCore rowCore;
                    rowCore.setExpanded(!(rowCore = (TableRowCore)row).isExpanded());
                }
            }
            if ((data = row.getData(ID_CHECKHITAREA)) instanceof Rectangle) {
                TableCellCore cellCore;
                Object existingTT;
                hitArea = (Rectangle)data;
                boolean inCheck = hitArea.contains(event2.x, event2.y);
                String our_tt = Messages.getLanguageText("filesview.name.check.tt");
                Object set_tt = null;
                if (inCheck) {
                    TableRowCore rowCore;
                    DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
                    boolean realFile = fileInfo2 instanceof FilesView.FilesViewTreeNode ? ((FilesView.FilesViewTreeNode)((Object)fileInfo2)).isLeaf() : true;
                    if (realFile) {
                        set_tt = our_tt;
                    }
                    inArea = true;
                    if (event2.eventType == 0 && event2.button == 1 && row instanceof TableRowCore && (rowCore = (TableRowCore)row) != null) {
                        dispatcher.dispatch(AERunnable.create(() -> {
                            FilesView.FilesViewTreeNode node;
                            if (fileInfo2 instanceof FilesView.FilesViewTreeNode && !(node = (FilesView.FilesViewTreeNode)((Object)fileInfo2)).isLeaf()) {
                                int old_skipped = node.getSkippedState();
                                boolean new_skipped = old_skipped == 0 ? false : old_skipped == 1;
                                Utils.execSWTThreadLater(100, () -> {
                                    cell.invalidate();
                                    rowCore.redraw(true);
                                });
                                node.setSkipped(new_skipped);
                                return;
                            }
                            if ((tableCellMouseEvent.keyboardState & 0x20000) != 0 && !fileInfo2.isSkipped()) {
                                FilesViewMenuUtil.changePriority(FilesViewMenuUtil.PRIORITY_DELETE, Collections.singletonList(fileInfo2), false);
                            } else {
                                Utils.execSWTThreadLater(100, () -> {
                                    cell.invalidate();
                                    rowCore.redraw();
                                });
                                ManagerUtils.setFileSkipped(fileInfo2, !fileInfo2.isSkipped());
                            }
                        }));
                    }
                }
                if (!(!(cell instanceof TableCellCore) || (existingTT = (cellCore = (TableCellCore)cell).getToolTip()) == set_tt || existingTT instanceof String && set_tt != null && set_tt.equals(existingTT))) {
                    if (existingTT != null && !existingTT.equals(our_tt)) {
                        cellCore.setData(KEY_OLD_CELL_TT, existingTT);
                    }
                    if (set_tt == null) {
                        set_tt = cellCore.getData(KEY_OLD_CELL_TT);
                    }
                    cellCore.setToolTip(set_tt);
                }
            }
            if (event2.eventType == 3) {
                ((TableCellCore)cell).setCursorID(inArea ? 21 : 0);
            }
        }
    }

    @Override
    public boolean inplaceValueSet(TableCell cell, String value, boolean finalEdit) {
        File target;
        if (value.equalsIgnoreCase(cell.getText()) || "".equals(value) || "".equals(cell.getText())) {
            return true;
        }
        final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        try {
            target = new File(fileInfo2.getFile(true).getParentFile(), value).getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!finalEdit) {
            return !target.exists();
        }
        if (target.exists()) {
            return false;
        }
        final boolean[] result = new boolean[1];
        boolean paused = fileInfo2.getDownloadManager().pause(true);
        FileUtil.runAsTask(new CoreOperationTask(){

            @Override
            public String getName() {
                return fileInfo2.getFile(true).getName();
            }

            @Override
            public DownloadManager getDownload() {
                return fileInfo2.getDownloadManager();
            }

            @Override
            public String[] getAffectedFileSystems() {
                return FileUtil.getFileStoreNames(fileInfo2.getDownloadManager().getAbsoluteSaveLocation(), target);
            }

            @Override
            public boolean runOperation(CoreOperation operation) {
                result[0] = fileInfo2.setLink(target, false);
                return true;
            }

            @Override
            public CoreOperationTask.ProgressCallback getProgressCallback() {
                return null;
            }
        });
        if (paused) {
            fileInfo2.getDownloadManager().resume();
        }
        if (!result[0]) {
            new MessageBoxShell(33, MessageText.getString("FilesView.rename.failed.title"), MessageText.getString("FilesView.rename.failed.text")).open(null);
        }
        return true;
    }
}

