/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.StringInterner;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.io.File;
import java.io.IOException;

public class PathItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private final ParameterListener configShowFullPathListener = new ParameterListener(){

        @Override
        public void parameterChanged(String parameterName) {
            PathItem.this.show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path");
            PathItem.this.invalidateCells();
        }
    };
    private boolean show_full_path;

    public PathItem() {
        super("path", 1, -2, 200, "Files");
        COConfigurationManager.addWeakParameterListener(this.configShowFullPathListener, true, "FilesView.show.full.path");
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.configShowFullPathListener, "FilesView.show.full.path");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        cell.setText(PathItem.determinePath(fileInfo2, this.show_full_path));
    }

    protected static StringInterner.DirKey determinePath(DiskManagerFileInfo fileInfo2, boolean _show_file_path) {
        String dl_save_path;
        FilesView.FilesViewTreeNode node;
        if (fileInfo2 == null) {
            return StringInterner.DirKey.EMPTY_PATH;
        }
        if (fileInfo2 instanceof FilesView.FilesViewTreeNode && !(node = (FilesView.FilesViewTreeNode)((Object)fileInfo2)).isLeaf()) {
            return StringInterner.DirKey.EMPTY_PATH;
        }
        boolean has_link = fileInfo2.getLink() != null;
        boolean show_full_path = _show_file_path;
        DownloadManager dm = fileInfo2.getDownloadManager();
        if (dm == null) {
            return StringInterner.DirKey.EMPTY_PATH;
        }
        File dl_save_path_file = dm.getAbsoluteSaveLocation();
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null && torrent.isSimpleTorrent()) {
            dl_save_path_file = dl_save_path_file.getParentFile();
        }
        if (!(dl_save_path = dl_save_path_file.getPath()).endsWith(File.separator)) {
            dl_save_path = String.valueOf(dl_save_path) + File.separator;
        }
        File file = fileInfo2.getFile(true);
        String dnd_al = null;
        if (has_link && !show_full_path) {
            String abs_path = file.getAbsolutePath();
            boolean bl = show_full_path = !abs_path.startsWith(dl_save_path);
            if (show_full_path && (dnd_al = dm.getDownloadState().getAttribute("dnd_al")) != null && abs_path.startsWith(dnd_al)) {
                show_full_path = false;
            }
        }
        String path = "";
        if (show_full_path) {
            File parent = file.getParentFile();
            if (parent != null) {
                try {
                    path = Utils.getCanonicalPathWithTimeout(parent);
                }
                catch (IOException e) {
                    path = file.getParentFile().getAbsolutePath();
                }
                if (path != null && !path.endsWith(File.separator)) {
                    path = String.valueOf(path) + File.separator;
                }
            }
        } else if (dnd_al != null) {
            path = "dnd" + File.separator + fileInfo2.getFile(false).getAbsolutePath().substring(dl_save_path.length());
        } else {
            String apath = file.getAbsolutePath();
            if (!apath.startsWith(dl_save_path)) {
                path = apath;
            } else {
                path = apath.substring(dl_save_path.length());
                if (path.length() == 0) {
                    path = File.separator;
                } else {
                    int pos;
                    if (path.charAt(0) == File.separatorChar) {
                        path = path.substring(1);
                    }
                    path = (pos = path.lastIndexOf(File.separator)) > 0 ? String.valueOf(File.separator) + path.substring(0, pos) : File.separator;
                }
                path = "." + path;
            }
        }
        return new StringInterner.DirKey(path);
    }
}

