/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.util.StringInterner;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellLightRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.tableitems.files.PathItem;
import org.eclipse.swt.graphics.Image;

public class PathNameItem
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfuscateCellText,
TableCellDisposeListener {
    private final ParamListenerShowProgramIcon paramListenerShowProgramIcon = new ParamListenerShowProgramIcon();
    private final ParameterListener configShowFullPathListener;
    private boolean show_full_path;
    private boolean bShowIcon;

    public PathNameItem() {
        super("pathname", 1, -1, 500, "Files");
        this.setObfuscation(true);
        this.setType(1);
        COConfigurationManager.addWeakParameterListener(this.paramListenerShowProgramIcon, true, "NameColumn.showProgramIcon");
        this.configShowFullPathListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                PathNameItem.this.show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path");
            }
        };
        COConfigurationManager.addWeakParameterListener(this.configShowFullPathListener, true, "FilesView.show.full.path");
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.paramListenerShowProgramIcon, "NameColumn.showProgramIcon");
        COConfigurationManager.removeWeakParameterListener(this.configShowFullPathListener, "FilesView.show.full.path");
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        StringInterner.DirKey dk;
        StringInterner.FileKey fk;
        String file_name;
        final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String string = file_name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        if (file_name == null) {
            file_name = "";
        }
        if ((cell.setText(fk = (dk = PathItem.determinePath(fileInfo2, this.show_full_path)).isEmpty() ? new StringInterner.FileKey(file_name) : new StringInterner.FileKey(dk, file_name)) || !cell.isValid()) && this.bShowIcon && !sortOnlyRefresh) {
            Image icon = null;
            final TableCellSWT _cell = (TableCellSWT)cell;
            if (fileInfo2 == null) {
                icon = null;
            } else if (Utils.isSWTThread()) {
                icon = ImageRepository.getPathIcon(fileInfo2.getFile(true).getPath(), cell.getHeight() > 32, false);
            } else {
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        Image icon = ImageRepository.getPathIcon(fileInfo2.getFile(true).getPath(), _cell.getHeight() > 32, false);
                        _cell.setIcon(icon);
                        _cell.redraw();
                    }
                });
            }
            if (icon != null) {
                _cell.setIcon(icon);
            }
        }
    }

    @Override
    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        return UIDebugGenerator.obfuscateFileName((DiskManagerFileInfo)cell.getDataSource());
    }

    @Override
    public void dispose(TableCell cell) {
    }

    private class ParamListenerShowProgramIcon
    implements ParameterListener {
        private ParamListenerShowProgramIcon() {
        }

        @Override
        public void parameterChanged(String parameterName) {
            PathNameItem.this.bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
        }
    }
}

