/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.files;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.io.File;

public class RelocatedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public RelocatedItem() {
        super("relocated", 3, -1, 70, "Files");
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        boolean relocated;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        if (fileInfo2 == null) {
            relocated = false;
        } else {
            int index = fileInfo2.getIndex();
            if (index < 0) {
                relocated = false;
            } else {
                File source = fileInfo2.getFile(false);
                File target = fileInfo2.getDownloadManager().getDownloadState().getFileLink(index);
                relocated = target == null ? false : (target == source ? false : !target.equals(source));
            }
        }
        if (!cell.setSortValue(relocated ? 1 : 0) && cell.isValid()) {
            return;
        }
        String text = relocated ? "*" : "";
        cell.setText(text);
    }
}

