/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class AvgAvailItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    private static final String zeros = "0000";
    private static final int numZeros = "0000".length();
    public static final String COLUMN_ID = "AvgAvail";
    private int iTimesBy;

    public AvgAvailItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 50, sTableID);
        this.setRefreshInterval(-2);
        this.iTimesBy = 1;
        int i = 1;
        while (i < numZeros) {
            this.iTimesBy *= 10;
            ++i;
        }
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
    }

    @Override
    public void refresh(TableCell cell) {
        String sText = "";
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return;
        }
        PEPeerManager pm = dm.getPeerManager();
        if (pm != null) {
            float f = pm.getAvgAvail();
            if (!cell.setSortValue((long)(f * 1000.0f)) && cell.isValid()) {
                return;
            }
            sText = String.valueOf((int)(f * (float)this.iTimesBy));
            if (numZeros - sText.length() > 0) {
                sText = String.valueOf(zeros.substring(0, numZeros - sText.length())) + sText;
            }
            sText = String.valueOf(sText.substring(0, sText.length() - numZeros + 1)) + "." + sText.substring(sText.length() - numZeros + 1);
        } else {
            cell.setSortValue(0L);
        }
        cell.setText(sText);
    }
}

