/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class ColumnFileCount
extends CoreTableColumnSWT
implements TableCellMouseListener,
TableCellSWTPaintListener,
TableCellAddedListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "filecount";

    public ColumnFileCount(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 60, sTableID);
        this.setRefreshInterval(-3);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellAdded(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int sortVal = dm.getNumFileInfos();
        cell.setSortValue(sortVal);
    }

    @Override
    public void cellMouseTrigger(final TableCellMouseEvent event2) {
        if (Utils.getUserMode() < 2) {
            return;
        }
        final DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (event2.eventType == 4) {
            ((TableCellCore)event2.cell).setCursorID(21);
        } else if (event2.eventType == 4) {
            ((TableCellCore)event2.cell).setCursorID(0);
        } else if (event2.eventType == 1 && event2.button == 1) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                @Override
                public void runSupport() {
                    ColumnFileCount.this.openFilesMiniView(dm, event2.cell);
                }
            });
        }
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return;
        }
        int sortVal = dm.getNumFileInfos();
        cell.setTextEquivalent(String.valueOf(sortVal));
        Rectangle bounds = cell.getBounds();
        Rectangle printArea = new Rectangle(bounds.x, bounds.y, bounds.width - 6, bounds.height);
        GCStringPrinter.printString(gc, "" + sortVal, printArea, true, true, 131072);
    }

    private void openFilesMiniView(DownloadManager dm, TableCell cell) {
        UISWTViewBuilderCore builder = ViewManagerSWT.getInstance().getBuilder(Download.class, "FilesView");
        if (builder == null) {
            return;
        }
        SkinnedDialog skinnedDialog = PopOutManager.buildSkinnedDialog("FilesView", dm, builder);
        if (skinnedDialog == null) {
            return;
        }
        skinnedDialog.setTitle(dm.getDisplayName());
        Shell shell = skinnedDialog.getShell();
        Rectangle bounds = ((TableCellSWT)cell).getBoundsOnDisplay();
        bounds.y += bounds.height;
        bounds.width = 630;
        bounds.height = 16 * dm.getNumFileInfos() + 60;
        Rectangle realBounds = shell.computeTrim(0, 0, bounds.width, bounds.height);
        realBounds.width -= realBounds.x;
        realBounds.height -= realBounds.y;
        realBounds.x = bounds.x;
        realBounds.y = bounds.y;
        if (bounds.height > 500) {
            bounds.height = 500;
        }
        shell.setBounds(realBounds);
        shell.setAlpha(230);
        Utils.verifyShellRect(shell, true);
        skinnedDialog.openUnadjusted();
    }
}

