/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;
import java.io.File;

public class DateAddedItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "date_added";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
        info.setProficiency((byte)0);
    }

    public DateAddedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setMultiline(false);
        TableContextMenuItem menuReset = this.addContextMenuItem("TableColumn.menu.date_added.reset");
        menuReset.addListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                if (target instanceof TableRowCore) {
                    TableRowCore row = (TableRowCore)target;
                    Object dataSource = row.getDataSource(true);
                    if (dataSource instanceof DownloadManager) {
                        DownloadManager dm = (DownloadManager)dataSource;
                        DownloadManagerState state = dm.getDownloadState();
                        try {
                            long add_time = new File(dm.getTorrentFileName()).lastModified();
                            if (add_time >= 0L) {
                                state.setLongParameter("stats.download.added.time", add_time);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    row.getTableCell(DateAddedItem.COLUMN_ID).invalidate();
                }
            }
        });
    }

    public DateAddedItem(String tableID, boolean v) {
        this(tableID);
        this.setVisible(v);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        timestamp = dm == null ? 0L : dm.getDownloadState().getLongParameter("stats.download.added.time");
        super.refresh(cell, timestamp);
    }
}

