/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.download.DownloadTypeComplete;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;
import java.io.File;

public class DateCompletedItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = DownloadTypeComplete.class;
    public static final String COLUMN_ID = "DateCompleted";
    private static final long SHOW_ETA_AFTER_MS = 30000L;

    public DateCompletedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setMultiline(false);
        this.addMenu();
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
        info.setProficiency((byte)0);
    }

    public DateCompletedItem(String tableID, boolean v) {
        this(tableID);
        this.setVisible(v);
    }

    private void addMenu() {
        final TableContextMenuItem menuItem = this.addContextMenuItem("MyTorrentsView.menu.datecomp.reset");
        menuItem.setHeaderCategory("Other");
        menuItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object target) {
                boolean enabled = false;
                if (target != null) {
                    Object[] o;
                    Object[] objectArray = o = (Object[])target;
                    int n = o.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DownloadManager dm;
                        Object object = objectArray[n2];
                        if (object instanceof TableRowCore) {
                            object = ((TableRowCore)object).getDataSource(true);
                        }
                        if (object instanceof DownloadManager && (dm = (DownloadManager)object).isDownloadComplete(false)) {
                            enabled = true;
                            break;
                        }
                        ++n2;
                    }
                }
                menuItem.setEnabled(enabled);
            }
        });
        menuItem.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                if (target == null) {
                    return;
                }
                Object[] o = (Object[])target;
                Utils.getOffOfSWTThread(() -> {
                    Object[] objectArray2 = o;
                    int n = o.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DownloadManager dm;
                        TableRowCore row;
                        Object object = objectArray2[n2];
                        if (object instanceof TableRowCore && (object = (row = (TableRowCore)object).getDataSource(true)) instanceof DownloadManager && (dm = (DownloadManager)object).isDownloadComplete(false)) {
                            DiskManagerFileInfo[] files;
                            long last_mod = 0L;
                            DiskManagerFileInfo[] diskManagerFileInfoArray = files = dm.getDiskManagerFileInfoSet().getFiles();
                            int n3 = files.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                long mod;
                                File f;
                                DiskManagerFileInfo file = diskManagerFileInfoArray[n4];
                                if (!file.isSkipped() && (f = file.getFile(true)).length() == file.getLength() && (mod = f.lastModified()) > last_mod) {
                                    last_mod = mod;
                                }
                                ++n4;
                            }
                            if (last_mod > 0L) {
                                DownloadManagerState dms = dm.getDownloadState();
                                dms.setLongParameter("stats.download.file.completed.time", last_mod);
                                dms.setLongParameter("stats.download.completed.time", last_mod);
                                dms.setLongAttribute("complt", last_mod);
                                row.invalidate(true);
                                row.refresh(true);
                            }
                        }
                        ++n2;
                    }
                });
            }
        });
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = 0L;
        if (dm == null) {
            return;
        }
        if (dm.isDownloadComplete(false)) {
            long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            value = completedTime <= 0L ? dm.getDownloadState().getLongParameter("stats.download.added.time") : completedTime;
        } else {
            long diff = SystemTime.getCurrentTime() - dm.getStats().getTimeStarted();
            if (diff > 30000L) {
                long eta = dm.getStats().getSmoothedETA();
                if (eta > 0L) {
                    String sETA = TimeFormatter.format(eta);
                    value = eta << 42;
                    if (value < 0L) {
                        value = Long.MAX_VALUE;
                    }
                    cell.setText(MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{sETA}));
                } else {
                    cell.setText("");
                    value = SystemTime.getCurrentTime() / 1000L * 1001L;
                }
            } else {
                cell.setText("");
                value = SystemTime.getCurrentTime() / 1000L * 1002L;
            }
            cell.invalidate();
            cell.setSortValue(value);
            return;
        }
        super.refresh(cell, value);
    }

    @Override
    public void cellHover(TableCell cell) {
        long dateAdded;
        super.cellHover(cell);
        Object oTooltip = cell.getToolTip();
        String s = oTooltip instanceof String ? String.valueOf((String)oTooltip) + "\n" : "";
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = dateAdded = dm == null ? 0L : dm.getDownloadState().getLongParameter("stats.download.added.time");
        if (dateAdded != 0L) {
            s = String.valueOf(s) + MessageText.getString("TableColumn.header.date_added") + ": " + DisplayFormatters.formatDate(dateAdded) + " (" + DisplayFormatters.formatETA((SystemTime.getCurrentTime() - dateAdded) / 1000L, false) + ")";
            cell.setToolTip(s);
        }
    }
}

