/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.startstoprules.defaultplugin.DefaultRankCalculator;
import com.biglybt.plugin.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DownSpeedItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
ParameterListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "downspeed";
    private static final String CFG_SHOW_ICON = "DownSpeedColumn.showIcon";
    private static Image disabled_img;
    private boolean showIcon;

    static {
        ImageLoader imageLoader = ImageLoader.getInstance();
        disabled_img = imageLoader.getImage("Blocked_x");
    }

    public DownSpeedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 60, sTableID);
        this.setType(1);
        this.addDataSourceType(com.biglybt.core.disk.DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
        this.setUseCoreDataSource(false);
        this.showIcon = COConfigurationManager.getBooleanParameter(CFG_SHOW_ICON);
        COConfigurationManager.addWeakParameterListener(this, false, CFG_SHOW_ICON);
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("pairing.ui.icon.show", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(DownSpeedItem.this.showIcon);
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(DownSpeedItem.CFG_SHOW_ICON, (Boolean)menu.getData());
            }
        });
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.setShowIcon(COConfigurationManager.getBooleanParameter(CFG_SHOW_ICON));
    }

    private void setShowIcon(boolean b) {
        this.showIcon = b;
        this.invalidateCells();
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter(CFG_SHOW_ICON);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "bytes"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.addRefreshListener(new RefreshListener());
    }

    private class RefreshListener
    implements TableCellRefreshListener {
        private int iLastState;
        private int loop = 0;

        private RefreshListener() {
        }

        @Override
        public void refresh(TableCell cell) {
            Object ds = cell.getDataSource();
            if (ds instanceof DiskManagerFileInfo) {
                try {
                    com.biglybt.core.disk.DiskManagerFileInfo fileInfo2 = PluginCoreUtils.unwrap((DiskManagerFileInfo)ds);
                    int speed = fileInfo2.getWriteBytesPerSecond();
                    if (!cell.setSortValue(speed) && cell.isValid()) {
                        return;
                    }
                    cell.setText(speed == 0 ? "" : DisplayFormatters.formatByteCountToKiBEtcPerSec(speed));
                }
                catch (Throwable fileInfo2) {}
            } else {
                long value;
                int iState;
                Download dm = (Download)ds;
                if (dm == null) {
                    iState = -1;
                    value = 0L;
                } else {
                    iState = dm.getState();
                    value = dm.getStats().getDownloadAverage();
                }
                boolean bChangeColor = ++this.loop % 10 == 0;
                String tt = null;
                if (cell instanceof TableCellSWT && dm != null) {
                    TableCellSWT swtCell = (TableCellSWT)cell;
                    Image icon = null;
                    if (dm.getDownloadRateLimitBytesPerSecond() == -1) {
                        value = -1L;
                        tt = MessageText.getString("label.disabled");
                        if (DownSpeedItem.this.showIcon) {
                            icon = disabled_img;
                        }
                    }
                    swtCell.setIcon(icon);
                }
                cell.setToolTip(tt);
                if (cell.setSortValue(value) || !cell.isValid() || iState != this.iLastState) {
                    cell.setText(value <= 0L ? (DownSpeedItem.this.showIcon ? " " : "") : DisplayFormatters.formatByteCountToKiBEtcPerSec(value));
                    bChangeColor = true;
                }
                if (bChangeColor && dm != null) {
                    this.changeColor(cell, dm, iState);
                    this.loop = 0;
                }
            }
        }

        private void changeColor(TableCell cell, Download dl, int iState) {
            try {
                DefaultRankCalculator calc = StartStopRulesDefaultPlugin.getRankCalculator(dl);
                Color newFG = null;
                if (calc != null && dl.getState() == 4 && !calc.getActivelyDownloading()) {
                    newFG = Colors.colorWarning;
                }
                cell.setForeground(Utils.colorToIntArray(newFG));
                this.iLastState = iState;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

