/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class FilePrioritiesItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "file.priorities";

    public FilePrioritiesItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-2);
        this.setPosition(-1);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        String text = "";
        long sortVal = 0L;
        Object ds = cell.getDataSource();
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)ds;
            DownloadManagerStats stats2 = dm.getStats();
            int[] vals = stats2.getFilePriorityStats();
            CellComparator sorter = new CellComparator(vals);
            Comparable old = cell.getSortValue();
            if (old instanceof CellComparator && sorter.compareTo((CellComparator)old) == 0 && cell.isValid()) {
                return;
            }
            cell.setSortValue(sorter);
            text = (vals[0] == Integer.MIN_VALUE ? "-" : Integer.valueOf(vals[0])) + "/" + (vals[1] == Integer.MIN_VALUE ? "-" : Integer.valueOf(vals[1])) + " (" + vals[2] + "/" + vals[3] + ")";
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            sortVal = fileInfo2.getPriority();
            if (!cell.setSortValue(sortVal) && cell.isValid()) {
                return;
            }
            text = String.valueOf(sortVal);
        } else {
            return;
        }
        cell.setText(text);
    }

    class CellComparator
    implements Comparable<CellComparator> {
        int[] vals;

        CellComparator(int[] _vals) {
            this.vals = _vals;
        }

        @Override
        public int compareTo(CellComparator o) {
            int i = 0;
            while (i < this.vals.length) {
                int res = Integer.compare(this.vals[i], o.vals[i]);
                if (res != 0) {
                    return res;
                }
                ++i;
            }
            return 0;
        }
    }
}

