/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tracker.host.TRHost;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class HealthItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    static final int COLUMN_WIDTH = 16;
    public static final String COLUMN_ID = "health";
    static TRHost tracker_host = null;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
    }

    public HealthItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 16, sTableID);
        this.initializeAsGraphic(-2, 16);
        this.setIconReference("column.image.health", true);
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(2);
        cell.setMarginHeight(2);
    }

    @Override
    public void refresh(TableCell cell) {
        String sToolTip;
        TRHostTorrent ht;
        int health;
        DownloadManager dm;
        if (tracker_host == null) {
            try {
                tracker_host = CoreFactory.getSingleton().getTrackerHost();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (tracker_host == null) {
                return;
            }
        }
        if ((dm = (DownloadManager)cell.getDataSource()) == null) {
            health = 0;
            ht = null;
        } else {
            health = dm.getHealthStatus();
            ht = tracker_host.getHostTorrent(dm.getTorrent());
        }
        if (!cell.setSortValue(health + (ht == null ? 0 : 256)) && cell.isValid()) {
            return;
        }
        String sHelpID = null;
        if (health == 5) {
            sHelpID = "health.explain.red";
        } else if (health == 4) {
            sHelpID = "health.explain.green";
        } else if (health == 2) {
            sHelpID = "health.explain.blue";
        } else if (health == 3) {
            sHelpID = "health.explain.yellow";
        } else if (health != 6) {
            sHelpID = "health.explain.grey";
        }
        String string = sToolTip = health == 6 && dm != null ? dm.getErrorDetails() : MessageText.getString(sHelpID);
        if (ht != null) {
            sToolTip = String.valueOf(sToolTip) + "\n" + MessageText.getString("health.explain.share");
        }
        cell.setToolTip(sToolTip);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Comparable sortValue = cell.getSortValue();
        if (!(sortValue instanceof Long)) {
            return;
        }
        boolean isShare = false;
        long health = (Long)sortValue;
        if (health >= 256L) {
            health -= 256L;
            isShare = true;
        }
        String color = null;
        if (health == 5L) {
            color = "#f00";
        } else if (health == 4L) {
            color = "#0f0";
        } else if (health == 2L) {
            color = "#0ff";
        } else if (health == 3L) {
            color = "#00f";
        } else if (health == 6L) {
            color = "#800";
        } else {
            return;
        }
        Color swtColor = ColorCache.getColor(gc.getDevice(), color);
        if (swtColor != null) {
            Rectangle bounds = cell.getBounds();
            int x = bounds.x;
            int y = bounds.y;
            int width = bounds.width;
            int height = bounds.height;
            gc.setAdvanced(true);
            gc.setAntialias(1);
            if (isShare) {
                gc.setForeground(Colors.getInstance().getSlightlyFadedColor(swtColor));
                if (width < height) {
                    int pad = (height - width) / 2;
                    gc.fillGradientRectangle(x, y + pad, width, width, true);
                } else {
                    gc.fillGradientRectangle(x, y, width, height, true);
                }
            } else {
                gc.setBackground(Colors.getInstance().getSlightlyFadedColor(swtColor));
                if (width < height) {
                    int pad = (height - width) / 2;
                    gc.fillOval(x, y + pad, width, width);
                } else {
                    gc.fillRoundRectangle(x, y, width, height, height, height);
                }
            }
        }
    }
}

