/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class MaskedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "masked";
    private static boolean globalMask;

    static {
        COConfigurationManager.addAndFireParameterListener("peercontrol.hide.piece", n -> {
            globalMask = COConfigurationManager.getBooleanParameter(n);
        });
    }

    public MaskedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 80, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        String text = "";
        if (ds instanceof DownloadManager) {
            boolean masked;
            DownloadManager dm = (DownloadManager)ds;
            Boolean dmMasked = dm.getDownloadState().getOptionalBooleanAttribute("mdlc");
            boolean bl = masked = dmMasked == null ? globalMask : dmMasked;
            if (masked) {
                text = MessageText.getString("GeneralView.yes");
                PEPeerManager pm = dm.getPeerManager();
                if (pm != null) {
                    text = String.valueOf(text) + " (" + pm.getHiddenPiece() + ")";
                }
            }
        }
        cell.setText(text);
    }
}

