/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import java.util.ArrayList;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class NetworksIconsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "networks.icons";
    private static Image[] images;

    static {
        ImageLoader imageLoader = ImageLoader.getInstance();
        String[] networks = AENetworkClassifier.AT_NETWORKS;
        images = new Image[networks.length];
        int i = 0;
        while (i < networks.length) {
            NetworksIconsItem.images[i] = imageLoader.getImage("net_" + networks[i] + "_b");
            ++i;
        }
    }

    public NetworksIconsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"tracker", "swarm"});
        info.setProficiency((byte)2);
    }

    @Override
    public void refresh(TableCell cell) {
        long sort = 0L;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            String[] order;
            String[] nets = dm.getDownloadState().getNetworks();
            if (nets.length == (order = AENetworkClassifier.AT_NETWORKS).length) {
                sort = Long.MAX_VALUE;
            } else {
                int i = 0;
                while (i < order.length) {
                    int j = 0;
                    while (j < nets.length) {
                        if (order[i] == nets[j]) {
                            sort = (sort << 4) + (long)i + 1L;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        cell.setSortValue(sort);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            String[] nets = dm.getDownloadState().getNetworks();
            Rectangle bounds = cell.getBounds();
            String[] order = AENetworkClassifier.AT_NETWORKS;
            ArrayList<Image> list = new ArrayList<Image>();
            int pad = -10;
            int total_width = -pad;
            int i = 0;
            while (i < order.length) {
                String[] stringArray = nets;
                int n = nets.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (str == order[i]) {
                        Image img = images[i];
                        list.add(img);
                        total_width += img.getBounds().width + pad;
                    }
                    ++n2;
                }
                ++i;
            }
            TableColumn tableColumn = cell.getTableColumn();
            if (tableColumn != null && tableColumn.getPreferredWidth() < total_width) {
                tableColumn.setPreferredWidth(total_width);
            }
            int x = bounds.x;
            if (bounds.width > total_width) {
                x += (bounds.width - total_width) / 2;
            }
            for (Image img : list) {
                gc.drawImage(img, x, bounds.y);
                x += img.getBounds().width + pad;
            }
        }
    }
}

