/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.swt.graphics.Image;

public class RankItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class<Download> DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "#";
    private final ParameterListener paramShowIconKeyListener;
    private String showIconKey;
    private boolean showIcon;
    private Image imgUp;
    private Image imgDown;
    private GMListener gmListener;
    private boolean bInvalidByTrigger = false;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public RankItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 50, sTableID);
        this.setRefreshInterval(-3);
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                Utils.getOffOfSWTThread(() -> {
                    RankItem.this.gmListener = new GMListener();
                    core.getGlobalManager().addListener(RankItem.this.gmListener);
                });
            }
        });
        this.showIconKey = "RankColumn.showUpDownIcon." + (sTableID.endsWith(".big") ? "big" : "small");
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showRankIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(RankItem.this.showIcon);
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            @Override
            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(RankItem.this.showIconKey, (Boolean)menu.getData());
            }
        });
        this.paramShowIconKeyListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                RankItem.this.showIcon = COConfigurationManager.getBooleanParameter(RankItem.this.showIconKey);
                RankItem.this.invalidateCells();
            }
        };
        COConfigurationManager.addWeakParameterListener(this.paramShowIconKeyListener, true, this.showIconKey);
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgUp = imageLoader.getImage("image.torrentspeed.up");
        this.imgDown = imageLoader.getImage("image.torrentspeed.down");
        TableContextMenuItem sep = this.addContextMenuItem("menu.set.order.sep", 1);
        sep.setStyle(4);
        final TableContextMenuItem menuSetFromSort = this.addContextMenuItem("menu.set.order.from.sort", 1);
        menuSetFromSort.setStyle(1);
        menuSetFromSort.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                TableRowCore[] selRows;
                TableView<?> tv = menuSetFromSort.getTable();
                if (tv != null && (selRows = tv.getSelectedRows()).length > 1) {
                    menuSetFromSort.setText(MessageText.getString("menu.set.order.for.selection"));
                    return;
                }
                menuSetFromSort.setText(MessageText.getString("menu.set.order.from.sort"));
            }
        });
        menuSetFromSort.addListener((menu, target) -> {
            TableView<?> tv = menuSetFromSort.getTable();
            if (tv != null) {
                TableRowCore[] selRows = tv.getSelectedRows();
                TableRowCore[] rows = selRows.length > 1 ? selRows : tv.getRows();
                int incomp_pos = 1;
                int comp_pos = 1;
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                ArrayList<DownloadManager> managers = new ArrayList<DownloadManager>(rows.length);
                ArrayList<Integer> positions = new ArrayList<Integer>(rows.length);
                TableRowCore[] tableRowCoreArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore row = tableRowCoreArray[n2];
                    DownloadManager dm = (DownloadManager)row.getDataSource(true);
                    managers.add(dm);
                    positions.add(dm.isDownloadComplete(false) ? comp_pos++ : incomp_pos++);
                    ++n2;
                }
                gm.moveTo(managers, positions);
                this.invalidateCells();
            }
        });
        TableContextMenuItem menuSortToClipboard = this.addContextMenuItem("menu.copy.order.to.clip", 1);
        menuSortToClipboard.setStyle(1);
        menuSortToClipboard.addListener((menu, target) -> {
            TableView<?> tv = menuSortToClipboard.getTable();
            if (tv != null) {
                TableRowCore[] rows = tv.getRows();
                StringBuffer str = new StringBuffer(2048);
                TableRowCore[] tableRowCoreArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRowCore row = tableRowCoreArray[n2];
                    DownloadManager dm = (DownloadManager)row.getDataSource(true);
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent != null) {
                        try {
                            byte[] hash = torrent.getHash();
                            str.append(dm.getPosition());
                            str.append(",");
                            str.append(ByteFormatter.encodeString(hash));
                            str.append(",");
                            str.append(dm.isDownloadComplete(false) ? 1 : 0);
                            str.append(",\"");
                            str.append(dm.getDisplayName());
                            str.append("\"\n");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                ClipboardCopy.copyToClipBoard(str.toString());
            }
        });
        final TableContextMenuItem menuClipboardToSort = this.addContextMenuItem("menu.set.sort.from.clip", 1);
        menuClipboardToSort.setStyle(1);
        menuClipboardToSort.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(MenuItem menu, Object data) {
                TableView<?> tv = menuClipboardToSort.getTable();
                boolean ok = false;
                if (tv != null) {
                    ok = RankItem.this.clipboardToSort(tv, true);
                }
                menuClipboardToSort.setEnabled(ok);
            }
        });
        menuClipboardToSort.addListener((menu, target) -> {
            TableView<?> tv = menuClipboardToSort.getTable();
            if (tv != null) {
                this.clipboardToSort(tv, false);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean clipboardToSort(TableView<?> tv, boolean test) {
        String[] lines = ClipboardCopy.copyFromClipboard().split("\n");
        if (lines.length == 0) {
            return false;
        }
        GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
        int max_incomp = 0;
        int max_comp = 0;
        for (DownloadManager dm : gm.getDownloadManagers()) {
            if (dm.isDownloadComplete(false)) {
                max_comp = Math.max(dm.getPosition(), max_comp);
                continue;
            }
            max_incomp = Math.max(dm.getPosition(), max_incomp);
        }
        ArrayList<DownloadManager> managers = new ArrayList<DownloadManager>(lines.length);
        ArrayList<Integer> positions = new ArrayList<Integer>(lines.length);
        HashSet<Integer> dup_pos_check = new HashSet<Integer>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(line = line.trim()).isEmpty()) {
                String[] bits = line.split(",");
                if (bits.length < 3) {
                    return false;
                }
                try {
                    boolean comp2;
                    int pos = Integer.parseInt(bits[0].trim());
                    if (pos <= 0) {
                        return false;
                    }
                    byte[] hash = ByteFormatter.decodeString(bits[1].trim());
                    DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash));
                    if (dm == null) {
                        return false;
                    }
                    boolean comp_expected = bits[2].trim().equals("1");
                    if (comp_expected != (comp2 = dm.isDownloadComplete(false))) {
                        return false;
                    }
                    if (comp2) {
                        if (pos > max_comp || dup_pos_check.contains(pos)) {
                            return false;
                        }
                        dup_pos_check.add(pos);
                    } else {
                        if (pos > max_incomp || dup_pos_check.contains(-pos)) {
                            return false;
                        }
                        dup_pos_check.add(-pos);
                    }
                    managers.add(dm);
                    positions.add(pos);
                }
                catch (Throwable e) {
                    return false;
                }
            }
            ++n2;
        }
        if (!test) {
            gm.moveTo(managers, positions);
            this.invalidateCells();
        }
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter(this.showIconKey);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.gmListener != null) {
            try {
                CoreFactory.getSingleton().getGlobalManager().removeListener(this.gmListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.gmListener = null;
        }
        COConfigurationManager.removeWeakParameterListener(this.paramShowIconKeyListener, this.showIconKey);
    }

    @Override
    public void refresh(TableCell cell) {
        Class dst;
        boolean complete;
        this.bInvalidByTrigger = false;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long value = dm == null ? 0 : dm.getPosition();
        String text = "" + value;
        boolean bl = complete = dm == null ? false : dm.getAssumedComplete();
        if (complete) {
            value += 0x1000000L;
        }
        cell.setSortValue(value);
        cell.setText(text);
        TableView<?> table = cell.getTableRow().getView();
        if (table != null && (dst = table.getDataSourceType()) == Download.class) {
            cell.setToolTip(String.valueOf(text) + ", " + MessageText.getString(complete ? "label.complete" : "label.incomplete"));
        }
        if (cell instanceof TableCellSWT) {
            if (this.showIcon && dm != null) {
                Image img = dm.getAssumedComplete() ? this.imgUp : this.imgDown;
                ((TableCellSWT)cell).setIcon(img);
            } else {
                ((TableCellSWT)cell).setIcon(null);
            }
        }
    }

    private class GMListener
    implements GlobalManagerListener {
        DownloadManagerListener listener = new DownloadManagerListener(){

            @Override
            public void completionChanged(DownloadManager manager, boolean bCompleted) {
            }

            @Override
            public void downloadComplete(DownloadManager manager) {
            }

            @Override
            public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                if (RankItem.this.bInvalidByTrigger) {
                    return;
                }
                RankItem.this.invalidateCells();
                RankItem.this.bInvalidByTrigger = true;
            }

            @Override
            public void stateChanged(DownloadManager manager, int state) {
            }

            @Override
            public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
            }
        };

        @Override
        public void destroyed() {
        }

        @Override
        public void destroyInitiated() {
            try {
                GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                gm.removeListener(this);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }

        @Override
        public void downloadManagerAdded(DownloadManager dm) {
            dm.addListener(this.listener);
        }

        @Override
        public void downloadManagerRemoved(DownloadManager dm) {
            dm.removeListener(this.listener);
        }

        @Override
        public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
        }
    }
}

