/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableRowSWT;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;

public class StatusItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "status";
    private static final Object CLICK_KEY = new Object();
    private static Map<String, Integer> sort_orders = new HashMap<String, Integer>();
    private static boolean overall_change_fg;
    private static TableViewSWT.ColorRequester color_requester;
    private static final int[] BLUE;
    private boolean changeRowFG;
    private boolean changeCellFG = true;
    private boolean showTrackerErrors;

    static {
        color_requester = () -> 20;
        String[] stringArray = TableManager.TABLE_MYTORRENTS_ALL;
        int n = TableManager.TABLE_MYTORRENTS_ALL.length;
        int n2 = 0;
        while (n2 < n) {
            final String tid = stringArray[n2];
            COConfigurationManager.addAndFireParameterListener("MyTorrents.status.sortorder." + tid, new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    sort_orders.put(tid, COConfigurationManager.getIntParameter(parameterName));
                }
            });
            ++n2;
        }
        COConfigurationManager.addAndFireParameterListener("MyTorrents.status.sortorder.other", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                sort_orders.put("other", COConfigurationManager.getIntParameter(parameterName));
            }
        });
        COConfigurationManager.addAndFireParameterListener("MyTorrents.status.change.fg", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                overall_change_fg = COConfigurationManager.getBooleanParameter(parameterName);
            }
        });
        BLUE = Utils.colorToIntArray(Colors.blue);
    }

    public StatusItem(String sTableID, boolean changeRowFG) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 80, sTableID);
        this.changeRowFG = changeRowFG;
        this.setRefreshInterval(-2);
    }

    public StatusItem(String sTableID) {
        this(sTableID, true);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        boolean update;
        long sort_value;
        String text;
        int state;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return;
        }
        Integer sort_order = sort_orders.get(this.getTableID());
        if (sort_order == null) {
            sort_order = sort_orders.get("other");
        }
        String tooltip = (state = dm.getState()) == 75 && Utils.getUserMode() == 0 ? MessageText.getString("ManagerItem.queued.tooltip") : null;
        if (state != 70 && state != 100 && dm.isDownloadComplete(false)) {
            Download.SeedingRank sr = dm.getSeedingRank();
            String[] status = sr.getStatus(true);
            String string = tooltip = tooltip == null ? status[0] : String.valueOf(tooltip) + "\n\n" + status[0];
            if (status[1] != null) {
                tooltip = String.valueOf(tooltip) + "\n\n" + status[1];
            }
        }
        if (this.showTrackerErrors && dm.isUnauthorisedOnTracker() && state != 100) {
            text = dm.getTrackerStatus();
            sort_value = 1100L;
        } else {
            boolean forced;
            text = DisplayFormatters.formatDownloadStatus(dm);
            boolean bl = forced = dm.isForceStart() && (state == 50 || state == 60);
            if (sort_order == 1) {
                if (forced) {
                    sort_value = 1000L;
                } else {
                    switch (state) {
                        case 60: {
                            sort_value = 900L;
                            break;
                        }
                        case 50: {
                            sort_value = 800L;
                            break;
                        }
                        case 75: {
                            if (dm.getSubState() == 60) {
                                sort_value = 750L;
                                break;
                            }
                            sort_value = 700L;
                            break;
                        }
                        case 70: {
                            if (dm.isPaused()) {
                                sort_value = 600L;
                                break;
                            }
                            sort_value = 500L;
                            break;
                        }
                        default: {
                            sort_value = 0L;
                            break;
                        }
                    }
                }
            } else if (sort_order == 2) {
                boolean super_seeding;
                PEPeerManager pm = dm.getPeerManager();
                boolean bl2 = super_seeding = pm != null && pm.isSuperSeedMode();
                if (forced) {
                    sort_value = 800L;
                } else if (dm.isPaused()) {
                    sort_value = 600L;
                } else if (super_seeding) {
                    sort_value = 825L;
                } else {
                    switch (state) {
                        case 0: {
                            sort_value = 100L;
                            break;
                        }
                        case 5: {
                            sort_value = 100L;
                            break;
                        }
                        case 10: {
                            sort_value = 100L;
                            break;
                        }
                        case 20: {
                            sort_value = 200L;
                            break;
                        }
                        case 30: {
                            sort_value = 900L;
                            break;
                        }
                        case 40: {
                            sort_value = 300L;
                            break;
                        }
                        case 50: {
                            sort_value = 400L;
                            break;
                        }
                        case 55: {
                            sort_value = 400L;
                            break;
                        }
                        case 60: {
                            DiskManager diskManager = dm.getDiskManager();
                            if (diskManager != null && diskManager.getCompleteRecheckStatus() != -1) {
                                sort_value = 900L;
                                break;
                            }
                            sort_value = 850L;
                            break;
                        }
                        case 65: {
                            sort_value = 500L;
                            break;
                        }
                        case 70: {
                            sort_value = 500L;
                            break;
                        }
                        case 75: {
                            if (dm.getSubState() == 60) {
                                sort_value = 810L;
                                break;
                            }
                            sort_value = 700L;
                            break;
                        }
                        case 100: {
                            sort_value = 1000L;
                            break;
                        }
                        default: {
                            sort_value = 999L;
                            break;
                        }
                    }
                }
            } else {
                sort_value = 0L;
            }
        }
        if (tooltip != null) {
            tooltip = String.valueOf(text) + "\n\n" + tooltip;
        }
        if (sort_order == 1) {
            sort_value += (long)state;
            sort_value <<= 32;
            if (dm.isDownloadComplete(false)) {
                Download dl = PluginCoreUtils.wrap(dm);
                if (dl != null) {
                    sort_value += (long)dl.getSeedingRank().getRank();
                }
            } else {
                sort_value -= (long)dm.getPosition();
            }
        }
        if (sort_order == 0) {
            update = cell.setSortValue((Comparable)((Object)text));
        } else {
            update = cell.setSortValue(sort_value);
            if (!update && !cell.getText().equals(text)) {
                update = true;
            }
        }
        if (update || !cell.isValid()) {
            cell.setText(text);
            cell.setToolTip(tooltip);
            boolean clickable = false;
            if (cell instanceof TableCellSWT) {
                int cursor_id;
                if (!text.contains("http://")) {
                    dm.setUserData(CLICK_KEY, null);
                    cursor_id = 0;
                } else {
                    dm.setUserData(CLICK_KEY, text);
                    cursor_id = 21;
                    clickable = true;
                }
                ((TableCellSWT)cell).setCursorID(cursor_id);
            }
            if (!this.changeCellFG && !this.changeRowFG) {
                cell.setForeground((int[])(clickable ? BLUE : null));
                return;
            }
            TableRow row = cell.getTableRow();
            if (row != null) {
                Object color = null;
                color = state == 60 ? (Utils.isDarkAppearanceNativeWindows() ? Colors.bluesFixed[7] : Colors.blues[7]) : (state == 100 ? Colors.colorError : null);
                if (this.changeRowFG) {
                    if (row instanceof TableRowSWT) {
                        ((TableRowSWT)row).requestForegroundColor(color_requester, (Color)(overall_change_fg ? color : null));
                    }
                } else if (this.changeCellFG) {
                    cell.setForeground(Utils.colorToIntArray(color));
                }
                if (clickable) {
                    cell.setForeground(Utils.colorToIntArray(Colors.blue));
                }
            }
        } else {
            String old_tt = (String)cell.getToolTip();
            if (!(old_tt == tooltip || old_tt != null && tooltip != null && old_tt.equals(tooltip))) {
                cell.setToolTip(tooltip);
            }
        }
    }

    public boolean isChangeRowFG() {
        return this.changeRowFG;
    }

    public void setChangeRowFG(boolean changeRowFG) {
        this.changeRowFG = changeRowFG;
    }

    public boolean isChangeCellFG() {
        return this.changeCellFG;
    }

    public void setChangeCellFG(boolean changeCellFG) {
        this.changeCellFG = changeCellFG;
    }

    public void setShowTrackerErrors(boolean s) {
        this.showTrackerErrors = s;
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String url;
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        String clickable = (String)dm.getUserData(CLICK_KEY);
        if (clickable == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType == 1 && (url = UrlUtils.getURL(clickable)) != null) {
            Utils.launch(url);
        }
    }
}

