/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TagIconsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener {
    private static Object KEY_TAG_MUT = new Object();
    private static Object KEY_IMAGE_FILES = new Object();
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "tag_icons";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public TagIconsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        String sTags = null;
        DownloadManager core_dm = (DownloadManager)cell.getDataSource();
        if (core_dm != null) {
            long mut = core_dm.getTagMutationCount();
            Long data = (Long)cell.getData(KEY_TAG_MUT);
            if (data != null && data == mut) {
                return;
            }
            cell.setData(KEY_TAG_MUT, mut);
            List<Tag> tags = tag_manager.getTagsForTaggable(new int[]{3, 2}, (Taggable)core_dm);
            if (tags.size() > 0) {
                for (Tag t : tags) {
                    String file = t.getImageFile();
                    if (file == null) continue;
                    String str = t.getTagName(true);
                    sTags = sTags == null ? str : String.valueOf(sTags) + ", " + str;
                }
            }
        }
        cell.setSortValue((Comparable)((Object)sTags));
        cell.setToolTip(sTags == null ? "" : sTags);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        String[] files;
        DownloadManager core_dm = (DownloadManager)cell.getDataSource();
        if (core_dm != null) {
            long mut = core_dm.getTagMutationCount();
            Object[] data = (Object[])cell.getData(KEY_IMAGE_FILES);
            if (data == null || (Long)data[0] != mut) {
                List<Tag> tags = tag_manager.getTagsForTaggable(new int[]{3, 2}, (Taggable)core_dm);
                tags = TagUtils.sortTagIcons(tags);
                ArrayList<String> f = new ArrayList<String>(tags.size());
                for (Tag tag : tags) {
                    String file = tag.getImageFile();
                    if (file == null) continue;
                    f.add(file);
                }
                files = f.toArray(new String[f.size()]);
                cell.setData(KEY_IMAGE_FILES, new Object[]{mut, files});
            } else {
                files = (String[])data[1];
            }
        } else {
            files = new String[]{};
        }
        int num_files = files.length;
        if (num_files > 0) {
            Rectangle bounds = cell.getBounds();
            ++bounds.x;
            ++bounds.y;
            --bounds.width;
            bounds.height -= 2;
            int w = bounds.width / num_files;
            final ArrayList images = new ArrayList();
            final ArrayList keys = new ArrayList();
            String[] stringArray = files;
            int file = files.length;
            int n = 0;
            while (n < file) {
                String file2 = stringArray[n];
                try {
                    ImageLoader.getInstance().getFileImage(new File(file2), new Point(w - 1, bounds.height), new ImageLoader.ImageDownloaderListener(){

                        @Override
                        public void imageDownloaded(Image image, String key, boolean returnedImmediately) {
                            if (image != null && returnedImmediately) {
                                images.add(image);
                                keys.add(key);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++n;
            }
            if (images.size() > 0) {
                int width_per_image = bounds.width / images.size();
                int i = 0;
                while (i < images.size()) {
                    Image image = (Image)images.get(i);
                    int iw = image.getBounds().width;
                    gc.drawImage(image, bounds.x + (width_per_image - iw) / 2, bounds.y);
                    bounds.x += width_per_image;
                    ImageLoader.getInstance().releaseImage((String)keys.get(i));
                    ++i;
                }
            }
        }
    }
}

