/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytorrents;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.tableitems.mytorrents.TrackerCellUtils;
import java.util.IdentityHashMap;
import java.util.Map;

public class TrackerNextAccessItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellDisposeListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "trackernextaccess";
    Map<DownloadManager, Long> map = new IdentityHashMap<DownloadManager, Long>();

    public TrackerNextAccessItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"tracker", "time"});
        info.setProficiency((byte)1);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (cell.isValid() && this.map.containsKey(dm)) {
            long lNextUpdate = this.map.get(dm);
            if (SystemTime.getMonotonousTime() < lNextUpdate) {
                return;
            }
        }
        if ((value = (long)(dm == null ? 0 : dm.getTrackerTime())) < -1L) {
            value = -1L;
        }
        long skip_secs = value > 60L ? value % 60L : 1L;
        long lNextUpdate = SystemTime.getMonotonousTime() + skip_secs * 1000L;
        this.map.put(dm, new Long(lNextUpdate));
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        String sText = TimeFormatter.formatColon(value);
        if (value > 60L) {
            sText = "< " + sText;
        }
        TrackerCellUtils.updateColor(cell, dm, false);
        cell.setText(sText);
    }

    @Override
    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        cell.setToolTip(TrackerCellUtils.getTooltipText(cell, dm, false));
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    @Override
    public void dispose(TableCell cell) {
        this.map.remove(cell.getDataSource());
    }
}

