/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytracker;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.category.Category;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class CategoryItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    protected static GlobalManager gm;

    public CategoryItem() {
        super("category", -1, 400, "MyTracker");
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        TRHostTorrent tr_torrent = (TRHostTorrent)cell.getDataSource();
        if (tr_torrent == null) {
            cell.setText("");
        } else {
            TOTorrent torrent = tr_torrent.getTorrent();
            if (gm == null) {
                if (!CoreFactory.isCoreRunning()) {
                    return;
                }
                gm = CoreFactory.getSingleton().getGlobalManager();
            }
            DownloadManager dm = gm.getDownloadManager(torrent);
            String cat_str = null;
            if (dm != null) {
                Category cat = dm.getDownloadState().getCategory();
                if (cat != null) {
                    cat_str = cat.getName();
                }
            } else {
                cat_str = TorrentUtils.getPluginStringProperty(torrent, "azcoreplugins.category");
            }
            cell.setText(cat_str == null ? "" : cat_str);
        }
    }
}

