/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.mytracker;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateCellText;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import org.eclipse.swt.graphics.Image;

public class NameItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
ObfuscateCellText {
    private static GlobalManager gm;
    private static boolean bShowIcon;
    private ParameterListener configShowProgramIconListener = new ParameterListenerConfigShowProgramIcon();

    public NameItem() {
        super("name", -2, 250, "MyTracker");
        this.setType(1);
        this.setRefreshInterval(-2);
        COConfigurationManager.addWeakParameterListener(this.configShowProgramIconListener, true, "NameColumn.showProgramIcon");
    }

    @Override
    public void remove() {
        super.remove();
        COConfigurationManager.removeWeakParameterListener(this.configShowProgramIconListener, "NameColumn.showProgramIcon");
    }

    @Override
    public void refresh(TableCell cell) {
        TRHostTorrent item = (TRHostTorrent)cell.getDataSource();
        final TOTorrent torrent = item == null ? null : item.getTorrent();
        String name = null;
        if (item == null) {
            name = "";
        } else {
            DownloadManager dm;
            if (gm == null && CoreFactory.isCoreRunning()) {
                gm = CoreFactory.getSingleton().getGlobalManager();
            }
            if (gm != null && (dm = gm.getDownloadManager(torrent)) != null) {
                name = dm.getDisplayName();
            }
            if (name == null) {
                name = TorrentUtils.getLocalisedName(torrent);
            }
        }
        if ((cell.setText(name) || !cell.isValid()) && item != null && torrent != null && bShowIcon && cell instanceof TableCellSWT) {
            try {
                final String path = torrent.getFiles()[0].getRelativePath();
                if (path != null) {
                    Image icon = null;
                    final TableCellSWT _cell = (TableCellSWT)cell;
                    if (Utils.isSWTThread()) {
                        icon = ImageRepository.getPathIcon(path, false, !torrent.isSimpleTorrent());
                    } else {
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                Image icon = ImageRepository.getPathIcon(path, false, !torrent.isSimpleTorrent());
                                _cell.setIcon(icon);
                                _cell.redraw();
                            }
                        });
                    }
                    if (icon != null) {
                        _cell.setIcon(icon);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        TRHostTorrent item = (TRHostTorrent)cell.getDataSource();
        String name = null;
        try {
            name = ByteFormatter.nicePrint(item.getTorrent().getHash(), true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    private static class ParameterListenerConfigShowProgramIcon
    implements ParameterListener {
        private ParameterListenerConfigShowProgramIcon() {
        }

        @Override
        public void parameterChanged(String parameterName) {
            bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
        }
    }
}

