/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class HostNameItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "host";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"identification"});
    }

    public HostNameItem(String table_id) {
        super(COLUMN_ID, -1, 100, table_id);
        this.setRefreshInterval(-2);
        this.setObfuscation(true);
    }

    @Override
    public void refresh(TableCell cell) {
        String addr;
        PEPeer peer = (PEPeer)cell.getDataSource();
        String string = addr = peer == null ? "" : peer.getIPHostName();
        if (cell.setText(addr) && !addr.equals(peer == null ? "" : peer.getIp())) {
            String[] l = addr.split("\\.");
            StringBuilder buf = new StringBuilder();
            int i = l.length - 1;
            while (i >= 0) {
                buf.append(l[i]);
                buf.append('.');
                --i;
            }
            cell.setSortValue((Comparable)((Object)buf.toString()));
        }
    }
}

