/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class PeerByteIDItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PeerByteIDItem(String table_id) {
        super("peer_byte_id", -1, 100, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"identification"});
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null) {
            cell.setText("");
            return;
        }
        byte[] peer_id = peer.getId();
        if (peer_id == null) {
            cell.setText("");
            return;
        }
        cell.setText(ByteFormatter.nicePrint(peer_id));
    }
}

