/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.pif.ui.Graphic;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellDisposeListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTGraphic;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class PiecesItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener,
DiskManagerListener {
    private static final int INDEX_COLOR_FADEDSTARTS = 10;
    private static final int borderHorizontalSize = 1;
    private static final int borderVerticalSize = 1;
    private static final int borderSplit = 1;
    private static final int completionHeight = 2;
    private int row_count;
    private FrequencyLimitedDispatcher invalidateDispatcher = new FrequencyLimitedDispatcher(AERunnable.create(() -> this.invalidateCells()), 250);

    public PiecesItem(String table_id) {
        super("pieces", table_id);
        this.initializeAsGraphic(-2, 200);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cellAdded(TableCell cell) {
        PEPeer peer;
        DiskManager diskmanager;
        PiecesItem piecesItem = this;
        synchronized (piecesItem) {
            ++this.row_count;
        }
        cell.setFillCell(true);
        Object ds = cell.getDataSource();
        if (ds instanceof PEPeer && (diskmanager = (peer = (PEPeer)ds).getManager().getDiskManager()).getRemaining() > 0L && !diskmanager.hasListener(this)) {
            diskmanager.addListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(TableCell cell) {
        Image img;
        Graphic graphic;
        PiecesItem piecesItem = this;
        synchronized (piecesItem) {
            --this.row_count;
        }
        final ArrayList<Image> to_dispose = new ArrayList<Image>();
        PEPeer infoObj = (PEPeer)cell.getDataSource();
        if (infoObj != null) {
            Image img2 = (Image)infoObj.getData("PiecesImage");
            if (img2 != null) {
                to_dispose.add(img2);
            }
            infoObj.setData("PiecesImageBuffer", null);
            infoObj.setData("PiecesImage", null);
        }
        if ((graphic = cell.getGraphic()) instanceof UISWTGraphic && (img = ((UISWTGraphic)graphic).getImage()) != null && to_dispose.contains(img)) {
            to_dispose.add(img);
        }
        if (to_dispose.size() > 0) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    for (Image img : to_dispose) {
                        if (img.isDisposed()) continue;
                        img.dispose();
                    }
                }
            });
        }
    }

    @Override
    public void refresh(final TableCell cell) {
        final PEPeer peer = (PEPeer)cell.getDataSource();
        long lCompleted = peer == null ? 0 : peer.getPercentDoneInThousandNotation();
        if (!cell.setSortValue(lCompleted) && cell.isValid() && peer.getData("PiecesActive") != null) {
            return;
        }
        if (peer == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                boolean reconnect;
                boolean established;
                GC gcImage;
                Rectangle imageBounds;
                boolean bImageChanged;
                if (cell.isDisposed()) {
                    return;
                }
                int newWidth = cell.getWidth();
                if (newWidth <= 0) {
                    return;
                }
                int newHeight = cell.getHeight();
                int x0 = 1;
                int x1 = newWidth - 1 - 1;
                int y0 = 4;
                int y1 = newHeight - 1 - 1;
                int drawWidth = x1 - x0 + 1;
                if (drawWidth < 10 || y1 < 3) {
                    return;
                }
                int[] imageBuffer = (int[])peer.getData("PiecesImageBuffer");
                boolean bImageBufferValid = imageBuffer != null && imageBuffer.length == drawWidth;
                Image image = (Image)peer.getData("PiecesImage");
                if (image == null || image.isDisposed()) {
                    bImageChanged = true;
                } else {
                    imageBounds = image.getBounds();
                    boolean bl = bImageChanged = imageBounds.width != newWidth || imageBounds.height != newHeight;
                }
                if (bImageChanged) {
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                    image = new Image((Device)Utils.getDisplay(), newWidth, newHeight);
                    imageBounds = image.getBounds();
                    bImageBufferValid = false;
                    gcImage = new GC((Drawable)image);
                    gcImage.setForeground(Colors.grey);
                    gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
                    gcImage.setForeground(Colors.white);
                    gcImage.drawLine(x0, 3, x1, 3);
                } else {
                    gcImage = new GC((Drawable)image);
                }
                BitFlags peerHave = peer.getAvailable();
                if (peer instanceof PEPeerTransport) {
                    PEPeerTransport pt = (PEPeerTransport)peer;
                    established = pt.getConnectionState() == 4;
                    reconnect = pt.isReconnect();
                } else {
                    established = true;
                    reconnect = false;
                }
                if (established && peerHave != null && peerHave.flags.length > 0) {
                    if (imageBuffer == null || imageBuffer.length != drawWidth) {
                        imageBuffer = new int[drawWidth];
                    }
                    peer.setData("PiecesActive", true);
                    boolean[] available = peerHave.flags;
                    try {
                        int limit;
                        int nbComplete = 0;
                        int nbPieces = available.length;
                        DiskManager disk_manager = peer.getManager().getDiskManager();
                        DiskManagerPiece[] pieces = disk_manager == null ? null : disk_manager.getPieces();
                        int a1 = 0;
                        int i = 0;
                        while (i < drawWidth) {
                            int index;
                            int a0;
                            if (i == 0) {
                                a0 = 0;
                                a1 = nbPieces / drawWidth;
                                if (a1 == 0) {
                                    a1 = 1;
                                }
                            } else {
                                a0 = a1;
                                a1 = (i + 1) * nbPieces / drawWidth;
                            }
                            int nbNeeded = 0;
                            if (a1 <= a0) {
                                index = imageBuffer[i - 1];
                            } else {
                                int nbAvailable = 0;
                                int j = a0;
                                while (j < a1) {
                                    if (available[j]) {
                                        if (pieces == null || !pieces[j].isDone()) {
                                            ++nbNeeded;
                                        }
                                        ++nbAvailable;
                                    }
                                    ++j;
                                }
                                nbComplete += nbAvailable;
                                index = nbAvailable * 9 / (a1 - a0);
                                if (nbNeeded <= nbAvailable / 2) {
                                    index += 10;
                                }
                            }
                            if (imageBuffer[i] != index) {
                                imageBuffer[i] = index;
                                if (bImageBufferValid) {
                                    bImageChanged = true;
                                    if (imageBuffer[i] >= 10) {
                                        gcImage.setForeground(Colors.faded[index - 10]);
                                    } else {
                                        gcImage.setForeground(Colors.blues[index]);
                                    }
                                    gcImage.drawLine(i + x0, y0, i + x0, y1);
                                }
                            }
                            ++i;
                        }
                        if (!bImageBufferValid && established) {
                            int iLastIndex = imageBuffer[0];
                            int iWidth = 1;
                            int i2 = 1;
                            while (i2 < drawWidth) {
                                if (iLastIndex == imageBuffer[i2]) {
                                    ++iWidth;
                                } else {
                                    if (iLastIndex >= 10) {
                                        gcImage.setBackground(Colors.faded[iLastIndex - 10]);
                                    } else {
                                        gcImage.setBackground(Colors.blues[iLastIndex]);
                                    }
                                    gcImage.fillRectangle(i2 - iWidth + x0, y0, iWidth, y1 - y0 + 1);
                                    iWidth = 1;
                                    iLastIndex = imageBuffer[i2];
                                }
                                ++i2;
                            }
                            if (iLastIndex >= 10) {
                                gcImage.setBackground(Colors.faded[iLastIndex - 10]);
                            } else {
                                gcImage.setBackground(Colors.blues[iLastIndex]);
                            }
                            gcImage.fillRectangle(x1 - iWidth + 1, y0, iWidth, y1 - y0 + 1);
                            bImageChanged = true;
                        }
                        if ((limit = drawWidth * nbComplete / nbPieces) < drawWidth) {
                            gcImage.setBackground(Colors.blues[0]);
                            gcImage.fillRectangle(limit + x0, 1, x1 - limit, 2);
                        }
                        gcImage.setBackground(Colors.colorProgressBar);
                        gcImage.fillRectangle(x0, 1, limit, 2);
                    }
                    catch (Exception e) {
                        System.out.println("Error Drawing PiecesItem");
                        Debug.printStackTrace(e);
                    }
                } else {
                    Color fill = established ? Colors.fadedGreen : (reconnect ? Colors.fadedBlue : Colors.grey);
                    gcImage.setForeground(fill);
                    gcImage.setBackground(fill);
                    gcImage.fillRectangle(x0, y0, newWidth, y1);
                }
                gcImage.dispose();
                Image oldImage = null;
                Graphic graphic = cell.getGraphic();
                if (graphic instanceof UISWTGraphic) {
                    oldImage = ((UISWTGraphic)graphic).getImage();
                }
                if (bImageChanged || image != oldImage || !cell.isValid()) {
                    if (cell instanceof TableCellSWT) {
                        ((TableCellSWT)cell).setGraphic(image);
                    } else {
                        cell.setGraphic(new UISWTGraphicImpl(image));
                    }
                    if (oldImage != null && image != oldImage && !oldImage.isDisposed()) {
                        oldImage.dispose();
                    }
                    if (bImageChanged || image != oldImage) {
                        cell.invalidate();
                    }
                    peer.setData("PiecesImage", image);
                    peer.setData("PiecesImageBuffer", imageBuffer);
                }
            }
        });
    }

    @Override
    public void filePriorityChanged(DiskManager dm, List<DiskManagerFileInfo> files) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pieceDoneChanged(DiskManager diskmanager, DiskManagerPiece piece) {
        boolean remove_listener;
        PiecesItem piecesItem = this;
        synchronized (piecesItem) {
            remove_listener = this.row_count == 0;
        }
        if (remove_listener) {
            diskmanager.removeListener(this);
        } else {
            this.invalidateDispatcher.dispatch();
            if (diskmanager.getRemaining() == 0L) {
                diskmanager.removeListener(this);
            }
        }
    }

    @Override
    public void stateChanged(DiskManager dm, int oldState, int newState) {
    }
}

