/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class ProtocolItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "Protocol";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
    }

    public ProtocolItem(String table_id) {
        super(COLUMN_ID, 3, -1, 50, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void refresh(TableCell cell) {
        String value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null) {
            value = "";
        } else {
            value = peer.getProtocol();
            String qualifier = peer.getProtocolQualifier();
            if (qualifier != null) {
                value = String.valueOf(value) + " (" + qualifier + ")";
            }
        }
        if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
            return;
        }
        cell.setText(value);
    }
}

