/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.proxy.AEProxyFactory;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class StateItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public StateItem(String table_id) {
        super("state", -2, 65, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol", "connection"});
    }

    @Override
    public void refresh(TableCell cell) {
        boolean reconnect;
        boolean localPeer;
        Object ds = cell.getDataSource();
        int state = -1;
        String extra = null;
        boolean bl = localPeer = ds instanceof PEPeer ? ((PEPeer)ds).isMyPeer() : false;
        if (ds instanceof PEPeerTransport) {
            Transport transport;
            NetworkConnection nc;
            PEPeerTransport peer = (PEPeerTransport)ds;
            state = peer.getConnectionState();
            reconnect = peer.isReconnect();
            if (state == 1 && !peer.isIncoming() && (nc = PluginCoreUtils.unwrap(peer.getPluginConnection())) != null && (transport = nc.getTransport()) != null) {
                if (transport.isSOCKS()) {
                    extra = " (SOCKS)";
                } else {
                    String net;
                    AEProxyFactory.PluginProxy pp = transport.getPluginProxy();
                    if (pp != null && (net = AENetworkClassifier.categoriseAddress(pp.getHost())) != "Public") {
                        extra = " (" + net + ")";
                    }
                }
            }
        } else {
            if (ds != null) {
                state = 4;
            }
            reconnect = false;
        }
        if (!cell.setSortValue(state) && cell.isValid()) {
            return;
        }
        String state_text = "";
        if (!localPeer) {
            switch (state) {
                case 0: {
                    state_text = MessageText.getString("PeersView.state.pending");
                    break;
                }
                case 1: {
                    state_text = MessageText.getString("PeersView.state.connecting");
                    if (extra == null) break;
                    state_text = String.valueOf(state_text) + extra;
                    break;
                }
                case 2: {
                    state_text = MessageText.getString("PeersView.state.handshake");
                    break;
                }
                case 4: {
                    state_text = MessageText.getString("PeersView.state.established");
                }
            }
            if (state != 4 && reconnect) {
                state_text = String.valueOf(state_text) + " *";
            }
        }
        cell.setText(state_text);
    }
}

