/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.peers;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;

public class TimeToSendPieceItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public TimeToSendPieceItem(String table_id) {
        super("timetosend", 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
    }

    @Override
    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        long value = peer == null ? 0 : peer.getUploadHint();
        Comparable sortValue = cell.getSortValue();
        long oldValue = 0L;
        if (sortValue instanceof Number) {
            oldValue = ((Number)((Object)sortValue)).longValue();
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        String text = TimeFormatter.format(value / 1000L);
        if (oldValue > 0L) {
            text = String.valueOf(text) + ", " + TimeFormatter.format(oldValue / 1000L);
        }
        cell.setText(text);
    }
}

