/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.tableitems.pieces;

import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.util.CopyOnWriteSet;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.PiecesViewBase;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import java.util.HashMap;

public class WritersItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public WritersItem(String table_id) {
        super("writers", 1, -1, 80, table_id);
        this.setObfuscation(true);
        this.setRefreshInterval(4);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
    }

    @Override
    public void refresh(TableCell cell) {
        PEPiece piece = (PEPiece)cell.getDataSource();
        if (piece instanceof PiecesViewBase.PEPieceUploading) {
            CopyOnWriteSet<String> peers = ((PiecesViewBase.PEPieceUploading)piece).getUploadPeers();
            StringBuilder sb = new StringBuilder(64);
            for (String peer : peers) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(peer);
            }
            String value = sb.toString();
            if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
                return;
            }
            cell.setText(value);
        } else {
            String[] core_writers = piece.getWriters();
            String[] my_writers = new String[core_writers.length];
            int writer_count = 0;
            HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
            int i = 0;
            while (true) {
                String this_writer = null;
                int start = i;
                while (start < core_writers.length) {
                    this_writer = core_writers[start];
                    if (this_writer != null) break;
                    ++start;
                }
                if (this_writer == null) break;
                int end = start + 1;
                while (end < core_writers.length) {
                    if (!this_writer.equals(core_writers[end])) break;
                    ++end;
                }
                StringBuffer pieces = (StringBuffer)map.get(this_writer);
                if (pieces == null) {
                    pieces = new StringBuffer();
                    map.put(this_writer, pieces);
                    my_writers[writer_count++] = this_writer;
                } else {
                    pieces.append(',');
                }
                pieces.append(start);
                if (end - 1 > start) {
                    pieces.append('-').append(end - 1);
                }
                i = end;
            }
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < writer_count) {
                String writer = my_writers[i2];
                StringBuffer pieces = (StringBuffer)map.get(writer);
                if (i2 > 0) {
                    sb.append(';');
                }
                sb.append(writer).append('[').append(pieces).append(']');
                ++i2;
            }
            String value = sb.toString();
            if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
                return;
            }
            cell.setText(value);
        }
    }
}

