/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views.utils;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagType;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.tracker.host.TRHostException;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.HTTPUtils;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.LaunchManager;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.xml.util.XUXmlWriter;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.UnloadablePlugin;
import com.biglybt.pif.disk.DiskManagerChannel;
import com.biglybt.pif.disk.DiskManagerEvent;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.disk.DiskManagerRequest;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.pif.tracker.web.TrackerWebPageRequest;
import com.biglybt.pif.tracker.web.TrackerWebPageResponse;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.FormattersImpl;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.shells.AdvRenameWindow;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinCheckboxListener;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinObjectCheckbox;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.skin.SWTSkinObjectList;
import com.biglybt.ui.swt.skin.SWTSkinObjectTextbox;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.ui.swt.views.skin.StandardButtonsArea;
import com.biglybt.ui.webplugin.WebPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class ManagerUtils {
    private static RunDownloadManager run;
    private static Map<DownloadManager, WebPlugin> browse_plugins;
    private static AsyncDispatcher alloc_dispatcher;
    private static AsyncDispatcher async;
    private static final int LOCATE_MODE_LINK = 0;
    private static final int LOCATE_MODE_COPY = 1;
    private static final int LOCATE_MODE_MOVE = 2;
    private static final int LOCATE_MODE_PIECE = 3;
    private static final int LOCATE_MODE_RELOCATE = 4;
    private static final int LOCATE_MODE_LINK_BLANK = 0;
    private static final int LOCATE_MODE_LINK_INTERNAL = 1;
    private static final int LOCATE_MODE_LINK_HARD = 2;
    private static List<TextViewerWindow> lf_windows;
    private static List<TextViewerWindow> sp_windows;
    private static final boolean lf_reuse;
    private static final long LOG_TICK_DOT_MIN = 250L;
    private static final long LOG_TICK_DOT_MAX = 2500L;
    private static final Object LOW_RES_RECHECK_KEY;

    static {
        browse_plugins = new IdentityHashMap<DownloadManager, WebPlugin>();
        alloc_dispatcher = new AsyncDispatcher(2000);
        async = new AsyncDispatcher(2000);
        lf_windows = new ArrayList<TextViewerWindow>();
        sp_windows = new ArrayList<TextViewerWindow>();
        lf_reuse = Constants.isWindows10OrHigher;
        LOW_RES_RECHECK_KEY = new Object();
    }

    public static void setRunRunnable(RunDownloadManager run) {
        ManagerUtils.run = run;
    }

    public static void run(final DownloadManager dm) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                @Override
                public void actionAllowed() {
                    PlatformTorrentUtils.setHasBeenOpened(dm, true);
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            if (run != null) {
                                run.run(dm);
                            } else {
                                Utils.launch(dm.getSaveLocation().toString());
                            }
                        }
                    });
                }

                @Override
                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(DownloadManager dm) {
        ManagerUtils.open(dm, false);
    }

    public static void open(final DownloadManager dm, final boolean open_containing_folder_mode) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                @Override
                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            ManagerUtils.open(dm.getSaveLocation(), open_containing_folder_mode);
                        }
                    });
                }

                @Override
                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(final DiskManagerFileInfo file, final boolean open_containing_folder_mode) {
        if (file != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(file);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                @Override
                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            PlatformTorrentUtils.setHasBeenOpened(file.getDownloadManager(), file.getIndex(), true);
                            File this_file = file.getFile(true);
                            File parent_file = open_containing_folder_mode ? this_file.getParentFile() : null;
                            ManagerUtils.open(parent_file == null ? this_file : parent_file);
                        }
                    });
                }

                @Override
                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(File f, boolean open_containing_folder_mode) {
        if (open_containing_folder_mode) {
            Utils.launch(f.getParent());
        } else {
            ManagerUtils.open(f);
        }
    }

    public static void open(File f) {
        while (f != null && !f.exists()) {
            f = f.getParentFile();
        }
        if (f == null) {
            return;
        }
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(f.toString());
                return;
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        if (f.isDirectory()) {
            Utils.launch(f.toString());
        } else {
            String cmd = Utils.getPredefinedExplicitLauncher("<showfile>");
            if (cmd != null) {
                String[] cmd_args = GeneralUtils.splitQuotedTokens(cmd);
                Utils.launchFileExplicit(f.getAbsolutePath(), cmd_args);
            } else {
                Utils.launch(f.getParent().toString());
            }
        }
    }

    private static boolean getBrowseAnon(DownloadManager dm) {
        boolean anon = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserAnon");
        if (!anon) {
            String[] nets;
            boolean found_pub = false;
            String[] stringArray = nets = dm.getDownloadState().getNetworks();
            int n = nets.length;
            int n2 = 0;
            while (n2 < n) {
                String net = stringArray[n2];
                if (net == "Public") {
                    found_pub = true;
                    break;
                }
                ++n2;
            }
            if (nets.length > 0 && !found_pub) {
                anon = true;
            }
        }
        return anon;
    }

    private static DiskManagerFileInfo getBrowseHomePage(DownloadManager dm) {
        try {
            DiskManagerFileInfo[] files;
            DiskManagerFileInfo[] diskManagerFileInfoArray = files = dm.getDiskManagerFileInfoSet().getFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                if (file.getTorrentFile().getPathComponents().length == 1 && ((name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US)).equals("index.html") || name.equals("index.htm"))) {
                    return file;
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return null;
    }

    public static boolean browseWebsite(DiskManagerFileInfo file) {
        try {
            String name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US);
            if (name.equals("index.html") || name.equals("index.htm")) {
                ManagerUtils.browse(file);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    public static boolean browseWebsite(DownloadManager dm) {
        DiskManagerFileInfo file = ManagerUtils.getBrowseHomePage(dm);
        if (file != null) {
            ManagerUtils.browse(file);
            return true;
        }
        return false;
    }

    public static String browse(DiskManagerFileInfo file) {
        boolean anon = ManagerUtils.getBrowseAnon(file.getDownloadManager());
        return ManagerUtils.browse(file, anon, true);
    }

    public static String browse(DiskManagerFileInfo file, boolean anon, boolean launch) {
        return ManagerUtils.browse(file.getDownloadManager(), file, anon, launch);
    }

    public static String browse(DownloadManager dm) {
        boolean anon = ManagerUtils.getBrowseAnon(dm);
        return ManagerUtils.browse(dm, null, anon, true);
    }

    public static String browse(DownloadManager dm, boolean anon, boolean launch) {
        return ManagerUtils.browse(dm, null, anon, launch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String browse(final DownloadManager dm, DiskManagerFileInfo _file, final boolean anon, final boolean launch) {
        String url_suffix;
        DiskManagerFileInfo file;
        Properties props = new Properties();
        File save_location = dm.getSaveLocation();
        String root_dir = save_location.isFile() ? save_location.getParentFile().getAbsolutePath() : save_location.getAbsolutePath();
        boolean always_browse = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList");
        if (!always_browse && _file == null) {
            _file = ManagerUtils.getBrowseHomePage(dm);
        }
        if ((file = _file) == null) {
            url_suffix = "";
        } else {
            String relative_path = file.getTorrentFile().getRelativePath();
            String[] bits = relative_path.replace(File.separatorChar, '/').split("/");
            String _url_suffix = "";
            int bits_to_use = always_browse ? bits.length - 1 : bits.length;
            int i = 0;
            while (i < bits_to_use) {
                String bit = bits[i];
                if (bit.length() != 0) {
                    _url_suffix = String.valueOf(_url_suffix) + (_url_suffix == "" ? "" : "/") + UrlUtils.encode(bit);
                }
                ++i;
            }
            url_suffix = _url_suffix;
        }
        Map<DownloadManager, WebPlugin> map = browse_plugins;
        synchronized (map) {
            WebPlugin plugin = browse_plugins.get(dm);
            if (plugin == null) {
                props.put("Port", (Object)0);
                props.put("Bind IP", "127.0.0.1");
                props.put("Home Page", "");
                props.put("Root Dir", root_dir);
                props.put("Access", "local");
                props.put("DefaultHideResourceConfig", (Object)true);
                props.put("DefaultEnableKeepAlive", (Object)true);
                props.put("EnablePairing", (Object)false);
                props.put("EnableUPNP", (Object)false);
                props.put("EnableI2P", (Object)false);
                props.put("EnableTor", (Object)false);
                String plugin_id = "webserver:" + dm.getInternalName();
                final String plugin_name = "Web Server for " + dm.getDisplayName();
                Properties messages = new Properties();
                messages.put("plugins." + plugin_id, plugin_name);
                PluginInitializer.getDefaultInterface().getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle(messages);
                final AESemaphore waiter = new AESemaphore("waiter");
                final String[] url_holder = new String[1];
                plugin = new UnloadableWebPlugin(props){
                    private Map<String, Object> file_map;
                    private String protocol;
                    private String host;
                    private int port;
                    {
                        super($anonymous0);
                        this.file_map = new HashMap<String, Object>();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void initialize(PluginInterface plugin_interface) throws PluginException {
                        DiskManagerFileInfoSet file_set = dm.getDiskManagerFileInfoSet();
                        DiskManagerFileInfo[] files = file_set.getFiles();
                        HashSet<Object> root_dir = new HashSet<Object>();
                        this.file_map.put("", root_dir);
                        Object[] objectArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DiskManagerFileInfo dm_file = objectArray[n2];
                            TOTorrentFile file2 = dm_file.getTorrentFile();
                            String path = file2.getRelativePath();
                            this.file_map.put(path, dm_file);
                            if (path.startsWith(File.separator)) {
                                path = path.substring(1);
                            }
                            Set<Object> dir = root_dir;
                            int pos = 0;
                            while (true) {
                                int next_pos;
                                if ((next_pos = path.indexOf(File.separatorChar, pos)) == -1) break;
                                String bit = path.substring(pos, next_pos);
                                dir.add(bit);
                                String sub_path = path.substring(0, next_pos);
                                dir = (Set)this.file_map.get(sub_path);
                                if (dir == null) {
                                    dir = new HashSet();
                                    this.file_map.put(sub_path, dir);
                                }
                                pos = next_pos + 1;
                            }
                            dir.add(dm_file);
                            ++n2;
                        }
                        Properties props = plugin_interface.getPluginProperties();
                        props.put("plugin.name", plugin_name);
                        super.initialize(plugin_interface);
                        InetAddress bind_ip = this.getServerBindIP();
                        this.host = bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
                        this.port = this.getServerPort();
                        this.log("Assigned port: " + this.port);
                        this.protocol = this.getProtocol();
                        String url = String.valueOf(this.protocol) + "://" + this.host + ":" + this.port + "/" + url_suffix;
                        if (launch) {
                            Utils.launch(url, false, true, anon);
                            return;
                        }
                        objectArray = url_holder;
                        synchronized (url_holder) {
                            url_holder[0] = url;
                            // ** MonitorExit[var8_5] (shouldn't be in output)
                            waiter.release();
                            return;
                        }
                    }

                    @Override
                    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
                        try {
                            boolean res = super.generate(request2, response);
                            if (!res) {
                                response.setReplyStatus(404);
                            }
                        }
                        catch (Throwable e) {
                            response.setReplyStatus(404);
                        }
                        return true;
                    }

                    @Override
                    protected boolean useFile(TrackerWebPageRequest request2, final TrackerWebPageResponse response, File root, String relative_url) throws IOException {
                        OutputStream os;
                        URL stream_url;
                        String content_type;
                        String path;
                        URL absolute_url = request2.getAbsoluteURL();
                        String query = absolute_url.getQuery();
                        if (query != null) {
                            String[] args = query.split("&");
                            String vuze_source = null;
                            int vuze_file_index = -1;
                            String vuze_file_name = null;
                            ArrayList<String> networks = new ArrayList<String>();
                            String[] stringArray = args;
                            int n = args.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String net;
                                String arg = stringArray[n2];
                                String[] bits = arg.split("=");
                                String lhs = bits[0];
                                String rhs = UrlUtils.decode(bits[1]);
                                if (lhs.equals("vuze_source")) {
                                    if (rhs.endsWith(".torrent") || rhs.startsWith("magnet")) {
                                        vuze_source = rhs;
                                    }
                                } else if (lhs.equals("vuze_file_index")) {
                                    vuze_file_index = Integer.parseInt(rhs);
                                } else if (lhs.equals("vuze_file_name")) {
                                    vuze_file_name = rhs;
                                } else if (lhs.equals("vuze_network") && (net = AENetworkClassifier.internalise(rhs)) != null) {
                                    networks.add(net);
                                }
                                ++n2;
                            }
                            if (vuze_source != null) {
                                String referrer = (String)request2.getHeaders().get("referer");
                                if (referrer == null || !referrer.contains("://" + this.host + ":" + this.port)) {
                                    response.setReplyStatus(403);
                                    return true;
                                }
                                if (vuze_source.endsWith(".torrent")) {
                                    Object file_node = this.file_map.get(vuze_source);
                                    if (file_node instanceof DiskManagerFileInfo) {
                                        boolean done;
                                        DiskManagerFileInfo dm_file = (DiskManagerFileInfo)file_node;
                                        long file_size = dm_file.getLength();
                                        File target_file = dm_file.getFile(true);
                                        boolean bl = done = dm_file.getDownloaded() == file_size && target_file.length() == file_size;
                                        if (done) {
                                            return this.handleRedirect(dm, target_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                        }
                                        try {
                                            File torrent_file = AETemporaryFileHandler.createTempFile();
                                            try (final FileOutputStream fos = new FileOutputStream(torrent_file);){
                                                DiskManagerChannel chan = PluginCoreUtils.wrap(dm_file).createChannel();
                                                try {
                                                    DiskManagerRequest req = chan.createRequest();
                                                    req.setOffset(0L);
                                                    req.setLength(file_size);
                                                    req.addListener(new DiskManagerListener(){

                                                        @Override
                                                        public void eventOccurred(DiskManagerEvent event2) {
                                                            int type = event2.getType();
                                                            if (type == 3) {
                                                                return;
                                                            }
                                                            if (type == 2) {
                                                                throw new RuntimeException(event2.getFailure());
                                                            }
                                                            PooledByteBuffer buffer = event2.getBuffer();
                                                            if (buffer == null) {
                                                                throw new RuntimeException("eh?");
                                                            }
                                                            try {
                                                                try {
                                                                    byte[] data = buffer.toByteArray();
                                                                    fos.write(data);
                                                                }
                                                                catch (IOException e) {
                                                                    throw new RuntimeException("Failed to write to " + file, e);
                                                                }
                                                            }
                                                            finally {
                                                                buffer.returnToPool();
                                                            }
                                                        }
                                                    });
                                                    req.run();
                                                }
                                                finally {
                                                    chan.destroy();
                                                }
                                            }
                                            return this.handleRedirect(dm, torrent_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                            return false;
                                        }
                                    }
                                    return false;
                                }
                                URL magnet = new URL(vuze_source);
                                File torrent_file = AETemporaryFileHandler.createTempFile();
                                try {
                                    URLConnection connection = magnet.openConnection();
                                    connection.connect();
                                    FileUtil.copyFile(connection.getInputStream(), torrent_file.getAbsoluteFile());
                                    return this.handleRedirect(dm, torrent_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        if ((path = absolute_url.getPath()).equals("/") && COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList")) {
                            relative_url = "/";
                        }
                        String download_name = XUXmlWriter.escapeXML(dm.getDisplayName());
                        String relative_file = relative_url.replace('/', File.separatorChar);
                        String node_key = relative_file.substring(1);
                        Object file_node = this.file_map.get(node_key);
                        boolean file_node_is_parent = false;
                        if (file_node == null) {
                            int pos = node_key.lastIndexOf(File.separator);
                            node_key = pos == -1 ? "" : node_key.substring(0, pos);
                            file_node = this.file_map.get(node_key);
                            file_node_is_parent = true;
                        }
                        if (file_node == null) {
                            return false;
                        }
                        if (file_node instanceof Set) {
                            String file_name;
                            if (relative_url.equals("/favicon.ico")) {
                                try {
                                    InputStream stream = this.getClass().getClassLoader().getResourceAsStream("com/biglybt/ui/icons/favicon.ico");
                                    response.useStream("image/x-icon", stream);
                                    return true;
                                }
                                catch (Throwable stream) {
                                    // empty catch block
                                }
                            }
                            Set kids = (Set)file_node;
                            String request_url = request2.getURL();
                            if (file_node_is_parent) {
                                int pos = request_url.lastIndexOf("/");
                                request_url = pos == -1 ? "" : request_url.substring(0, pos);
                            }
                            response.setContentType("text/html");
                            OutputStream os2 = response.getOutputStream();
                            String title = XUXmlWriter.escapeXML(UrlUtils.decode(request_url));
                            if (title.length() == 0) {
                                title = "/";
                            }
                            os2.write(("<html>\r\n <head>\r\n <meta charset=\"UTF-8\">\r\n  <title>" + download_name + ": Index of " + title + "</title>" + "\r\n" + " </head>" + "\r\n" + " <body>" + "\r\n" + "  <p>" + download_name + "</p>" + "\r\n" + "  <h1>Index of " + title + "</h1>" + "\r\n" + "  <pre><hr>" + "\r\n").getBytes("UTF-8"));
                            String root_url = request_url;
                            if (!root_url.endsWith("/")) {
                                root_url = String.valueOf(root_url) + "/";
                            }
                            if (request_url.length() > 1) {
                                int pos = request_url.lastIndexOf(47);
                                if (pos == 0) {
                                    ++pos;
                                }
                                String parent = request_url.substring(0, pos);
                                os2.write(("<a href=\"" + parent + "\">..</a>" + "\r\n").getBytes("UTF-8"));
                            }
                            ArrayList<String[]> filenames = new ArrayList<String[]>(kids.size());
                            int max_filename = 0;
                            int MAX_LEN = 120;
                            for (Object entry : kids) {
                                int len;
                                Object file2;
                                if (entry instanceof String) {
                                    file2 = null;
                                    file_name = (String)entry;
                                } else {
                                    file2 = (DiskManagerFileInfo)entry;
                                    if (file2.isSkipped()) continue;
                                    file_name = file2.getTorrentFile().getRelativePath();
                                    int pos = file_name.lastIndexOf(File.separatorChar);
                                    if (pos != -1) {
                                        file_name = file_name.substring(pos + 1);
                                    }
                                }
                                String url = String.valueOf(root_url) + UrlUtils.encode(file_name);
                                if (file2 == null) {
                                    file_name = String.valueOf(file_name) + "/";
                                }
                                if ((len = file_name.length()) > MAX_LEN) {
                                    file_name = String.valueOf(file_name.substring(0, MAX_LEN - 3)) + "...";
                                    len = file_name.length();
                                }
                                if (len > max_filename) {
                                    max_filename = len;
                                }
                                filenames.add(new String[]{url, file_name, file2 == null ? "" : DisplayFormatters.formatByteCountToKiBEtc(file2.getLength())});
                            }
                            max_filename = (max_filename + 15) / 8 * 8;
                            char[] padding = new char[max_filename];
                            Arrays.fill(padding, ' ');
                            Collections.sort(filenames, new Comparator<String[]>(){
                                Comparator comp = new FormattersImpl().getAlphanumericComparator(true);

                                @Override
                                public int compare(String[] o1, String[] o2) {
                                    return this.comp.compare(o1[0], o2[0]);
                                }
                            });
                            for (String[] entry : filenames) {
                                file_name = entry[1];
                                int len = file_name.length();
                                StringBuilder line = new StringBuilder(max_filename + 64);
                                line.append("<a href=\"").append(entry[0]).append("\">").append(XUXmlWriter.escapeXML(file_name)).append("</a>");
                                line.append(padding, 0, max_filename - len);
                                line.append(entry[2]);
                                line.append("\r\n");
                                os2.write(line.toString().getBytes("UTF-8"));
                            }
                            os2.write(("  <hr></pre>\r\n  <address>" + Constants.APP_NAME + " Web Server at " + this.host + " Port " + this.getServerPort() + "</address>" + "\r\n" + " </body>" + "\r\n" + "</html>").getBytes("UTF-8"));
                            return true;
                        }
                        DiskManagerFileInfo dm_file = (DiskManagerFileInfo)file_node;
                        long file_size = dm_file.getLength();
                        File target_file = dm_file.getFile(true);
                        boolean done = dm_file.getDownloaded() == file_size && target_file.length() == file_size;
                        String relative_path = dm_file.getTorrentFile().getRelativePath();
                        int pos = relative_path.lastIndexOf(".");
                        String file_type = pos == -1 ? "" : relative_path.substring(pos + 1);
                        if (file_size >= 524288L && !(content_type = HTTPUtils.guessContentTypeFromFileType(file_type)).startsWith("text/") && !content_type.startsWith("image/") && (stream_url = ManagerUtils.getMediaServerContentURL(dm_file)) != null) {
                            OutputStream os3 = response.getRawOutputStream();
                            os3.write(("HTTP/1.1 302 Found\r\nLocation: " + stream_url.toExternalForm() + "\r\n" + "\r\n").getBytes("UTF-8"));
                            return true;
                        }
                        if (done) {
                            if (file_size < 524288L) {
                                try (FileInputStream fis = null;){
                                    fis = new FileInputStream(target_file);
                                    response.useStream(file_type, fis);
                                    return true;
                                }
                            }
                            os = null;
                            InputStream is = null;
                            try {
                                try {
                                    int len;
                                    os = response.getRawOutputStream();
                                    os.write(("HTTP/1.1 200 OK\r\nContent-Type:" + HTTPUtils.guessContentTypeFromFileType(file_type) + "\r\n" + "Content-Length: " + file_size + "\r\n" + "Connection: close" + "\r\n" + "\r\n").getBytes("UTF-8"));
                                    byte[] buffer = new byte[131072];
                                    is = new FileInputStream(target_file);
                                    while ((len = is.read(buffer)) > 0) {
                                        os.write(buffer, 0, len);
                                    }
                                }
                                catch (Throwable buffer) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable line) {
                                        // empty catch block
                                    }
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable line) {}
                                }
                            }
                            finally {
                                try {
                                    os.close();
                                }
                                catch (Throwable line) {}
                                try {
                                    is.close();
                                }
                                catch (Throwable line) {}
                            }
                            return true;
                        }
                        dm_file.setPriority(10);
                        os = response.getRawOutputStream();
                        os.write(("HTTP/1.1 200 OK\r\nContent-Type:" + HTTPUtils.guessContentTypeFromFileType(file_type) + "\r\n" + "Content-Length: " + file_size + "\r\n" + "Connection: close" + "\r\n" + "X-Vuze-Hack: X").getBytes("UTF-8"));
                        DiskManagerChannel chan = PluginCoreUtils.wrap(dm_file).createChannel();
                        try {
                            final DiskManagerRequest req = chan.createRequest();
                            final boolean[] header_complete = new boolean[1];
                            final long[] last_write = new long[1];
                            req.setOffset(0L);
                            req.setLength(file_size);
                            req.addListener(new DiskManagerListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void eventOccurred(DiskManagerEvent event2) {
                                    int type = event2.getType();
                                    if (type == 3) {
                                        return;
                                    }
                                    if (type == 2) {
                                        throw new RuntimeException(event2.getFailure());
                                    }
                                    PooledByteBuffer buffer = event2.getBuffer();
                                    if (buffer == null) {
                                        throw new RuntimeException("eh?");
                                    }
                                    try {
                                        try {
                                            boolean do_header = false;
                                            boolean[] blArray = header_complete;
                                            synchronized (header_complete) {
                                                if (!header_complete[0]) {
                                                    do_header = true;
                                                    header_complete[0] = true;
                                                }
                                                last_write[0] = SystemTime.getMonotonousTime();
                                                // ** MonitorExit[var5_6] (shouldn't be in output)
                                                if (do_header) {
                                                    os.write("\r\n\r\n".getBytes("UTF-8"));
                                                }
                                                byte[] data = buffer.toByteArray();
                                                os.write(data);
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new RuntimeException("Failed to write to " + file, e);
                                        }
                                    }
                                    finally {
                                        buffer.returnToPool();
                                    }
                                    {
                                        return;
                                    }
                                }
                            });
                            TimerEventPeriodic[] timer_event = new TimerEventPeriodic[]{SimpleTimer.addPeriodicEvent("KeepAlive", 10000L, new TimerEventPerformer(){
                                boolean cancel_outstanding = false;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Override
                                public void perform(TimerEvent event2) {
                                    if (this.cancel_outstanding) {
                                        req.cancel();
                                        return;
                                    }
                                    boolean[] blArray = header_complete;
                                    synchronized (header_complete) {
                                        if (header_complete[0]) {
                                            if (SystemTime.getMonotonousTime() - last_write[0] >= 300000L) {
                                                req.cancel();
                                            }
                                        } else {
                                            try {
                                                os.write("X".getBytes("UTF-8"));
                                                os.flush();
                                            }
                                            catch (Throwable e) {
                                                req.cancel();
                                            }
                                        }
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                        if (response.isActive()) return;
                                        this.cancel_outstanding = true;
                                        return;
                                    }
                                }
                            })};
                            try {
                                req.run();
                            }
                            finally {
                                timer_event[0].cancel();
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                chan.destroy();
                                throw throwable;
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    }

                    /*
                     * Enabled aggressive exception aggregation
                     */
                    private boolean handleRedirect(DownloadManager dm2, File torrent_file, int file_index, String file_name, List<String> networks, TrackerWebPageRequest request2, TrackerWebPageResponse response) {
                        try {
                            int n;
                            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(torrent_file);
                            GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            TorrentOpenOptions torrent_options = new TorrentOpenOptions(torrent_file.getAbsolutePath(), torrent, false, null);
                            torrent_options.setTorrent(torrent);
                            String[] existing_nets = networks.size() == 0 ? dm2.getDownloadState().getNetworks() : networks.toArray(new String[networks.size()]);
                            String[] stringArray = AENetworkClassifier.AT_NETWORKS;
                            int n2 = AENetworkClassifier.AT_NETWORKS.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String net = stringArray[n3];
                                boolean found = false;
                                String[] stringArray2 = existing_nets;
                                n = existing_nets.length;
                                int n4 = 0;
                                while (n4 < n) {
                                    String x = stringArray2[n4];
                                    if (net == x) {
                                        found = true;
                                        break;
                                    }
                                    ++n4;
                                }
                                torrent_options.setNetworkEnabled(net, found);
                                ++n3;
                            }
                            HashMap<String, Object> add_options = new HashMap<String, Object>();
                            add_options.put("silent", true);
                            if (uif.addTorrentWithOptions(torrent_options, add_options)) {
                                long start = SystemTime.getMonotonousTime();
                                while (true) {
                                    long now;
                                    DownloadManager o_dm;
                                    if ((o_dm = gm.getDownloadManager(torrent)) != null && !o_dm.getDownloadState().getFlag(512L)) {
                                        String original_path;
                                        DiskManagerFileInfo[] files = o_dm.getDiskManagerFileInfoSet().getFiles();
                                        DiskManagerFileInfo o_dm_file = null;
                                        if (file_name != null) {
                                            DiskManagerFileInfo[] diskManagerFileInfoArray = files;
                                            int n5 = files.length;
                                            n = 0;
                                            while (n < n5) {
                                                DiskManagerFileInfo file2 = diskManagerFileInfoArray[n];
                                                String path = file2.getTorrentFile().getRelativePath();
                                                if (path.equals(file_name)) {
                                                    o_dm_file = file2;
                                                    break;
                                                }
                                                ++n;
                                            }
                                            if (o_dm_file == null) {
                                                o_dm_file = files[0];
                                            }
                                        } else if (file_index < 0) {
                                            long largest = -1L;
                                            DiskManagerFileInfo[] diskManagerFileInfoArray = files;
                                            int n6 = files.length;
                                            int n7 = 0;
                                            while (n7 < n6) {
                                                DiskManagerFileInfo file3 = diskManagerFileInfoArray[n7];
                                                if (file3.getLength() > largest) {
                                                    o_dm_file = file3;
                                                    largest = file3.getLength();
                                                }
                                                ++n7;
                                            }
                                        } else {
                                            o_dm_file = files[file_index];
                                        }
                                        if ((original_path = request2.getAbsoluteURL().getPath()).endsWith(".html")) {
                                            String url = ManagerUtils.browse(o_dm, file_index < 0 ? null : o_dm_file, anon, false);
                                            OutputStream os = response.getRawOutputStream();
                                            os.write(("HTTP/1.1 302 Found\r\nLocation: " + url + "\r\n" + "\r\n").getBytes("UTF-8"));
                                            return true;
                                        }
                                        URL stream_url = ManagerUtils.getMediaServerContentURL(o_dm_file);
                                        if (stream_url != null) {
                                            OutputStream os = response.getRawOutputStream();
                                            os.write(("HTTP/1.1 302 Found\r\nLocation: " + stream_url.toExternalForm() + "\r\n" + "\r\n").getBytes("UTF-8"));
                                            return true;
                                        }
                                    }
                                    if ((now = SystemTime.getMonotonousTime()) - start > 180000L) {
                                        Debug.out("Timeout waiting for download to be added");
                                        return false;
                                    }
                                    Thread.sleep(1000L);
                                }
                            }
                            Debug.out("Failed to add download for some reason");
                            return false;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            return false;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void unload() throws PluginException {
                        Map map = browse_plugins;
                        synchronized (map) {
                            browse_plugins.remove(dm);
                        }
                        super.unload();
                    }
                };
                PluginManager.registerPlugin(plugin, plugin_id, plugin_id);
                browse_plugins.put(dm, plugin);
                if (launch) {
                    return null;
                }
                waiter.reserve(10000L);
                String[] stringArray = url_holder;
                synchronized (url_holder) {
                    // ** MonitorExit[var17_21] (shouldn't be in output)
                    return url_holder[0];
                }
            }
            String protocol = plugin.getProtocol();
            InetAddress bind_ip = plugin.getServerBindIP();
            String host = bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
            String url = String.valueOf(protocol) + "://" + host + ":" + plugin.getServerPort() + "/" + url_suffix;
            if (launch) {
                Utils.launch(url, false, true, anon);
                return null;
            }
            return url;
        }
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo file) {
        PluginManager pm = CoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            return null;
        }
        try {
            String s_url;
            Object url = pi.getIPC().invoke("getContentURL", new Object[]{PluginCoreUtils.wrap(file)});
            if (url instanceof String && (s_url = (String)url).length() > 0) {
                return new URL(s_url);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isStartable(DownloadManager dm) {
        return ManagerUtils.isStartable(dm, false);
    }

    public static boolean isStartable(DownloadManager dm, boolean allow_error) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        if (state != 70) {
            return allow_error && state == 100;
        }
        return true;
    }

    public static boolean isStopable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        if (state == 70 || state == 65) {
            return dm.isPaused();
        }
        return true;
    }

    public static boolean isPauseable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return !dm.isPaused() && state != 65 && state != 100;
    }

    public static boolean isStopped(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 100;
    }

    public static boolean isForceStartable(DownloadManager dm) {
        return ManagerUtils.isForceStartable(dm, false);
    }

    public static boolean isForceStartable(DownloadManager dm, boolean allow_error) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        if (state != 70 && state != 75 && state != 60 && state != 50) {
            return allow_error && state == 100;
        }
        return true;
    }

    public static boolean canForceRecheck(DownloadManager dm) {
        if (dm.canForceRecheck()) {
            return true;
        }
        int state = dm.getState();
        return state == 60 || state == 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void forceRecheck(final DownloadManager dm) {
        int state = dm.getState();
        if (state != 100 && dm.canForceRecheck()) {
            ManagerUtils.asyncRecheck(dm);
            return;
        }
        if (state != 100 && state != 60 && state != 50) return;
        final DownloadManagerListener[] listener = new DownloadManagerListener[1];
        final boolean was_force_start = dm.isForceStart();
        DownloadManagerListener[] downloadManagerListenerArray = listener;
        synchronized (listener) {
            listener[0] = new DownloadManagerAdapter(){
                long start_time = SystemTime.getMonotonousTime();
                boolean waiting_for_stop = true;
                boolean waiting_for_checking = true;
                boolean done = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void stateChanged(DownloadManager manager, int state) {
                    block24: {
                        try {
                            if (!this.done) break block24;
                            if (!this.done) return;
                            DownloadManagerListener[] downloadManagerListenerArray = listener;
                        }
                        catch (Throwable throwable) {
                            if (!this.done) throw throwable;
                            DownloadManagerListener[] downloadManagerListenerArray = listener;
                            synchronized (listener) {
                                dm.removeListener(listener[0]);
                                // ** MonitorExit[var4_4] (shouldn't be in output)
                                throw throwable;
                            }
                        }
                        synchronized (listener) {
                            dm.removeListener(listener[0]);
                            // ** MonitorExit[var4_3] (shouldn't be in output)
                            return;
                        }
                    }
                    if (this.waiting_for_stop) {
                        if (state == 70) {
                            this.waiting_for_stop = false;
                            ManagerUtils.asyncRecheck(dm);
                        } else if (state != 65 && SystemTime.getMonotonousTime() - this.start_time > 30000L) {
                            Debug.out("Abandoning recheck, download hasn't stopped");
                            this.done = true;
                        }
                    } else if (state == 30) {
                        this.waiting_for_checking = false;
                    } else if (state == 70 && !this.waiting_for_checking) {
                        this.done = true;
                        if (was_force_start) {
                            ManagerUtils.asyncForceStart(dm);
                        } else {
                            ManagerUtils.asyncQueue(dm);
                        }
                    } else if (state == 50 || state == 60 || state == 100) {
                        this.done = true;
                    }
                    if (!this.done) return;
                    DownloadManagerListener[] downloadManagerListenerArray = listener;
                    synchronized (listener) {
                        dm.removeListener(listener[0]);
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        return;
                    }
                }
            };
            // ** MonitorExit[var4_4] (shouldn't be in output)
            dm.addListener(listener[0]);
            dm.stopIt(70, false, false);
            return;
        }
    }

    public static void host(Core core, DownloadManager dm) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            core.getTrackerHost().hostTorrent(torrent, true, false);
        }
        catch (TRHostException e) {
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("MyTorrentsView.menu.host.error.title"), MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
            mb.open(null);
        }
    }

    public static void publish(Core core, DownloadManager dm) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            core.getTrackerHost().publishTorrent(torrent);
        }
        catch (TRHostException e) {
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("MyTorrentsView.menu.host.error.title"), MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
            mb.open(null);
        }
    }

    public static void start(DownloadManager dm) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateWaiting();
        }
    }

    public static boolean canAllocate(DownloadManager dm) {
        boolean stopped = ManagerUtils.isStopped(dm);
        return stopped && !dm.isDataAlreadyAllocated() && !dm.isDownloadComplete(false);
    }

    public static void allocate(DownloadManager[] dms) {
        boolean smallest_first = COConfigurationManager.getBooleanParameter("diskmanager.alloc.smallestfirst");
        if (smallest_first) {
            dms = (DownloadManager[])dms.clone();
            Arrays.sort(dms, (o1, o2) -> {
                long comp2 = o1.getSize() - o2.getSize();
                return comp2 < 0L ? -1 : (comp2 > 0L ? 1 : 0);
            });
        }
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            if (ManagerUtils.canAllocate(dm)) {
                dm.getDownloadState().setLongAttribute("fas", 2L);
                long order = COConfigurationManager.getLongParameter("file.alloc.order.next", 0L);
                COConfigurationManager.setParameter("file.alloc.order.next", order + 1L);
                dm.getDownloadState().setLongAttribute("fao", order);
                dm.getDownloadState().setFlag(16384L, false);
                alloc_dispatcher.dispatch(() -> {
                    dm.setForceStart(true);
                    try {
                        long start = SystemTime.getMonotonousTime();
                        final AtomicInteger latest_state = new AtomicInteger(-1);
                        DownloadManagerAdapter listener = new DownloadManagerAdapter(){

                            @Override
                            public void stateChanged(DownloadManager manager, int state) {
                                latest_state.set(state);
                            }
                        };
                        dm.addListener(listener);
                        try {
                            int state;
                            while ((state = latest_state.get()) != 100 && state != 70 && state != 20) {
                                if (state == 50) {
                                    break;
                                }
                                if (SystemTime.getMonotonousTime() - start > 5000L) {
                                    break;
                                }
                                Thread.sleep(50L);
                            }
                        }
                        finally {
                            dm.removeListener(listener);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    dm.setForceStart(false);
                });
            }
            ++n2;
        }
    }

    public static void queue(DownloadManager dm) {
        int state;
        if (dm != null && ((state = dm.getState()) == 70 || state == 100)) {
            dm.setStateQueued();
        }
    }

    public static void pause(DownloadManager dm, Shell shell) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (dm.isPaused() || state == 65) {
            return;
        }
        ManagerUtils.asyncPause(dm);
    }

    public static void stop(DownloadManager dm, Shell shell) {
        ManagerUtils.stop(dm, shell, 70);
    }

    public static void stop(final DownloadManager dm, final Shell shell, final int stateAfterStopped) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (!(state != 70 && state != 65 && state != stateAfterStopped || dm.isPaused())) {
            return;
        }
        boolean stopme = true;
        if (state == 60 && dm.getStats().getShareRatio() >= 0 && dm.getStats().getShareRatio() < 1000 && COConfigurationManager.getBooleanParameter("Alert on close", false)) {
            if (!Utils.isThisThreadSWT()) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        ManagerUtils.stop(dm, shell, stateAfterStopped);
                    }
                });
                return;
            }
            Shell aShell = shell == null ? Utils.findAnyShell() : shell;
            MessageBox mb = new MessageBox(aShell, 200);
            mb.setText(MessageText.getString("seedmore.title"));
            mb.setMessage(String.valueOf(MessageText.getString("seedmore.shareratio")) + dm.getStats().getShareRatio() / 10 + "%.\n" + MessageText.getString("seedmore.uploadmore"));
            int action = mb.open();
            boolean bl = stopme = action == 64;
        }
        if (stopme) {
            ManagerUtils.asyncStop(dm, stateAfterStopped);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void asyncStopDelete(final DownloadManager dm, int stateAfterStopped, final boolean bDeleteTorrent, final boolean bDeleteData, final AERunnable deleteFailed) {
        final DownloadManager[] dms = new DownloadManager[]{dm};
        TorrentUtils.startTorrentDelete(dms);
        final boolean[] endDone = new boolean[1];
        try {
            async.dispatch(new AERunnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void runSupport() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
            return;
        }
        catch (Throwable e) {
            boolean[] blArray = endDone;
            // MONITORENTER : endDone
            if (!endDone[0]) {
                TorrentUtils.endTorrentDelete(dms);
                endDone[0] = true;
            }
            // MONITOREXIT : blArray
            Debug.out(e);
        }
    }

    public static void asyncStop(final DownloadManager dm, final int stateAfterStopped) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                if (dm.isPaused()) {
                    CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new CoreRunningListener(){

                        @Override
                        public void coreRunning(Core core) {
                            dm.stopPausedDownload();
                        }
                    });
                } else {
                    dm.stopIt(stateAfterStopped, false, false);
                }
            }
        });
    }

    public static void asyncPause(final DownloadManager dm) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                dm.pause(false);
            }
        });
    }

    public static void asyncRecheck(final DownloadManager dm) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                dm.forceRecheck();
            }
        });
    }

    public static void asyncQueue(final DownloadManager dm) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                dm.setStateQueued();
            }
        });
    }

    public static void asyncForceStart(final DownloadManager dm) {
        async.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                dm.setForceStart(true);
            }
        });
    }

    public static void asyncStartAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                core.getGlobalManager().startAllDownloads();
            }
        });
    }

    public static void asyncStopAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                core.getGlobalManager().stopAllDownloads();
            }
        });
    }

    public static void asyncPause() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                core.getGlobalManager().pauseDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                core.getGlobalManager().pauseDownloadsForPeriod(seconds);
            }
        });
    }

    public static void asyncResume() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                core.getGlobalManager().resumeDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final List<DownloadManager> dms, final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new CoreRunningListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void coreRunning(Core core) {
                final ArrayList<DownloadManager> paused = new ArrayList<DownloadManager>();
                final DownloadManagerAdapter listener = new DownloadManagerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void stateChanged(DownloadManager manager, int state) {
                        List list = paused;
                        synchronized (list) {
                            if (!paused.remove(manager)) {
                                return;
                            }
                        }
                        manager.removeListener(this);
                    }
                };
                final long target_time = SystemTime.getOffsetTime(seconds * 1000);
                String time_str = new SimpleDateFormat("HH:mm:ss").format(new Date(target_time));
                String reason = MessageText.getString("label.resuming.at", new String[]{time_str});
                for (DownloadManager dm : dms) {
                    if (!dm.isPaused() && !ManagerUtils.isPauseable(dm) || !dm.pause(false, target_time)) continue;
                    dm.setStopReason(reason);
                    ArrayList<DownloadManager> arrayList = paused;
                    synchronized (arrayList) {
                        paused.add(dm);
                    }
                    dm.addListener(listener, false);
                }
                if (paused.size() > 0) {
                    SimpleTimer.addEvent("ManagerUtils.resumer", target_time, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void perform(TimerEvent event2) {
                            ArrayList to_resume = new ArrayList();
                            List list = paused;
                            synchronized (list) {
                                to_resume.addAll(paused);
                                paused.clear();
                            }
                            for (DownloadManager dm : to_resume) {
                                dm.removeListener(listener);
                                try {
                                    if (dm.getAutoResumeTime() != target_time) continue;
                                    dm.resume();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public static void moveToArchive(final List<Download> downloads, ArchiveCallback _run_when_complete) {
        final ArchiveCallback run_when_complete = _run_when_complete == null ? new ArchiveCallback() : _run_when_complete;
        Utils.getOffOfSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    String title = MessageText.getString("archive.info.title");
                    String text = MessageText.getString("archive.info.text");
                    MessageBoxShell prompter = new MessageBoxShell(title, text, new String[]{MessageText.getString("Button.ok")}, 0);
                    String remember_id = "managerutils.archive.info";
                    prompter.setRemember(remember_id, true, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                    prompter.setAutoCloseInMS(0);
                    prompter.open(null);
                    prompter.waitUntilClosed();
                    for (Download dm : downloads) {
                        try {
                            DownloadStub stub = dm.stubbify();
                            run_when_complete.success(dm, stub);
                        }
                        catch (DownloadRemovalVetoException e) {
                            run_when_complete.failed(dm, e);
                            if (e.isSilent()) continue;
                            UIFunctionsManager.getUIFunctions().forceNotify(2, MessageText.getString("globalmanager.download.remove.veto"), e.getMessage(), dm.getName(), new Object[]{dm}, -1);
                        }
                        catch (Throwable e) {
                            run_when_complete.failed(dm, e);
                            Debug.out(e);
                        }
                    }
                }
                finally {
                    run_when_complete.completed();
                }
            }
        });
    }

    public static void restoreFromArchive(final List<DownloadStub> downloads, final boolean start, ArchiveCallback _run_when_complete) {
        final ArchiveCallback run_when_complete = _run_when_complete == null ? new ArchiveCallback() : _run_when_complete;
        Utils.getOffOfSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                try {
                    TagManager tag_manager = null;
                    Tag tag_restored = null;
                    try {
                        tag_manager = TagManagerFactory.getTagManager();
                        TagType tt = tag_manager.getTagType(3);
                        String tag_name = MessageText.getString("label.restored");
                        tag_restored = tt.getTag(tag_name, true);
                        if (tag_restored == null) {
                            tag_restored = tt.createTag(tag_name, true);
                            tag_restored.setPublic(false);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    try {
                        if (tag_manager != null) {
                            tag_manager.setProcessingEnabled(false);
                        }
                        for (DownloadStub dm : downloads) {
                            try {
                                Download dl = dm.destubbify();
                                if (dl != null) {
                                    run_when_complete.success(dm, dl);
                                    if (tag_restored != null) {
                                        tag_restored.addTaggable(PluginCoreUtils.unwrap(dl));
                                    }
                                    if (!start) continue;
                                    ManagerUtils.start(PluginCoreUtils.unwrap(dl));
                                    continue;
                                }
                                run_when_complete.failed(dm, new Exception("Unknown error"));
                            }
                            catch (Throwable e) {
                                run_when_complete.failed(dm, e);
                                Debug.out(e);
                            }
                        }
                    }
                    finally {
                        if (tag_manager != null) {
                            tag_manager.setProcessingEnabled(true);
                        }
                    }
                }
                finally {
                    run_when_complete.completed();
                }
            }
        });
    }

    public static DownloadManager[] cleanUp(DownloadManager[] dms) {
        ArrayList<DownloadManager> result = new ArrayList<DownloadManager>();
        if (dms != null) {
            DownloadManager[] downloadManagerArray = dms;
            int n = dms.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager dm = downloadManagerArray[n2];
                if (dm != null && !dm.isDestroyed()) {
                    result.add(dm);
                }
                ++n2;
            }
        }
        return result.toArray(new DownloadManager[result.size()]);
    }

    public static void locateFiles(DownloadManager[] dms, Shell shell) {
        ManagerUtils.locateFiles(dms, null, shell);
    }

    public static void locateFiles(DownloadManager[] dms, DiskManagerFileInfo[][] dm_files, Shell shell) {
        MessageBoxShell mb;
        if (!Utils.isSWTThread()) {
            Utils.execSWTThread(() -> ManagerUtils.locateFiles(dms, dm_files, shell));
            return;
        }
        boolean all_bad = true;
        boolean some_bad = false;
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            int dm_state = dm.getState();
            if (dm_state != 70 && dm_state != 100) {
                some_bad = true;
            } else {
                all_bad = false;
            }
            ++n2;
        }
        if (all_bad) {
            mb = new MessageBoxShell(MessageText.getString("dlg.finddatafiles.title"), MessageText.getString("dlg.finddatafiles.dms.all.bad"));
            mb.setButtons(new String[]{MessageText.getString("Button.ok")});
            mb.setIconResource("error");
            mb.open(result -> {});
        } else if (some_bad) {
            mb = new MessageBoxShell(MessageText.getString("dlg.finddatafiles.title"), MessageText.getString("dlg.finddatafiles.dms.some.bad"));
            mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
            mb.setIconResource("warning");
            mb.open(result -> {
                if (result == 0) {
                    ManagerUtils.locateFilesSupport(dms, dm_files, null, null, shell);
                }
            });
        } else {
            ManagerUtils.locateFilesSupport(dms, dm_files, null, null, shell);
        }
    }

    private static void locateFilesSupport(final DownloadManager[] dms, final DiskManagerFileInfo[][] dm_files, final List<TorrentOpenOptions> torrents, final Consumer<File[]> listener, final Shell shell) {
        URLClassLoader loader = null;
        if (Constants.isCVSVersion()) {
            try {
                File file = new File("C:\\Users\\Paul\\git\\BiglyBT\\uis\\src");
                if (file.exists()) {
                    URL[] urls = new URL[]{file.toURI().toURL()};
                    loader = new URLClassLoader(urls);
                }
            }
            catch (Throwable e2) {
                Debug.out(e2);
            }
        }
        final SkinnedDialog dialog = new SkinnedDialog(loader, "skin3_dlg_findfiles", "shell", shell, 2160);
        dialog.setTitle(MessageText.getString(dms != null ? "dlg.finddatafiles.title" : "dlg.findsavelocations.title"));
        SWTSkin skin = dialog.getSkin();
        SWTSkinObjectList so_def_locs = (SWTSkinObjectList)skin.getSkinObject("roots-list");
        final org.eclipse.swt.widgets.List def_locs = so_def_locs.getListControl();
        List<String> roots = COConfigurationManager.getStringListParameter("find.files.search.roots");
        if (!roots.isEmpty()) {
            def_locs.setItems(roots.toArray(new String[roots.size()]));
        }
        final SWTSkinObjectTextbox so_exp_text = (SWTSkinObjectTextbox)skin.getSkinObject("exp-text");
        SWTSkinObjectButton so_exp_but = (SWTSkinObjectButton)skin.getSkinObject("exp-but");
        final SWTSkinObjectButton so_add_but = (SWTSkinObjectButton)skin.getSkinObject("add-but");
        final SWTSkinObjectCheckbox so_use_def = (SWTSkinObjectCheckbox)skin.getSkinObject("use-def");
        SWTSkinObject so_mode_label = skin.getSkinObject("mode-label");
        SWTSkinObjectContainer so_mode = (SWTSkinObjectContainer)skin.getSkinObject("mode");
        final SWTSkinObjectCheckbox so_include_skipped = (SWTSkinObjectCheckbox)skin.getSkinObject("skip-inc");
        final SWTSkinObjectCheckbox so_test_only = (SWTSkinObjectCheckbox)skin.getSkinObject("test-only");
        Composite c_mode = so_mode.getComposite();
        c_mode.setLayoutData((Object)Utils.getFilledFormData());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c_mode.setLayout((Layout)layout);
        final Combo mode_combo = new Combo(c_mode, 8);
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)c_mode, 0);
        fd.bottom = new FormAttachment(100);
        mode_combo.setLayoutData((Object)fd);
        mode_combo.setItems(new String[]{String.valueOf(MessageText.getString("label.link")) + "    ", String.valueOf(MessageText.getString("label.copy")) + "    ", String.valueOf(MessageText.getString("label.move")) + "    ", String.valueOf(MessageText.getString("Peers.column.piece")) + "    ", String.valueOf(MessageText.getString("label.relocate")) + "    "});
        final Combo link_combo = new Combo(c_mode, 8);
        fd = new FormData();
        fd.top = new FormAttachment((Control)c_mode, 0);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment((Control)mode_combo, 2);
        link_combo.setLayoutData((Object)fd);
        link_combo.setItems(new String[]{"    ", String.valueOf(MessageText.getString("tag.type.internal")) + "    ", String.valueOf(MessageText.getString("label.hard")) + "    "});
        Utils.setTT((Control)link_combo, MessageText.getString("label.link.type"));
        CLabel tolerance = new CLabel(c_mode, 0x1000000);
        fd = new FormData();
        fd.top = new FormAttachment((Control)c_mode, 0);
        fd.bottom = new FormAttachment(100, -2);
        fd.left = new FormAttachment((Control)link_combo);
        tolerance.setLayoutData((Object)fd);
        tolerance.setText(MessageText.getString("label.tolerance.pct"));
        final Spinner tolerance_spinner = new Spinner(c_mode, 133120);
        fd = new FormData();
        fd.top = new FormAttachment((Control)c_mode, 0);
        fd.bottom = new FormAttachment(100);
        fd.left = new FormAttachment((Control)tolerance, 2);
        fd.right = new FormAttachment(100);
        tolerance_spinner.setLayoutData((Object)fd);
        tolerance_spinner.setMinimum(0);
        tolerance_spinner.setMaximum(10);
        SWTSkinObjectContainer soButtonArea = (SWTSkinObjectContainer)skin.getSkinObject("bottom-area");
        final StandardButtonsArea buttonsArea = new StandardButtonsArea(){

            @Override
            protected void clicked(int buttonValue) {
                if (buttonValue == 32) {
                    final String[] roots = so_use_def.isChecked() ? def_locs.getItems() : new String[]{so_exp_text.getText().trim()};
                    final int mode = mode_combo.getSelectionIndex();
                    final int link_type = link_combo.getSelectionIndex();
                    final int tolerance = tolerance_spinner.getSelection();
                    final boolean include_skipped = so_include_skipped.isChecked();
                    final boolean test_only = so_test_only.isChecked();
                    dialog.close();
                    Utils.execSWTThreadLater(1, new Runnable(){

                        @Override
                        public void run() {
                            if (dms != null) {
                                ManagerUtils.locateFiles(dms, dm_files, shell, roots, mode, link_type, tolerance, include_skipped, test_only);
                            } else {
                                ManagerUtils.locateSavePaths(torrents, shell, roots, listener);
                            }
                        }
                    });
                } else {
                    dialog.close();
                }
            }
        };
        buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.search"), MessageText.getString("Button.cancel")});
        buttonsArea.setButtonVals(new Integer[]{32, 256});
        buttonsArea.swt_createButtons(soButtonArea.getComposite());
        final Runnable state_changed = new Runnable(){

            @Override
            public void run() {
                String exp_text = so_exp_text.getText().trim();
                boolean is_explicit = !exp_text.isEmpty();
                boolean has_default = def_locs.getItemCount() > 0;
                boolean can_search = is_explicit || has_default;
                so_use_def.setEnabled(has_default);
                if (is_explicit) {
                    so_use_def.setChecked(false);
                } else if (has_default) {
                    so_use_def.setChecked(true);
                }
                so_add_but.getButton().setEnabled(is_explicit && !Arrays.asList(def_locs.getItems()).contains(exp_text));
                buttonsArea.setButtonEnabled(32, can_search);
                int mode = COConfigurationManager.getIntParameter("find.files.search.mode", 0);
                mode_combo.select(mode);
                boolean not_relocate = mode != 4;
                int link_mode = COConfigurationManager.getIntParameter("find.files.search.mode.link", 1);
                boolean link_enabled = mode == 0;
                link_combo.select(link_enabled ? link_mode : 0);
                link_combo.setEnabled(link_enabled);
                tolerance_spinner.setEnabled(not_relocate);
                so_include_skipped.setEnabled(not_relocate);
            }
        };
        state_changed.run();
        final Menu menu = new Menu((Control)def_locs);
        def_locs.setMenu(menu);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent arg0) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                final String[] selected = def_locs.getSelection();
                MenuItem mi = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)mi, "MySharesView.menu.remove");
                Utils.setMenuItemImage(mi, "delete");
                mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ArrayList<String> temp = new ArrayList<String>(Arrays.asList(def_locs.getItems()));
                        temp.removeAll(Arrays.asList(selected));
                        def_locs.setItems(temp.toArray(new String[temp.size()]));
                        COConfigurationManager.setParameter("find.files.search.roots", temp);
                        state_changed.run();
                    }
                });
                mi.setEnabled(selected.length > 0);
                new MenuItem(menu, 2);
                mi = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)mi, "wizard.multitracker.edit.text");
                mi.addListener(13, ev -> {
                    String[] old_items = def_locs.getItems();
                    String old_text = "";
                    String[] stringArray = old_items;
                    int n = old_items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String o = stringArray[n2];
                        old_text = String.valueOf(old_text) + o + "\n";
                        ++n2;
                    }
                    final String f_old_text = old_text;
                    final TextViewerWindow viewer = new TextViewerWindow(shell, "dlg.finddatafiles.deflab", null, old_text, false, false);
                    viewer.setEditable(true);
                    viewer.addListener(new TextViewerWindow.TextViewerWindowListener(){

                        @Override
                        public void closed() {
                            if (viewer.getOKPressed()) {
                                String new_text = viewer.getText().trim();
                                if (!f_old_text.trim().equals(new_text)) {
                                    String[] lines = new_text.split("\n");
                                    ArrayList<String> temp = new ArrayList<String>();
                                    String[] stringArray = lines;
                                    int n = lines.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String line = stringArray[n2];
                                        if ((line = line.trim()).length() > 0) {
                                            temp.add(line);
                                        }
                                        ++n2;
                                    }
                                    def_locs.setItems(temp.toArray(new String[temp.size()]));
                                    COConfigurationManager.setParameter("find.files.search.roots", temp);
                                    state_changed.run();
                                }
                            }
                        }
                    });
                });
            }

            public void menuHidden(MenuEvent arg0) {
            }
        });
        def_locs.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event2) {
                if (event2.stateMask == 0 && event2.keyCode == 127) {
                    String[] selected = def_locs.getSelection();
                    if (selected.length > 0) {
                        ArrayList<String> temp = new ArrayList<String>(Arrays.asList(def_locs.getItems()));
                        temp.removeAll(Arrays.asList(selected));
                        def_locs.setItems(temp.toArray(new String[temp.size()]));
                        COConfigurationManager.setParameter("find.files.search.roots", temp);
                        state_changed.run();
                    }
                } else {
                    int key = event2.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (event2.stateMask == SWT.MOD1) {
                        switch (key) {
                            case 97: {
                                def_locs.selectAll();
                                event2.doit = false;
                            }
                        }
                    }
                }
            }
        });
        mode_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = mode_combo.getSelectionIndex();
                COConfigurationManager.setParameter("find.files.search.mode", index);
                state_changed.run();
            }
        });
        link_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = link_combo.getSelectionIndex();
                if (index == 0) {
                    index = 1;
                }
                COConfigurationManager.setParameter("find.files.search.mode.link", index);
                state_changed.run();
            }
        });
        tolerance_spinner.addListener(13, e -> {
            int index;
            int value = tolerance_spinner.getSelection();
            if (value != 0 && (index = mode_combo.getSelectionIndex()) == 0) {
                index = 1;
                mode_combo.select(index);
                COConfigurationManager.setParameter("find.files.search.mode", index);
                state_changed.run();
            }
        });
        so_exp_text.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                state_changed.run();
            }
        });
        so_exp_but.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            @Override
            public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                DirectoryDialog dd = new DirectoryDialog(shell);
                dd.setFilterPath(TorrentOpener.getFilterPathData());
                dd.setText(MessageText.getString("MyTorrentsView.menu.locatefiles.dialog"));
                String path = dd.open();
                if (path != null) {
                    TorrentOpener.setFilterPathData(path);
                    so_exp_text.setText(new File(path).getAbsolutePath());
                    state_changed.run();
                }
            }
        });
        so_add_but.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            @Override
            public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                String loc = so_exp_text.getText().trim();
                String[] existing = def_locs.getItems();
                String[] locs = new String[existing.length + 1];
                int pos = 0;
                String[] stringArray = existing;
                int n = existing.length;
                int n2 = 0;
                while (n2 < n) {
                    String e = stringArray[n2];
                    if (loc.equals(e)) {
                        return;
                    }
                    locs[pos++] = e;
                    ++n2;
                }
                locs[pos] = loc;
                def_locs.setItems(locs);
                COConfigurationManager.setParameter("find.files.search.roots", Arrays.asList(locs));
                state_changed.run();
            }
        });
        so_use_def.addSelectionListener(new SWTSkinCheckboxListener(){

            @Override
            public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                if (checked) {
                    so_exp_text.setText("");
                }
                state_changed.run();
            }
        });
        so_include_skipped.setChecked(COConfigurationManager.getBooleanParameter("find.files.include.skipped"));
        so_include_skipped.addSelectionListener(new SWTSkinCheckboxListener(){

            @Override
            public void checkboxChanged(SWTSkinObjectCheckbox so, boolean checked) {
                COConfigurationManager.setParameter("find.files.include.skipped", checked);
            }
        });
        skin.setAutoSizeOnLayout(true, true);
        if (dms == null) {
            so_mode_label.setVisible(false);
            so_mode.setVisible(false);
            skin.getSkinObject("opt2-line").setVisible(false);
        }
        dialog.open("skin3_dlg_findfiles." + (dms == null ? "dms" : "sps"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void locateFiles(final DownloadManager[] dms, final DiskManagerFileInfo[][] dm_files, Shell shell, final String[] initial_search_roots, final int mode, final int link_type, final int tolerance, final boolean include_skipped, final boolean test_only) {
        TextViewerWindow _viewer = null;
        List<TextViewerWindow> list = lf_windows;
        synchronized (list) {
            if (lf_reuse && !lf_windows.isEmpty()) {
                _viewer = lf_windows.remove(0);
            }
            if (_viewer == null) {
                _viewer = new TextViewerWindow(lf_reuse ? null : shell, MessageText.getString("locatefiles.view.title"), null, "", false, false);
            } else {
                _viewer.reset();
            }
        }
        final TextViewerWindow viewer = _viewer;
        if (lf_reuse) {
            viewer.setReuseWindow();
        }
        viewer.setEditable(false);
        viewer.setOKEnabled(false);
        new AEThread2("FileLocator"){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void locateSavePaths(final List<TorrentOpenOptions> torrents, Shell shell, final String[] roots, final Consumer<File[]> listener) {
        TextViewerWindow _viewer = null;
        List<TextViewerWindow> list = sp_windows;
        synchronized (list) {
            if (lf_reuse && !sp_windows.isEmpty()) {
                _viewer = sp_windows.remove(0);
            }
            if (_viewer == null) {
                _viewer = new TextViewerWindow(lf_reuse ? null : shell, MessageText.getString("locatesavepaths.view.title"), null, "", false, false);
            } else {
                _viewer.reset();
            }
        }
        final TextViewerWindow viewer = _viewer;
        if (lf_reuse) {
            viewer.setReuseWindow();
        }
        viewer.setEditable(false);
        viewer.setCancelEnabled(true);
        viewer.setOKEnabled(false);
        viewer.setOKisApply(true);
        viewer.getShell().moveAbove((Control)shell);
        new AEThread2("FileLocator"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                date_format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                results = new File[torrents.size()];
                result_count = new int[1];
                try {
                    try {
                        incomplete_file_suffix = null;
                        if (COConfigurationManager.getBooleanParameter("Rename Incomplete Files")) {
                            incomplete_file_suffix = COConfigurationManager.getStringParameter("Rename Incomplete Files Extension").trim();
                            if ((incomplete_file_suffix = FileUtil.convertOSSpecificChars(incomplete_file_suffix, false)).isEmpty()) {
                                incomplete_file_suffix = null;
                            }
                        }
                        file_map = new HashMap<K, V>();
                        quit = new boolean[1];
                        viewer.addListener(new TextViewerWindow.TextViewerWindowListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void closed() {
                                Object object = quit;
                                synchronized (quit) {
                                    quit[0] = true;
                                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                    List list = sp_windows;
                                    object = list;
                                    synchronized (list) {
                                        if (lf_reuse) {
                                            sp_windows.add(viewer);
                                        }
                                        // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                        return;
                                    }
                                }
                            }
                        });
                        indent = 0;
                        ManagerUtils.access$5(viewer, indent, "Checking " + torrents.size() + " torrents against " + roots.length + " search locations");
                        tested_folders = new HashSet<String>();
                        to_do = new LinkedList<Object>();
                        var13_11 /* !! */  = roots;
                        var12_13 = roots.length;
                        var11_14 = 0;
                        while (true) {
                            block38: {
                                if (var11_14 < var12_13) break block38;
                                candidates = new HashMap<TorrentOpenOptions, Object[]>();
                                last_dir_log = -1L;
                                if (true) ** GOTO lbl136
                            }
                            root = var13_11 /* !! */ [var11_14];
                            to_do.add(new File(root));
                            ++var11_14;
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        ManagerUtils.access$7(viewer, 0, "\r\n" + date_format.format(new Date()) + ": Failed: " + Debug.getNestedExceptionMessage(e) + "\r\n");
                        Utils.execSWTThread(new Runnable(this, viewer, result_count, listener, results){
                            final /* synthetic */ 34 this$1;
                            private final /* synthetic */ TextViewerWindow val$viewer;
                            private final /* synthetic */ int[] val$result_count;
                            private final /* synthetic */ Consumer val$listener;
                            private final /* synthetic */ File[] val$results;
                            {
                                this.this$1 = var1_1;
                                this.val$viewer = textViewerWindow;
                                this.val$result_count = nArray;
                                this.val$listener = consumer;
                                this.val$results = fileArray;
                            }

                            @Override
                            public void run() {
                                if (!this.val$viewer.isDisposed()) {
                                    boolean has_results = this.val$result_count[0] > 0;
                                    this.val$viewer.setOKEnabled(has_results);
                                    if (has_results) {
                                        this.val$viewer.addListener(() -> {
                                            if (this.val$viewer.getOKPressed()) {
                                                this.val$listener.accept(this.val$results);
                                            }
                                        });
                                    }
                                }
                            }
                        });
                        return;
                    }
                }
                catch (Throwable var36_58) {
                    Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                    throw var36_58;
                }
                do {
                    var13_11 /* !! */  = (String[])quit;
                    // MONITORENTER : quit
                    if (quit[0]) {
                        // MONITOREXIT : var13_11 /* !! */ 
                        break;
                    }
                    // MONITOREXIT : var13_11 /* !! */ 
                    dir = (File)to_do.removeFirst();
                    if (!dir.isDirectory() || tested_folders.contains(abs_dir = dir.getAbsolutePath())) continue;
                    tested_folders.add(abs_dir);
                    now = SystemTime.getMonotonousTime();
                    if (last_dir_log == -1L || now - last_dir_log > 100L) {
                        last_dir_log = now;
                        ManagerUtils.access$5(viewer, indent, "Searching " + abs_dir + ", remaining=" + to_do.size());
                    }
                    for (TorrentOpenOptions too : torrents) {
                        torrent = too.getTorrent();
                        tfiles = torrent.getFiles();
                        files = too.getFiles();
                        hits = 0;
                        hits_size = 0L;
                        pads = 0;
                        if (torrent.isSimpleTorrent()) {
                            file = files[0].getDestFileName();
                            test_file = new File(dir, file);
                            if (test_file.exists()) {
                                ++hits;
                                hits_size += test_file.length();
                            }
                        } else {
                            var29_47 = files;
                            var28_44 = files.length;
                            test_file = 0;
                            while (test_file < var28_44) {
                                tofile = var29_47[test_file];
                                index = tofile.getIndex();
                                tfile = tfiles[index];
                                if (tfile.isPadFile()) {
                                    ++pads;
                                } else {
                                    file = tofile.getDestFileName();
                                    path = tfile.getRelativePath();
                                    pos = path.lastIndexOf(File.separator);
                                    if (pos != -1) {
                                        path = String.valueOf(path.substring(0, pos + 1)) + file;
                                    }
                                    if ((test_file = new File(dir, path)).exists()) {
                                        ++hits;
                                        hits_size += test_file.length();
                                    } else if (incomplete_file_suffix != null && (test_file = new File(dir, String.valueOf(path) + incomplete_file_suffix)).exists()) {
                                        ++hits;
                                        hits_size += test_file.length();
                                    }
                                }
                                ++test_file;
                            }
                        }
                        if (hits <= 0) continue;
                        ManagerUtils.access$5(viewer, indent + 1, "Testing " + dir + " against " + too.getDisplayName() + ": matches=" + hits);
                        entry = (Object[])candidates.get(too);
                        if (entry == null) {
                            v1 = new Object[2];
                            v2 = new int[2];
                            v2[1] = pads;
                            v1[0] = v2;
                            v1[1] = new ArrayList<E>();
                            entry = v1;
                            candidates.put(too, entry);
                        }
                        counts = (int[])entry[0];
                        hit_entries = (List)entry[1];
                        if (hits > counts[0]) {
                            counts[0] = hits;
                            hit_entries.clear();
                            hit_entries.add(new Object[]{dir, hits_size});
                            continue;
                        }
                        if (hits != counts[0]) continue;
                        hit_entries.add(new Object[]{dir, hits_size});
                    }
                    files = dir.listFiles();
                    if (files == null) continue;
                    files = files;
                    var20_27 = files.length;
                    torrent = 0;
                    while (torrent < var20_27) {
                        f = files[torrent];
                        if (f.isDirectory() && !f.getName().startsWith(".")) {
                            to_do.add(f);
                        }
                        ++torrent;
                    }
lbl136:
                    // 4 sources

                } while (!to_do.isEmpty());
                ManagerUtils.access$5(viewer, indent, "Search complete, " + tested_folders.size() + " folders checked");
                pos = 0;
                result_lines = new ArrayList<String[]>();
                for (TorrentOpenOptions too : torrents) {
                    entry = (Object[])candidates.get(too);
                    if (entry == null) {
                        ManagerUtils.access$5(viewer, indent, "No results for " + too.getDisplayName());
                    } else {
                        torrent = too.getTorrent();
                        torrent_size = torrent.getSize();
                        min_hit_size = torrent_size / 10L;
                        fc = torrent.getFileCount();
                        counts = (int[])entry[0];
                        hit_entries = (List)entry[1];
                        matches = counts[0];
                        pad = counts[1];
                        ManagerUtils.access$5(viewer, indent, String.valueOf(too.getDisplayName()) + " (" + DisplayFormatters.formatByteCountToKiBEtc(torrent_size) + ") has " + hit_entries.size() + " locations with " + matches + " out of " + (fc - pad) + " matches:");
                        valid = new ArrayList<File>();
                        for (Object[] e : hit_entries) {
                            f = (File)e[0];
                            size = (Long)e[1];
                            permille = (int)(size * 1000L / torrent_size);
                            ManagerUtils.access$5(viewer, indent + 1, String.valueOf(f.getAbsolutePath()) + ", match size=" + DisplayFormatters.formatByteCountToKiBEtc(size) + " (" + DisplayFormatters.formatPercentFromThousands(permille) + ")");
                            if (size >= min_hit_size) {
                                valid.add(f);
                                continue;
                            }
                            ManagerUtils.access$5(viewer, indent + 2, "Match is too small, ignoring");
                        }
                        if (valid.size() == 1) {
                            results[pos] = (File)valid.get(0);
                            result_count[0] = result_count[0] + 1;
                            ManagerUtils.access$5(viewer, indent + 2, "Selected for application");
                            result_lines.add(new String[]{too.getDisplayName(), ((File)valid.get(0)).getAbsolutePath()});
                        } else if (valid.size() > 1) {
                            ManagerUtils.access$5(viewer, indent + 2, "Multiple locations require manual resolution");
                        }
                    }
                    ++pos;
                }
                if (!result_lines.isEmpty()) {
                    ManagerUtils.access$5(viewer, indent, "");
                    ManagerUtils.access$5(viewer, indent, "--- Summary ---");
                    ManagerUtils.access$5(viewer, indent, "");
                    for (String[] entry : result_lines) {
                        ManagerUtils.access$5(viewer, indent, entry[0]);
                        ManagerUtils.access$5(viewer, indent + 2, "-> " + entry[1]);
                    }
                }
                Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
            }
        }.start();
    }

    public static void locateSaveLocations(List<TorrentOpenOptions> torrents, Shell shell, Consumer<File[]> listener) {
        ManagerUtils.locateFilesSupport(null, null, torrents, listener, shell);
    }

    private static void logLine(TextViewerWindow viewer, int indent, String str) {
        ManagerUtils.log(viewer, indent, String.valueOf(str) + "\r\n");
    }

    private static void log(final TextViewerWindow viewer, int indent, String str) {
        String f_str;
        if (indent == 0) {
            f_str = str;
        } else {
            String prefix = "";
            int i = 0;
            while (i < indent) {
                prefix = String.valueOf(prefix) + "    ";
                ++i;
            }
            f_str = String.valueOf(prefix) + str;
        }
        Utils.execSWTThread(new Runnable(){

            @Override
            public void run() {
                if (!viewer.isDisposed()) {
                    viewer.append2(f_str);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static int buildFileMap(TextViewerWindow viewer, File dir, Map<Long, Set<File>> map, long[] log_details, boolean[] quit) {
        File[] files = dir.listFiles();
        int total_files = 0;
        if (files == null) return total_files;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            boolean[] blArray = quit;
            // MONITORENTER : quit
            if (quit[0]) {
                // MONITOREXIT : blArray
                return total_files;
            }
            // MONITOREXIT : blArray
            long now = SystemTime.getMonotonousTime();
            long elapsed = now - log_details[2];
            long delay = Math.min(250L + 2250L * elapsed / 60000L, 2500L);
            if (now - log_details[0] > delay) {
                long l = log_details[1];
                log_details[1] = l + 1L;
                if (l > 80L) {
                    ManagerUtils.logLine(viewer, 0, "");
                    log_details[1] = 1L;
                }
                ManagerUtils.log(viewer, 0, ".");
                log_details[0] = now;
            }
            if (f.isDirectory()) {
                total_files += ManagerUtils.buildFileMap(viewer, f, map, log_details, quit);
            } else {
                long size = f.length();
                if (size > 0L) {
                    ++total_files;
                    Set<File> list = map.get(size);
                    if (list == null) {
                        list = new HashSet<File>();
                        map.put(size, list);
                    }
                    list.add(f);
                }
            }
            ++n2;
        }
        return total_files;
    }

    public static boolean canFindMoreLikeThis() {
        try {
            PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm");
            if (pi != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupByExpression", new Object[]{"", new String[0], new HashMap()})) {
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    public static void findMoreLikeThis(DownloadManager dm, Shell shell) {
        ManagerUtils.findMoreLikeThis(dm, null, shell);
    }

    public static void findMoreLikeThis(DiskManagerFileInfo file, Shell shell) {
        ManagerUtils.findMoreLikeThis(file.getDownloadManager(), file, shell);
    }

    private static void findMoreLikeThis(final DownloadManager dm, DiskManagerFileInfo file, Shell shell) {
        String expression = file == null ? dm.getDisplayName() : file.getFile(true).getName();
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("find.more.like.title", "find.more.like.msg");
        entryWindow.setPreenteredText(expression, false);
        entryWindow.selectPreenteredText(true);
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String expression = entryWindow.getSubmittedInput();
                if (expression != null && expression.trim().length() > 0) {
                    expression = expression.trim();
                    try {
                        PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm");
                        if (pi != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupByExpression", new Object[]{"", new String[0], new HashMap()})) {
                            HashMap<String, Object> options = new HashMap<String, Object>();
                            options.put("Subscription", true);
                            options.put("Name", expression);
                            pi.getIPC().invoke("lookupByExpression", new Object[]{expression, dm.getDownloadState().getNetworks(), options});
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    public static void setFileSkipped(DiskManagerFileInfo file_info, boolean skipped) {
        int compact_target;
        int new_storage_type;
        int existing_storage_type;
        DownloadManager dm;
        if (skipped && (dm = file_info.getDownloadManager()) != null && dm.getState() == 70 && !dm.isDataAlreadyAllocated() && dm.getStats().getSecondsDownloading() <= 0L && !file_info.getFile(true).exists() && existing_storage_type != (new_storage_type = (compact_target = (existing_storage_type = file_info.getStorageType()) == 2 || existing_storage_type == 1 ? 2 : 4))) {
            file_info.setStorageType(new_storage_type);
        }
        file_info.setSkipped(skipped);
    }

    public static void setFilesSkipped(List<DiskManagerFileInfo> file_infos, boolean skipped) {
        ArrayList<DiskManagerFileInfo> files;
        DownloadManager dm;
        IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> dm_map = new IdentityHashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
        for (DiskManagerFileInfo diskManagerFileInfo : file_infos) {
            dm = diskManagerFileInfo.getDownloadManager();
            if (dm == null) continue;
            files = (ArrayList<DiskManagerFileInfo>)dm_map.get(dm);
            if (files == null) {
                files = new ArrayList<DiskManagerFileInfo>();
                dm_map.put(dm, files);
            }
            files.add(diskManagerFileInfo);
        }
        for (Map.Entry entry : dm_map.entrySet()) {
            dm = (DownloadManager)entry.getKey();
            files = (List)entry.getValue();
            DiskManagerFileInfoSet info_set = dm.getDiskManagerFileInfoSet();
            if (skipped && dm.getState() == 70 && !dm.isDataAlreadyAllocated() && dm.getStats().getSecondsDownloading() <= 0L) {
                boolean[] changed;
                ArrayList<DiskManagerFileInfo> change_compact = new ArrayList<DiskManagerFileInfo>(files.size());
                ArrayList<DiskManagerFileInfo> change_reorder_compact = new ArrayList<DiskManagerFileInfo>(files.size());
                for (DiskManagerFileInfo file_info : files) {
                    int compact_target;
                    int existing_storage_type;
                    if (file_info.getFile(true).exists() || existing_storage_type == (compact_target = (existing_storage_type = file_info.getStorageType()) == 2 || existing_storage_type == 1 ? 2 : 4)) continue;
                    if (compact_target == 2) {
                        change_compact.add(file_info);
                        continue;
                    }
                    change_reorder_compact.add(file_info);
                }
                if (!change_compact.isEmpty()) {
                    changed = new boolean[info_set.nbFiles()];
                    for (DiskManagerFileInfo file : change_compact) {
                        changed[file.getIndex()] = true;
                    }
                    info_set.setStorageTypes(changed, 2);
                }
                if (!change_reorder_compact.isEmpty()) {
                    changed = new boolean[info_set.nbFiles()];
                    for (DiskManagerFileInfo file : change_reorder_compact) {
                        changed[file.getIndex()] = true;
                    }
                    info_set.setStorageTypes(changed, 4);
                }
            }
            boolean[] changed = new boolean[info_set.nbFiles()];
            boolean has_changes = false;
            for (DiskManagerFileInfo file_info : files) {
                if (file_info.isSkipped() == skipped) continue;
                changed[file_info.getIndex()] = true;
                has_changes = true;
            }
            if (!has_changes) continue;
            info_set.setSkipped(changed, skipped);
        }
    }

    public static boolean canLowResourceRecheck(DownloadManager dm) {
        return dm.getState() == 60 && dm.getUserData(LOW_RES_RECHECK_KEY) == null;
    }

    public static void lowResourceRecheck(final DownloadManager dm) {
        DiskManager diskManager;
        if (dm.getState() == 60 && dm.getUserData(LOW_RES_RECHECK_KEY) == null && (diskManager = dm.getDiskManager()) != null) {
            dm.setUserData(LOW_RES_RECHECK_KEY, "");
            DiskManagerCheckRequest req = diskManager.createCheckRequest(-1, null);
            req.setExplicit(true);
            diskManager.enqueueCompleteRecheckRequest(req, new DiskManagerCheckRequestListener(){
                boolean failed = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void checkFailed(DiskManagerCheckRequest request2, Throwable cause) {
                    37 var3_3 = this;
                    synchronized (var3_3) {
                        if (this.failed) {
                            return;
                        }
                        this.failed = true;
                    }
                    dm.stopIt(70, false, false);
                    dm.forceRecheck();
                    dm.setUserData(LOW_RES_RECHECK_KEY, null);
                }

                @Override
                public void checkCompleted(DiskManagerCheckRequest request2, boolean passed) {
                    dm.setUserData(LOW_RES_RECHECK_KEY, null);
                }

                @Override
                public void checkCancelled(DiskManagerCheckRequest request2) {
                }
            });
        }
    }

    public static void advancedRename(DownloadManager[] dms) {
        if (dms.length < 1) {
            return;
        }
        ArrayList<DownloadManager> list = new ArrayList<DownloadManager>(Arrays.asList(dms));
        ManagerUtils.advancedRename(list);
    }

    private static void advancedRename(List<DownloadManager> list) {
        if (list.isEmpty()) {
            return;
        }
        DownloadManager dm = list.remove(0);
        AdvRenameWindow window = new AdvRenameWindow(dm);
        window.open(result -> {
            if (result == -1 || list.isEmpty()) {
                return;
            }
            ManagerUtils.advancedRename(list);
        });
    }

    public static void viewLinks(DownloadManager[] dms) {
        StringBuilder details = new StringBuilder(32768);
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null || !torrent.isSimpleTorrent()) {
                DiskManagerFileInfoSet fis = dm.getDiskManagerFileInfoSet();
                DiskManagerFileInfo[] files = fis.getFiles();
                boolean done_name = false;
                DiskManagerFileInfo[] diskManagerFileInfoArray = files;
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    DiskManagerFileInfo file_info = diskManagerFileInfoArray[n4];
                    File file_link = file_info.getFile(true);
                    File file_nolink = file_info.getFile(false);
                    if (!file_nolink.getAbsolutePath().equals(file_link.getAbsolutePath())) {
                        if (dms.length > 1 && !done_name) {
                            done_name = true;
                            if (details.length() > 0) {
                                details.append("\n");
                            }
                            details.append(dm.getDisplayName());
                            details.append("\n\n");
                        }
                        details.append("    ");
                        details.append(file_nolink.getAbsolutePath());
                        details.append(" -> ");
                        details.append(file_link.getAbsolutePath());
                        details.append("\n");
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        TextViewerWindow viewer = new TextViewerWindow(Utils.findAnyShell(), "view.links.title", "view.links.text", details.toString(), true, true);
        viewer.setEditable(false);
        viewer.setCancelEnabled(false);
        viewer.setNonProportionalFont();
        viewer.goModal();
    }

    public static void viewDebug(DownloadManager[] dms) {
        StringWriter debug = new StringWriter(32768);
        IndentWriter writer = new IndentWriter(new PrintWriter(debug));
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            if (dms.length > 1) {
                writer.println("Download " + dm.getDisplayName());
                writer.indent();
            }
            dm.generateEvidence(writer, true);
            if (dms.length > 1) {
                writer.exdent();
            }
            ++n2;
        }
        writer.close();
        TextViewerWindow viewer = new TextViewerWindow(Utils.findAnyShell(), "GeneralView.section.info", null, debug.toString(), true, true);
        viewer.setEditable(false);
        viewer.setCancelEnabled(false);
        viewer.setNonProportionalFont();
        viewer.goModal();
    }

    static /* synthetic */ void access$5(TextViewerWindow textViewerWindow, int n, String string) {
        ManagerUtils.logLine(textViewerWindow, n, string);
    }

    static /* synthetic */ int access$6(TextViewerWindow textViewerWindow, File file, Map map, long[] lArray, boolean[] blArray) {
        return ManagerUtils.buildFileMap(textViewerWindow, file, map, lArray, blArray);
    }

    static /* synthetic */ void access$7(TextViewerWindow textViewerWindow, int n, String string) {
        ManagerUtils.log(textViewerWindow, n, string);
    }

    public static class ArchiveCallback {
        public void success(DownloadStub source, DownloadStub target) {
        }

        public void failed(DownloadStub original, Throwable error) {
        }

        public void completed() {
        }
    }

    public static interface RunDownloadManager {
        public void run(DownloadManager var1);
    }

    private static class UnloadableWebPlugin
    extends WebPlugin
    implements UnloadablePlugin {
        private UnloadableWebPlugin(Properties props) {
            super(props);
        }

        @Override
        public void unload() throws PluginException {
            super.unloadPlugin();
        }
    }
}

